---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, page, note en base de page, verbatim
---

# Comment utiliser le mode verbatim dans une note de bas de page ?

Le mode `verbatim` permet de saisir du texte qui apparaîtra tel quel dans le document, 
sans interprétation des caractères spéciaux. 
Il est spécialement adapté pour le code informatique :

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page

\begin{document}
Voici \verb+un \textbf{exemple} de code \LaTeX+.
\end{document}
```

Mais le mode `verbatim` n'est généralement pas utilisable en argument d'une commande, 
et notamment pas utilisable dans une note de bas de page. 


## Avec les commandes de base

Si on a juste besoin de quelques mots en style verbatim, 
on peut imaginer sélectionner la fonte utilisée par le mode `verbatim` avec `\texttt{}`, 
puis à faire le `verbatim` "à la main" en protégeant les caractères spéciaux...


## Avec l'extension <ctanpkg:fancyvrb>

Mais, heureusement, l'extension <ctanpkg:fancyvrb> propose la commande `\VerbatimFootnotes`. 
Une fois cette commande utilisée dans le préambule, 
il devient possible d'inclure du `verbatim` dans l'argument d'une commande. 
En voici un exemple :

```
\documentclass{article}
  \usepackage{lmodern}   % Caractères plus lisibles
  \pagestyle{empty}      % N'affiche pas de numéro de page
  \usepackage{fancyvrb}

  \VerbatimFootnotes
  \DefineShortVerb{\|}   % voir la doc de fancyvrb

\begin{document}
On peut inclure du texte verbatim dans une
note\footnote{En écrivant directement |\verb|
dans la note de bas de page, avec l'extension
\textit{fancyvrb}.}, sans avoir besoin des
anciens mécanismes avec |\SaveVerb| et |\UseVerb|.
\end{document}
```

:::{note}
Une ancienne méthode consistait à mémoriser le texte verbatim en dehors de la commande avec `\SaveVerb`, 
puis à inclure ce qui a été enregistré, avec `\UseVerb`. Cet usage n'est plus recommandé.
:::