# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventgrid.aio import EventGridManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventGridManagementNamespaceTopicEventSubscriptionsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventGridManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespace_topic_event_subscriptions_get(self, resource_group):
        response = await self.client.namespace_topic_event_subscriptions.get(
            resource_group_name=resource_group.name,
            namespace_name="str",
            topic_name="str",
            event_subscription_name="str",
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespace_topic_event_subscriptions_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.namespace_topic_event_subscriptions.begin_create_or_update(
                resource_group_name=resource_group.name,
                namespace_name="str",
                topic_name="str",
                event_subscription_name="str",
                event_subscription_info={
                    "deliveryConfiguration": {
                        "deliveryMode": "str",
                        "push": {
                            "deadLetterDestinationWithResourceIdentity": {
                                "deadLetterDestination": "dead_letter_destination",
                                "identity": {
                                    "federatedIdentityCredentialInfo": {"federatedClientId": "str"},
                                    "type": "str",
                                    "userAssignedIdentity": "str",
                                },
                            },
                            "deliveryWithResourceIdentity": {
                                "destination": "event_subscription_destination",
                                "identity": {
                                    "federatedIdentityCredentialInfo": {"federatedClientId": "str"},
                                    "type": "str",
                                    "userAssignedIdentity": "str",
                                },
                            },
                            "destination": "event_subscription_destination",
                            "eventTimeToLive": "str",
                            "maxDeliveryCount": 0,
                        },
                        "queue": {
                            "deadLetterDestinationWithResourceIdentity": {
                                "deadLetterDestination": "dead_letter_destination",
                                "identity": {
                                    "federatedIdentityCredentialInfo": {"federatedClientId": "str"},
                                    "type": "str",
                                    "userAssignedIdentity": "str",
                                },
                            },
                            "eventTimeToLive": "1 day, 0:00:00",
                            "maxDeliveryCount": 0,
                            "receiveLockDurationInSeconds": 0,
                        },
                    },
                    "eventDeliverySchema": "str",
                    "expirationTimeUtc": "2020-02-20 00:00:00",
                    "filtersConfiguration": {"filters": ["filter"], "includedEventTypes": ["str"]},
                    "id": "str",
                    "name": "str",
                    "provisioningState": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2025-04-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespace_topic_event_subscriptions_begin_delete(self, resource_group):
        response = await (
            await self.client.namespace_topic_event_subscriptions.begin_delete(
                resource_group_name=resource_group.name,
                namespace_name="str",
                topic_name="str",
                event_subscription_name="str",
                api_version="2025-04-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespace_topic_event_subscriptions_begin_update(self, resource_group):
        response = await (
            await self.client.namespace_topic_event_subscriptions.begin_update(
                resource_group_name=resource_group.name,
                namespace_name="str",
                topic_name="str",
                event_subscription_name="str",
                event_subscription_update_parameters={
                    "deliveryConfiguration": {
                        "deliveryMode": "str",
                        "push": {
                            "deadLetterDestinationWithResourceIdentity": {
                                "deadLetterDestination": "dead_letter_destination",
                                "identity": {
                                    "federatedIdentityCredentialInfo": {"federatedClientId": "str"},
                                    "type": "str",
                                    "userAssignedIdentity": "str",
                                },
                            },
                            "deliveryWithResourceIdentity": {
                                "destination": "event_subscription_destination",
                                "identity": {
                                    "federatedIdentityCredentialInfo": {"federatedClientId": "str"},
                                    "type": "str",
                                    "userAssignedIdentity": "str",
                                },
                            },
                            "destination": "event_subscription_destination",
                            "eventTimeToLive": "str",
                            "maxDeliveryCount": 0,
                        },
                        "queue": {
                            "deadLetterDestinationWithResourceIdentity": {
                                "deadLetterDestination": "dead_letter_destination",
                                "identity": {
                                    "federatedIdentityCredentialInfo": {"federatedClientId": "str"},
                                    "type": "str",
                                    "userAssignedIdentity": "str",
                                },
                            },
                            "eventTimeToLive": "1 day, 0:00:00",
                            "maxDeliveryCount": 0,
                            "receiveLockDurationInSeconds": 0,
                        },
                    },
                    "eventDeliverySchema": "str",
                    "expirationTimeUtc": "2020-02-20 00:00:00",
                    "filtersConfiguration": {"filters": ["filter"], "includedEventTypes": ["str"]},
                    "tags": {"str": "str"},
                },
                api_version="2025-04-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespace_topic_event_subscriptions_list_by_namespace_topic(self, resource_group):
        response = self.client.namespace_topic_event_subscriptions.list_by_namespace_topic(
            resource_group_name=resource_group.name,
            namespace_name="str",
            topic_name="str",
            api_version="2025-04-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespace_topic_event_subscriptions_get_delivery_attributes(self, resource_group):
        response = await self.client.namespace_topic_event_subscriptions.get_delivery_attributes(
            resource_group_name=resource_group.name,
            namespace_name="str",
            topic_name="str",
            event_subscription_name="str",
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_namespace_topic_event_subscriptions_get_full_url(self, resource_group):
        response = await self.client.namespace_topic_event_subscriptions.get_full_url(
            resource_group_name=resource_group.name,
            namespace_name="str",
            topic_name="str",
            event_subscription_name="str",
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...
