# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class BillingModel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Billing model."""

    CAPACITY = "Capacity"
    """Billed on capacity."""


class ConnectionIntent(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Connection Intent."""

    CONNECTED = "Connected"
    """Device is connected to cloud."""
    DISCONNECTED = "Disconnected"
    """Device is disconnected from cloud."""


class ConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Connection status."""

    CONNECTED = "Connected"
    """Device is connected to cloud."""
    DISCONNECTED = "Disconnected"
    """Device is disconnected from cloud."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class RegistrationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Registration status."""

    REGISTERED = "Registered"
    """Device is registered to cloud."""
    UNREGISTERED = "Unregistered"
    """Device is not registered to cloud."""


class ReleaseType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Release Type."""

    INSTALL = "Install"
    """Release is a new install."""
    UPDATE = "Update"
    """Release is update."""


class ResourceProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of a resource type."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
