; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -verify-machineinstrs -mcpu=pwr4 -mattr=-altivec \
; RUN:  -mtriple powerpc-ibm-aix-xcoff < %s | \
; RUN: FileCheck --check-prefixes=32BIT %s

; RUN: llc -verify-machineinstrs -mcpu=pwr4 -mattr=-altivec \
; RUN:  -mtriple powerpc64-ibm-aix-xcoff < %s | \
; RUN: FileCheck --check-prefixes=64BIT %s

%struct.S0 = type {}

%struct.S1 = type { [1 x i8] }
@gS1 = external global %struct.S1, align 1

define void @call_test_byval_1Byte() {
; 32BIT-LABEL: call_test_byval_1Byte:
; 32BIT:       # %bb.0: # %entry
; 32BIT-NEXT:    mflr 0
; 32BIT-NEXT:    stwu 1, -64(1)
; 32BIT-NEXT:    lwz 3, L..C0(2) # @gS1
; 32BIT-NEXT:    stw 0, 72(1)
; 32BIT-NEXT:    lbz 3, 0(3)
; 32BIT-NEXT:    slwi 3, 3, 24
; 32BIT-NEXT:    bl .test_byval_1Byte
; 32BIT-NEXT:    nop
; 32BIT-NEXT:    addi 1, 1, 64
; 32BIT-NEXT:    lwz 0, 8(1)
; 32BIT-NEXT:    mtlr 0
; 32BIT-NEXT:    blr
;
; 64BIT-LABEL: call_test_byval_1Byte:
; 64BIT:       # %bb.0: # %entry
; 64BIT-NEXT:    mflr 0
; 64BIT-NEXT:    stdu 1, -128(1)
; 64BIT-NEXT:    ld 3, L..C0(2) # @gS1
; 64BIT-NEXT:    std 0, 144(1)
; 64BIT-NEXT:    lbz 3, 0(3)
; 64BIT-NEXT:    sldi 3, 3, 56
; 64BIT-NEXT:    bl .test_byval_1Byte
; 64BIT-NEXT:    nop
; 64BIT-NEXT:    addi 1, 1, 128
; 64BIT-NEXT:    ld 0, 16(1)
; 64BIT-NEXT:    mtlr 0
; 64BIT-NEXT:    blr
entry:
  %s0 = alloca %struct.S0, align 8
  %call = call zeroext i8 @test_byval_1Byte(ptr byval(%struct.S0) align 1 %s0, ptr byval(%struct.S1) align 1 @gS1)
  ret void
}

define zeroext i8 @test_byval_1Byte(ptr byval(%struct.S0) align 1 %s0, ptr byval(%struct.S1) align 1 %s) {
; 32BIT-LABEL: test_byval_1Byte:
; 32BIT:       # %bb.0: # %entry
; 32BIT-NEXT:    mr 4, 3
; 32BIT-NEXT:    srwi 3, 3, 24
; 32BIT-NEXT:    stw 4, 24(1)
; 32BIT-NEXT:    blr
;
; 64BIT-LABEL: test_byval_1Byte:
; 64BIT:       # %bb.0: # %entry
; 64BIT-NEXT:    mr 4, 3
; 64BIT-NEXT:    rldicl 3, 3, 8, 56
; 64BIT-NEXT:    std 4, 48(1)
; 64BIT-NEXT:    blr
entry:
  %0 = load i8, ptr %s, align 1
  ret i8 %0
}

@f = common global float 0.000000e+00, align 4

%struct.S2 = type { [2 x i8] }

@gS2 = external global %struct.S2, align 1

define void @call_test_byval_2Byte() {
; 32BIT-LABEL: call_test_byval_2Byte:
; 32BIT:       # %bb.0: # %entry
; 32BIT-NEXT:    mflr 0
; 32BIT-NEXT:    stwu 1, -64(1)
; 32BIT-NEXT:    lwz 3, L..C1(2) # @f
; 32BIT-NEXT:    stw 0, 72(1)
; 32BIT-NEXT:    li 7, 43
; 32BIT-NEXT:    lfs 1, 0(3)
; 32BIT-NEXT:    lwz 3, L..C2(2) # @gS2
; 32BIT-NEXT:    lhz 3, 0(3)
; 32BIT-NEXT:    fmr 2, 1
; 32BIT-NEXT:    slwi 5, 3, 16
; 32BIT-NEXT:    li 3, 42
; 32BIT-NEXT:    bl .test_byval_2Byte
; 32BIT-NEXT:    nop
; 32BIT-NEXT:    addi 1, 1, 64
; 32BIT-NEXT:    lwz 0, 8(1)
; 32BIT-NEXT:    mtlr 0
; 32BIT-NEXT:    blr
;
; 64BIT-LABEL: call_test_byval_2Byte:
; 64BIT:       # %bb.0: # %entry
; 64BIT-NEXT:    mflr 0
; 64BIT-NEXT:    stdu 1, -112(1)
; 64BIT-NEXT:    ld 3, L..C1(2) # @f
; 64BIT-NEXT:    std 0, 128(1)
; 64BIT-NEXT:    li 7, 43
; 64BIT-NEXT:    lfs 1, 0(3)
; 64BIT-NEXT:    ld 3, L..C2(2) # @gS2
; 64BIT-NEXT:    lhz 3, 0(3)
; 64BIT-NEXT:    fmr 2, 1
; 64BIT-NEXT:    sldi 5, 3, 48
; 64BIT-NEXT:    li 3, 42
; 64BIT-NEXT:    bl .test_byval_2Byte
; 64BIT-NEXT:    nop
; 64BIT-NEXT:    addi 1, 1, 112
; 64BIT-NEXT:    ld 0, 16(1)
; 64BIT-NEXT:    mtlr 0
; 64BIT-NEXT:    blr
entry:
  %0 = load float, ptr @f, align 4
  %call = call zeroext i8 @test_byval_2Byte(i32 signext 42, float %0, ptr byval(%struct.S2) align 1 @gS2, float %0, i32 signext 43)
  ret void
}

define zeroext i8 @test_byval_2Byte(i32, float, ptr byval(%struct.S2) align 1 %s, float, i32) {
; 32BIT-LABEL: test_byval_2Byte:
; 32BIT:       # %bb.0: # %entry
; 32BIT-NEXT:    stw 5, 32(1)
; 32BIT-NEXT:    lbz 3, 33(1)
; 32BIT-NEXT:    blr
;
; 64BIT-LABEL: test_byval_2Byte:
; 64BIT:       # %bb.0: # %entry
; 64BIT-NEXT:    std 5, 64(1)
; 64BIT-NEXT:    lbz 3, 65(1)
; 64BIT-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds %struct.S2, ptr %s, i32 0, i32 0, i32 1
  %4 = load i8, ptr %arrayidx, align 1
  ret i8 %4
}

%struct.S3 = type <{ i8, i16 }>
@gS3 = external global %struct.S3, align 1

define void @call_test_byval_3Byte() {
; 32BIT-LABEL: call_test_byval_3Byte:
; 32BIT:       # %bb.0: # %entry
; 32BIT-NEXT:    mflr 0
; 32BIT-NEXT:    stwu 1, -64(1)
; 32BIT-NEXT:    lwz 4, L..C3(2) # @gS3
; 32BIT-NEXT:    li 3, 42
; 32BIT-NEXT:    stw 0, 72(1)
; 32BIT-NEXT:    li 5, 3
; 32BIT-NEXT:    li 6, 4
; 32BIT-NEXT:    li 7, 5
; 32BIT-NEXT:    stw 3, 56(1)
; 32BIT-NEXT:    li 8, 6
; 32BIT-NEXT:    li 9, 7
; 32BIT-NEXT:    lbz 3, 2(4)
; 32BIT-NEXT:    lhz 4, 0(4)
; 32BIT-NEXT:    rlwinm 10, 3, 8, 16, 23
; 32BIT-NEXT:    li 3, 1
; 32BIT-NEXT:    rlwimi 10, 4, 16, 0, 15
; 32BIT-NEXT:    li 4, 2
; 32BIT-NEXT:    bl .test_byval_3Byte
; 32BIT-NEXT:    nop
; 32BIT-NEXT:    addi 1, 1, 64
; 32BIT-NEXT:    lwz 0, 8(1)
; 32BIT-NEXT:    mtlr 0
; 32BIT-NEXT:    blr
;
; 64BIT-LABEL: call_test_byval_3Byte:
; 64BIT:       # %bb.0: # %entry
; 64BIT-NEXT:    mflr 0
; 64BIT-NEXT:    stdu 1, -128(1)
; 64BIT-NEXT:    ld 4, L..C3(2) # @gS3
; 64BIT-NEXT:    li 3, 42
; 64BIT-NEXT:    std 0, 144(1)
; 64BIT-NEXT:    li 5, 3
; 64BIT-NEXT:    li 6, 4
; 64BIT-NEXT:    li 7, 5
; 64BIT-NEXT:    std 3, 112(1)
; 64BIT-NEXT:    li 8, 6
; 64BIT-NEXT:    li 9, 7
; 64BIT-NEXT:    lbz 3, 2(4)
; 64BIT-NEXT:    lhz 4, 0(4)
; 64BIT-NEXT:    rldic 10, 3, 40, 16
; 64BIT-NEXT:    li 3, 1
; 64BIT-NEXT:    rldimi 10, 4, 48, 0
; 64BIT-NEXT:    li 4, 2
; 64BIT-NEXT:    bl .test_byval_3Byte
; 64BIT-NEXT:    nop
; 64BIT-NEXT:    addi 1, 1, 128
; 64BIT-NEXT:    ld 0, 16(1)
; 64BIT-NEXT:    mtlr 0
; 64BIT-NEXT:    blr
entry:
  %call = call zeroext i16 @test_byval_3Byte(i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, ptr byval(%struct.S3) align 1 @gS3, i32 42)
  ret void
}

define zeroext i16 @test_byval_3Byte(i32, i32, i32, i32, i32, i32, i32, ptr byval(%struct.S3) align 1 %s, i32) {
; 32BIT-LABEL: test_byval_3Byte:
; 32BIT:       # %bb.0: # %entry
; 32BIT-NEXT:    stw 10, 52(1)
; 32BIT-NEXT:    lhz 3, 53(1)
; 32BIT-NEXT:    blr
;
; 64BIT-LABEL: test_byval_3Byte:
; 64BIT:       # %bb.0: # %entry
; 64BIT-NEXT:    std 10, 104(1)
; 64BIT-NEXT:    lhz 3, 105(1)
; 64BIT-NEXT:    blr
entry:
  %gep = getelementptr inbounds %struct.S3, ptr %s, i32 0, i32 1
  %8 = load i16, ptr %gep, align 1
  ret i16 %8
}

%struct.S4 = type { [4 x i8] }
%struct.S4A = type { i32 }

@gS4 = external global %struct.S4, align 1

define void @call_test_byval_4Byte() {
; 32BIT-LABEL: call_test_byval_4Byte:
; 32BIT:       # %bb.0: # %entry
; 32BIT-NEXT:    mflr 0
; 32BIT-NEXT:    stwu 1, -80(1)
; 32BIT-NEXT:    lwz 3, L..C4(2) # @gS4
; 32BIT-NEXT:    stw 0, 88(1)
; 32BIT-NEXT:    lwz 3, 0(3)
; 32BIT-NEXT:    lwz 4, 64(1)
; 32BIT-NEXT:    bl .test_byval_4Byte
; 32BIT-NEXT:    nop
; 32BIT-NEXT:    addi 1, 1, 80
; 32BIT-NEXT:    lwz 0, 8(1)
; 32BIT-NEXT:    mtlr 0
; 32BIT-NEXT:    blr
;
; 64BIT-LABEL: call_test_byval_4Byte:
; 64BIT:       # %bb.0: # %entry
; 64BIT-NEXT:    mflr 0
; 64BIT-NEXT:    stdu 1, -128(1)
; 64BIT-NEXT:    ld 3, L..C4(2) # @gS4
; 64BIT-NEXT:    std 0, 144(1)
; 64BIT-NEXT:    lwz 3, 0(3)
; 64BIT-NEXT:    lwz 4, 112(1)
; 64BIT-NEXT:    sldi 3, 3, 32
; 64BIT-NEXT:    sldi 4, 4, 32
; 64BIT-NEXT:    bl .test_byval_4Byte
; 64BIT-NEXT:    nop
; 64BIT-NEXT:    addi 1, 1, 128
; 64BIT-NEXT:    ld 0, 16(1)
; 64BIT-NEXT:    mtlr 0
; 64BIT-NEXT:    blr
entry:
  %s0 = alloca %struct.S0, align 8
  %s4a = alloca %struct.S4A, align 8
  %call = call signext i32 @test_byval_4Byte(ptr byval(%struct.S4) align 1 @gS4, ptr byval(%struct.S0) align 1 %s0, ptr byval(%struct.S4A) align 4 %s4a)
  ret void
}

define signext i32 @test_byval_4Byte(ptr byval(%struct.S4) align 1 %s, ptr byval(%struct.S0) align 1, ptr byval(%struct.S4A) align 4 %s4a) {
; 32BIT-LABEL: test_byval_4Byte:
; 32BIT:       # %bb.0: # %entry
; 32BIT-NEXT:    stw 3, 24(1)
; 32BIT-NEXT:    clrlwi 3, 3, 24
; 32BIT-NEXT:    add 3, 4, 3
; 32BIT-NEXT:    stw 4, 28(1)
; 32BIT-NEXT:    blr
;
; 64BIT-LABEL: test_byval_4Byte:
; 64BIT:       # %bb.0: # %entry
; 64BIT-NEXT:    std 3, 48(1)
; 64BIT-NEXT:    lbz 3, 51(1)
; 64BIT-NEXT:    std 4, 56(1)
; 64BIT-NEXT:    rldicl 4, 4, 32, 32
; 64BIT-NEXT:    add 3, 4, 3
; 64BIT-NEXT:    extsw 3, 3
; 64BIT-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds %struct.S4, ptr %s, i32 0, i32 0, i32 3
  %1 = load i8, ptr %arrayidx, align 1
  %2 = load i32, ptr %s4a, align 4
  %conv = zext i8 %1 to i32
  %add = add nsw i32 %2, %conv
  ret i32 %add
}

%struct.S5 = type { [5 x i8] }

@gS5 = external global %struct.S5, align 1

define void @call_test_byval_5Byte() {
; 32BIT-LABEL: call_test_byval_5Byte:
; 32BIT:       # %bb.0: # %entry
; 32BIT-NEXT:    mflr 0
; 32BIT-NEXT:    stwu 1, -64(1)
; 32BIT-NEXT:    lwz 3, L..C5(2) # @gS5
; 32BIT-NEXT:    stw 0, 72(1)
; 32BIT-NEXT:    lbz 4, 4(3)
; 32BIT-NEXT:    lwz 3, 0(3)
; 32BIT-NEXT:    slwi 4, 4, 24
; 32BIT-NEXT:    bl .test_byval_5Byte[PR]
; 32BIT-NEXT:    nop
; 32BIT-NEXT:    addi 1, 1, 64
; 32BIT-NEXT:    lwz 0, 8(1)
; 32BIT-NEXT:    mtlr 0
; 32BIT-NEXT:    blr
;
; 64BIT-LABEL: call_test_byval_5Byte:
; 64BIT:       # %bb.0: # %entry
; 64BIT-NEXT:    mflr 0
; 64BIT-NEXT:    stdu 1, -112(1)
; 64BIT-NEXT:    ld 3, L..C5(2) # @gS5
; 64BIT-NEXT:    std 0, 128(1)
; 64BIT-NEXT:    lbz 4, 4(3)
; 64BIT-NEXT:    lwz 5, 0(3)
; 64BIT-NEXT:    rlwinm 3, 4, 24, 0, 7
; 64BIT-NEXT:    rldimi 3, 5, 32, 0
; 64BIT-NEXT:    bl .test_byval_5Byte[PR]
; 64BIT-NEXT:    nop
; 64BIT-NEXT:    addi 1, 1, 112
; 64BIT-NEXT:    ld 0, 16(1)
; 64BIT-NEXT:    mtlr 0
; 64BIT-NEXT:    blr
entry:
  %call = call zeroext i8 @test_byval_5Byte(ptr byval(%struct.S5) align 1 @gS5)
  ret void
}

declare zeroext i8 @test_byval_5Byte(ptr byval(%struct.S5) align 1)

%struct.S6 = type { [6 x i8] }

@gS6 = external global %struct.S6, align 1

define void @call_test_byval_6Byte() {
; 32BIT-LABEL: call_test_byval_6Byte:
; 32BIT:       # %bb.0: # %entry
; 32BIT-NEXT:    mflr 0
; 32BIT-NEXT:    stwu 1, -64(1)
; 32BIT-NEXT:    lwz 3, L..C6(2) # @gS6
; 32BIT-NEXT:    stw 0, 72(1)
; 32BIT-NEXT:    lhz 4, 4(3)
; 32BIT-NEXT:    lwz 3, 0(3)
; 32BIT-NEXT:    slwi 4, 4, 16
; 32BIT-NEXT:    bl .test_byval_6Byte[PR]
; 32BIT-NEXT:    nop
; 32BIT-NEXT:    addi 1, 1, 64
; 32BIT-NEXT:    lwz 0, 8(1)
; 32BIT-NEXT:    mtlr 0
; 32BIT-NEXT:    blr
;
; 64BIT-LABEL: call_test_byval_6Byte:
; 64BIT:       # %bb.0: # %entry
; 64BIT-NEXT:    mflr 0
; 64BIT-NEXT:    stdu 1, -112(1)
; 64BIT-NEXT:    ld 3, L..C6(2) # @gS6
; 64BIT-NEXT:    std 0, 128(1)
; 64BIT-NEXT:    lhz 4, 4(3)
; 64BIT-NEXT:    lwz 5, 0(3)
; 64BIT-NEXT:    rlwinm 3, 4, 16, 0, 15
; 64BIT-NEXT:    rldimi 3, 5, 32, 0
; 64BIT-NEXT:    bl .test_byval_6Byte[PR]
; 64BIT-NEXT:    nop
; 64BIT-NEXT:    addi 1, 1, 112
; 64BIT-NEXT:    ld 0, 16(1)
; 64BIT-NEXT:    mtlr 0
; 64BIT-NEXT:    blr
entry:
  %call = call zeroext i8 @test_byval_6Byte(ptr byval(%struct.S6) align 1 @gS6)
  ret void
}

declare zeroext i8 @test_byval_6Byte(ptr byval(%struct.S6) align 1)

%struct.S7 = type { [7 x i8] }

@gS7 = external global %struct.S7, align 1

define void @call_test_byval_7Byte() {
; 32BIT-LABEL: call_test_byval_7Byte:
; 32BIT:       # %bb.0: # %entry
; 32BIT-NEXT:    mflr 0
; 32BIT-NEXT:    stwu 1, -64(1)
; 32BIT-NEXT:    lwz 3, L..C7(2) # @gS7
; 32BIT-NEXT:    stw 0, 72(1)
; 32BIT-NEXT:    lbz 4, 6(3)
; 32BIT-NEXT:    lhz 5, 4(3)
; 32BIT-NEXT:    rlwinm 4, 4, 8, 16, 23
; 32BIT-NEXT:    lwz 3, 0(3)
; 32BIT-NEXT:    rlwimi 4, 5, 16, 0, 15
; 32BIT-NEXT:    bl .test_byval_7Byte[PR]
; 32BIT-NEXT:    nop
; 32BIT-NEXT:    addi 1, 1, 64
; 32BIT-NEXT:    lwz 0, 8(1)
; 32BIT-NEXT:    mtlr 0
; 32BIT-NEXT:    blr
;
; 64BIT-LABEL: call_test_byval_7Byte:
; 64BIT:       # %bb.0: # %entry
; 64BIT-NEXT:    mflr 0
; 64BIT-NEXT:    stdu 1, -112(1)
; 64BIT-NEXT:    ld 3, L..C7(2) # @gS7
; 64BIT-NEXT:    std 0, 128(1)
; 64BIT-NEXT:    lbz 5, 6(3)
; 64BIT-NEXT:    lhz 4, 4(3)
; 64BIT-NEXT:    lwz 6, 0(3)
; 64BIT-NEXT:    rlwinm 3, 5, 8, 16, 23
; 64BIT-NEXT:    rlwimi 3, 4, 16, 0, 15
; 64BIT-NEXT:    rldimi 3, 6, 32, 0
; 64BIT-NEXT:    bl .test_byval_7Byte[PR]
; 64BIT-NEXT:    nop
; 64BIT-NEXT:    addi 1, 1, 112
; 64BIT-NEXT:    ld 0, 16(1)
; 64BIT-NEXT:    mtlr 0
; 64BIT-NEXT:    blr
entry:
  %call = call zeroext i8 @test_byval_7Byte(ptr byval(%struct.S7) align 1 @gS7)
  ret void
}

declare zeroext i8 @test_byval_7Byte(ptr byval(%struct.S7) align 1)

%struct.S8 = type { [8 x i8] }

@gS8 = external global %struct.S8, align 1

define void @call_test_byval_8Byte() {
; 32BIT-LABEL: call_test_byval_8Byte:
; 32BIT:       # %bb.0: # %entry
; 32BIT-NEXT:    mflr 0
; 32BIT-NEXT:    stwu 1, -64(1)
; 32BIT-NEXT:    lwz 3, L..C8(2) # @gS8
; 32BIT-NEXT:    stw 0, 72(1)
; 32BIT-NEXT:    lwz 4, 4(3)
; 32BIT-NEXT:    lwz 3, 0(3)
; 32BIT-NEXT:    bl .test_byval_8Byte[PR]
; 32BIT-NEXT:    nop
; 32BIT-NEXT:    addi 1, 1, 64
; 32BIT-NEXT:    lwz 0, 8(1)
; 32BIT-NEXT:    mtlr 0
; 32BIT-NEXT:    blr
;
; 64BIT-LABEL: call_test_byval_8Byte:
; 64BIT:       # %bb.0: # %entry
; 64BIT-NEXT:    mflr 0
; 64BIT-NEXT:    stdu 1, -112(1)
; 64BIT-NEXT:    ld 3, L..C8(2) # @gS8
; 64BIT-NEXT:    std 0, 128(1)
; 64BIT-NEXT:    ld 3, 0(3)
; 64BIT-NEXT:    bl .test_byval_8Byte[PR]
; 64BIT-NEXT:    nop
; 64BIT-NEXT:    addi 1, 1, 112
; 64BIT-NEXT:    ld 0, 16(1)
; 64BIT-NEXT:    mtlr 0
; 64BIT-NEXT:    blr
entry:
  %call = call zeroext i8 @test_byval_8Byte(ptr byval(%struct.S8) align 1 @gS8)
  ret void
}

declare zeroext i8 @test_byval_8Byte(ptr byval(%struct.S8) align 1)

%struct.S32 = type { [32 x i8] }

@gS32 = external global %struct.S32, align 1

define void @call_test_byval_32Byte() {
; 32BIT-LABEL: call_test_byval_32Byte:
; 32BIT:       # %bb.0: # %entry
; 32BIT-NEXT:    mflr 0
; 32BIT-NEXT:    stwu 1, -64(1)
; 32BIT-NEXT:    lwz 3, L..C9(2) # @gS32
; 32BIT-NEXT:    stw 0, 72(1)
; 32BIT-NEXT:    lwz 10, 28(3)
; 32BIT-NEXT:    lwz 9, 24(3)
; 32BIT-NEXT:    lwz 8, 20(3)
; 32BIT-NEXT:    lwz 7, 16(3)
; 32BIT-NEXT:    lwz 6, 12(3)
; 32BIT-NEXT:    lwz 5, 8(3)
; 32BIT-NEXT:    lwz 4, 4(3)
; 32BIT-NEXT:    lwz 3, 0(3)
; 32BIT-NEXT:    bl .test_byval_32Byte
; 32BIT-NEXT:    nop
; 32BIT-NEXT:    addi 1, 1, 64
; 32BIT-NEXT:    lwz 0, 8(1)
; 32BIT-NEXT:    mtlr 0
; 32BIT-NEXT:    blr
;
; 64BIT-LABEL: call_test_byval_32Byte:
; 64BIT:       # %bb.0: # %entry
; 64BIT-NEXT:    mflr 0
; 64BIT-NEXT:    stdu 1, -112(1)
; 64BIT-NEXT:    ld 3, L..C9(2) # @gS32
; 64BIT-NEXT:    std 0, 128(1)
; 64BIT-NEXT:    ld 6, 24(3)
; 64BIT-NEXT:    ld 5, 16(3)
; 64BIT-NEXT:    ld 4, 8(3)
; 64BIT-NEXT:    ld 3, 0(3)
; 64BIT-NEXT:    bl .test_byval_32Byte
; 64BIT-NEXT:    nop
; 64BIT-NEXT:    addi 1, 1, 112
; 64BIT-NEXT:    ld 0, 16(1)
; 64BIT-NEXT:    mtlr 0
; 64BIT-NEXT:    blr
entry:
  %call = call zeroext i8 @test_byval_32Byte(ptr byval(%struct.S32) align 1 @gS32)
  ret void
}

define zeroext i8 @test_byval_32Byte(ptr byval(%struct.S32) align 1 %s) {
; 32BIT-LABEL: test_byval_32Byte:
; 32BIT:       # %bb.0: # %entry
; 32BIT-NEXT:    stw 8, 44(1)
; 32BIT-NEXT:    stw 3, 24(1)
; 32BIT-NEXT:    lbz 3, 45(1)
; 32BIT-NEXT:    stw 4, 28(1)
; 32BIT-NEXT:    stw 5, 32(1)
; 32BIT-NEXT:    stw 6, 36(1)
; 32BIT-NEXT:    stw 7, 40(1)
; 32BIT-NEXT:    stw 9, 48(1)
; 32BIT-NEXT:    stw 10, 52(1)
; 32BIT-NEXT:    blr
;
; 64BIT-LABEL: test_byval_32Byte:
; 64BIT:       # %bb.0: # %entry
; 64BIT-NEXT:    std 5, 64(1)
; 64BIT-NEXT:    std 3, 48(1)
; 64BIT-NEXT:    lbz 3, 69(1)
; 64BIT-NEXT:    std 4, 56(1)
; 64BIT-NEXT:    std 6, 72(1)
; 64BIT-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds %struct.S32, ptr %s, i32 0, i32 0, i32 21
  %0 = load i8, ptr %arrayidx, align 1
  ret i8 %0
}

; The ByVal handling produces dead stores. See `LowerFormalArguments_AIX` for
; details on why.

%struct.S31 = type <{ float, i32, i64, double, i32, i16, i8 }>

@gS31 = external global %struct.S31, align 1

define void @call_test_byval_31Byte() {
; 32BIT-LABEL: call_test_byval_31Byte:
; 32BIT:       # %bb.0: # %entry
; 32BIT-NEXT:    mflr 0
; 32BIT-NEXT:    stwu 1, -64(1)
; 32BIT-NEXT:    lwz 3, L..C10(2) # @gS31
; 32BIT-NEXT:    stw 0, 72(1)
; 32BIT-NEXT:    lbz 10, 30(3)
; 32BIT-NEXT:    lhz 11, 28(3)
; 32BIT-NEXT:    rlwinm 10, 10, 8, 16, 23
; 32BIT-NEXT:    lwz 9, 24(3)
; 32BIT-NEXT:    rlwimi 10, 11, 16, 0, 15
; 32BIT-NEXT:    lwz 8, 20(3)
; 32BIT-NEXT:    lwz 7, 16(3)
; 32BIT-NEXT:    lwz 6, 12(3)
; 32BIT-NEXT:    lwz 5, 8(3)
; 32BIT-NEXT:    lwz 4, 4(3)
; 32BIT-NEXT:    lwz 3, 0(3)
; 32BIT-NEXT:    bl .test_byval_31Byte
; 32BIT-NEXT:    nop
; 32BIT-NEXT:    addi 1, 1, 64
; 32BIT-NEXT:    lwz 0, 8(1)
; 32BIT-NEXT:    mtlr 0
; 32BIT-NEXT:    blr
;
; 64BIT-LABEL: call_test_byval_31Byte:
; 64BIT:       # %bb.0: # %entry
; 64BIT-NEXT:    mflr 0
; 64BIT-NEXT:    stdu 1, -112(1)
; 64BIT-NEXT:    ld 3, L..C10(2) # @gS31
; 64BIT-NEXT:    std 0, 128(1)
; 64BIT-NEXT:    lbz 6, 30(3)
; 64BIT-NEXT:    lhz 7, 28(3)
; 64BIT-NEXT:    rlwinm 6, 6, 8, 16, 23
; 64BIT-NEXT:    lwz 8, 24(3)
; 64BIT-NEXT:    rlwimi 6, 7, 16, 0, 15
; 64BIT-NEXT:    ld 5, 16(3)
; 64BIT-NEXT:    rldimi 6, 8, 32, 0
; 64BIT-NEXT:    ld 4, 8(3)
; 64BIT-NEXT:    ld 3, 0(3)
; 64BIT-NEXT:    bl .test_byval_31Byte
; 64BIT-NEXT:    nop
; 64BIT-NEXT:    addi 1, 1, 112
; 64BIT-NEXT:    ld 0, 16(1)
; 64BIT-NEXT:    mtlr 0
; 64BIT-NEXT:    blr
entry:
  %call = call double @test_byval_31Byte(ptr byval(%struct.S31) align 1 @gS31)
  ret void
}

define double @test_byval_31Byte(ptr byval(%struct.S31) align 1 %s) {
; 32BIT-LABEL: test_byval_31Byte:
; 32BIT:       # %bb.0: # %entry
; 32BIT-NEXT:    stw 8, 44(1)
; 32BIT-NEXT:    stw 7, 40(1)
; 32BIT-NEXT:    lfd 1, 40(1)
; 32BIT-NEXT:    stw 3, 24(1)
; 32BIT-NEXT:    stw 4, 28(1)
; 32BIT-NEXT:    stw 5, 32(1)
; 32BIT-NEXT:    stw 6, 36(1)
; 32BIT-NEXT:    stw 9, 48(1)
; 32BIT-NEXT:    stw 10, 52(1)
; 32BIT-NEXT:    blr
;
; 64BIT-LABEL: test_byval_31Byte:
; 64BIT:       # %bb.0: # %entry
; 64BIT-NEXT:    std 5, 64(1)
; 64BIT-NEXT:    lfd 1, 64(1)
; 64BIT-NEXT:    std 3, 48(1)
; 64BIT-NEXT:    std 4, 56(1)
; 64BIT-NEXT:    std 6, 72(1)
; 64BIT-NEXT:    blr
entry:
  %gep = getelementptr inbounds %struct.S31, ptr %s, i32 0, i32 3
  %load = load double, ptr %gep, align 1
  ret double %load
}

%struct.F = type { float, float, float }

define i32 @call_test_byval_homogeneous_float_struct() {
; 32BIT-LABEL: call_test_byval_homogeneous_float_struct:
; 32BIT:       # %bb.0: # %entry
; 32BIT-NEXT:    mflr 0
; 32BIT-NEXT:    stwu 1, -80(1)
; 32BIT-NEXT:    li 3, 0
; 32BIT-NEXT:    stw 0, 88(1)
; 32BIT-NEXT:    stw 3, 72(1)
; 32BIT-NEXT:    stw 3, 68(1)
; 32BIT-NEXT:    lwz 5, 72(1)
; 32BIT-NEXT:    lwz 4, 68(1)
; 32BIT-NEXT:    stw 3, 64(1)
; 32BIT-NEXT:    bl .test_byval_homogeneous_float_struct[PR]
; 32BIT-NEXT:    nop
; 32BIT-NEXT:    addi 1, 1, 80
; 32BIT-NEXT:    lwz 0, 8(1)
; 32BIT-NEXT:    mtlr 0
; 32BIT-NEXT:    blr
;
; 64BIT-LABEL: call_test_byval_homogeneous_float_struct:
; 64BIT:       # %bb.0: # %entry
; 64BIT-NEXT:    mflr 0
; 64BIT-NEXT:    stdu 1, -128(1)
; 64BIT-NEXT:    li 3, 0
; 64BIT-NEXT:    std 0, 144(1)
; 64BIT-NEXT:    stw 3, 120(1)
; 64BIT-NEXT:    std 3, 112(1)
; 64BIT-NEXT:    lwz 3, 120(1)
; 64BIT-NEXT:    sldi 4, 3, 32
; 64BIT-NEXT:    li 3, 0
; 64BIT-NEXT:    bl .test_byval_homogeneous_float_struct[PR]
; 64BIT-NEXT:    nop
; 64BIT-NEXT:    addi 1, 1, 128
; 64BIT-NEXT:    ld 0, 16(1)
; 64BIT-NEXT:    mtlr 0
; 64BIT-NEXT:    blr
entry:
  %s = alloca %struct.F, align 8
  call void @llvm.memset.p0.i32(ptr align 4 %s, i8 0, i32 12, i1 false)
  %call = call i32 @test_byval_homogeneous_float_struct(ptr byval(%struct.F) align 4 %s)
  ret i32 %call
}

declare void @llvm.memset.p0.i32(ptr nocapture writeonly, i8, i32, i1 immarg)

declare i32 @test_byval_homogeneous_float_struct(ptr byval(%struct.F) align 4)
