; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu -mcpu=pwr8 < %s | FileCheck %s -check-prefixes=PPC64-P8,PPC64-P8-LE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu -mcpu=pwr7 < %s | FileCheck %s -check-prefixes=PPC64,PPC64-LE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu -mcpu=pwr8 < %s | FileCheck %s -check-prefixes=PPC64-P8,PPC64-P8-BE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu -mcpu=pwr7 < %s | FileCheck %s -check-prefixes=PPC64,PPC64-BE
; RUN: llc -verify-machineinstrs -mtriple=powerpc-unknown-linux-gnu < %s | FileCheck %s -check-prefix=PPC32

define i128 @test_abs(ppc_fp128 %x) nounwind  {
; PPC64-P8-LABEL: test_abs:
; PPC64-P8:       # %bb.0: # %entry
; PPC64-P8-NEXT:    mffprd 3, 1
; PPC64-P8-NEXT:    mffprd 4, 2
; PPC64-P8-NEXT:    rldicr 5, 3, 0, 0
; PPC64-P8-NEXT:    xor 3, 3, 5
; PPC64-P8-NEXT:    xor 4, 4, 5
; PPC64-P8-NEXT:    blr
;
; PPC64-LABEL: test_abs:
; PPC64:       # %bb.0: # %entry
; PPC64-NEXT:    stfd 1, -16(1)
; PPC64-NEXT:    stfd 2, -8(1)
; PPC64-NEXT:    ld 3, -16(1)
; PPC64-NEXT:    ld 4, -8(1)
; PPC64-NEXT:    rldicr 5, 3, 0, 0
; PPC64-NEXT:    xor 3, 3, 5
; PPC64-NEXT:    xor 4, 4, 5
; PPC64-NEXT:    blr
;
; PPC32-LABEL: test_abs:
; PPC32:       # %bb.0: # %entry
; PPC32-NEXT:    stwu 1, -32(1)
; PPC32-NEXT:    stfd 1, 24(1)
; PPC32-NEXT:    stfd 2, 16(1)
; PPC32-NEXT:    lwz 3, 24(1)
; PPC32-NEXT:    lwz 5, 16(1)
; PPC32-NEXT:    rlwinm 7, 3, 0, 0, 0
; PPC32-NEXT:    lwz 4, 28(1)
; PPC32-NEXT:    xor 3, 3, 7
; PPC32-NEXT:    lwz 6, 20(1)
; PPC32-NEXT:    xor 5, 5, 7
; PPC32-NEXT:    addi 1, 1, 32
; PPC32-NEXT:    blr
entry:
	%0 = tail call ppc_fp128 @llvm.fabs.ppcf128(ppc_fp128 %x)
	%1 = bitcast ppc_fp128 %0 to i128
	ret i128 %1
}

define i128 @test_neg(ppc_fp128 %x) nounwind  {
; PPC64-P8-LABEL: test_neg:
; PPC64-P8:       # %bb.0: # %entry
; PPC64-P8-NEXT:    mffprd 4, 2
; PPC64-P8-NEXT:    mffprd 3, 1
; PPC64-P8-NEXT:    li 5, 1
; PPC64-P8-NEXT:    rldic 5, 5, 63, 0
; PPC64-P8-NEXT:    xor 3, 3, 5
; PPC64-P8-NEXT:    xor 4, 4, 5
; PPC64-P8-NEXT:    blr
;
; PPC64-LABEL: test_neg:
; PPC64:       # %bb.0: # %entry
; PPC64-NEXT:    stfd 2, -8(1)
; PPC64-NEXT:    stfd 1, -16(1)
; PPC64-NEXT:    li 5, 1
; PPC64-NEXT:    ld 4, -8(1)
; PPC64-NEXT:    ld 3, -16(1)
; PPC64-NEXT:    rldic 5, 5, 63, 0
; PPC64-NEXT:    xor 3, 3, 5
; PPC64-NEXT:    xor 4, 4, 5
; PPC64-NEXT:    blr
;
; PPC32-LABEL: test_neg:
; PPC32:       # %bb.0: # %entry
; PPC32-NEXT:    stwu 1, -32(1)
; PPC32-NEXT:    stfd 1, 24(1)
; PPC32-NEXT:    stfd 2, 16(1)
; PPC32-NEXT:    lwz 5, 16(1)
; PPC32-NEXT:    lwz 3, 24(1)
; PPC32-NEXT:    lwz 4, 28(1)
; PPC32-NEXT:    xoris 5, 5, 32768
; PPC32-NEXT:    lwz 6, 20(1)
; PPC32-NEXT:    xoris 3, 3, 32768
; PPC32-NEXT:    addi 1, 1, 32
; PPC32-NEXT:    blr
entry:
	%0 = fsub ppc_fp128 0xM80000000000000000000000000000000, %x
	%1 = bitcast ppc_fp128 %0 to i128
	ret i128 %1
}

define i128 @test_copysign(ppc_fp128 %x, ppc_fp128 %y) nounwind  {
; PPC64-P8-LE-LABEL: test_copysign:
; PPC64-P8-LE:       # %bb.0: # %entry
; PPC64-P8-LE-NEXT:    mflr 0
; PPC64-P8-LE-NEXT:    stdu 1, -32(1)
; PPC64-P8-LE-NEXT:    std 0, 48(1)
; PPC64-P8-LE-NEXT:    bl copysignl
; PPC64-P8-LE-NEXT:    nop
; PPC64-P8-LE-NEXT:    mffprd 3, 1
; PPC64-P8-LE-NEXT:    mffprd 4, 2
; PPC64-P8-LE-NEXT:    addi 1, 1, 32
; PPC64-P8-LE-NEXT:    ld 0, 16(1)
; PPC64-P8-LE-NEXT:    mtlr 0
; PPC64-P8-LE-NEXT:    blr
;
; PPC64-LE-LABEL: test_copysign:
; PPC64-LE:       # %bb.0: # %entry
; PPC64-LE-NEXT:    mflr 0
; PPC64-LE-NEXT:    stdu 1, -48(1)
; PPC64-LE-NEXT:    std 0, 64(1)
; PPC64-LE-NEXT:    bl copysignl
; PPC64-LE-NEXT:    nop
; PPC64-LE-NEXT:    stfd 1, 32(1)
; PPC64-LE-NEXT:    stfd 2, 40(1)
; PPC64-LE-NEXT:    ld 3, 32(1)
; PPC64-LE-NEXT:    ld 4, 40(1)
; PPC64-LE-NEXT:    addi 1, 1, 48
; PPC64-LE-NEXT:    ld 0, 16(1)
; PPC64-LE-NEXT:    mtlr 0
; PPC64-LE-NEXT:    blr
;
; PPC64-P8-BE-LABEL: test_copysign:
; PPC64-P8-BE:       # %bb.0: # %entry
; PPC64-P8-BE-NEXT:    mflr 0
; PPC64-P8-BE-NEXT:    stdu 1, -112(1)
; PPC64-P8-BE-NEXT:    std 0, 128(1)
; PPC64-P8-BE-NEXT:    bl copysignl
; PPC64-P8-BE-NEXT:    nop
; PPC64-P8-BE-NEXT:    mffprd 3, 1
; PPC64-P8-BE-NEXT:    mffprd 4, 2
; PPC64-P8-BE-NEXT:    addi 1, 1, 112
; PPC64-P8-BE-NEXT:    ld 0, 16(1)
; PPC64-P8-BE-NEXT:    mtlr 0
; PPC64-P8-BE-NEXT:    blr
;
; PPC64-BE-LABEL: test_copysign:
; PPC64-BE:       # %bb.0: # %entry
; PPC64-BE-NEXT:    mflr 0
; PPC64-BE-NEXT:    stdu 1, -128(1)
; PPC64-BE-NEXT:    std 0, 144(1)
; PPC64-BE-NEXT:    bl copysignl
; PPC64-BE-NEXT:    nop
; PPC64-BE-NEXT:    stfd 1, 112(1)
; PPC64-BE-NEXT:    stfd 2, 120(1)
; PPC64-BE-NEXT:    ld 3, 112(1)
; PPC64-BE-NEXT:    ld 4, 120(1)
; PPC64-BE-NEXT:    addi 1, 1, 128
; PPC64-BE-NEXT:    ld 0, 16(1)
; PPC64-BE-NEXT:    mtlr 0
; PPC64-BE-NEXT:    blr
;
; PPC32-LABEL: test_copysign:
; PPC32:       # %bb.0: # %entry
; PPC32-NEXT:    mflr 0
; PPC32-NEXT:    stwu 1, -80(1)
; PPC32-NEXT:    stw 0, 84(1)
; PPC32-NEXT:    stfd 1, 32(1)
; PPC32-NEXT:    lwz 3, 36(1)
; PPC32-NEXT:    stfd 2, 24(1)
; PPC32-NEXT:    stw 3, 52(1)
; PPC32-NEXT:    lwz 3, 32(1)
; PPC32-NEXT:    stfd 3, 56(1)
; PPC32-NEXT:    stw 3, 48(1)
; PPC32-NEXT:    lwz 3, 28(1)
; PPC32-NEXT:    lfd 4, 64(1)
; PPC32-NEXT:    stw 3, 44(1)
; PPC32-NEXT:    lwz 3, 24(1)
; PPC32-NEXT:    lfd 1, 48(1)
; PPC32-NEXT:    stw 3, 40(1)
; PPC32-NEXT:    lwz 3, 60(1)
; PPC32-NEXT:    lfd 2, 40(1)
; PPC32-NEXT:    stw 3, 76(1)
; PPC32-NEXT:    lwz 3, 56(1)
; PPC32-NEXT:    stw 3, 72(1)
; PPC32-NEXT:    lfd 3, 72(1)
; PPC32-NEXT:    bl copysignl
; PPC32-NEXT:    stfd 1, 8(1)
; PPC32-NEXT:    stfd 2, 16(1)
; PPC32-NEXT:    lwz 3, 8(1)
; PPC32-NEXT:    lwz 4, 12(1)
; PPC32-NEXT:    lwz 5, 16(1)
; PPC32-NEXT:    lwz 6, 20(1)
; PPC32-NEXT:    lwz 0, 84(1)
; PPC32-NEXT:    addi 1, 1, 80
; PPC32-NEXT:    mtlr 0
; PPC32-NEXT:    blr
entry:
	%0 = tail call ppc_fp128 @llvm.copysign.ppcf128(ppc_fp128 %x, ppc_fp128 %y)
	%1 = bitcast ppc_fp128 %0 to i128
	ret i128 %1
}

define i128 @test_copysign_const(ppc_fp128 %x) nounwind  {
; PPC64-P8-LABEL: test_copysign_const:
; PPC64-P8:       # %bb.0: # %entry
; PPC64-P8-NEXT:    mffprd 3, 1
; PPC64-P8-NEXT:    li 5, 3019
; PPC64-P8-NEXT:    rldic 5, 5, 52, 0
; PPC64-P8-NEXT:    rldicr 4, 3, 0, 0
; PPC64-P8-NEXT:    li 3, 16399
; PPC64-P8-NEXT:    rldic 3, 3, 48, 1
; PPC64-P8-NEXT:    or 3, 4, 3
; PPC64-P8-NEXT:    xor 4, 4, 5
; PPC64-P8-NEXT:    blr
;
; PPC64-LABEL: test_copysign_const:
; PPC64:       # %bb.0: # %entry
; PPC64-NEXT:    stfd 1, -8(1)
; PPC64-NEXT:    li 5, 3019
; PPC64-NEXT:    ld 3, -8(1)
; PPC64-NEXT:    rldic 5, 5, 52, 0
; PPC64-NEXT:    rldicr 4, 3, 0, 0
; PPC64-NEXT:    li 3, 16399
; PPC64-NEXT:    rldic 3, 3, 48, 1
; PPC64-NEXT:    or 3, 4, 3
; PPC64-NEXT:    xor 4, 4, 5
; PPC64-NEXT:    blr
;
; PPC32-LABEL: test_copysign_const:
; PPC32:       # %bb.0: # %entry
; PPC32-NEXT:    stwu 1, -32(1)
; PPC32-NEXT:    stfd 1, 24(1)
; PPC32-NEXT:    li 6, 0
; PPC32-NEXT:    lwz 3, 24(1)
; PPC32-NEXT:    rlwinm 4, 3, 0, 0, 0
; PPC32-NEXT:    oris 3, 4, 16399
; PPC32-NEXT:    xoris 5, 4, 48304
; PPC32-NEXT:    li 4, 0
; PPC32-NEXT:    addi 1, 1, 32
; PPC32-NEXT:    blr
entry:
	%0 = tail call ppc_fp128 @llvm.copysign.ppcf128(ppc_fp128 0xM400F000000000000BCB0000000000000, ppc_fp128 %x)
	%1 = bitcast ppc_fp128 %0 to i128
	ret i128 %1
}

declare ppc_fp128 @llvm.fabs.ppcf128(ppc_fp128)
declare ppc_fp128 @llvm.copysign.ppcf128(ppc_fp128, ppc_fp128)
