#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2015 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2019 BetaRays <array@dotslashplay.it>
set -o errexit

###
# The Witcher
# send your bug reports to vv221@dotslashplay.it
###

script_version=20251113.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='the-witcher-1'
GAME_NAME='The Witcher'

## TODO: This archive and the previous ones can be merged once compatibility level is bumped to 2.34.
ARCHIVE_BASE_3_NAME='setup_the_witcher_enhanced_edition_directors_cut_1.5_(cs)_gog_0.2_(77554).exe'
ARCHIVE_BASE_3_MD5='5b6f7dd2247e5fbb1d0049dcc5de6b63'
ARCHIVE_BASE_3_TYPE='innosetup'
ARCHIVE_BASE_3_PART1_NAME='setup_the_witcher_enhanced_edition_directors_cut_1.5_(cs)_gog_0.2_(77554)-1.bin'
ARCHIVE_BASE_3_PART1_MD5='8d242faffa4b3b8dc09ff8697401ece3'
ARCHIVE_BASE_3_PART2_NAME='setup_the_witcher_enhanced_edition_directors_cut_1.5_(cs)_gog_0.2_(77554)-2.bin'
ARCHIVE_BASE_3_PART2_MD5='869b510afebbd14e208a5252392662c7'
ARCHIVE_BASE_3_PART3_NAME='setup_the_witcher_enhanced_edition_directors_cut_1.5_(cs)_gog_0.2_(77554)-3.bin'
ARCHIVE_BASE_3_PART3_MD5='d9fc78540f616d0deb1fe83a91032138'
ARCHIVE_BASE_3_SIZE='14782478'
ARCHIVE_BASE_3_VERSION='1.5.726-gog77554'
ARCHIVE_BASE_3_URL='https://www.gog.com/game/the_witcher'

ARCHIVE_BASE_2_NAME='setup_the_witcher_enhanced_edition_directors_cut_1.5_(cs)_gog_0.2_(77554).exe'
ARCHIVE_BASE_2_MD5='97cffb60d12f41bf03c84165a79a9157'
ARCHIVE_BASE_2_TYPE='innosetup'
ARCHIVE_BASE_2_PART1_NAME='setup_the_witcher_enhanced_edition_directors_cut_1.5_(cs)_gog_0.2_(77554)-1.bin'
ARCHIVE_BASE_2_PART1_MD5='12107f584732052c4e11e09657df655a'
ARCHIVE_BASE_2_PART2_NAME='setup_the_witcher_enhanced_edition_directors_cut_1.5_(cs)_gog_0.2_(77554)-2.bin'
ARCHIVE_BASE_2_PART2_MD5='ee77b189cf42bde0e89ea86c071b830e'
ARCHIVE_BASE_2_PART3_NAME='setup_the_witcher_enhanced_edition_directors_cut_1.5_(cs)_gog_0.2_(77554)-3.bin'
ARCHIVE_BASE_2_PART3_MD5='b5fd3359b7129903a13baf731496f0c7'
ARCHIVE_BASE_2_SIZE='14785291'
ARCHIVE_BASE_2_VERSION='1.5.726-gog77554'

ARCHIVE_BASE_1_NAME='setup_the_witcher_enhanced_edition_directors_cut_1.5_(cs)_gog_0.2_(77554).exe'
ARCHIVE_BASE_1_MD5='3d8467c76abe8cd16711ada268e1600f'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1_NAME='setup_the_witcher_enhanced_edition_directors_cut_1.5_(cs)_gog_0.2_(77554)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='149adafe38e79c246103e664613558c7'
ARCHIVE_BASE_1_PART2_NAME='setup_the_witcher_enhanced_edition_directors_cut_1.5_(cs)_gog_0.2_(77554)-2.bin'
ARCHIVE_BASE_1_PART2_MD5='baa94a6d83dc3a4703d8c414b4442ce5'
ARCHIVE_BASE_1_PART3_NAME='setup_the_witcher_enhanced_edition_directors_cut_1.5_(cs)_gog_0.2_(77554)-3.bin'
ARCHIVE_BASE_1_PART3_MD5='5b74090cd3314dd0db1849c0dce5aa84'
ARCHIVE_BASE_1_SIZE='14781823'
ARCHIVE_BASE_1_VERSION='1.5.726-gog77554'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/the_witcher'

ARCHIVE_BASE_0_NAME='setup_the_witcher_enhanced_edition_1.5_(a)_(10712).exe'
ARCHIVE_BASE_0_MD5='2440cfb5fb4890ff4b9bc4b88b434d38'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_the_witcher_enhanced_edition_1.5_(a)_(10712)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='e530a1a2e86094740b45a14f63260804'
ARCHIVE_BASE_0_PART2_NAME='setup_the_witcher_enhanced_edition_1.5_(a)_(10712)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='fb3a478bcb6e4702e1e8d392cb55391d'
ARCHIVE_BASE_0_PART3_NAME='setup_the_witcher_enhanced_edition_1.5_(a)_(10712)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='2df8369af401815a736f5d88f85fbf8d'
ARCHIVE_BASE_0_SIZE='15000000'
ARCHIVE_BASE_0_VERSION='1.5.726-gog10712'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_witcher'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
## witcher.exe requirements
CONTENT_LIBS_BIN_FILES='
system/binkw32.dll
system/mss32.dll
system/CommonLibs.dll'
CONTENT_GAME_BIN_FILES='
system/miles
system/scripts
system/witcher.exe
system/witcher.ini'
CONTENT_GAME_DATA_FILES='
data/cutscenes
data/dialogues
data/meshes
data/modules
data/movies
data/music
data/scripts
data/templates
data/attackeffects.2da
data/languages.2da
data/2da00.bif
data/cutscenes00.bif
data/dialogues00.bif
data/fx00.bif
data/items00.bif
data/legacy00.bif
data/localized00.bif
data/materials00.bif
data/meshes00.bif
data/mg_poker00.bif
data/music00.bif
data/physics00.bif
data/quests00.bif
data/scripts00.bif
data/sounds00.bif
data/templates00.bif
data/textures00.bif
data/textures01.bif
data/trees00.bif
data/*.bik
data/*.key
data/*.tlk'
## These files are required for text display.
CONTENT_GAME0_DATA_FILES='
system/__cache/*.fontcache'
CONTENT_GAME_DATA_VOICES_FILES='
data/voices/*.bif
data/voices_*.bif'
CONTENT_DOC_DATA_FILES='
manual.pdf
readme.rtf
release.txt'
## "Enhanced Edition" add-ons
CONTENT_ADDONS_RELATIVE_PATH='__support/add/the witcher'
CONTENT_ADDONS_FILES='
*.adv'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Documents/The Witcher'
WINE_REGEDIT_PERSISTENT_KEYS='
HKEY_CURRENT_USER\Software\CD Projekt RED\Witcher\Bindings
HKEY_CURRENT_USER\Software\CD Projekt RED\Witcher\Settings'
## Silence a ShellCheck false positive about single quotes escaping.
# shellcheck disable=SC1003
WINE_REGISTRY_INIT='
[HKEY_LOCAL_MACHINE\Software\CD Projekt Red\The Witcher]

"InstallFolder"="C:\\'"${GAME_ID}"'\\"
"IsDjinniInstalled"=dword:00000000
"Language"="3"
"RegionVersion"="WE"'
## Work around texture display problems.
## cf. https://bugs.winehq.org/show_bug.cgi?id=46553
## (WINE 10.0)
WINE_WINETRICKS_VERBS='d3dx9_35'
## Prevent the mouse from leaving the game window,
## to avoid problems with camera control.
## (WINE 10.0)
WINE_WINETRICKS_VERBS="${WINE_WINETRICKS_VERBS:-} grabfullscreen=y"
## Without a virtual desktop, the game loses input on loss of focus.
## In addition, the game window turns into a black screen.
## (WINE 10.0)
WINE_VIRTUAL_DESKTOP='auto'

APP_MAIN_EXE='system/witcher.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA
PKG_DATA_VOICES
PKG_ADDONS'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
PKG_DATA_DEPENDENCIES_SIBLINGS='
PKG_DATA_VOICES'

PKG_DATA_VOICES_ID="${PKG_DATA_ID}-voices"
PKG_DATA_VOICES_DESCRIPTION='voices'
## Easier upgrades from pre-20251106.4 packages
PKG_DATA_VOICES_PROVIDES='
the-witcher-1-voices'

PKG_ADDONS_ID="${GAME_ID}-addons"
PKG_ADDONS_DESCRIPTION='Enhanced Edition add-ons'
PKG_ADDONS_DEPENDENCIES_SIBLINGS='
PKG_BIN'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
## Include "Enhanced Edition" add-ons.
content_inclusion 'ADDONS' 'PKG_ADDONS' "$(path_game_data)/addons"
content_inclusion_default

# Write launchers.

## Custom WINEPREFIX actions:
## - Install shipped libraries.
## - Include "Enhanced Edition" add-ons.
wineprefix_init_custom() {
	cat <<- EOF
	# Install shipped libraries.
	PATH_LIBRARIES_SYSTEM='$(path_libraries)'
	EOF
	cat <<- 'EOF'
	find "$PATH_LIBRARIES_SYSTEM" -iname '*.dll' | while read -r dll_source; do
		dll_destination="${PATH_PREFIX}${dll_source#"${PATH_LIBRARIES_SYSTEM}"}"
	    mkdir --parents "$(dirname "$dll_destination")"
	    ln --symbolic "$dll_source" "$dll_destination"
	done
	EOF
	cat <<- 'EOF'
	# Include "Enhanced Edition" add-ons.
	if [ -e "${PATH_GAME_DATA}/addons" ]; then
	    install -D --mode=644 \
	        --target-directory="${WINEPREFIX}/drive_c/users/Public/Documents/The Witcher" \
	        "${PATH_GAME_DATA}/addons"/*.adv
	fi
	EOF
}

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
