#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Neurodeck: Psychological Deckbuilder
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251014.3

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='neurodeck-psychological-deckbuilder'
GAME_NAME='Neurodeck: Psychological Deckbuilder'

ARCHIVE_BASE_1_NAME='neurodeck_psychological_deckbuilder_1_5_3_49984.sh'
ARCHIVE_BASE_1_MD5='609908c4cfa583e4fc6d6b3c1764f91b'
ARCHIVE_BASE_1_SIZE='690000'
ARCHIVE_BASE_1_VERSION='1.5.3-gog49984'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/neurodeck_psychological_deckbuilder'

UNITY3D_NAME='Neurodeck'
UNITY3D_PLUGINS='
libfmodstudio.so
libfmodstudioL.so
libresonanceaudio.so
libStandaloneFileBrowser.so'

CONTENT_PATH_DEFAULT='data/noarch/game'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libglib-2.0.so.0
libgobject-2.0.so.0
libgtk-3.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

## Some shipped Unity3D plugins require an executable stack.
game_exec_line() {
	cat <<- EOF
	GLIBC_TUNABLES=glibc.rtld.execstack=2 ./Neurodeck.x86_64 -logFile "./logs/\$(date +%F-%R).log" "\$@"
	EOF
}

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
