<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:bido="http://schema.bmbwk.gv.at/bidokvuni1">
	<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:decimal-format name="euro" decimal-separator="," grouping-separator="." NaN=""/>
	<xsl:variable name="bereich" select="/bido:bido2019_216_2/bereich/."/>
	<xsl:template match="/">
		<html>
			<head>
				<title>BIDO 2019-216-2</title>
				<style type="text/css">
				    h1 { font-family:Arial,sans-serif; font-size:18px; font-weight:bold;}
					h2 { font-family:Arial,sans-serif; font-size:16px; font-weight:bold;}
					p { font-family:Arial,sans-serif; font-size:10px; font-weight:normal;}
					p.fett { font-family:Arial,sans-serif; font-size:10px; font-weight:bold;}
					table {border: 0; font-family:Arial,sans-serif;border-collapse: collapse;border-color: #000000;}
					tr {font-family:Arial,sans-serif; font-size:8px; font-weight:normal; border-bottom-style:solid; border-bottom-width:1;}
					td.werte {font-family:Arial,sans-serif; font-size:8px; font-weight:normal; text-align:right; border-left-width: 1; border-right-width: 1; border-top-width: 1; border-bottom-style: solid; border-bottom-width: 1;}
					td.bez {font-family:Arial,sans-serif; font-size:8px; font-weight:normal; text-align:left; border-left-width: 1; border-right-width: 1; border-top-width: 1; border-bottom-style: solid; border-bottom-width: 1;}
				</style>
			</head>
			<body>
				<xsl:apply-templates select="bido:bido2019_216_2"/>
			</body>
		</html>
	</xsl:template>
	<!--
	-->
	<xsl:template match="bido:bido2019_216_2">
		<h1 class="h1">
			<xsl:text>Bildungsdokumentation</xsl:text>
		</h1>
		<table class="table">
			<tbody>
				<tr>
					<td>
						<xsl:text>Version: </xsl:text>
					</td>
					<td>
						<xsl:value-of select="version"/>
					</td>
				</tr>
				<tr>
					<td>
						<xsl:text>Stichtag: </xsl:text>
					</td>
					<td>
						<xsl:value-of select="stichtag"/>
					</td>
				</tr>
				<tr>
					<td>
						<xsl:text>Kennzeichen: </xsl:text>
					</td>
					<td>
						<xsl:value-of select="kennzeichen"/>
					</td>
				</tr>
				<tr>
					<td>
						<xsl:text>Bereich: </xsl:text>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="$bereich = 'pers'">
								<xsl:text>Personaldaten</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>Raumdaten</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
				<tr>
					<td>
						<xsl:text>Universität: </xsl:text>
					</td>
					<td>
						<xsl:value-of select="universitaet/univname"/>
						<xsl:text> (</xsl:text>
						<xsl:value-of select="universitaet/univkode"/>
						<xsl:text>)</xsl:text>
					</td>
				</tr>
				<tr>
					<td>
						<xsl:text>Lieferdatum: </xsl:text>
					</td>
					<td>
						<xsl:value-of select="lieferdaten/lieferdatum"/>
					</td>
				</tr>
				<tr>
					<td>
						<xsl:text>Lieferzeit: </xsl:text>
					</td>
					<td>
						<xsl:value-of select="lieferdaten/lieferzeit"/>
					</td>
				</tr>
			</tbody>
		</table>
		<h2>
			<xsl:call-template name="bereichname"/>
		</h2>
		<xsl:if test="$bereich = 'pers'">
			<table class="table">
				<tbody>
					<tr>
						<td>
							<xsl:text>Anzahl der Datensätze: </xsl:text>
						</td>
						<td>
							<xsl:value-of select="count(bido_pers/daten//perszeile)"/>
						</td>
					</tr>
				</tbody>
			</table>
			<xsl:apply-templates select="bido_pers"/>
		</xsl:if>
		<xsl:if test="$bereich = 'raum'">
			<table class="table">
				<tbody>
					<tr>
						<td>
							<xsl:text>Anzahl der Datensätze: </xsl:text>
						</td>
						<td>
							<xsl:value-of select="count(bido_raum/daten//raumzeile)"/>
						</td>
					</tr>
				</tbody>
			</table>
			<xsl:apply-templates select="bido_raum"/>
		</xsl:if>
	</xsl:template>
	<!--
	-->
	<xsl:template match="bido_pers">
		<br/>
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="80" align="left">Primekey</th>
					<th width="100" align="left">Satzkennung 1</th>
					<th width="110" align="left">Satzkennung 2</th>
					<th width="50" align="left">Geschl.</th>
					<th width="80" align="left">Geb. Jahr</th>
					<th width="50" align="left">Staat</th>
					<th width="80" align="left">Uni Beginn</th>
					<th width="100" align="left">Beschäft. Art 1</th>
					<th width="100" align="left">Beschäft. Art 2</th>
					<th width="50" align="left">Ausmaß</th>
					<th width="80" align="left">Verwendung</th>
					<th width="80" align="left">Ausbildung</th>
					<th width="80" align="left">Funktion</th>
					<th width="80" align="left">Verw. Beginn</th>
					<th width="50" align="left">Ausmaß Jahresvollzeit</th>
					<th width="50" align="left">Personal Med. Fak.</th>
					<th width="50" align="left">Ausmaß Merkmal 15</th>
				</tr>
				<xsl:apply-templates select="daten"/>
			</tbody>
		</table>
	</xsl:template>
	<!--
	-->
	<xsl:template name="bereichname">
		<xsl:choose>
			<xsl:when test="$bereich = 'pers'">
				<xsl:text>Personaldaten</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text>Raumdaten</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!--
	-->
	<xsl:template match="daten">
		<xsl:if test="$bereich = 'pers'">
			<xsl:for-each select="perszeile">
				<tr class="tr">
					<td class="bez">
						<xsl:value-of select="primekey"/>
					</td>
					<td class="bez">
						<xsl:value-of select="satzkennung1"/>
					</td>
					<td class="bez">
						<xsl:value-of select="satzkennung2"/>
					</td>
					<td class="bez">
						<xsl:value-of select="geschlecht"/>
					</td>
					<td class="bez">
						<xsl:value-of select="geburtsjahr"/>
					</td>
					<td class="bez">
						<xsl:value-of select="staatenkode"/>
					</td>
					<td class="bez">
						<xsl:value-of select="uni_beginn"/>
					</td>
					<td class="bez">
						<xsl:value-of select="beschaeftigungsart1"/>
					</td>
					<td class="bez">
						<xsl:value-of select="beschaeftigungsart2"/>
					</td>
					<td class="bez">
						<xsl:value-of select="ausmass"/>
					</td>
					<td class="bez">
						<xsl:value-of select="verwendung"/>
					</td>
					<td class="bez">
						<xsl:value-of select="ausbildung"/>
					</td>
					<td class="bez">
						<xsl:value-of select="funktion"/>
					</td>
					<td class="bez">
						<xsl:value-of select="verwendung_beginn"/>
					</td>
					<td class="bez">
						<xsl:value-of select="ausmass_jahresvollzeit"/>
					</td>
					<td class="bez">
						<xsl:value-of select="personal_medfak"/>
					</td>
					<td class="bez">
						<xsl:value-of select="ausmass_merkmal15"/>
					</td>
				</tr>
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="$bereich = 'raum'">
			<xsl:for-each select="raumzeile">
				<tr class="tr">
					<td class="bez">
						<xsl:value-of select="primekey"/>
					</td>
					<td class="bez">
						<xsl:value-of select="objektkode"/>
					</td>
					<td class="bez">
						<xsl:value-of select="bezeichnung"/>
					</td>
					<td class="bez">
						<xsl:value-of select="staatenkode"/>
					</td>
					<td class="bez">
						<xsl:value-of select="postleitzahl"/>
					</td>
					<td class="bez">
						<xsl:value-of select="ort"/>
					</td>
					<td class="bez">
						<xsl:value-of select="adresse"/>
					</td>
					<td class="bez">
						<xsl:value-of select="hausnummer"/>
					</td>
					<td class="werte">
						<xsl:if test="nettogrundflaeche">
							<xsl:value-of select="format-number(number(translate(nettogrundflaeche, ',', '.')), '#.##0,00', 'euro')"/>
						</xsl:if>
					</td>
					<td class="werte">
						<xsl:if test="flaechen/einzelflaeche[@art = 'NF1']">
							<xsl:value-of select="format-number(number(translate(flaechen/einzelflaeche[@art = 'NF1'], ',', '.')), '#.##0,00', 'euro')"/>
						</xsl:if>
					</td>
					<td class="werte">
						<xsl:if test="flaechen/einzelflaeche[@art = 'NF2']">
							<xsl:value-of select="format-number(number(translate(flaechen/einzelflaeche[@art = 'NF2'], ',', '.')), '#.##0,00', 'euro')"/>
						</xsl:if>
					</td>
					<td class="werte">
						<xsl:if test="flaechen/einzelflaeche[@art = 'NF3']">
							<xsl:value-of select="format-number(number(translate(flaechen/einzelflaeche[@art = 'NF3'], ',', '.')), '#.##0,00', 'euro')"/>
						</xsl:if>
					</td>
					<td class="werte">
						<xsl:if test="flaechen/einzelflaeche[@art = 'NF4']">
							<xsl:value-of select="format-number(number(translate(flaechen/einzelflaeche[@art = 'NF4'], ',', '.')), '#.##0,00', 'euro')"/>
						</xsl:if>
					</td>
					<td class="werte">
						<xsl:if test="flaechen/einzelflaeche[@art = 'NF5']">
							<xsl:value-of select="format-number(number(translate(flaechen/einzelflaeche[@art = 'NF5'], ',', '.')), '#.##0,00', 'euro')"/>
						</xsl:if>
					</td>
					<td class="werte">
						<xsl:if test="flaechen/einzelflaeche[@art = 'NF6']">
							<xsl:value-of select="format-number(number(translate(flaechen/einzelflaeche[@art = 'NF6'], ',', '.')), '#.##0,00', 'euro')"/>
						</xsl:if>
					</td>
					<td class="werte">
						<xsl:if test="flaechen/einzelflaeche[@art = 'NF7']">
							<xsl:value-of select="format-number(number(translate(flaechen/einzelflaeche[@art = 'NF7'], ',', '.')), '#.##0,00', 'euro')"/>
						</xsl:if>
					</td>
					<td class="werte">
						<xsl:if test="flaechen/einzelflaeche[@art = 'FF8']">
							<xsl:value-of select="format-number(number(translate(flaechen/einzelflaeche[@art = 'FF8'], ',', '.')), '#.##0,00', 'euro')"/>
						</xsl:if>
					</td>
					<td class="werte">
						<xsl:if test="flaechen/einzelflaeche[@art = 'VF9']">
							<xsl:value-of select="format-number(number(translate(flaechen/einzelflaeche[@art = 'VF9'], ',', '.')), '#.##0,00', 'euro')"/>
						</xsl:if>
					</td>
					<td class="werte">
						<xsl:if test="miete">
							<xsl:value-of select="format-number(number(translate(miete, ',', '.')), '#.##0,00', 'euro')"/>
						</xsl:if>
					</td>
					<td class="werte">
						<xsl:if test="betriebskosten">
							<xsl:value-of select="format-number(number(translate(betriebskosten, ',', '.')), '#.##0,00', 'euro')"/>
						</xsl:if>
					</td>
					<td class="werte">
						<xsl:if test="umsatzsteuer">
							<xsl:value-of select="format-number(number(translate(umsatzsteuer, ',', '.')), '#.##0,00', 'euro')"/>
						</xsl:if>
					</td>
				</tr>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	<!--
	-->
	<xsl:template match="bido_raum">
		<br/>
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="80" align="left" rowspan="2">Primekey</th>
					<th width="100" align="left" rowspan="2">Objektcode</th>
					<th width="150" align="left" rowspan="2">Bezeichnung</th>
					<th width="50" align="left" rowspan="2">Staat</th>
					<th width="50" align="left" rowspan="2">PLZ</th>
					<th width="100" align="left" rowspan="2">Ort</th>
					<th width="200" align="left" rowspan="2">Adresse</th>
					<th width="50" align="left" rowspan="2">Nr.</th>
					<th width="100" align="right" rowspan="2">Netto-GF</th>
					<th width="450" align="center" colspan="9">Flächen</th>
					<th width="150" align="right" rowspan="2">Nutzungsentgelt p.a.</th>
					<th width="150" align="right" rowspan="2">Betriebskosten p.a.</th>
					<th width="80" align="right" rowspan="2">UST p.a.</th>
				</tr>
				<tr class="tr">
					<th width="50" align="right">NF1</th>
					<th width="50" align="right">NF2</th>
					<th width="50" align="right">NF3</th>
					<th width="50" align="right">NF4</th>
					<th width="50" align="right">NF5</th>
					<th width="50" align="right">NF6</th>
					<th width="50" align="right">NF7</th>
					<th width="50" align="right">FF8</th>
					<th width="50" align="right">VF9</th>
				</tr>
				<xsl:apply-templates select="daten"/>
			</tbody>
		</table>
	</xsl:template>
</xsl:stylesheet>
