<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:wb="http://schema.bmbwf.gv.at/vii/wissensbilanz2">
	<xsl:output method="html" version="1.0" encoding="UTF-8"
		indent="yes" />
	<xsl:decimal-format name="euro"
		decimal-separator="," grouping-separator="." NaN="" minus-sign="-"
		zero-digit="0" />
	<xsl:variable name="fullDocument" select="/wb:wbv2025_176_1"/>
	<xsl:template match="/">
		<html>
			<head>
				<title>WBV 2025-176-1</title>
				<style type="text/css">
					h1 { font-family:Arial,sans-serif; font-size:18px;
					font-weight:bold;}
					p { font-family:Arial,sans-serif; font-size:10px;
					font-weight:normal;}
					p.fett { font-family:Arial,sans-serif;
					font-size:10px; font-weight:bold;}
					table {border: 0;
					font-family:Arial,sans-serif;border-collapse:
					collapse;border-color: #000000;}
					tr {font-family:Arial,sans-serif;
					font-size:8px; font-weight:normal; border-bottom-style:solid;
					border-bottom-width:1px;}
					td.werte {font-family:Arial,sans-serif;
					font-size:8px; font-weight:normal; text-align:right;
					border-left-width: 1px; border-right-width: 1px; border-top-width:
					1px; border-bottom-style: solid; border-bottom-width: 1px;}
					td.werteborderleft {font-family:Arial,sans-serif; font-size:8px;
					font-weight:normal; text-align:right; border-left: 1px solid;
					border-right-width: 1px; border-top-width: 1px;
					border-bottom-style: solid; border-bottom-width: 1px;}
					th.werte
					{font-family:Arial,sans-serif; font-size:8px; font-weight:bold;
					text-align:right;}
					td.bez {font-family:Arial,sans-serif;
					font-size:8px; font-weight:normal; text-align:left;
					border-left-width: 1px; border-right-width: 1px; border-top-width:
					1px; border-bottom-style: solid; border-bottom-width: 1px;}
					td.bezgruppe {font-family:Arial,sans-serif; font-size:8px;
					font-weight:normal; text-align:left; border-left-width: 1px;
					border-right-width: 1px; border-top-width: 1px;
					border-bottom-style: solid; border-bottom-width: 1px;}
				</style>
			</head>
			<body>
				<xsl:apply-templates />
			</body>
		</html>
	</xsl:template>
	<xsl:template name="formatNegNumber">
		<xsl:param name="val" />
		<xsl:if test="$val &lt; 0">
			<xsl:attribute name="style"><xsl:text>color:red</xsl:text></xsl:attribute>
		</xsl:if>
	</xsl:template>
	<xsl:template match="wb:wbv2025_176_1">
		<h1 class="h1">
			<xsl:text>Wissensbilanz</xsl:text>
		</h1>
		<table class="table">
			<tbody>
				<tr>
					<td>
						<xsl:text>Version: </xsl:text>
					</td>
					<td>
						<xsl:value-of select="version" />
					</td>
				</tr>
				<tr>
					<td>
						<xsl:text>Stichtag-Jahr: </xsl:text>
					</td>
					<td>
						<xsl:value-of select="stichtagjahr" />
					</td>
				</tr>
				<tr>
					<td>
						<xsl:text>Kennzeichen: </xsl:text>
					</td>
					<td>
						<xsl:value-of select="kennzeichen" />
					</td>
				</tr>
				<tr>
					<td>
						<xsl:text>Universität: </xsl:text>
					</td>
					<td>
						<xsl:value-of select="universitaet/univname" />
						<xsl:text> (</xsl:text>
						<xsl:value-of select="universitaet/univkode" />
						<xsl:text>)</xsl:text>
					</td>
				</tr>
				<tr>
					<td>
						<xsl:text>Lieferdatum: </xsl:text>
					</td>
					<td>
						<xsl:value-of select="lieferdaten/lieferdatum" />
					</td>
				</tr>
				<tr>
					<td>
						<xsl:text>Lieferzeit: </xsl:text>
					</td>
					<td>
						<xsl:value-of select="lieferdaten/lieferzeit" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:apply-templates
			select="wb_1 | wb_2 | wb_3 | wb_4 | db_5 | wb_9" />
	</xsl:template>
	<!-- Template gibt die Kopfdaten pro Kennzahl aus -->
	<xsl:template name="printKZKopf">
		<xsl:variable name="kzidf" select="name" />
		<p class="p">
			<xsl:value-of
				select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxwbkennz.xml')//KZKODE[../KZIDF = $kzidf]" />
		</p>
		<p class="fett">
			<xsl:value-of
				select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxwbkennz.xml')//KZBEZ[../KZIDF = $kzidf]" />
		</p>
	</xsl:template>
	<!-- Template gibt die Interpretation pro Kennzahl aus -->
	<xsl:template name="printInterpret">
		<p class="p">
			<xsl:copy-of select="interpretation" />
		</p>
	</xsl:template>
	<!-- -->
	<xsl:template match="wb_1 | wb_2 | wb_3 | wb_4 | db_5">
		<xsl:apply-templates select="*[name() != 'name']" />
	</xsl:template>
	<!-- Leere Kennzahlen (nicht originär) 1.A.1, 2.A.3, 2.A.5, 2.A.6, 2.A.7, 
		2.A.8, 2.A.9, 2.A.10, 3.A.1, 3.A.2, 3.A.3 -->
	<xsl:template
		match="wb_1_A_1 | wb_2_A_3 | wb_2_AM_3 | wb_2_A_5 | wb_2_A_6 | wb_2_A_7 | wb_2_A_8 | wb_2_A_9 | wb_3_A_1 | wb_3_A_2 | wb_3_A_3">
		<xsl:call-template name="printKZKopf" />
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 1.AM.1 -->
	<xsl:template match="wb_1_AM_1">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th />
					<th colspan="3">Köpfe</th>
					<th colspan="3">Vollzeitäquivalente</th>
				</tr>
				<tr class="tr">
					<th width="80" align="left">Personalkategorie</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
				</tr>
				<xsl:for-each select="descendant::personalzeile">
					<xsl:sort select="personalkategorie" data-type="number"
						order="ascending" />
					<xsl:variable name="personalkategorie"
						select="personalkategorie" />
					<tr class="tr">
						<td class="bez">
							<xsl:choose>
								<xsl:when test="ancestor::wb_1_AM_1">
									<xsl:value-of
										select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE6_AV' and ../RV_LOW_VALUE = $personalkategorie]" />
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of
										select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE7_AV' and ../RV_LOW_VALUE = $personalkategorie]" />
								</xsl:otherwise>
							</xsl:choose>
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@frauen), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@maenner), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@gesamt), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(vollzeitaequivalente/@frauen), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(vollzeitaequivalente/@maenner), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(vollzeitaequivalente/@gesamt), '#.##0,00', 'euro')" />
						</td>
					</tr>
				</xsl:for-each>
				<tr class="tr">
					<td class="bezgruppe">Insgesamt</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen[../personalkategorie=1 or ../personalkategorie=8]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen[../personalkategorie=1 or ../personalkategorie=8]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen[../personalkategorie=1 or ../personalkategorie=8]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::vollzeitaequivalente[../personalkategorie=1 or ../personalkategorie=8]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::vollzeitaequivalente[../personalkategorie=1 or ../personalkategorie=8]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::vollzeitaequivalente[../personalkategorie=1 or ../personalkategorie=8]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 1.A.2, 1.AM.2 -->
	<xsl:template match="wb_1_A_2 | wb_1_AM_2">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th colspan="2" />
					<th colspan="18" align="center">Berufungsart</th>
				</tr>
				<tr class="tr">
					<th colspan="2" />
					<th colspan="3" align="center">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN='BERUFUNGSART_AV' and ../RV_LOW_VALUE=1]" />
					</th>
					<th colspan="3" align="center">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN='BERUFUNGSART_AV' and ../RV_LOW_VALUE=2]" />
					</th>
					<th colspan="3" align="center">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN='BERUFUNGSART_AV' and ../RV_LOW_VALUE=3]" />
					</th>
					<th colspan="3" align="center">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN='BERUFUNGSART_AV' and ../RV_LOW_VALUE=4]" />
					</th>
					<th colspan="3" align="center">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN='BERUFUNGSART_AV' and ../RV_LOW_VALUE=5]" />
					</th>
					<th colspan="3" align="center">Gesamt</th>
				</tr>
				<tr class="tr">
					<th width="250" align="left">Wissenschafts-/Kunstzweig</th>
					<th align="left">
						Herkunftsuniversität/
						<br />
						vorherige Dienstgeberin oder
						<br />
						vorheriger Dienstgeber
					</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
				</tr>

				<xsl:variable name="zweige"
					select="descendant::berufungzeile/zweig" />
				<xsl:for-each select="$zweige">
					<xsl:sort select="substring(., 1, 1)" order="ascending" />
					<xsl:sort select="." order="ascending" />
					<xsl:variable name="zweigKategorie"
						select="substring(., 1, 1)" />
					<xsl:if
						test="generate-id() = generate-id($zweige[substring(.,1,1) = substring(current(),1,1)][1])">
						<xsl:call-template name="printZweigByKategorie">
							<xsl:with-param name="kategorie"
								select="$zweigKategorie" />
						</xsl:call-template>
					</xsl:if>
				</xsl:for-each>

				<tr class="tr">
					<td class="bez" colspan="2" style="border-top: 1px solid;">Insgesamt</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten//anzahlen[../berufungsart=1]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten//anzahlen[../berufungsart=1]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten//anzahlen[../berufungsart=1]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten//anzahlen[../berufungsart=2]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten//anzahlen[../berufungsart=2]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten//anzahlen[../berufungsart=2]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten//anzahlen[../berufungsart=3]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten//anzahlen[../berufungsart=3]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten//anzahlen[../berufungsart=3]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten//anzahlen[../berufungsart=4]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten//anzahlen[../berufungsart=4]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten//anzahlen[../berufungsart=4]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten//anzahlen[../berufungsart=5]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten//anzahlen[../berufungsart=5]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten//anzahlen[../berufungsart=5]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten//anzahlen/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten//anzahlen/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten//anzahlen/@gesamt)), '#.##0,00', 'euro')" />
					</td>
				</tr>

			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 1.A.3 -->
	<xsl:template match="wb_1_A_3">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<thead>
				<tr class="tr">
					<th />
					<th align="center" colspan="3">Kopfzahlen</th>
					<th align="center" colspan="2">Anteile in %</th>
					<th align="center" colspan="2">Frauenquoten-Erfüllungsgrad</th>
				</tr>
				<tr class="tr">
					<th width="80" align="left">Monitoring-Kategorie</th>
					<th width="0" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="100" align="werte">Organe mit erfüllter Quote</th>
					<th width="100" align="werte">Organe gesamt</th>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="descendant::quotenzeile">
					<xsl:sort select="monitoringkategorie" order="ascending"
						data-type="number" />
					<xsl:variable name="monitoringkategorie"
						select="monitoringkategorie" />
					<tr class="tr">
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'MONITORINGKATEGORIE_AV' and ../RV_LOW_VALUE = $monitoringkategorie]" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@frauen), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@maenner), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@gesamt), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anteile/@frauen), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anteile/@maenner), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(organanzahlmitquote), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(organanzahl), '#.##0,00', 'euro')" />
						</td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 1.A.4 -->
	<xsl:template match="wb_1_A_4">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr" style="border: 0;">
					<th width="80" align="left" rowspan="2">Personalkategorie</th>
					<th colspan="3">Kopfzahlen</th>
					<th width="50" rowspan="2">
						Gender pay gap
						<br />
						Frauenlöhne entsprechen ...% der Männerlöhne
					</th>
				</tr>
				<tr class="tr">
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
				</tr>

				<xsl:variable name="daten" select="." />
				<xsl:for-each
					select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE1_AV']">
					<xsl:sort select="../SORTFELD" />
					<xsl:variable name="kat" select="../RV_LOW_VALUE" />
					<xsl:if test="$kat=$daten//personalkategorie1">
						<tr class="tr">
							<td class="bez">
								<xsl:value-of select="." />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number($daten//anzahlen[../personalkategorie1=$kat]/@frauen), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number($daten//anzahlen[../personalkategorie1=$kat]/@maenner), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number($daten//anzahlen[../personalkategorie1=$kat]/@gesamt), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:choose>
									<xsl:when
										test="$daten//genderpaygap[../personalkategorie1=$kat] = -1">
										<xsl:text>n.a.</xsl:text>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of
											select="format-number(number($daten//genderpaygap[../personalkategorie1=$kat]), '#.##0,00', 'euro')" />
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
					</xsl:if>
				</xsl:for-each>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 1.A.5 -->
	<xsl:template match="wb_1_A_5">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="60%"></th>
					<th colspan="4" align="center">Anzahl</th>
				</tr>
				<tr class="tr">
					<td class="bez">Verfahren gemäß § 98 UG, die zum Dienstantritt eines
						Professorin / eines Professors geführt haben</td>
					<td colspan="4" align="center">
						<xsl:value-of
							select="format-number(number(descendant::prozessschrittZeile[prozessschritt='8']/anzahlen/@gesamt), '#0', 'euro')" />
					</td>
				</tr>
				<tr class="tr">
					<td class="bez">Prozessschritte</td>
					<td align="center" style="border-right: 2px solid;">
						Ø Frauen-
						<br />
						anteil in %
					</td>
					<td colspan="3" align="center">Kopfzahlen</td>
				</tr>
				<tr class="tr">
					<td colspan="2" style="border-right: 2px solid;" />
					<td align="center">Frauen</td>
					<td align="center">Männer</td>
					<td align="center">Gesamt</td>
				</tr>

				<xsl:for-each select="descendant::prozessschrittZeile">
					<xsl:sort select="prozessschritt" order="ascending" />
					<xsl:variable name="prozessschritt"
						select="prozessschritt" />
					<tr class="tr">
						<xsl:if test="$prozessschritt=2">
							<xsl:attribute name="style">border-bottom: 2px solid;</xsl:attribute>
						</xsl:if>
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PROZESSSCHRITT_AV' and ../RV_LOW_VALUE = $prozessschritt]" />
						</td>
						<td class="werte" style="border-right: 2px solid;">
							<xsl:value-of
								select="format-number(number(frauenanteil), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@frauen), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@maenner), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@gesamt), '#.##0,00', 'euro')" />
						</td>
					</tr>
				</xsl:for-each>

				<tr class="tr" style="border-top: 2px solid;">
					<td />
					<td colspan="4" align="center">
						Chancenindikator
						<br />
						(1= Chancen-Gleichheit)
					</td>
				</tr>

				<tr class="tr">
					<td class="bez">Selektionschance für Frauen – Hearing</td>
					<td class="werte" colspan="4">
						<xsl:value-of
							select="format-number(number(descendant::prozessschrittZeile[prozessschritt=6]/chancenindikator), '#.##0,00', 'euro')" />
					</td>
				</tr>
				<tr class="tr">
					<td class="bez">Selektionschance für Frauen – Berufungsvorschlag</td>
					<td class="werte" colspan="4">
						<xsl:value-of
							select="format-number(number(descendant::prozessschrittZeile[prozessschritt=7]/chancenindikator), '#.##0,00', 'euro')" />
					</td>
				</tr>
				<tr class="tr">
					<td class="bez">Berufungschance für Frauen</td>
					<td class="werte" colspan="4">
						<xsl:value-of
							select="format-number(number(descendant::prozessschrittZeile[prozessschritt=8]/chancenindikator), '#.##0,00', 'euro')" />
					</td>
				</tr>

			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 1.B.1 -->
    <xsl:template match="wb_1_B_1">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th/>
					<th/>
					<th align="center" colspan="3">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE9_AV' and ../RV_LOW_VALUE = 1]" />
					</th>
					<th align="center" colspan="3">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE9_AV' and ../RV_LOW_VALUE = 2]" />
					</th>
					<th align="center" colspan="3">Insgesamt</th>
				</tr>
				<tr class="tr">
					<th width="80" align="left">Aufenthaltsdauer</th>
					<th width="80" align="left">Gastlandkategorie</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte" style="border-right: 1px solid;">Gesamt</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte" style="border-right: 1px solid;">Gesamt</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte" style="border-right: 1px solid;">Gesamt</th>
				</tr>

				<xsl:if test="//aufenthaltsdauer[.=1]">
					<xsl:call-template
						name="printAufenthaltsdauerRow">
						<xsl:with-param name="aufenthaltsdauer" select="1" />
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="//aufenthaltsdauer[.=2]">
					<xsl:call-template
						name="printAufenthaltsdauerRow">
						<xsl:with-param name="aufenthaltsdauer" select="2" />
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="//aufenthaltsdauer[.=3]">
					<xsl:call-template
						name="printAufenthaltsdauerRow">
						<xsl:with-param name="aufenthaltsdauer" select="3" />
					</xsl:call-template>
				</xsl:if>

				<tr class="tr" style="border: 0;">
					<td class="bez" rowspan="2">Insgesamt</td>
					<td class="bez">EU</td>
					<td class="werte">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland=3 and ../personalkategorie=1]/@frauen)" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland=3 and ../personalkategorie=1]/@maenner)" />
					</td>
					<td class="werte" style="border-right: 1px solid;">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland=3 and ../personalkategorie=1]/@gesamt)" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland=3 and ../personalkategorie=2]/@frauen)" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland=3 and ../personalkategorie=2]/@maenner)" />
					</td>
					<td class="werte" style="border-right: 1px solid;">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland=3 and ../personalkategorie=2]/@gesamt)" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland=3 and ../personalkategorie=3]/@frauen)" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland=3 and ../personalkategorie=3]/@maenner)" />
					</td>
					<td class="werte" style="border-right: 1px solid;">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland=3 and ../personalkategorie=3]/@gesamt)" />
					</td>
				</tr>
				<tr class="tr">
					<td class="bez">Drittstaaten</td>
					<td class="werte">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland=4 and ../personalkategorie=1]/@frauen)" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland=4 and ../personalkategorie=1]/@maenner)" />
					</td>
					<td class="werte" style="border-right: 1px solid;">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland=4 and ../personalkategorie=1]/@gesamt)" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland=4 and ../personalkategorie=2]/@frauen)" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland=4 and ../personalkategorie=2]/@maenner)" />
					</td>
					<td class="werte" style="border-right: 1px solid;">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland=4 and ../personalkategorie=2]/@gesamt)" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland=4 and ../personalkategorie=3]/@frauen)" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland=4 and ../personalkategorie=3]/@maenner)" />
					</td>
					<td class="werte" style="border-right: 1px solid;">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland=4 and ../personalkategorie=3]/@gesamt)" />
					</td>
				</tr>
				<tr class="tr">
					<td class="bez" colspan="2" >Gesamt</td>
					<td class="werte">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland!=0 and ../personalkategorie=1]/@frauen)" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland!=0 and ../personalkategorie=1]/@maenner)" />
					</td>
					<td class="werte" style="border-right: 1px solid;">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland!=0 and ../personalkategorie=1]/@gesamt)" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland!=0 and ../personalkategorie=2]/@frauen)" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland!=0 and ../personalkategorie=2]/@maenner)" />
					</td>
					<td class="werte" style="border-right: 1px solid;">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland!=0 and ../personalkategorie=2]/@gesamt)" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland!=0 and ../personalkategorie=3]/@frauen)" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland!=0 and ../personalkategorie=3]/@maenner)" />
					</td>
					<td class="werte" style="border-right: 1px solid;">
						<xsl:value-of
							select="sum(descendant::auslandzeile/anzahlen[../gastland!=0 and ../personalkategorie=3]/@gesamt)" />
					</td>
				</tr>
				
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	
	<xsl:template name="printAufenthaltsdauerRow">
		<xsl:param name="aufenthaltsdauer" />
		<tr class="tr" style="border: 0;">
			<td class="bez" rowspan="3">
				<xsl:value-of
					select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN='AUFENTHALTSDAUER_AV' and ../RV_LOW_VALUE=$aufenthaltsdauer]" />
			</td>
			<td class="bez">EU</td>
			<td class="werte">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland=3 and ../personalkategorie=1]/@frauen)" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland=3 and ../personalkategorie=1]/@maenner)" />
			</td>
			<td class="werte" style="border-right: 1px solid;">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland=3 and ../personalkategorie=1]/@gesamt)" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland=3 and ../personalkategorie=2]/@frauen)" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland=3 and ../personalkategorie=2]/@maenner)" />
			</td>
			<td class="werte" style="border-right: 1px solid;">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland=3 and ../personalkategorie=2]/@gesamt)" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland=3 and ../personalkategorie=3]/@frauen)" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland=3 and ../personalkategorie=3]/@maenner)" />
			</td>
			<td class="werte" style="border-right: 1px solid;">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland=3 and ../personalkategorie=3]/@gesamt)" />
			</td>
		</tr>
		<tr class="tr" style="border: 0;">
			<td class="bez">Drittstaaten</td>
			<td class="werte">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland=4 and ../personalkategorie=1]/@frauen)" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland=4 and ../personalkategorie=1]/@maenner)" />
			</td>
			<td class="werte" style="border-right: 1px solid;">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland=4 and ../personalkategorie=1]/@gesamt)" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland=4 and ../personalkategorie=2]/@frauen)" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland=4 and ../personalkategorie=2]/@maenner)" />
			</td>
			<td class="werte" style="border-right: 1px solid;">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland=4 and ../personalkategorie=2]/@gesamt)" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland=4 and ../personalkategorie=3]/@frauen)" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland=4 and ../personalkategorie=3]/@maenner)" />
			</td>
			<td class="werte" style="border-right: 1px solid;">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland=4 and ../personalkategorie=3]/@gesamt)" />
			</td>
		</tr>
		<tr class="tr" style="border: 0;">
			<td class="bez">Gesamt</td>
			<td class="werte">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland!=0 and ../personalkategorie=1]/@frauen)" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland!=0 and ../personalkategorie=1]/@maenner)" />
			</td>
			<td class="werte" style="border-right: 1px solid;">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland!=0 and ../personalkategorie=1]/@gesamt)" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland!=0 and ../personalkategorie=2]/@frauen)" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland!=0 and ../personalkategorie=2]/@maenner)" />
			</td>
			<td class="werte" style="border-right: 1px solid;">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland!=0 and ../personalkategorie=2]/@gesamt)" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland!=0 and ../personalkategorie=3]/@frauen)" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland!=0 and ../personalkategorie=3]/@maenner)" />
			</td>
			<td class="werte" style="border-right: 1px solid;">
				<xsl:value-of
					select="sum(descendant::auslandzeile/anzahlen[../aufenthaltsdauer=$aufenthaltsdauer and ../gastland!=0 and ../personalkategorie=3]/@gesamt)" />
			</td>
		</tr>
	</xsl:template>

	<!-- Einzeilige Reports 5.2.1, 9.11 -->
	<xsl:template match="db_5_2_1 | wb_9011">
		<xsl:variable name="kzidf" select="name" />
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="500" align="left" />
					<th width="50" class="werte">Gesamt</th>
				</tr>
				<tr class="tr">
					<td class="bez">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxwbkennz.xml')//KZBEZ[../KZIDF = $kzidf]" />
					</td>
					<td class="werte">
						<xsl:choose>
							<xsl:when test="daten/betrag">
								<xsl:value-of
									select="format-number(number(daten/betrag), '#.##0,00', 'euro')" />
							</xsl:when>
							<xsl:when test="daten/anzahl">
								<xsl:value-of
									select="format-number(number(daten/anzahl), '#.##0,00', 'euro')" />
							</xsl:when>
							<xsl:when test="daten/flaeche">
								<xsl:value-of
									select="format-number(number(daten/flaeche), '#.##0,00', 'euro')" />
							</xsl:when>
						</xsl:choose>
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 5.1.3 -->
	<xsl:template match="db_5_1_3">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr" style="border-bottom: 0px solid;">
					<th width="200" align="left" rowspan="2">Spendengeber</th>
					<th width="100" colspan="4">Sitz der Spendengeber</th>
				</tr>
				<tr class="tr">
					<th width="50">national</th>
					<th width="50">sonstige</th>
					<th width="50">Drittstaaten</th>
					<th width="50">Gesamt</th>
				</tr>
				<xsl:variable name="spendengeberListe"
					select="descendant::spendenzeile/geber" />
				<xsl:for-each select="$spendengeberListe">
					<xsl:sort select="." data-type="number" order="ascending" />
					<xsl:variable name="spendengeber" select="." />
					<xsl:if
						test="generate-id() = generate-id($spendengeberListe[. = current()][1])">
						<tr class="tr">
							<td class="bez">
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'SPENDENGEBER_AV' and ../RV_LOW_VALUE=$spendengeber]" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(../..//betrag[../geber=$spendengeber and ../herkunft=1], '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(../..//betrag[../geber=$spendengeber and ../herkunft=2], '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(../..//betrag[../geber=$spendengeber and ../herkunft=3], '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(sum(../..//betrag[../geber=$spendengeber]), '#.##0,00', 'euro')" />
							</td>
						</tr>
					</xsl:if>
				</xsl:for-each>
				<tr class="tr">
					<td class="bez">Insgesamt</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(.//betrag[../herkunft=1]), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(.//betrag[../herkunft=2]), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(.//betrag[../herkunft=3]), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(.//betrag), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 5.1.6 -->
	<xsl:template match="db_5_1_6">
		<xsl:call-template name="printKZKopf" />
		<table class="table" cellpadding="0" cellspacing="0"
			style="border-collapse: collapse;">
			<tbody>
				<tr class="tr">
					<th width="400" colspan="2" />
					<th colspan="3" style="border-right: 1px solid;" width="150">Vollzeitäquivalente</th>
				</tr>
				<tr class="tr" style="border: 0;">
					<th width="100">Fächergruppe</th>
					<th width="300" align="left">Personalkategorie</th>
					<th class="werte" width="50">Frauen</th>
					<th class="werte" width="50">Männer</th>
					<th class="werte" width="50">Gesamt</th>
				</tr>

				<xsl:variable name="faechergruppen"
					select="daten/personalzeile/faechergruppe" />
				<xsl:for-each select="$faechergruppen">
					<xsl:sort select="." order="ascending" />
					<xsl:variable name="faechergruppe" select="." />
					<tr style="border: 0;">
						<xsl:if
							test="generate-id() = generate-id($faechergruppen[. = current()][1])">
							<td width="100"
								style="border-bottom: 0; border-top: 1px solid;">
								<xsl:value-of select="$faechergruppe" />
							</td>
							<td colspan="7" style="border: 0;">
								<table cellpadding="0" cellspacing="0"
									style="border: 0; border-collapse: collapse;">
									<xsl:variable name="personalzeilen"
										select="../../..//personalzeile[faechergruppe=$faechergruppe]" />
									<xsl:for-each select="$personalzeilen">
										<xsl:sort select="personalkategorie"
											order="ascending" />
										<xsl:variable name="persKat"
											select="personalkategorie" />
										<tr style="border: 0;">
											<td width="300"
												style="border-bottom: 0; border-top: 1px solid;">
												<xsl:value-of
													select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE8_AV' and ../RV_LOW_VALUE = $persKat]" />
											</td>
											<td class="werte" width="50"
												style="border-bottom: 0; border-top: 1px solid;">
												<xsl:value-of
													select="format-number(number(./vollzeitaequivalente/@frauen), '#.##0,00', 'euro')" />
											</td>
											<td class="werte" width="50"
												style="border-bottom: 0; border-top: 1px solid;">
												<xsl:value-of
													select="format-number(number(./vollzeitaequivalente/@maenner), '#.##0,00', 'euro')" />
											</td>
											<td class="werte" width="50"
												style="border-bottom: 0; border-top: 1px solid; border-right: 1px solid;">
												<xsl:value-of
													select="format-number(number(./vollzeitaequivalente/@gesamt), '#.##0,00', 'euro')" />
											</td>
										</tr>
									</xsl:for-each>
								</table>
							</td>
						</xsl:if>
					</tr>
				</xsl:for-each>
				<tr style="border-top: 1px solid;">
					<td colspan="2">Insgesamt</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(.//vollzeitaequivalente[../personalkategorie=1]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(.//vollzeitaequivalente[../personalkategorie=1]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte" style="border-right: 1px solid;">
						<xsl:value-of
							select="format-number(number(sum(.//vollzeitaequivalente[../personalkategorie=1]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
				</tr>

			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 2.A.1 -->
	<xsl:template match="wb_2_A_1">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th />
					<th align="center" colspan="5" style="border-right: 1px solid;">Vollzeitäquivalente</th>
					<th align="center" colspan="5">Jahresvollzeitäquivalente</th>
				</tr>
				<tr class="tr">
					<th width="350" align="left">Curriculum</th>
					<th class="werte">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE4_AV' and ../RV_LOW_VALUE = '1']" />
					</th>
					<th class="werte">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE4_AV' and ../RV_LOW_VALUE = '3']" />
					</th>
					<th class="werte">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE4_AV' and ../RV_LOW_VALUE = '2']" />
					</th>
					<th class="werte">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE4_AV' and ../RV_LOW_VALUE = '6']" />
					</th>
					<th class="werte" style="border-right: 1px solid;">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE4_AV' and ../RV_LOW_VALUE = '5']" />
					</th>
					<th class="werte">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE4_AV' and ../RV_LOW_VALUE = '1']" />
					</th>
					<th class="werte">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE4_AV' and ../RV_LOW_VALUE = '3']" />
					</th>
					<th class="werte">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE4_AV' and ../RV_LOW_VALUE = '2']" />
					</th>
					<th class="werte">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE4_AV' and ../RV_LOW_VALUE = '6']" />
					</th>
					<th class="werte">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE4_AV' and ../RV_LOW_VALUE = '5']" />
					</th>
				</tr>

				<xsl:variable name="isceds"
					select="descendant::zeitzeile/iscedf13" />
				<xsl:for-each select="$isceds">
					<xsl:sort select="." order="ascending" />
					<xsl:variable name="isced" select="." />
					<xsl:if
						test="generate-id() = generate-id($isceds[substring(.,1,2) = substring(current(),1,2)][1]) and $isced != 9000">
						<xsl:call-template name="printIscedByKategorie">
							<xsl:with-param name="kategorie"
								select="substring($isced,1,2)" />
						</xsl:call-template>
					</xsl:if>
				</xsl:for-each>


				<tr class="tr">
					<td class="bezgruppe">Insgesamt</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::vollzeitaequivalent[../personalkategorie='1' and ../iscedf13!=9000])), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::vollzeitaequivalent[../personalkategorie='3' and ../iscedf13!=9000])), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::vollzeitaequivalent[../personalkategorie='2' and ../iscedf13!=9000])), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::vollzeitaequivalent[../personalkategorie='6' and ../iscedf13!=9000])), '#.##0,00', 'euro')" />
					</td>
					<td class="werte" style="border-right: 1px solid;">
						<xsl:value-of
							select="format-number(number(sum(descendant::vollzeitaequivalent[../personalkategorie='5' and ../iscedf13!=9000])), '#.##0,00', 'euro')" />
					</td>

					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::jahresvollzeitaequivalent[../personalkategorie='1' and ../iscedf13!=9000])), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::jahresvollzeitaequivalent[../personalkategorie='3' and ../iscedf13!=9000])), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::jahresvollzeitaequivalent[../personalkategorie='2' and ../iscedf13!=9000])), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::jahresvollzeitaequivalent[../personalkategorie='6' and ../iscedf13!=9000])), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::jahresvollzeitaequivalent[../personalkategorie='5' and ../iscedf13!=9000])), '#.##0,00', 'euro')" />
					</td>
				</tr>
				<tr class="tr">
					<td class="bezgruppe" style="padding-left:40px;">davon Lehramtsstudien und
						Pädagogische Studien</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(descendant::vollzeitaequivalent[../personalkategorie='1' and ../iscedf13=9000]), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(descendant::vollzeitaequivalent[../personalkategorie='3' and ../iscedf13=9000]), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(descendant::vollzeitaequivalent[../personalkategorie='2' and ../iscedf13=9000]), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(descendant::vollzeitaequivalent[../personalkategorie='6' and ../iscedf13=9000]), '#.##0,00', 'euro')" />
					</td>
					<td class="werte" style="border-right: 1px solid;">
						<xsl:value-of
							select="format-number(number(descendant::vollzeitaequivalent[../personalkategorie='5' and ../iscedf13=9000]), '#.##0,00', 'euro')" />
					</td>

					<td class="werte">
						<xsl:value-of
							select="format-number(number(descendant::jahresvollzeitaequivalent[../personalkategorie='1' and ../iscedf13=9000]), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(descendant::jahresvollzeitaequivalent[../personalkategorie='3' and ../iscedf13=9000]), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(descendant::jahresvollzeitaequivalent[../personalkategorie='2' and ../iscedf13=9000]), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(descendant::jahresvollzeitaequivalent[../personalkategorie='6' and ../iscedf13=9000]), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(descendant::jahresvollzeitaequivalent[../personalkategorie='5' and ../iscedf13=9000]), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 2.A.2 -->
	<xsl:template match="wb_2_A_2">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr" style="border-bottom: 0px solid;">
					<th align="center" colspan="8" style="border-right: 1px solid;">Studienform</th>
					<th align="center" colspan="5">Programmbeteiligung</th>
				</tr>
				<tr class="tr">
					<th>Studienart</th>
					<th>Präsenzstudien</th>
					<th>davon zur Gänze englischsprachig studierbar</th>
					<th>davon berufsbegleitend studierbar</th>
					<th>Fernstudien</th>
					<th>davon zur Gänze englischsprachig studierbar</th>
					<th>davon berufsbegleitend studierbar</th>
					<th style="border-right: 1px solid;">Gesamt</th>
					<th align="center">internationale Joint Degree/ Double
						Degree/Multiple
						Degree-Programme</th>
					<th align="center">nationale Studienkooperationen</th>
					<th align="center">davon Programme gem. § 54d UG</th>
					<th align="center">davon Programme gem. § 54e UG</th>
					<th align="center">davon sonstige Kooperationen</th>
				</tr>

				<xsl:variable name="daten" select="." />
				<xsl:variable name="studienarten"
					select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN='STUDIENART_AV']" />
				<xsl:for-each select="$studienarten">
					<xsl:sort select="../SORTFELD" data-type="number"
						order="ascending" />
					<xsl:variable name="studienart"
						select="../RV_LOW_VALUE" />
					<xsl:if test="$studienart=$daten//studienart">
						<tr class="tr">
							<td class="bez">
								<xsl:value-of select="." />
							</td>
							<!-- Präsenzstudien -->
							<td class="werte">
								<xsl:value-of
									select="format-number($daten//anzahl[../studienart=$studienart and ../studienform=1], '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number($daten//anzahl[../studienart=$studienart and ../studienform=14], '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number($daten//anzahl[../studienart=$studienart and ../studienform=15], '#.##0,00', 'euro')" />
							</td>
							<!-- Fernstudien -->
							<td class="werte">
								<xsl:value-of
									select="format-number($daten//anzahl[../studienart=$studienart and ../studienform=3], '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number($daten//anzahl[../studienart=$studienart and ../studienform=16], '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number($daten//anzahl[../studienart=$studienart and ../studienform=17], '#.##0,00', 'euro')" />
							</td>
							<!-- Gesamt -->
							<td class="werte" style="border-right: 1px solid;">
								<xsl:value-of
									select="format-number(sum($daten//anzahl[../studienart=$studienart and (../studienform=1 or ../studienform=3)]), '#.##0,00', 'euro')" />
							</td>
							<!-- Kooperationen -->
							<td class="werte">
								<xsl:value-of
									select="format-number($daten//anzahl[../studienart=$studienart and ../studienform=5], '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number($daten//anzahl[../studienart=$studienart and ../studienform=6], '#.##0,00', 'euro')" />
							</td>

							<td class="werte">
								<xsl:value-of
									select="format-number($daten//anzahl[../studienart=$studienart and ../studienform=18], '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number($daten//anzahl[../studienart=$studienart and ../studienform=19], '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number($daten//anzahl[../studienart=$studienart and ../studienform=20], '#.##0,00', 'euro')" />
							</td>
						</tr>
					</xsl:if>
				</xsl:for-each>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 2.B.1, 2.BM.1 -->
	<xsl:template match="wb_2_B_1 | wb_2_BM_1">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr" style="border-bottom: 0px solid;">
					<th width="350" align="left" rowspan="3">Ausbildungsstruktur</th>
					<th align="center" colspan="12">Staatsangehörigkeit</th>
				</tr>
				<tr class="tr" style="border-bottom: 0px solid;">
					<th align="center" colspan="3">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'STAATSANGEHOERIGKEIT_AV' and ../RV_LOW_VALUE = 2]" />
					</th>
					<th align="center" colspan="3">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'STAATSANGEHOERIGKEIT_AV' and ../RV_LOW_VALUE = 3]" />
					</th>
					<th align="center" colspan="3">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'STAATSANGEHOERIGKEIT_AV' and ../RV_LOW_VALUE = 4]" />
					</th>
					<th align="center" colspan="3">Gesamt</th>
				</tr>
				<tr class="tr">
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
				</tr>
				<xsl:variable name="beschaeftigung"
					select="descendant::beschaeftigungszeile/personalkategorie" />
				<xsl:for-each select="$beschaeftigung">
					<xsl:sort select="." data-type="number" order="ascending" />
					<xsl:variable name="personalkategorie" select="." />
					<xsl:if
						test="generate-id() = generate-id($beschaeftigung[. = current()][1])">
						<tr class="tr">
							<td class="bez">
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE2_AV' and ../RV_LOW_VALUE = $personalkategorie]" />
							</td>

							<td class="werte">
								<xsl:value-of
									select="format-number(number(../../beschaeftigungszeile[personalkategorie=$personalkategorie and staatsangehoerigkeit=2]/anzahlen/@frauen), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(../../beschaeftigungszeile[personalkategorie=$personalkategorie and staatsangehoerigkeit=2]/anzahlen/@maenner), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(../../beschaeftigungszeile[personalkategorie=$personalkategorie and staatsangehoerigkeit=2]/anzahlen/@gesamt), '#.##0,00', 'euro')" />
							</td>

							<td class="werte">
								<xsl:value-of
									select="format-number(number(../../beschaeftigungszeile[personalkategorie=$personalkategorie and staatsangehoerigkeit=3]/anzahlen/@frauen), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(../../beschaeftigungszeile[personalkategorie=$personalkategorie and staatsangehoerigkeit=3]/anzahlen/@maenner), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(../../beschaeftigungszeile[personalkategorie=$personalkategorie and staatsangehoerigkeit=3]/anzahlen/@gesamt), '#.##0,00', 'euro')" />
							</td>

							<td class="werte">
								<xsl:value-of
									select="format-number(number(../../beschaeftigungszeile[personalkategorie=$personalkategorie and staatsangehoerigkeit=4]/anzahlen/@frauen), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(../../beschaeftigungszeile[personalkategorie=$personalkategorie and staatsangehoerigkeit=4]/anzahlen/@maenner), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(../../beschaeftigungszeile[personalkategorie=$personalkategorie and staatsangehoerigkeit=4]/anzahlen/@gesamt), '#.##0,00', 'euro')" />
							</td>

							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../../beschaeftigungszeile[personalkategorie=$personalkategorie]/anzahlen/@frauen)), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../../beschaeftigungszeile[personalkategorie=$personalkategorie]/anzahlen/@maenner)), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../../beschaeftigungszeile[personalkategorie=$personalkategorie]/anzahlen/@gesamt)), '#.##0,00', 'euro')" />
							</td>

						</tr>
					</xsl:if>
				</xsl:for-each>
				<tr class="tr">
					<td class="bezgruppe">Insgesamt</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen[../staatsangehoerigkeit=2 and (../personalkategorie=0 or ../personalkategorie=5 or ../personalkategorie=9 or ../personalkategorie=13)]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen[../staatsangehoerigkeit=2 and (../personalkategorie=0 or ../personalkategorie=5 or ../personalkategorie=9 or ../personalkategorie=13)]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen[../staatsangehoerigkeit=2 and (../personalkategorie=0 or ../personalkategorie=5 or ../personalkategorie=9 or ../personalkategorie=13)]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen[../staatsangehoerigkeit=3 and (../personalkategorie=0 or ../personalkategorie=5 or ../personalkategorie=9 or ../personalkategorie=13)]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen[../staatsangehoerigkeit=3 and (../personalkategorie=0 or ../personalkategorie=5 or ../personalkategorie=9 or ../personalkategorie=13)]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen[../staatsangehoerigkeit=3 and (../personalkategorie=0 or ../personalkategorie=5 or ../personalkategorie=9 or ../personalkategorie=13)]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen[../staatsangehoerigkeit=4 and (../personalkategorie=0 or ../personalkategorie=5 or ../personalkategorie=9 or ../personalkategorie=13)]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen[../staatsangehoerigkeit=4 and (../personalkategorie=0 or ../personalkategorie=5 or ../personalkategorie=9 or ../personalkategorie=13)]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen[../staatsangehoerigkeit=4 and (../personalkategorie=0 or ../personalkategorie=5 or ../personalkategorie=9 or ../personalkategorie=13)]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen[../personalkategorie=0 or ../personalkategorie=5 or ../personalkategorie=9 or ../personalkategorie=13]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen[../personalkategorie=0 or ../personalkategorie=5 or ../personalkategorie=9 or ../personalkategorie=13]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen[../personalkategorie=0 or ../personalkategorie=5 or ../personalkategorie=9 or ../personalkategorie=13]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 3.B.1 -->
	<xsl:template match="wb_3_B_1 | wb_3_BM_1">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="200" align="left">Wissenschafts-/Kunstzweig</th>
					<th width="200" align="left">Typus von Publikationen</th>
					<th width="50" class="werte">Gesamt</th>
				</tr>

				<xsl:variable name="daten" select="." />
				<xsl:variable name="hauptZweige"
					select="descendant::publikationzeile/zweig" />
				<xsl:for-each select="$hauptZweige">
					<xsl:sort select="." order="ascending" />
					<xsl:variable name="hauptZweig"
						select="substring(.,1,1)" />
					<xsl:if
						test="generate-id() = generate-id($hauptZweige[substring(.,1,1) = substring(current(),1,1)][1])">
						<tr class="tr" style="border: 0;">
							<td style="border-top: 1px solid;">
								<xsl:value-of select="$hauptZweig" />
								<xsl:text> </xsl:text>
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxwikuzw2014.xml')//WISSZWTEXT[../WISSZWCODE = $hauptZweig]" />
							</td>
							<td class="bez">Gesamt</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(sum(../..//publikationzeile[substring(zweig,1,1)=$hauptZweig and publikation!=12]/anzahl), '#.##0,00', 'euro')" />
							</td>
						</tr>

						<xsl:for-each
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PUBLIKATIONSTYP_AV']">
							<xsl:sort select="../SORTFELD" />
							<xsl:variable name="publikationsTyp"
								select="../RV_LOW_VALUE" />
							<xsl:if
								test="$publikationsTyp=$daten//publikation[substring(../zweig,1,1)=$hauptZweig]">
								<tr style="border: 0;">
									<td />
									<td class="bez">
										<xsl:value-of select="." />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum($daten//publikationzeile[substring(zweig,1,1)=$hauptZweig and publikation=$publikationsTyp]/anzahl), '#.##0,00', 'euro')" />
									</td>
								</tr>
							</xsl:if>
						</xsl:for-each>

						<xsl:variable name="zweige"
							select="../..//publikationzeile[substring(zweig,1,1)=$hauptZweig]/zweig" />
						<xsl:for-each select="$zweige">
							<xsl:sort select="." />
							<xsl:variable name="zweig" select="." />
							<xsl:if
								test="generate-id() = generate-id($zweige[. = current()][1])">
								<tr class="tr" style="border: 0;">
									<td style="padding-left: 10; border-top: 1px solid;">
										<xsl:value-of select="$zweig" />
										<xsl:text> </xsl:text>
										<xsl:value-of
											select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxwikuzw2014.xml')//WISSZWTEXT[../WISSZWCODE = $zweig]" />
									</td>
									<td class="bez">Gesamt</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//publikationzeile[zweig=$zweig and publikation!=12]/anzahl), '#.##0,00', 'euro')" />
									</td>
								</tr>

								<xsl:for-each
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PUBLIKATIONSTYP_AV']">
									<xsl:sort select="../SORTFELD" />
									<xsl:variable name="publikationsTyp"
										select="../RV_LOW_VALUE" />
									<xsl:if
										test="$publikationsTyp=$daten//publikation[../zweig=$zweig]">
										<tr style="border: 0;">
											<td />
											<td class="bez">
												<xsl:value-of select="." />
											</td>
											<td class="werte">
												<xsl:value-of
													select="format-number(sum($daten//publikationzeile[zweig=$zweig and publikation=$publikationsTyp]/anzahl), '#.##0,00', 'euro')" />
											</td>
										</tr>
									</xsl:if>
								</xsl:for-each>

							</xsl:if>
						</xsl:for-each>
					</xsl:if>
				</xsl:for-each>

				<tr class="tr">
					<td class="bezgruppe" colspan="2" style="border-top: 1px solid;">Insgesamt</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahl[../publikation!=12])), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 3.B.2 -->
	<xsl:template match="wb_3_B_2 | wb_3_BM_2">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr" style="border-bottom: 0px solid;">
					<th colspan="2" />
					<th colspan="6">Veranstaltungstypus</th>
				</tr>
				<tr class="tr" style="border-bottom: 0px solid;">
					<th colspan="2" />
					<th colspan="3">
						science to science/
						<br />
						art to art
					</th>
					<th colspan="3">
						science to public/
						<br />
						art to public
					</th>
				</tr>
				<tr>
					<th width="200" align="left">Wissenschafts-/Kunstzweig</th>
					<th width="100" align="left">Vortragsort</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
				</tr>

				<xsl:variable name="daten" select="." />
				<xsl:variable name="hauptZweige"
					select="descendant::herkunftzeile/zweig" />
				<xsl:for-each select="$hauptZweige">
					<xsl:sort select="." order="ascending" />
					<xsl:variable name="hauptZweig"
						select="substring(.,1,1)" />
					<xsl:if
						test="generate-id() = generate-id($hauptZweige[substring(.,1,1) = substring(current(),1,1)][1])">
						<tr class="tr" style="border: 0;">
							<td style="border-top: 1px solid;">
								<xsl:value-of select="$hauptZweig" />
								<xsl:text> </xsl:text>
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxwikuzw2014.xml')//WISSZWTEXT[../WISSZWCODE = $hauptZweig]" />
							</td>
							<td class="bez">Gesamt</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(sum(../..//herkunftzeile[substring(zweig,1,1)=$hauptZweig and veranstaltung=3]/anzahlen/@frauen), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(sum(../..//herkunftzeile[substring(zweig,1,1)=$hauptZweig and veranstaltung=3]/anzahlen/@maenner), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(sum(../..//herkunftzeile[substring(zweig,1,1)=$hauptZweig and veranstaltung=3]/anzahlen/@gesamt), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(sum(../..//herkunftzeile[substring(zweig,1,1)=$hauptZweig and veranstaltung=4]/anzahlen/@frauen), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(sum(../..//herkunftzeile[substring(zweig,1,1)=$hauptZweig and veranstaltung=4]/anzahlen/@maenner), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(sum(../..//herkunftzeile[substring(zweig,1,1)=$hauptZweig and veranstaltung=4]/anzahlen/@gesamt), '#.##0,00', 'euro')" />
							</td>
						</tr>

						<xsl:variable name="herkuenfte"
							select="$daten//herkunft[substring(../zweig,1,1)=$hauptZweig]" />
						<xsl:for-each select="$herkuenfte">
							<xsl:sort select="." />
							<xsl:variable name="herkunft" select="." />
							<xsl:if
								test="generate-id() = generate-id($herkuenfte[. = current()][1])">
								<tr style="border: 0;">
									<td />
									<td class="bez">
										<xsl:value-of
											select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'HERKUNFT_AV' and ../RV_LOW_VALUE = $herkunft]" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum($daten//herkunftzeile[substring(zweig,1,1)=$hauptZweig and herkunft=$herkunft and veranstaltung=3]/anzahlen/@frauen), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum($daten//herkunftzeile[substring(zweig,1,1)=$hauptZweig and herkunft=$herkunft and veranstaltung=3]/anzahlen/@maenner), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum($daten//herkunftzeile[substring(zweig,1,1)=$hauptZweig and herkunft=$herkunft and veranstaltung=3]/anzahlen/@gesamt), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum($daten//herkunftzeile[substring(zweig,1,1)=$hauptZweig and herkunft=$herkunft and veranstaltung=4]/anzahlen/@frauen), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum($daten//herkunftzeile[substring(zweig,1,1)=$hauptZweig and herkunft=$herkunft and veranstaltung=4]/anzahlen/@maenner), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum($daten//herkunftzeile[substring(zweig,1,1)=$hauptZweig and herkunft=$herkunft and veranstaltung=4]/anzahlen/@gesamt), '#.##0,00', 'euro')" />
									</td>
								</tr>
							</xsl:if>
						</xsl:for-each>

						<xsl:variable name="zweige"
							select="../..//herkunftzeile[substring(zweig,1,1)=$hauptZweig]/zweig" />
						<xsl:for-each select="$zweige">
							<xsl:sort select="." order="ascending" />
							<xsl:variable name="zweig" select="." />
							<xsl:if
								test="generate-id() = generate-id($zweige[. = current()][1])">
								<tr class="tr" style="border: 0;">
									<td style="padding-left: 10; border-top: 1px solid;">
										<xsl:value-of select="$zweig" />
										<xsl:text> </xsl:text>
										<xsl:value-of
											select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxwikuzw2014.xml')//WISSZWTEXT[../WISSZWCODE = $zweig]" />
									</td>
									<td class="bez">Gesamt</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//herkunftzeile[zweig=$zweig and veranstaltung=3]/anzahlen/@frauen), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//herkunftzeile[zweig=$zweig and veranstaltung=3]/anzahlen/@maenner), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//herkunftzeile[zweig=$zweig and veranstaltung=3]/anzahlen/@gesamt), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//herkunftzeile[zweig=$zweig and veranstaltung=4]/anzahlen/@frauen), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//herkunftzeile[zweig=$zweig and veranstaltung=4]/anzahlen/@maenner), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//herkunftzeile[zweig=$zweig and veranstaltung=4]/anzahlen/@gesamt), '#.##0,00', 'euro')" />
									</td>
								</tr>

								<xsl:variable name="herkuenfte"
									select="$daten//herkunft[../zweig=$zweig]" />
								<xsl:for-each select="$herkuenfte">
									<xsl:sort select="." />
									<xsl:variable name="herkunft" select="." />
									<xsl:if
										test="generate-id() = generate-id($herkuenfte[. = current()][1])">
										<tr style="border: 0;">
											<td />
											<td class="bez">
												<xsl:value-of
													select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'HERKUNFT_AV' and ../RV_LOW_VALUE = $herkunft]" />
											</td>
											<td class="werte">
												<xsl:value-of
													select="format-number(sum($daten//herkunftzeile[zweig=$zweig and herkunft=$herkunft and veranstaltung=3]/anzahlen/@frauen), '#.##0,00', 'euro')" />
											</td>
											<td class="werte">
												<xsl:value-of
													select="format-number(sum($daten//herkunftzeile[zweig=$zweig and herkunft=$herkunft and veranstaltung=3]/anzahlen/@maenner), '#.##0,00', 'euro')" />
											</td>
											<td class="werte">
												<xsl:value-of
													select="format-number(sum($daten//herkunftzeile[zweig=$zweig and herkunft=$herkunft and veranstaltung=3]/anzahlen/@gesamt), '#.##0,00', 'euro')" />
											</td>
											<td class="werte">
												<xsl:value-of
													select="format-number(sum($daten//herkunftzeile[zweig=$zweig and herkunft=$herkunft and veranstaltung=4]/anzahlen/@frauen), '#.##0,00', 'euro')" />
											</td>
											<td class="werte">
												<xsl:value-of
													select="format-number(sum($daten//herkunftzeile[zweig=$zweig and herkunft=$herkunft and veranstaltung=4]/anzahlen/@maenner), '#.##0,00', 'euro')" />
											</td>
											<td class="werte">
												<xsl:value-of
													select="format-number(sum($daten//herkunftzeile[zweig=$zweig and herkunft=$herkunft and veranstaltung=4]/anzahlen/@gesamt), '#.##0,00', 'euro')" />
											</td>
										</tr>
									</xsl:if>
								</xsl:for-each>
							</xsl:if>
						</xsl:for-each>
					</xsl:if>
				</xsl:for-each>

				<tr class="tr">
					<td class="bez" colspan="2" style="border-top: 1px solid;">Insgesamt</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(descendant::herkunftzeile[veranstaltung=3]/anzahlen/@frauen), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(descendant::herkunftzeile[veranstaltung=3]/anzahlen/@maenner), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(descendant::herkunftzeile[veranstaltung=3]/anzahlen/@gesamt), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(descendant::herkunftzeile[veranstaltung=4]/anzahlen/@frauen), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(descendant::herkunftzeile[veranstaltung=4]/anzahlen/@maenner), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(descendant::herkunftzeile[veranstaltung=4]/anzahlen/@gesamt), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 3.B.3, 3.BM.3 -->
	<xsl:template match="wb_3_B_3 | wb_3_BM_3">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="350" align="left">Zählkategorie</th>
					<th width="50" class="werte">Anzahl</th>
				</tr>
				<xsl:for-each select="descendant::patentzeile">
					<xsl:sort select="patentanzahl" order="ascending"
						data-type="number" />
					<xsl:variable name="patentanzahl"
						select="patentanzahl" />
					<tr class="tr">
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PATENTANZAHL_AV' and ../RV_LOW_VALUE = $patentanzahl]" />
						</td>
						<td class="werte">
							<xsl:choose>
								<xsl:when test="patentanzahl > 12 and anzahl = -1">
									<xsl:text>n.a.</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of
										select="format-number(number(anzahl), '#.##0,00', 'euro')" />
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 1.C.1, 1.CM.1 -->
	<xsl:template match="wb_1_C_1 | wb_1_CM_1">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th colspan="3" />
					<th colspan="4">Sitz der Auftrag-/Fördergeber-Organisation</th>
				</tr>
				<tr class="tr">
					<th colspan="2" width="200" align="left">Wissenschafts-/Kunstzweig</th>
					<th align="left">Auftrag-/Fördergeber-Organisation</th>
					<th width="50">national</th>
					<th width="50">EU</th>
					<th width="50">Drittstaaten</th>
					<th width="50">Gesamt</th>
				</tr>
				
				<xsl:variable name="hauptZweige"
					select="descendant::einnahmenzeile/zweig" />
				<xsl:for-each select="$hauptZweige">
					<xsl:sort select="." order="ascending" />
					<xsl:variable name="hauptZweig"
						select="substring(.,1,1)" />
					<xsl:if
						test="generate-id() = generate-id($hauptZweige[substring(.,1,1) = substring(current(),1,1)][1])">
						<tr class="tr" style="border: 0;">
							<td colspan="2" style="border-top: 1px solid;">
								<xsl:value-of select="$hauptZweig" />
								<xsl:text> </xsl:text>
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxwikuzw2014.xml')//WISSZWTEXT[../WISSZWCODE = $hauptZweig]" />
							</td>
							<td class="bez">
								Gesamt
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(sum(../..//betrag[substring(../zweig,1,1)=$hauptZweig and not(../zweig=999) and ../herkunft=2]), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(sum(../..//betrag[substring(../zweig,1,1)=$hauptZweig and not(../zweig=999) and ../herkunft=3]), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(sum(../..//betrag[substring(../zweig,1,1)=$hauptZweig and not(../zweig=999) and ../herkunft=4]), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(sum(../..//betrag[substring(../zweig,1,1)=$hauptZweig and not(../zweig=999)]), '#.##0,00', 'euro')" />
							</td>
						</tr>
						
						<xsl:variable name="auftraggebers"
							select="../..//auftraggeber[substring(../zweig,1,1)=$hauptZweig and not(../zweig=999)]" />
						<xsl:for-each select="$auftraggebers">
							<xsl:sort select="." />
							<xsl:variable name="auftraggeber" select="." />
							<xsl:if
								test="generate-id() = generate-id($auftraggebers[. = current()][1])">
								<tr style="border: 0;">
									<td colspan="2" />
									<td class="bez">
										<xsl:value-of
											select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'AUFTRAGGEBER_AV' and ../RV_LOW_VALUE = $auftraggeber]" />
									</td>
									
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//betrag[substring(../zweig,1,1)=$hauptZweig and not(../zweig=999) and ../auftraggeber=$auftraggeber  and ../herkunft=2]), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//betrag[substring(../zweig,1,1)=$hauptZweig and not(../zweig=999) and ../auftraggeber=$auftraggeber  and ../herkunft=3]), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//betrag[substring(../zweig,1,1)=$hauptZweig and not(../zweig=999) and ../auftraggeber=$auftraggeber  and ../herkunft=4]), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//betrag[substring(../zweig,1,1)=$hauptZweig and not(../zweig=999) and ../auftraggeber=$auftraggeber ]), '#.##0,00', 'euro')" />
									</td>
								</tr>
							</xsl:if>
						</xsl:for-each>
						
						<xsl:variable name="zweige"
							select="../..//einnahmenzeile[substring(zweig,1,1)=$hauptZweig]/zweig" />
						<xsl:for-each select="$zweige">
							<xsl:sort select="." data-type="number"
								order="ascending" />
							<xsl:variable name="zweig" select="." />
							<xsl:if
								test="generate-id() = generate-id($zweige[. = current()][1])">
								<tr class="tr" style="border: 0;">
									<td colspan="2"
										style="padding-left: 10; border-top: 1px solid;">
										<xsl:value-of select="$zweig" />
										<xsl:text> </xsl:text>
										<xsl:value-of
											select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxwikuzw2014.xml')//WISSZWTEXT[../WISSZWCODE = $zweig]" />
									</td>
									<td class="bez">Gesamt</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//betrag[../zweig=$zweig and ../herkunft=2]), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//betrag[../zweig=$zweig and ../herkunft=3]), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//betrag[../zweig=$zweig and ../herkunft=4]), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//betrag[../zweig=$zweig]), '#.##0,00', 'euro')" />
									</td>
								</tr>
								
								<xsl:variable name="auftraggebers"
									select="../..//auftraggeber[../zweig=$zweig]" />
								<xsl:for-each select="$auftraggebers">
									<xsl:sort select="." />
									<xsl:variable name="auftraggeber" select="." />
									<xsl:if
										test="generate-id() = generate-id($auftraggebers[. = current()][1])">
										<tr style="border: 0;">
											<td colspan="2" />
											<td class="bez">
												<xsl:value-of
													select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'AUFTRAGGEBER_AV' and ../RV_LOW_VALUE = $auftraggeber]" />
											</td>
											
											<td class="werte">
												<xsl:value-of
													select="format-number(sum(../..//betrag[../zweig=$zweig and ../auftraggeber=$auftraggeber  and ../herkunft=2]), '#.##0,00', 'euro')" />
											</td>
											<td class="werte">
												<xsl:value-of
													select="format-number(sum(../..//betrag[../zweig=$zweig and ../auftraggeber=$auftraggeber  and ../herkunft=3]), '#.##0,00', 'euro')" />
											</td>
											<td class="werte">
												<xsl:value-of
													select="format-number(sum(../..//betrag[../zweig=$zweig and ../auftraggeber=$auftraggeber  and ../herkunft=4]), '#.##0,00', 'euro')" />
											</td>
											<td class="werte">
												<xsl:value-of
													select="format-number(sum(../..//betrag[../zweig=$zweig and ../auftraggeber=$auftraggeber ]), '#.##0,00', 'euro')" />
											</td>
										</tr>
									</xsl:if>
								</xsl:for-each>
								
							</xsl:if>
						</xsl:for-each>
					</xsl:if>
				</xsl:for-each>

				
				<tr class="tr">
					<td class="bez" colspan="3" style="border-top: 1px solid;">Insgesamt</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(.//betrag[../herkunft=2]), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(.//betrag[../herkunft=3]), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(.//betrag[../herkunft=4]), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(.//betrag), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	
	<!-- 9.14 -->
	<xsl:template match="wb_9014">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th colspan="2" />
					<xsl:for-each
						select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
						<xsl:sort select="RV_LOW_VALUE" />
						<th colspan="3">
							<xsl:value-of select="RV_MEANING" />
						</th>
					</xsl:for-each>
				</tr>
				<tr class="tr">
					<th colspan="2" align="left">Wiss-/Kunstzweig Bezeichnung</th>
					<xsl:for-each
						select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
						<th width="100">national</th>
						<th width="100">EU (ohne A)</th>
						<th width="100">Gesamt</th>
					</xsl:for-each>
				</tr>
				<xsl:variable name="zweige"
					select="descendant::erloeszeile/zweig" />
				<xsl:for-each select="$zweige">
					<xsl:sort select="." order="ascending" />
					<xsl:variable name="zweig" select="." />
					<xsl:if
						test="generate-id() = generate-id($zweige[. = current()][1])">
						<tr style="border: 0; border-top: 1px solid;">
							<td style="padding-right: 20;">
								<xsl:value-of select="$zweig" />
							</td>
							<td width="320" style="border-bottom: 1px solid;">
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxwikuzw2014.xml')//WISSZWTEXT[../WISSZWCODE = $zweig]" />
							</td>
							<xsl:for-each
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
								<xsl:sort select="RV_LOW_VALUE" />
								<xsl:variable name="rsatyp" select="RV_LOW_VALUE" />
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum($fullDocument/wb_9/wb_9014//betrag[../zweig=$zweig and ../herkunft=2 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
								</td>
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum($fullDocument/wb_9/wb_9014//betrag[../zweig=$zweig and ../herkunft=3 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
								</td>
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum($fullDocument/wb_9/wb_9014//betrag[../zweig=$zweig and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
								</td>
							</xsl:for-each>
						</tr>

						<xsl:variable name="zweigAuftraggeber"
							select="//wb_9014//auftraggeber[../zweig=$zweig]" />
						<xsl:for-each select="$zweigAuftraggeber">
							<xsl:sort select="." order="ascending" />
							<xsl:variable name="auftraggeber" select="." />
							<xsl:if
								test="generate-id() = generate-id($zweigAuftraggeber[. = current()][1])">
								<tr style="border: 0;">
									<td />
									<td style="border-bottom: 1px solid; padding-left: 20;">
										<xsl:value-of
											select="format-number($auftraggeber, '##00', 'euro')" />
										<xsl:text> ... </xsl:text>
										<xsl:value-of
											select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'AUFTRAGGEBER_AV' and ../RV_LOW_VALUE = $auftraggeber]" />
									</td>
									<xsl:for-each
										select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
										<xsl:sort select="RV_LOW_VALUE" />
										<xsl:variable name="rsatyp" select="RV_LOW_VALUE" />
										<td class="werte">
											<xsl:value-of
												select="format-number(number(sum($fullDocument/wb_9/wb_9014//betrag[../zweig=$zweig and ../auftraggeber=$auftraggeber and ../herkunft=2 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
										</td>
										<td class="werte">
											<xsl:value-of
												select="format-number(number(sum($fullDocument/wb_9/wb_9014//betrag[../zweig=$zweig and ../auftraggeber=$auftraggeber and ../herkunft=3 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
										</td>
										<td class="werte">
											<xsl:value-of
												select="format-number(number(sum($fullDocument/wb_9/wb_9014//betrag[../zweig=$zweig and ../auftraggeber=$auftraggeber and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
										</td>
									</xsl:for-each>
								</tr>
							</xsl:if>
						</xsl:for-each>
					</xsl:if>
				</xsl:for-each>
				<tr class="tr">
					<td class="bez" colspan="2" style="border-top: 1px solid;">Insgesamt</td>

					<xsl:for-each
						select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
						<xsl:sort select="RV_LOW_VALUE" />
						<xsl:variable name="rsatyp" select="RV_LOW_VALUE" />
						<td class="werte">
							<xsl:value-of
								select="format-number(number(sum($fullDocument/wb_9/wb_9014//betrag[../herkunft=2 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(sum($fullDocument/wb_9/wb_9014//betrag[../herkunft=3 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(sum($fullDocument/wb_9/wb_9014//betrag[../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
						</td>
					</xsl:for-each>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 1.C.2, 1.CM.2 -->
	<xsl:template match="wb_1_C_2 | wb_1_CM_2">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr" style="border: 0px solid;">
					<th width="400" align="left" rowspan="2">Wissenschafts-/Kunstzweig</th>
					<th width="200" colspan="5">Investitionsbereich</th>
					<th width="50" class="werte" rowspan="2">Gesamt</th>
				</tr>
				<tr class="tr">
					<th>Großgeräte/Großanlagen</th>
					<th>Core Facilities</th>
					<th>Elektronische Datenbanken / Sammlungen</th>
					<th>Räumliche Infrastruktur</th>
					<th>Sonstige Forschungsinfrastruktur</th>
				</tr>

				<xsl:variable name="hauptZweige"
					select="descendant::aufwendungzeile/zweig" />
				<xsl:for-each select="$hauptZweige">
					<xsl:sort select="." order="ascending" />
					<xsl:variable name="hauptZweig"
						select="substring(.,1,1)" />
					<xsl:if
						test="generate-id() = generate-id($hauptZweige[substring(.,1,1) = substring(current(),1,1)][1])">
						<tr class="tr">
							<td class="bez">
								<xsl:value-of select="$hauptZweig" />
								<xsl:text> </xsl:text>
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxwikuzw2014.xml')//WISSZWTEXT[../WISSZWCODE = $hauptZweig]" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(sum(../..//betrag[substring(../zweig,1,1)=$hauptZweig and ../investitionsbereich=1]), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(sum(../..//betrag[substring(../zweig,1,1)=$hauptZweig and ../investitionsbereich=2]), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(sum(../..//betrag[substring(../zweig,1,1)=$hauptZweig and ../investitionsbereich=3]), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(sum(../..//betrag[substring(../zweig,1,1)=$hauptZweig and ../investitionsbereich=4]), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(sum(../..//betrag[substring(../zweig,1,1)=$hauptZweig and ../investitionsbereich=5]), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(sum(../..//betrag[substring(../zweig,1,1)=$hauptZweig]), '#.##0,00', 'euro')" />
							</td>
						</tr>
						<xsl:variable name="zweige"
							select="../..//aufwendungzeile/zweig[substring(.,1,1)=$hauptZweig]" />
						<xsl:for-each select="$zweige">
							<xsl:sort select="." data-type="number"
								order="ascending" />
							<xsl:variable name="zweig" select="." />
							<xsl:if
								test="generate-id() = generate-id($zweige[. = current()][1])">
								<tr class="tr">
									<td class="bez" style="padding-left: 10;">
										<xsl:value-of select="$zweig" />
										<xsl:text> </xsl:text>
										<xsl:value-of
											select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxwikuzw2014.xml')//WISSZWTEXT[../WISSZWCODE = $zweig]" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//betrag[../zweig=$zweig and ../investitionsbereich=1]), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//betrag[../zweig=$zweig and ../investitionsbereich=2]), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//betrag[../zweig=$zweig and ../investitionsbereich=3]), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//betrag[../zweig=$zweig and ../investitionsbereich=4]), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//betrag[../zweig=$zweig and ../investitionsbereich=5]), '#.##0,00', 'euro')" />
									</td>
									<td class="werte">
										<xsl:value-of
											select="format-number(sum(../..//betrag[../zweig=$zweig]), '#.##0,00', 'euro')" />
									</td>
								</tr>
							</xsl:if>
						</xsl:for-each>
					</xsl:if>
				</xsl:for-each>
				<tr class="tr">
					<td class="bez">Insgesamt</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(.//betrag[../investitionsbereich=1]), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(.//betrag[../investitionsbereich=2]), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(.//betrag[../investitionsbereich=3]), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(.//betrag[../investitionsbereich=4]), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(.//betrag[../investitionsbereich=5]), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(.//betrag), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 4.1 -->
	<xsl:template match="wb_4_1">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th />
					<th colspan="2" align="center">Begutachtungstyp</th>
					<th />
				</tr>
				<tr class="tr">
					<th>Kategorien</th>
					<th align="center">
						Begutachtung im eigenen
						<br />
						Bereich
						<br />
						der Universität/
						<br />
						Medizinischen Fakultät
					</th>
					<th align="center">
						Begutachtung
						<br />
						für Externe
					</th>
					<th align="center">Gesamt</th>
				</tr>
				<xsl:variable name="studien"
					select="daten/begutachtungszeile/studie" />
				<xsl:for-each select="$studien">
					<xsl:sort select="." order="ascending" />
					<xsl:variable name="studie" select="." />
					<xsl:if
						test="generate-id() = generate-id($studien[. = current()][1])">
						<tr class="tr">
							<td class="bez">
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'STUDIE_AV' and ../RV_LOW_VALUE = $studie]" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(../../begutachtungszeile[studie=$studie and begutachtung='1']/anzahl), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(../../begutachtungszeile[studie=$studie and begutachtung='3']/anzahl), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../../begutachtungszeile[studie=$studie]/anzahl)), '#.##0,00', 'euro')" />
							</td>
						</tr>
					</xsl:if>
				</xsl:for-each>
				<tr class="tr">
					<td class="bezgruppe">Insgesamt</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten/begutachtungszeile/begutachtung[. = '1']/../anzahl)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten/begutachtungszeile/begutachtung[. = '3']/../anzahl)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(daten/begutachtungszeile/anzahl)), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 4.2 -->
	<xsl:template match="wb_4_2">
		<xsl:variable name="kzidf" select="name" />
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="200" align="left">Kategorien</th>
					<th width="50" align="center">Anzahl der Teilnehmerinnen/Teilnehmer</th>
				</tr>
				<xsl:for-each select="descendant::teilnehmerzeile">
					<xsl:sort select="studie" order="ascending" />
					<xsl:variable name="studie" select="studie" />
					<tr class="tr">
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'STUDIE_AV' and ../RV_LOW_VALUE = $studie]" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahl), '#.##0,00', 'euro')" />
						</td>
					</tr>
				</xsl:for-each>
				<tr class="tr">
					<td class="bezgruppe">
						<xsl:text>Insgesamt</xsl:text>
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahl)), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 4.3 -->
	<xsl:template match="wb_4_3">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="350" align="left">Dienstgeberin oder Dienstgeber</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
				</tr>
				<xsl:for-each select="descendant::dienstgeberzeile">
					<xsl:sort select="dienstgeber" order="ascending" />
					<xsl:variable name="dienstgeber" select="dienstgeber" />
					<tr class="tr">
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'DIENSTGEBER_AV' and ../RV_LOW_VALUE = $dienstgeber]" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@frauen), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@maenner), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@gesamt), '#.##0,00', 'euro')" />
						</td>
					</tr>
				</xsl:for-each>
				<tr class="tr">
					<td class="bezgruppe">Insgesamt</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen/@gesamt)), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 4.4 -->
	<xsl:template match="wb_4_4">
		<xsl:variable name="kzidf" select="name" />
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="200" align="left" />
					<th width="50" class="werte">Anzahl</th>
				</tr>
				<tr class="tr">
					<td class="bezgruppe">
						<xsl:text>Insgesamt</xsl:text>
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(daten/anzahl), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 5.2.6, 9.6, 9.7 -->
	<xsl:template match="db_5_2_6 | wb_9006 | wb_9007">
		<xsl:variable name="kzidf" select="name" />
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr" style="border-bottom: 0px solid;">
					<th width="200" align="left" rowspan="2">Wissenschaftliches Personal</th>
					<th colspan="3">Köpfe</th>
				</tr>
				<tr class="tr">
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
				</tr>
				<tr class="tr">
					<td class="bezgruppe">
						<xsl:text>Insgesamt</xsl:text>
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(daten/anzahlen/@frauen), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(daten/anzahlen/@maenner), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(daten/anzahlen/@gesamt), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 2.A.4, 2.AM.4 -->
	<xsl:template match="wb_2_A_4 | wb_2_AM_4">
		<xsl:call-template name="printKZKopf" />

		<table class="table">
			<tr class="tr">
				<th colspan="3" rowspan="2" />
				<th colspan="9" align="center">Verfahrensschritte</th>
			</tr>
			<tr class="tr">
				<th colspan="3" align="center">angemeldet</th>
				<th colspan="3" align="center">angetreten</th>
				<th colspan="3" align="center">zulassungsberechtigt</th>
			</tr>
			<tr>
				<th colspan="2" align="left">Studien mit besonderen Zugangsregelungen |
					UG idF
					BGBl. I Nr. 8/2018</th>
				<th width="100" align="right">Studienkennzahl</th>
				<th width="50" class="werte">Frauen</th>
				<th width="50" class="werte">Männer</th>
				<th width="50" class="werte">Gesamt</th>
				<th width="50" class="werte">Frauen</th>
				<th width="50" class="werte">Männer</th>
				<th width="50" class="werte">Gesamt</th>
				<th width="50" class="werte">Frauen</th>
				<th width="50" class="werte">Männer</th>
				<th width="50" class="werte">Gesamt</th>
			</tr>

			<xsl:variable name="zugangsregime"
				select="descendant::zulassungzeile/zugangsregime" />
			<!-- 1. Regime -->
			<xsl:for-each select="$zugangsregime">
				<xsl:sort select="." order="ascending" />
				<xsl:if
					test="generate-id() = generate-id($zugangsregime[. = current()][1])">
					<tr class="tr" style="font-weight: bold;">
						<td colspan="3">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'REGIME_AV' and ../RV_LOW_VALUE = current()]" />
						</td>
						<td class="werte" style="font-weight: bold;">
							<xsl:value-of
								select="format-number(number(sum(../..//anzahlen[../zugangsregime=current() and ../verfahrensschritt=1]/@frauen[.!=-2])), '#.##0,00', 'euro')" />
						</td>
						<td class="werte" style="font-weight: bold;">
							<xsl:value-of
								select="format-number(number(sum(../..//anzahlen[../zugangsregime=current() and ../verfahrensschritt=1]/@maenner[.!=-2])), '#.##0,00', 'euro')" />
						</td>
						<td class="werte" style="font-weight: bold;">
							<xsl:value-of
								select="format-number(number(sum(../..//anzahlen[../zugangsregime=current() and ../verfahrensschritt=1]/@gesamt[.!=-2])), '#.##0,00', 'euro')" />
						</td>
						<td class="werte" style="font-weight: bold;">
							<xsl:value-of
								select="format-number(number(sum(../..//anzahlen[../zugangsregime=current() and ../verfahrensschritt=2]/@frauen[.!=-2])), '#.##0,00', 'euro')" />
						</td>
						<td class="werte" style="font-weight: bold;">
							<xsl:value-of
								select="format-number(number(sum(../..//anzahlen[../zugangsregime=current() and ../verfahrensschritt=2]/@maenner[.!=-2])), '#.##0,00', 'euro')" />
						</td>
						<td class="werte" style="font-weight: bold;">
							<xsl:value-of
								select="format-number(number(sum(../..//anzahlen[../zugangsregime=current() and ../verfahrensschritt=2]/@gesamt[.!=-2])), '#.##0,00', 'euro')" />
						</td>
						<td class="werte" style="font-weight: bold;">
							<xsl:value-of
								select="format-number(number(sum(../..//anzahlen[../zugangsregime=current() and ../verfahrensschritt=3]/@frauen[.!=-2])), '#.##0,00', 'euro')" />
						</td>
						<td class="werte" style="font-weight: bold;">
							<xsl:value-of
								select="format-number(number(sum(../..//anzahlen[../zugangsregime=current() and ../verfahrensschritt=3]/@maenner[.!=-2])), '#.##0,00', 'euro')" />
						</td>
						<td class="werte" style="font-weight: bold;">
							<xsl:value-of
								select="format-number(number(sum(../..//anzahlen[../zugangsregime=current() and ../verfahrensschritt=3]/@gesamt[.!=-2])), '#.##0,00', 'euro')" />
						</td>
					</tr>

					<xsl:variable name="iscedfs"
						select="../..//iscedf13[../zugangsregime=current()]" />
					<!-- 2. ISCEDFs -->
					<xsl:for-each select="$iscedfs">
						<xsl:sort select="." order="ascending" />
						<xsl:if
							test="generate-id() = generate-id($iscedfs[. = current()][1])">
							<tr class="tr">
								<td colspan="3" style="padding-left: 10px">
									<xsl:value-of select="." />
									<xsl:text> </xsl:text>
									<xsl:value-of
										select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxiscedf13.xml')//ISCEDBEZ_DT[../ISCEDKODE = current()]" />
								</td>
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum(../..//anzahlen[../zugangsregime=current()/../zugangsregime and ../iscedf13=current() and ../verfahrensschritt=1]/@frauen[.!=-2])), '#.##0,00', 'euro')" />
								</td>
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum(../..//anzahlen[../zugangsregime=current()/../zugangsregime and ../iscedf13=current() and ../verfahrensschritt=1]/@maenner[.!=-2])), '#.##0,00', 'euro')" />
								</td>
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum(../..//anzahlen[../zugangsregime=current()/../zugangsregime and ../iscedf13=current() and ../verfahrensschritt=1]/@gesamt[.!=-2])), '#.##0,00', 'euro')" />
								</td>
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum(../..//anzahlen[../zugangsregime=current()/../zugangsregime and ../iscedf13=current() and ../verfahrensschritt=2]/@frauen[.!=-2])), '#.##0,00', 'euro')" />
								</td>
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum(../..//anzahlen[../zugangsregime=current()/../zugangsregime and ../iscedf13=current() and ../verfahrensschritt=2]/@maenner[.!=-2])), '#.##0,00', 'euro')" />
								</td>
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum(../..//anzahlen[../zugangsregime=current()/../zugangsregime and ../iscedf13=current() and ../verfahrensschritt=2]/@gesamt[.!=-2])), '#.##0,00', 'euro')" />
								</td>
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum(../..//anzahlen[../zugangsregime=current()/../zugangsregime and ../iscedf13=current() and ../verfahrensschritt=3]/@frauen[.!=-2])), '#.##0,00', 'euro')" />
								</td>
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum(../..//anzahlen[../zugangsregime=current()/../zugangsregime and ../iscedf13=current() and ../verfahrensschritt=3]/@maenner[.!=-2])), '#.##0,00', 'euro')" />
								</td>
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum(../..//anzahlen[../zugangsregime=current()/../zugangsregime and ../iscedf13=current() and ../verfahrensschritt=3]/@gesamt[.!=-2])), '#.##0,00', 'euro')" />
								</td>
							</tr>

							<!-- 3. Bezeichnung -->
							<xsl:variable name="bezeichnungen"
								select="../..//bezeichnung[../zugangsregime=current()/../zugangsregime and ../iscedf13=current()]" />
							<xsl:for-each select="$bezeichnungen">
								<xsl:sort select="." order="ascending" />
								<xsl:if
									test="generate-id() = generate-id($bezeichnungen[. = current()][1])">
									<tr class="tr">
										<td colspan="2" style="padding-left: 20px">
											<xsl:value-of select='.' />
										</td>
										<td align="right">
											<xsl:value-of select="../..//studienkennzahl[../zugangsregime=$zugangsregime and ../iscedf13=$iscedfs and ../bezeichnung=current() and ../verfahrensschritt=1]" />
										</td>
										<td class="werte">
											<xsl:choose>
												<xsl:when
													test="../..//anzahlen[../zugangsregime=$zugangsregime and ../iscedf13=$iscedfs and ../bezeichnung=current() and ../verfahrensschritt=1]/@frauen != -2">
													<xsl:value-of
														select="format-number(../..//anzahlen[../zugangsregime=$zugangsregime and ../iscedf13=$iscedfs and ../bezeichnung=current() and ../verfahrensschritt=1]/@frauen, '#.##0,00', 'euro')" />
												</xsl:when>
												<xsl:otherwise>
													---
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="werte">
											<xsl:choose>
												<xsl:when
													test="../..//anzahlen[../zugangsregime=$zugangsregime and ../iscedf13=$iscedfs and ../bezeichnung=current() and ../verfahrensschritt=1]/@maenner != -2">
													<xsl:value-of
														select="format-number(../..//anzahlen[../zugangsregime=$zugangsregime and ../iscedf13=$iscedfs and ../bezeichnung=current() and ../verfahrensschritt=1]/@maenner, '#.##0,00', 'euro')" />
												</xsl:when>
												<xsl:otherwise>
													---
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="werte">
											<xsl:choose>
												<xsl:when
													test="../..//anzahlen[../zugangsregime=$zugangsregime and ../iscedf13=$iscedfs and ../bezeichnung=current() and ../verfahrensschritt=1]/@gesamt != -2">
													<xsl:value-of
														select="format-number(../..//anzahlen[../zugangsregime=$zugangsregime and ../iscedf13=$iscedfs and ../bezeichnung=current() and ../verfahrensschritt=1]/@gesamt, '#.##0,00', 'euro')" />
												</xsl:when>
												<xsl:otherwise>
													---
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="werte">
											<xsl:choose>
												<xsl:when
													test="../..//anzahlen[../zugangsregime=$zugangsregime and ../iscedf13=$iscedfs and ../bezeichnung=current() and ../verfahrensschritt=2]/@frauen != -2">
													<xsl:value-of
														select="format-number(../..//anzahlen[../zugangsregime=$zugangsregime and ../iscedf13=$iscedfs and ../bezeichnung=current() and ../verfahrensschritt=2]/@frauen, '#.##0,00', 'euro')" />
												</xsl:when>
												<xsl:otherwise>
													---
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="werte">
											<xsl:choose>
												<xsl:when
													test="../..//anzahlen[../zugangsregime=$zugangsregime and ../iscedf13=$iscedfs and ../bezeichnung=current() and ../verfahrensschritt=2]/@maenner != -2">
													<xsl:value-of
														select="format-number(../..//anzahlen[../zugangsregime=$zugangsregime and ../iscedf13=$iscedfs and ../bezeichnung=current() and ../verfahrensschritt=2]/@maenner, '#.##0,00', 'euro')" />
												</xsl:when>
												<xsl:otherwise>
													---
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="werte">
											<xsl:choose>
												<xsl:when
													test="../..//anzahlen[../zugangsregime=$zugangsregime and ../iscedf13=$iscedfs and ../bezeichnung=current() and ../verfahrensschritt=2]/@gesamt != -2">
													<xsl:value-of
														select="format-number(../..//anzahlen[../zugangsregime=$zugangsregime and ../iscedf13=$iscedfs and ../bezeichnung=current() and ../verfahrensschritt=2]/@gesamt, '#.##0,00', 'euro')" />
												</xsl:when>
												<xsl:otherwise>
													---
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="werte">
											<xsl:choose>
												<xsl:when
													test="../..//anzahlen[../zugangsregime=$zugangsregime and ../iscedf13=$iscedfs and ../bezeichnung=current() and ../verfahrensschritt=3]/@frauen != -2">
													<xsl:value-of
														select="format-number(../..//anzahlen[../zugangsregime=$zugangsregime and ../iscedf13=$iscedfs and ../bezeichnung=current() and ../verfahrensschritt=3]/@frauen, '#.##0,00', 'euro')" />
												</xsl:when>
												<xsl:otherwise>
													---
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="werte">
											<xsl:choose>
												<xsl:when
													test="../..//anzahlen[../zugangsregime=$zugangsregime and ../iscedf13=$iscedfs and ../bezeichnung=current() and ../verfahrensschritt=3]/@maenner != -2">
													<xsl:value-of
														select="format-number(../..//anzahlen[../zugangsregime=$zugangsregime and ../iscedf13=$iscedfs and ../bezeichnung=current() and ../verfahrensschritt=3]/@maenner, '#.##0,00', 'euro')" />
												</xsl:when>
												<xsl:otherwise>
													---
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td class="werte">
											<xsl:choose>
												<xsl:when
													test="../..//anzahlen[../zugangsregime=$zugangsregime and ../iscedf13=$iscedfs and ../bezeichnung=current() and ../verfahrensschritt=3]/@gesamt != -2">
													<xsl:value-of
														select="format-number(../..//anzahlen[../zugangsregime=$zugangsregime and ../iscedf13=$iscedfs and ../bezeichnung=current() and ../verfahrensschritt=3]/@gesamt, '#.##0,00', 'euro')" />
												</xsl:when>
												<xsl:otherwise>
													---
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</xsl:if>
							</xsl:for-each>
						</xsl:if>
					</xsl:for-each>
				</xsl:if>
			</xsl:for-each>

			<tr class="tr">
				<td class="bezgruppe" colspan="3">Insgesamt</td>
				<td class="werte">
					<xsl:value-of
						select="format-number(number(sum(.//anzahlen[../verfahrensschritt=1]/@frauen[.!=-2])), '#.##0,00', 'euro')" />
				</td>
				<td class="werte">
					<xsl:value-of
						select="format-number(number(sum(.//anzahlen[../verfahrensschritt=1]/@maenner[.!=-2])), '#.##0,00', 'euro')" />
				</td>
				<td class="werte">
					<xsl:value-of
						select="format-number(number(sum(.//anzahlen[../verfahrensschritt=1]/@gesamt[.!=-2])), '#.##0,00', 'euro')" />
				</td>
				<td class="werte">
					<xsl:value-of
						select="format-number(number(sum(.//anzahlen[../verfahrensschritt=2]/@frauen[.!=-2])), '#.##0,00', 'euro')" />
				</td>
				<td class="werte">
					<xsl:value-of
						select="format-number(number(sum(.//anzahlen[../verfahrensschritt=2]/@maenner[.!=-2])), '#.##0,00', 'euro')" />
				</td>
				<td class="werte">
					<xsl:value-of
						select="format-number(number(sum(.//anzahlen[../verfahrensschritt=2]/@gesamt[.!=-2])), '#.##0,00', 'euro')" />
				</td>
				<td class="werte">
					<xsl:value-of
						select="format-number(number(sum(.//anzahlen[../verfahrensschritt=3]/@frauen[.!=-2])), '#.##0,00', 'euro')" />
				</td>
				<td class="werte">
					<xsl:value-of
						select="format-number(number(sum(.//anzahlen[../verfahrensschritt=3]/@maenner[.!=-2])), '#.##0,00', 'euro')" />
				</td>
				<td class="werte">
					<xsl:value-of
						select="format-number(number(sum(.//anzahlen[../verfahrensschritt=3]/@gesamt[.!=-2])), '#.##0,00', 'euro')" />
				</td>
			</tr>
		</table>

		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 5.1.1 -->
	<xsl:template match="db_5_1_1">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="400" align="left" />
					<th width="50" class="werte">Gesamt</th>
				</tr>
				<xsl:for-each select="descendant::aufwandzeile">
					<xsl:sort select="personalaufwand" order="ascending" />
					<xsl:variable name="personalaufwand"
						select="personalaufwand" />
					<tr class="tr">
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALAUFWAND_AV' and ../RV_LOW_VALUE = $personalaufwand]" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(betrag), '#.##0,00', 'euro')" />
						</td>
					</tr>
				</xsl:for-each>
				<tr>
					<td class="bez">Insgesamt</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::betrag)), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 5.1.2 -->
	<xsl:template match="db_5_1_2">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="300" align="left">Art der Erlöse</th>
					<th width="50" class="werte">Gesamt</th>
				</tr>
				<xsl:for-each select="descendant::erloeszeile">
					<xsl:sort select="erloesart" order="ascending" />
					<xsl:variable name="erloesart" select="erloesart" />
					<tr class="tr">
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'ERLOESART_AV' and ../RV_LOW_VALUE = $erloesart]" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(betrag), '#.##0,00', 'euro')" />
						</td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 5.1.4 -->
	<xsl:template match="db_5_1_4">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="300" align="left" colspan="2">KLR-Disziplinengruppe</th>
					<th width="50" class="werte">Kosten je prüfungsaktivem Studium</th>
					<th width="50" class="werte">Kosten je Studienabschluss</th>
					<th width="50" class="werte">Kosten absolut</th>
				</tr>

				<xsl:variable name="klrgruppen"
					select="descendant::kostenzeile/klrgruppe" />
				<xsl:for-each select="$klrgruppen">
					<xsl:sort select="." order="ascending" data-type="number" />
					<xsl:variable name="klrgruppe" select="." />
					<xsl:if
						test="generate-id() = generate-id($klrgruppen[. = current()][1])">
						<tr class="tr">
							<td>
								<xsl:value-of select="format-number(.,'00')" />
							</td>
							<td class="bez">
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'KLRGRUPPE_AV' and ../RV_LOW_VALUE = $klrgruppe]" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(../..//betrag[../klrgruppe=$klrgruppe and ../kostenart=2]), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(../..//betrag[../klrgruppe=$klrgruppe and ../kostenart=3]), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(../..//betrag[../klrgruppe=$klrgruppe and ../kostenart=1]), '#.##0,00', 'euro')" />
							</td>
						</tr>
					</xsl:if>
				</xsl:for-each>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 5.1.5 -->
	<xsl:template match="db_5_1_5">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="300" align="left" colspan="2">KLR-Disziplinengruppe</th>
					<th width="50" class="werte">Kosten je Professor/in und Äquivalente</th>
					<th width="50" class="werte">Kosten absolut</th>
				</tr>

				<xsl:variable name="klrgruppen"
					select="descendant::kostenzeile/klrgruppe" />
				<xsl:for-each select="$klrgruppen">
					<xsl:sort select="." order="ascending" data-type="number" />
					<xsl:variable name="klrgruppe" select="." />
					<xsl:if
						test="generate-id() = generate-id($klrgruppen[. = current()][1])">
						<tr class="tr">
							<td>
								<xsl:value-of select="format-number(.,'00')" />
							</td>
							<td class="bez">
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'KLRGRUPPE_AV' and ../RV_LOW_VALUE = $klrgruppe]" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(../..//betrag[../klrgruppe=$klrgruppe and ../kostenart=4]), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(../..//betrag[../klrgruppe=$klrgruppe and ../kostenart=1]), '#.##0,00', 'euro')" />
							</td>
						</tr>
					</xsl:if>
				</xsl:for-each>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 5.2.2 -->
	<xsl:template match="db_5_2_2">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr" style="border-bottom: 0px solid;">
					<th />
					<th colspan="6">Tätigkeitsbereich</th>
				</tr>
				<tr class="tr" style="border-bottom: 0px solid;">
					<th width="350" align="left" rowspan="2">Zeitvolumen des
						wissenschaftlichen Personals im Klinischen Bereich</th>
					<th colspan="3">Ärztinnen/Ärzte</th>
					<th colspan="3">Ärztinnen/Ärzte in Facharztausbildung</th>
					<th width="50" class="werte" rowspan="2">Gesamt</th>
				</tr>
				<tr class="tr">

					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>

				</tr>
				<xsl:variable name="zeitvolumen"
					select="descendant::zeitvolumenzeile/zeitvolumen" />
				<xsl:for-each select="$zeitvolumen">
					<xsl:sort select="." order="ascending" />
					<xsl:variable name="zeitVol" select="." />
					<xsl:if
						test="generate-id() = generate-id($zeitvolumen[. = current()][1])">
						<tr class="tr">
							<td class="bez">
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'ZEITVOLUMEN_AV' and ../RV_LOW_VALUE = $zeitVol]" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(../../zeitvolumenzeile[zeitvolumen=$zeitVol and personalkategorie='8']/vollzeitaequivalente/@frauen), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(../../zeitvolumenzeile[zeitvolumen=$zeitVol and personalkategorie='8']/vollzeitaequivalente/@maenner), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(../../zeitvolumenzeile[zeitvolumen=$zeitVol and personalkategorie='8']/vollzeitaequivalente/@gesamt), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(../../zeitvolumenzeile[zeitvolumen=$zeitVol and personalkategorie='9']/vollzeitaequivalente/@frauen), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(../../zeitvolumenzeile[zeitvolumen=$zeitVol and personalkategorie='9']/vollzeitaequivalente/@maenner), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(../../zeitvolumenzeile[zeitvolumen=$zeitVol and personalkategorie='9']/vollzeitaequivalente/@gesamt), '#.##0,00', 'euro')" />
							</td>
							<!-- 14.03.2023 Fix für Prozentanzeige -->
							<xsl:if 
								test = "$zeitVol != 3">
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum(../../zeitvolumenzeile[zeitvolumen=$zeitVol]/vollzeitaequivalente/@gesamt)), '#.##0,00', 'euro')" />
								</td>
							</xsl:if>
							<xsl:if 
								test = "$zeitVol = 3">
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum(../../zeitvolumenzeile[zeitvolumen=$zeitVol -1]/vollzeitaequivalente/@gesamt) 
										div 
											sum(../../zeitvolumenzeile[zeitvolumen=$zeitVol -2]/vollzeitaequivalente/@gesamt)) * 100 , '#.##0,00', 'euro')" />
								</td>
							</xsl:if>
						</tr>
					</xsl:if>
				</xsl:for-each>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 5.2.3 -->
	<xsl:template match="db_5_2_3">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr" style="border-bottom: 0px solid;">
					<th width="350" align="left" rowspan="2">Personal im Klinischen
						Bereich</th>
					<th colspan="3">Geschlecht</th>
				</tr>
				<tr class="tr">
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
				</tr>

				<xsl:variable name="daten" select="." />
				<xsl:for-each
					select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE3_AV']">
					<xsl:sort select="../SORTFELD" order="ascending" />
					<xsl:variable name="persKat" select="../RV_LOW_VALUE" />
					<xsl:if test="$persKat=$daten//personalkategorie3">
						<tr class="tr">
							<td class="bez">
								<xsl:value-of select="." />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number($daten//vollzeitaequivalente[../personalkategorie3=$persKat]/@frauen), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number($daten//vollzeitaequivalente[../personalkategorie3=$persKat]/@maenner), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number($daten//vollzeitaequivalente[../personalkategorie3=$persKat]/@gesamt), '#.##0,00', 'euro')" />
							</td>
						</tr>
					</xsl:if>
				</xsl:for-each>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 5.2.4 -->
	<xsl:template match="db_5_2_4">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="350" align="left">KMA - paktierte Investitionen</th>
					<th width="50" class="werte">Gesamt</th>
				</tr>
				<xsl:for-each
					select="descendant::investitionszeile | descendant::zahlungszeile">
					<xsl:sort select="kmatyp" order="ascending" />
					<xsl:variable name="kmatyp" select="kmatyp" />
					<tr class="tr">
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'KMATYP_AV' and ../RV_LOW_VALUE = $kmatyp]" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(betrag), '#.##0,00', 'euro')" />
						</td>
					</tr>
				</xsl:for-each>
				<tr class="tr">
					<td class="bez">Insgesamt</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(.//betrag), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 5.2.5 -->
	<xsl:template match="db_5_2_5">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th align="left" width="100">Kategorien</th>
					<xsl:variable name="vertragsNummern"
						select="descendant::vertragszeile/vertragsnummer" />
					<xsl:for-each select="$vertragsNummern">
						<xsl:sort select="." data-type="number" order="ascending" />
						<xsl:variable name="vertragsNummer" select="." />
						<xsl:if
							test="generate-id() = generate-id($vertragsNummern[. = current()][1])">
							<th style="padding-right: 5px;">
								Betrag Vertrag
								<xsl:value-of select="$vertragsNummer" />
							</th>
						</xsl:if>
					</xsl:for-each>
					<th>Gesamtbetrag</th>
				</tr>
				<xsl:variable name="kategorien"
					select="descendant::vertragszeile/kmatyp" />
				<xsl:for-each select="$kategorien">
					<xsl:sort select="." data-type="number" order="ascending" />
					<xsl:variable name="kmatyp" select="." />
					<xsl:if
						test="generate-id() = generate-id($kategorien[. = current()][1])">
						<tr class="tr">
							<td class="bez">
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'KMATYP_AV' and ../RV_LOW_VALUE = $kmatyp]" />
							</td>
							<!-- Verträge -->
							<xsl:variable name="vertragsNummern"
								select="../..//vertragszeile/vertragsnummer" />
							<xsl:for-each select="$vertragsNummern">
								<xsl:sort select="." data-type="number"
									order="ascending" />
								<xsl:variable name="vertragsNummer" select="." />
								<xsl:if
									test="generate-id() = generate-id($vertragsNummern[. = current()][1])">
									<td class="werte" style="padding-right: 5px;">
										<xsl:value-of
											select="format-number(sum(../..//betrag[../kmatyp=$kmatyp and ../vertragsnummer=$vertragsNummer]), '#.##0,00', 'euro')" />
									</td>
								</xsl:if>
							</xsl:for-each>
							<!-- Gesamtbetrag -->
							<td class="werte">
								<xsl:value-of
									select="format-number(sum(../..//betrag[../kmatyp=$kmatyp]), '#.##0,00', 'euro')" />
							</td>
						</tr>
					</xsl:if>
				</xsl:for-each>
				<tr class="tr">
					<td class="bez">Insgesamt</td>
					<!-- Verträge -->
					<xsl:variable name="vertragsNummern"
						select="../..//vertragszeile/vertragsnummer" />
					<xsl:for-each select="$vertragsNummern">
						<xsl:sort select="." data-type="number" order="ascending" />
						<xsl:variable name="vertragsNummer" select="." />
						<xsl:if
							test="generate-id() = generate-id($vertragsNummern[. = current()][1])">
							<td class="werte" style="padding-right: 5px;">
								<xsl:value-of
									select="format-number(sum(../..//betrag[../vertragsnummer=$vertragsNummer]), '#.##0,00', 'euro')" />
							</td>
						</xsl:if>
					</xsl:for-each>
					<!-- Gesamtbetrag -->
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(.//betrag), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 9.1 -->
	<xsl:template match="wb_9001">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="350" align="left">Studienkategorie</th>
					<th width="350" align="left">Personenmenge</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
				</tr>
				<xsl:for-each select="descendant::studierendezeile">
					<xsl:sort select="studienkategorie" order="ascending" />
					<xsl:sort select="personenmenge" order="ascending" />
					<xsl:variable name="studienkategorie"
						select="studienkategorie" />
					<xsl:variable name="personenmenge"
						select="personenmenge" />
					<tr class="tr">
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'STUDIENKATEGORIE_AV' and ../RV_LOW_VALUE = $studienkategorie]" />
						</td>
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'STUDIERENDE_AV' and ../RV_LOW_VALUE = $personenmenge]" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@frauen), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@maenner), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@gesamt), '#.##0,00', 'euro')" />
						</td>
					</tr>
				</xsl:for-each>
				<tr class="tr">
					<td class="bezgruppe">Insgesamt</td>
					<td class="bezgruppe" />
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen/@gesamt)), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 9.2, 9.3 -->
	<xsl:template match="wb_9002 | wb_9003">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="350" align="left">Studienkategorie</th>
					<th width="350" align="left">Studienart</th>
					<th width="350" align="left">Eingerichtetes Studium</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
				</tr>
				<xsl:for-each select="descendant::studienzeile">
					<xsl:sort select="studienkategorie" order="ascending" />
					<xsl:sort select="studienart" order="ascending" />
					<xsl:sort select="eingerichtetes_studium"
						order="ascending" />
					<xsl:variable name="studienkategorie"
						select="studienkategorie" />
					<xsl:variable name="studienart" select="studienart" />
					<xsl:variable name="eingerichtetes_studium"
						select="eingerichtetes_studium" />
					<tr class="tr">
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'STUDIENKATEGORIE_AV' and ../RV_LOW_VALUE = $studienkategorie]" />
						</td>
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'STUDIENART_AV' and ../RV_LOW_VALUE = $studienart]" />
						</td>
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxstudien.xml')//BEZEICHNUNG[../EINGER_STUDIUM_IDF = $eingerichtetes_studium]" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@frauen), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@maenner), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@gesamt), '#.##0,00', 'euro')" />
						</td>
					</tr>
				</xsl:for-each>
				<tr class="tr">
					<td class="bezgruppe">Insgesamt</td>
					<td class="bezgruppe" />
					<td class="bezgruppe" />
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahlen/@gesamt)), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 9.4, 9.5 -->
	<xsl:template match="wb_9004 | wb_9005">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="350" align="left">Belegte Studien</th>
					<th width="100" align="left">Staatsangehörigkeit</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
				</tr>
				<xsl:for-each select="descendant::studienzeile">
					<xsl:sort select="studienart" order="ascending" />
					<xsl:sort select="staatsangehoerigkeit" order="ascending" />
					<xsl:variable name="studienart" select="studienart" />
					<xsl:variable name="staatsangehoerigkeit"
						select="staatsangehoerigkeit" />
					<tr class="tr">
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'STUDIENART_AV' and ../RV_LOW_VALUE = $studienart]" />
						</td>
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'STAATSANGEHOERIGKEIT_AV' and ../RV_LOW_VALUE = $staatsangehoerigkeit]" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@frauen), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@maenner), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@gesamt), '#.##0,00', 'euro')" />
						</td>
					</tr>
				</xsl:for-each>
				<tr class="tr">
					<td class="bez" colspan="2">Insgesamt</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(.//anzahlen/@frauen), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(.//anzahlen/@maenner), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum(.//anzahlen/@gesamt), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 9.8 -->
	<xsl:template match="wb_9008">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="300" align="left">Unternehmenszweck</th>
					<th width="50" class="werte">Gesamt</th>
				</tr>
				<xsl:for-each select="descendant::beteiligungszeile">
					<xsl:sort select="unternehmenszweck" order="ascending" />
					<xsl:variable name="unternehmenszweck"
						select="unternehmenszweck" />
					<tr class="tr">
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'UNTERNEHMENSZWECK_AV' and ../RV_LOW_VALUE = $unternehmenszweck]" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahl), '#.##0,00', 'euro')" />
						</td>
					</tr>
				</xsl:for-each>
				<tr class="tr">
					<td class="bezgruppe">Insgesamt</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(descendant::anzahl)), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 9.9 -->
	<xsl:template match="wb_9009">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th />
					<th />
					<th colspan="3">Anzahlen</th>
					<th colspan="3">Vollzeitäquivalente</th>
				</tr>
				<tr class="tr">
					<th width="350" align="left">Personalzuordnung</th>
					<th width="350" align="left">Personalkategorie</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
					<th width="50" class="werte">Frauen</th>
					<th width="50" class="werte">Männer</th>
					<th width="50" class="werte">Gesamt</th>
				</tr>
				<xsl:for-each select="descendant::personalzeile">
					<xsl:sort select="personalzuordnung" order="ascending" />
					<xsl:sort select="personalkategorie" order="ascending" />
					<xsl:variable name="personalzuordnung"
						select="personalzuordnung" />
					<xsl:variable name="personalkategorie"
						select="personalkategorie" />
					<tr class="tr">
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALZUORDNUNG_AV' and ../RV_LOW_VALUE = $personalzuordnung]" />
						</td>
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE5_AV' and ../RV_LOW_VALUE = $personalkategorie]" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@frauen), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@maenner), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(anzahlen/@gesamt), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(vollzeitaequivalente/@frauen), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(vollzeitaequivalente/@maenner), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(vollzeitaequivalente/@gesamt), '#.##0,00', 'euro')" />
						</td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 9.10 -->
	<xsl:key name="kBetLeistung"
		match="personalzeile[ancestor::wb_9010]" use="betriebsleistung" />
	<xsl:template match="wb_9010">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="350" align="left">Betriebsleistung</th>
					<th width="350" align="left">Rechnungskreis</th>
					<th width="100" class="werte">Betrag</th>
				</tr>
				<xsl:for-each
					select="descendant::personalzeile[generate-id(.) = generate-id(key('kBetLeistung', betriebsleistung)[position() = 1])]">
					<xsl:sort select="betriebsleistung" order="ascending" />
					<xsl:variable name="betriebsleistung"
						select="betriebsleistung" />
					<xsl:for-each
						select="key('kBetLeistung', betriebsleistung)">
						<xsl:sort select="rechnungskreis" order="ascending" />
						<xsl:variable name="rechnungskreis"
							select="rechnungskreis" />
						<tr class="tr">
							<td class="bez">
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'BETRIEBSLEISTUNG_AV' and ../RV_LOW_VALUE = $betriebsleistung]" />
							</td>
							<td class="bez">
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'RECHNUNGSKREIS_AV' and ../RV_LOW_VALUE = $rechnungskreis]" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(betrag), '#.##0,00', 'euro')" />
							</td>
						</tr>
					</xsl:for-each>
					<tr class="tr">
						<td class="bezgruppe" colspan="2">Insgesamt</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(sum(key('kBetLeistung', betriebsleistung)/betrag)), '#.##0,00', 'euro')" />
						</td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 9.12 -->
	<xsl:key name="kPubZuord"
		match="publikationszeile[ancestor::wb_9012]"
		use="publikationszuordnung" />
	<xsl:template match="wb_9012">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="350" align="left">Publikationszuordnung</th>
					<th width="350" align="left">Publikationstyp</th>
					<th width="50" class="werte">Gesamt</th>
				</tr>
				<xsl:for-each
					select="descendant::publikationszeile[generate-id(.) = generate-id(key('kPubZuord', publikationszuordnung)[position() = 1])]">
					<xsl:sort select="publikationszuordnung" order="ascending"
						data-type="number" />
					<xsl:variable name="publikationszuordnung"
						select="publikationszuordnung" />
					<xsl:for-each
						select="key('kPubZuord', publikationszuordnung)">
						<xsl:sort select="publikationstyp" order="ascending"
							data-type="number" />
						<xsl:variable name="publikationstyp"
							select="publikationstyp" />
						<tr class="tr">
							<td class="bez">
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PUBLIKATIONSZUORDNUNG_AV' and ../RV_LOW_VALUE = $publikationszuordnung]" />
							</td>
							<td class="bez">
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PUBLIKATIONSTYP_AV' and ../RV_LOW_VALUE = $publikationstyp]" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(anzahl), '#.##0,00', 'euro')" />
							</td>
						</tr>
					</xsl:for-each>
					<tr class="tr">
						<td class="bezgruppe" colspan="2">Insgesamt</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(sum(key('kPubZuord', publikationszuordnung)/anzahl[../publikationstyp!=12])), '#.##0,00', 'euro')" />
						</td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 9.13 -->
	<xsl:template match="wb_9013">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tr class="tr">
				<th width="350" />
				<xsl:for-each
					select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
					<xsl:sort select="RV_LOW_VALUE" />
					<th colspan="6" width="300">
						<xsl:value-of select="RV_MEANING" />
					</th>
				</xsl:for-each>
			</tr>
			<tr class="tr">
				<th align="left">Dienstgeber oder Dienstgeberin</th>
				<xsl:for-each
					select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
					<th>Frauen</th>
					<th>Männer</th>
					<th>Gesamt</th>
					<th>
						VZÄ
						<br />
						Frauen
					</th>
					<th>
						VZÄ
						<br />
						Männer
					</th>
					<th>
						VZÄ
						<br />
						Gesamt
					</th>
				</xsl:for-each>
			</tr>

			<xsl:variable name="personalkategorien"
				select="descendant::personalzeile/personalkategorie" />
			<xsl:for-each select="$personalkategorien">
				<xsl:sort select="." data-type="number" order="ascending" />
				<xsl:variable name="personalkategorie" select="." />
				<xsl:if
					test="generate-id() = generate-id($personalkategorien[. = current()][1])">
					<tr class="tr">
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PERSONALKATEGORIE7_AV' and ../RV_LOW_VALUE = $personalkategorie]" />
						</td>
						<xsl:for-each
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
							<xsl:sort select="RV_LOW_VALUE" />
							<xsl:variable name="rsatyp" select="RV_LOW_VALUE" />
							<td class="werte">
								<xsl:value-of
									select="format-number(number($fullDocument/wb_9/wb_9013//personalzeile[personalkategorie=$personalkategorie and rsatyp=$rsatyp]/anzahlen/@frauen), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number($fullDocument/wb_9/wb_9013//personalzeile[personalkategorie=$personalkategorie and rsatyp=$rsatyp]/anzahlen/@maenner), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number($fullDocument/wb_9/wb_9013//personalzeile[personalkategorie=$personalkategorie and rsatyp=$rsatyp]/anzahlen/@gesamt), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number($fullDocument/wb_9/wb_9013//personalzeile[personalkategorie=$personalkategorie and rsatyp=$rsatyp]/vollzeitaequivalente/@frauen), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number($fullDocument/wb_9/wb_9013//personalzeile[personalkategorie=$personalkategorie and rsatyp=$rsatyp]/vollzeitaequivalente/@maenner), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number($fullDocument/wb_9/wb_9013//personalzeile[personalkategorie=$personalkategorie and rsatyp=$rsatyp]/vollzeitaequivalente/@gesamt), '#.##0,00', 'euro')" />
							</td>
						</xsl:for-each>
					</tr>
				</xsl:if>
			</xsl:for-each>
			<tr class="tr">
				<td class="bez">Insgesamt</td>
				<xsl:for-each
					select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
					<xsl:sort select="RV_LOW_VALUE" />
					<xsl:variable name="rsatyp" select="RV_LOW_VALUE" />

					<td class="werte">
						<xsl:value-of
							select="format-number(sum($fullDocument/wb_9/wb_9013//personalzeile[rsatyp=$rsatyp]/anzahlen/@frauen), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum($fullDocument/wb_9/wb_9013//personalzeile[rsatyp=$rsatyp]/anzahlen/@maenner), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum($fullDocument/wb_9/wb_9013//personalzeile[rsatyp=$rsatyp]/anzahlen/@gesamt), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum($fullDocument/wb_9/wb_9013//personalzeile[rsatyp=$rsatyp]/vollzeitaequivalente/@frauen), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum($fullDocument/wb_9/wb_9013//personalzeile[rsatyp=$rsatyp]/vollzeitaequivalente/@maenner), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(sum($fullDocument/wb_9/wb_9013//personalzeile[rsatyp=$rsatyp]/vollzeitaequivalente/@gesamt), '#.##0,00', 'euro')" />
					</td>
				</xsl:for-each>
			</tr>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<!-- 9.15 -->
	<xsl:template match="wb_9015">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th colspan="3" />
					<xsl:for-each
						select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
						<xsl:sort select="RV_LOW_VALUE" />
						<th colspan="6">
							<xsl:value-of select="RV_MEANING" />
						</th>
					</xsl:for-each>
				</tr>
				<tr class="tr">
					<th colspan="3" align="left">Wiss-/Kunstzweig
						Publikationszuordnung</th>
					<xsl:for-each
						select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
						<xsl:sort select="RV_LOW_VALUE" />
						<th>Erstauflagen von wissenschaftlichen Fach- oder
							Lehrbüchern</th>
						<th>erstveröffentlichte Beiträge in SCI, SSCI und
							A&amp;HCI-Fachzeitschriften</th>
						<th>erstveröffentlichte Beiträge in sonstigen
							wissenschaftlichen
							Fachzeitschriften</th>
						<th>erstveröffentlichte Beiträge in Sammelwerken</th>
						<th>sonstige wissenschaftliche Veröffentlichungen</th>
						<th>Gesamt</th>
					</xsl:for-each>
				</tr>
				<xsl:variable name="hauptZweige"
					select="descendant::publikationszeile/zweig" />
				<xsl:for-each select="$hauptZweige">
					<xsl:sort select="." order="ascending" />
					<xsl:variable name="hauptZweig"
						select="substring(.,1,1)" />
					<xsl:if
						test="generate-id() = generate-id($hauptZweige[substring(.,1,1) = substring(current(),1,1)][1])">
						<tr style="border: 0;">
							<td width="15">
								<xsl:value-of select="$hauptZweig" />
							</td>
							<td colspan="2" style="border-bottom: 1px solid;">
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxwikuzw2014.xml')//WISSZWTEXT[../WISSZWCODE = $hauptZweig]" />
							</td>

							<xsl:for-each
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
								<xsl:sort select="RV_LOW_VALUE" />
								<xsl:variable name="rsatyp" select="RV_LOW_VALUE" />
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[substring(../zweig,1,1)=$hauptZweig and ../publikationstyp=1 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
								</td>
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[substring(../zweig,1,1)=$hauptZweig and ../publikationstyp=2 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
								</td>
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[substring(../zweig,1,1)=$hauptZweig and ../publikationstyp=3 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
								</td>
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[substring(../zweig,1,1)=$hauptZweig and ../publikationstyp=4 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
								</td>
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[substring(../zweig,1,1)=$hauptZweig and ../publikationstyp=7 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
								</td>
								<td class="werte">
									<xsl:value-of
										select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[substring(../zweig,1,1)=$hauptZweig and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
								</td>
							</xsl:for-each>
						</tr>

						<xsl:variable name="zweige"
							select="../..//zweig[substring(.,1,1)=$hauptZweig]" />
						<xsl:for-each select="$zweige">
							<xsl:sort select="." order="ascending" />
							<xsl:variable name="zweig" select="." />
							<xsl:if
								test="generate-id() = generate-id($zweige[. = current()][1])">
								<tr style="border: 0;">
									<td />
									<td width="25">
										<xsl:value-of select="$zweig" />
									</td>
									<td style="border-bottom: 1px solid;">
										<xsl:value-of
											select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxwikuzw2014.xml')//WISSZWTEXT[../WISSZWCODE = $zweig]" />
									</td>
									<xsl:for-each
										select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
										<xsl:sort select="RV_LOW_VALUE" />
										<xsl:variable name="rsatyp" select="RV_LOW_VALUE" />
										<td class="werte">
											<xsl:value-of
												select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[../zweig=$zweig and ../publikationstyp=1 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
										</td>
										<td class="werte">
											<xsl:value-of
												select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[../zweig=$zweig and ../publikationstyp=2 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
										</td>
										<td class="werte">
											<xsl:value-of
												select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[../zweig=$zweig and ../publikationstyp=3 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
										</td>
										<td class="werte">
											<xsl:value-of
												select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[../zweig=$zweig and ../publikationstyp=4 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
										</td>
										<td class="werte">
											<xsl:value-of
												select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[../zweig=$zweig and ../publikationstyp=7 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
										</td>
										<td class="werte">
											<xsl:value-of
												select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[../zweig=$zweig and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
										</td>
									</xsl:for-each>

								</tr>

								<xsl:variable name="pubZuordnungen"
									select="../..//publikationszuordnung[../zweig=$zweig]" />
								<xsl:for-each select="$pubZuordnungen">
									<xsl:sort select="." order="ascending" />
									<xsl:variable name="pubZuordnung" select="." />
									<xsl:if
										test="generate-id() = generate-id($pubZuordnungen[. = current()][1])">
										<tr style="border: 0;">
											<td colspan="2" />
											<td width="300"
												style="padding-left: 10; border-bottom: 1px solid;">
												<xsl:value-of
													select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PUBLIKATIONSZUORDNUNG_AV' and ../RV_LOW_VALUE = $pubZuordnung]" />
											</td>

											<xsl:for-each
												select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
												<xsl:sort select="RV_LOW_VALUE" />
												<xsl:variable name="rsatyp"
													select="RV_LOW_VALUE" />
												<td class="werte">
													<xsl:value-of
														select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[../zweig=$zweig and ../publikationstyp=1 and ../publikationszuordnung=$pubZuordnung and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
												</td>
												<td class="werte">
													<xsl:value-of
														select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[../zweig=$zweig and ../publikationstyp=2 and ../publikationszuordnung=$pubZuordnung and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
												</td>
												<td class="werte">
													<xsl:value-of
														select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[../zweig=$zweig and ../publikationstyp=3 and ../publikationszuordnung=$pubZuordnung and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
												</td>
												<td class="werte">
													<xsl:value-of
														select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[../zweig=$zweig and ../publikationstyp=4 and ../publikationszuordnung=$pubZuordnung and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
												</td>
												<td class="werte">
													<xsl:value-of
														select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[../zweig=$zweig and ../publikationstyp=7 and ../publikationszuordnung=$pubZuordnung and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
												</td>
												<td class="werte">
													<xsl:value-of
														select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[../zweig=$zweig and ../publikationszuordnung=$pubZuordnung and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
												</td>
											</xsl:for-each>
										</tr>
									</xsl:if>
								</xsl:for-each>

							</xsl:if>
						</xsl:for-each>
					</xsl:if>
				</xsl:for-each>

				<tr class="tr">
					<td class="bez" colspan="3" style="border-top: 1px solid;">Insgesamt</td>
					<xsl:for-each
						select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
						<xsl:sort select="RV_LOW_VALUE" />
						<xsl:variable name="rsatyp" select="RV_LOW_VALUE" />
						<td class="werte">
							<xsl:value-of
								select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[../publikationstyp=1 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[../publikationstyp=2 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[../publikationstyp=3 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[../publikationstyp=4 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[../publikationstyp=7 and ../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
						</td>
						<td class="werte">
							<xsl:value-of
								select="format-number(number(sum($fullDocument/wb_9/wb_9015//anzahl[../rsatyp=$rsatyp])), '#.##0,00', 'euro')" />
						</td>
					</xsl:for-each>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 9.16 -->
	<xsl:template match="wb_9016">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="300" align="left">Patentanzahl</th>
					<xsl:for-each
						select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
						<xsl:sort select="RV_LOW_VALUE" />
						<th width="150" align="right">
							<xsl:value-of select="RV_MEANING" />
						</th>
					</xsl:for-each>
				</tr>
				<xsl:variable name="patentanzahlen"
					select="descendant::patentzeile/patentanzahl" />
				<xsl:for-each select="$patentanzahlen">
					<xsl:sort select="." order="ascending" data-type="number" />
					<xsl:variable name="patentanzahl" select="." />
					<xsl:if
						test="generate-id() = generate-id($patentanzahlen[. = current()][1])">
						<tr class="tr">
							<td class="bez">
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'PATENTANZAHL_AV' and ../RV_LOW_VALUE = $patentanzahl]" />
							</td>
							<xsl:for-each
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
								<xsl:sort select="RV_LOW_VALUE" />
								<xsl:variable name="rsatyp" select="RV_LOW_VALUE" />
								<td class="werte">
									<xsl:value-of
										select="format-number(number($fullDocument/wb_9/wb_9016//patentzeile[patentanzahl=$patentanzahl and rsatyp=$rsatyp]/anzahl), '#.##0,00', 'euro')" />
								</td>
							</xsl:for-each>
						</tr>
					</xsl:if>
				</xsl:for-each>
				<tr class="tr">
					<td class="bezgruppe">Insgesamt</td>
					<xsl:for-each
						select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
						<xsl:sort select="RV_LOW_VALUE" />
						<xsl:variable name="rsatyp" select="RV_LOW_VALUE" />
						<td class="werte">
							<xsl:value-of
								select="format-number(number(sum($fullDocument/wb_9/wb_9016//patentzeile[rsatyp=$rsatyp and (patentanzahl=0 or patentanzahl=1 or patentanzahl=5 or patentanzahl=9 or patentanzahl=10 or patentanzahl=11 or patentanzahl=12 or patentanzahl=13)]/anzahl)), '#.##0,00', 'euro')" />
						</td>
					</xsl:for-each>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>
	<!-- 9.17 -->
	<xsl:template match="wb_9017">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<tr class="tr">
					<th width="300" align="left">Outputkategorie</th>
					<xsl:for-each
						select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
						<xsl:sort select="RV_LOW_VALUE" />
						<th width="150" align="right">
							<xsl:value-of select="RV_MEANING" />
						</th>
					</xsl:for-each>
				</tr>
				<xsl:variable name="outputkategorien"
					select="descendant::outputzeile/outputkategorie" />
				<xsl:for-each select="$outputkategorien">
					<xsl:sort select="." order="ascending" />
					<xsl:variable name="outputkategorie" select="." />
					<xsl:if
						test="generate-id() = generate-id($outputkategorien[. = current()][1])">
						<tr class="tr">
							<td class="bez">
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN = 'OUTPUTKATEGORIE_AV' and ../RV_LOW_VALUE = $outputkategorie]" />
							</td>
							<xsl:for-each
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
								<xsl:sort select="RV_LOW_VALUE" />
								<xsl:variable name="rsatyp" select="RV_LOW_VALUE" />
								<td class="werte">
									<xsl:value-of
										select="format-number(number($fullDocument/wb_9/wb_9017//outputzeile[outputkategorie=$outputkategorie and rsatyp=$rsatyp]/anzahl), '#.##0,00', 'euro')" />
								</td>
							</xsl:for-each>
						</tr>
					</xsl:if>
				</xsl:for-each>
				<tr class="tr">
					<td class="bezgruppe">Insgesamt</td>
					<xsl:for-each
						select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//ROW[RV_DOMAIN = 'RSATYP_AV']">
						<xsl:sort select="RV_LOW_VALUE" />
						<xsl:variable name="rsatyp" select="RV_LOW_VALUE" />
						<td class="werte">
							<xsl:value-of
								select="format-number(number(sum($fullDocument/wb_9/wb_9017//outputzeile[rsatyp=$rsatyp]/anzahl)), '#.##0,00', 'euro')" />
						</td>
					</xsl:for-each>
				</tr>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<xsl:template match="wb_9018">
		<xsl:call-template name="printKZKopf" />
		<table class="table">
			<tbody>
				<!-- HEADER für Kategorie 1 -->
				<tr class="tr">
					<th width="300" align="left"></th>
					<th width="150" align="right">Menge Absolut</th>
				</tr>
				
				<!-- Emissionskategorie = 1 -->
				<xsl:variable name="ek1" select="daten/emissionszeile[emissionskategorie=1]" />
				<tr class="tr">
					<td class="bez">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')
							//RV_MEANING[
							../RV_DOMAIN = 'EMISSIONSKATEGORIE_AV'
							and ../RV_LOW_VALUE = 1]" />
					</td>
					<td class="werte">
						<xsl:value-of select="format-number(number($ek1/tonnenco2), '#.##0,00', 'euro')" />
					</td>
				</tr>
				
				<!-- Freie Zeile -->
				<tr><td colspan="2"></td></tr>
				
				<!-- HEADER für restliche Kategorien -->
				<tr class="tr">
					<th width="300" align="left"></th>
					<th width="150" align="right">Menge je</th>
				</tr>
				
				<!-- Alle anderen emissionskategorien (ohne 1), sortiert -->
				<xsl:for-each select="daten/emissionszeile[not(emissionskategorie=1)]">
					<xsl:sort select="emissionskategorie" data-type="number" order="ascending" />
					<xsl:variable name="emissionskategorie" select="emissionskategorie" />
					<tr class="tr">
						<td class="bez">
							<xsl:value-of
								select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')
								//RV_MEANING[
								../RV_DOMAIN = 'EMISSIONSKATEGORIE_AV'
								and ../RV_LOW_VALUE = $emissionskategorie]" />
						</td>
						<td class="werte">
							<xsl:value-of select="format-number(number(tonnenco2), '#.##0,00', 'euro')" />
						</td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		<xsl:call-template name="printInterpret" />
	</xsl:template>

	<xsl:template name="printZweigByKategorie">
		<xsl:param name="kategorie" />

		<tr style="border:0;">
			<td style="border-top: 1px solid;">
				<xsl:value-of select="$kategorie" />
				<xsl:text> </xsl:text>
				<xsl:value-of
					select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxwikuzw2014.xml')//WISSZWTEXT[../WISSZWCODE = $kategorie]" />
			</td>
			<td class="bez">Gesamt</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../berufungsart=1]/@frauen)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../berufungsart=1]/@maenner)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../berufungsart=1]/@gesamt)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../berufungsart=2]/@frauen)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../berufungsart=2]/@maenner)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../berufungsart=2]/@gesamt)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../berufungsart=3]/@frauen)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../berufungsart=3]/@maenner)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../berufungsart=3]/@gesamt)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../berufungsart=4]/@frauen)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../berufungsart=4]/@maenner)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../berufungsart=4]/@gesamt)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../berufungsart=5]/@frauen)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../berufungsart=5]/@maenner)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../berufungsart=5]/@gesamt)), '#.##0,00', 'euro')" />
			</td>

			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie]/@frauen)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie]/@maenner)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie]/@gesamt)), '#.##0,00', 'euro')" />
			</td>
		</tr>

		<xsl:variable name="herkuenfte"
			select="../../berufungzeile/herkunft[substring(../zweig,1,1)=$kategorie]" />
		<xsl:for-each select="$herkuenfte">
			<xsl:sort select="." order="ascending" />
			<xsl:variable name="herkunft" select="." />
			<xsl:if
				test="generate-id() = generate-id($herkuenfte[. = current()][1])">
				<tr style="border: 0;">
					<td />
					<td class="bez">
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN='HERKUNFT_AV' and ../RV_LOW_VALUE=$herkunft]" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../herkunft=$herkunft  and ../berufungsart=1]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../herkunft=$herkunft  and ../berufungsart=1]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../herkunft=$herkunft  and ../berufungsart=1]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../herkunft=$herkunft  and ../berufungsart=2]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../herkunft=$herkunft  and ../berufungsart=2]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../herkunft=$herkunft  and ../berufungsart=2]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../herkunft=$herkunft  and ../berufungsart=3]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../herkunft=$herkunft  and ../berufungsart=3]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../herkunft=$herkunft  and ../berufungsart=3]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../herkunft=$herkunft  and ../berufungsart=4]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../herkunft=$herkunft  and ../berufungsart=4]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../herkunft=$herkunft  and ../berufungsart=4]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../herkunft=$herkunft  and ../berufungsart=5]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../herkunft=$herkunft  and ../berufungsart=5]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../herkunft=$herkunft  and ../berufungsart=5]/@gesamt)), '#.##0,00', 'euro')" />
					</td>

					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../herkunft=$herkunft ]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../herkunft=$herkunft ]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[substring(../zweig,1,1)=$kategorie and ../herkunft=$herkunft ]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</xsl:if>
		</xsl:for-each>

		<xsl:variable name="zweige"
			select="../../berufungzeile/zweig[substring(.,1,1)=$kategorie]" />
		<xsl:for-each select="$zweige">
			<xsl:sort select="substring(., 1, 1)" order="ascending" />
			<xsl:sort select="." order="ascending" />
			<xsl:variable name="zweig" select="." />
			<xsl:if
				test="generate-id() = generate-id($zweige[. = current()][1])">
				<tr style="border: 0;">
					<td style="padding-left: 10; border-top: 1px solid;">
						<xsl:value-of select="$zweig" />
						<xsl:text> </xsl:text>
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxwikuzw2014.xml')//WISSZWTEXT[../WISSZWCODE = $zweig]" />
					</td>
					<td class="bez">Gesamt</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../berufungsart=1]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../berufungsart=1]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../berufungsart=1]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../berufungsart=2]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../berufungsart=2]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../berufungsart=2]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../berufungsart=3]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../berufungsart=3]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../berufungsart=3]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../berufungsart=4]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../berufungsart=4]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../berufungsart=4]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../berufungsart=5]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../berufungsart=5]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../berufungsart=5]/@gesamt)), '#.##0,00', 'euro')" />
					</td>

					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[../zweig=$zweig]/@frauen)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[../zweig=$zweig]/@maenner)), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(sum(../..//anzahlen[../zweig=$zweig]/@gesamt)), '#.##0,00', 'euro')" />
					</td>
				</tr>

				<xsl:variable name="herkuenfte"
					select="../../berufungzeile/herkunft[../zweig=$zweig]" />
				<xsl:for-each select="$herkuenfte">
					<xsl:sort select="." order="ascending" />
					<xsl:variable name="herkunft" select="." />
					<xsl:if
						test="generate-id() = generate-id($herkuenfte[. = current()][1])">
						<tr style="border: 0;">
							<td />
							<td class="bez">
								<xsl:value-of
									select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxrefcodes.xml')//RV_MEANING[../RV_DOMAIN='HERKUNFT_AV' and ../RV_LOW_VALUE=$herkunft]" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../herkunft=$herkunft  and ../berufungsart=1]/@frauen)), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../herkunft=$herkunft  and ../berufungsart=1]/@maenner)), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../herkunft=$herkunft  and ../berufungsart=1]/@gesamt)), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../herkunft=$herkunft  and ../berufungsart=2]/@frauen)), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../herkunft=$herkunft  and ../berufungsart=2]/@maenner)), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../herkunft=$herkunft  and ../berufungsart=2]/@gesamt)), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../herkunft=$herkunft  and ../berufungsart=3]/@frauen)), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../herkunft=$herkunft  and ../berufungsart=3]/@maenner)), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../herkunft=$herkunft  and ../berufungsart=3]/@gesamt)), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../herkunft=$herkunft  and ../berufungsart=4]/@frauen)), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../herkunft=$herkunft  and ../berufungsart=4]/@maenner)), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../herkunft=$herkunft  and ../berufungsart=4]/@gesamt)), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../herkunft=$herkunft  and ../berufungsart=5]/@frauen)), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../herkunft=$herkunft  and ../berufungsart=5]/@maenner)), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../herkunft=$herkunft  and ../berufungsart=5]/@gesamt)), '#.##0,00', 'euro')" />
							</td>

							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../herkunft=$herkunft ]/@frauen)), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../herkunft=$herkunft ]/@maenner)), '#.##0,00', 'euro')" />
							</td>
							<td class="werte">
								<xsl:value-of
									select="format-number(number(sum(../..//anzahlen[../zweig=$zweig and ../herkunft=$herkunft ]/@gesamt)), '#.##0,00', 'euro')" />
							</td>
						</tr>
					</xsl:if>
				</xsl:for-each>

			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="printIscedBySubKategorie">
		<xsl:param name="subKategorie" />
		<xsl:variable name="isceds"
			select="../../zeitzeile/iscedf13[substring(.,1,3)=$subKategorie]" />

		<tr class="tr">
			<td class="bez" style="padding-left: 10;">
				<xsl:value-of select="$subKategorie"
					disable-output-escaping="yes" />
				<xsl:text> </xsl:text>
				<xsl:value-of
					select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxiscedf13.xml')//ISCEDBEZ_DT[../ISCEDKODE = $subKategorie]" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,3)=$subKategorie and personalkategorie='1']/vollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,3)=$subKategorie and personalkategorie='3']/vollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,3)=$subKategorie and personalkategorie='2']/vollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,3)=$subKategorie and personalkategorie='6']/vollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte" style="border-right: 1px solid;">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,3)=$subKategorie and personalkategorie='5']/vollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>

			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,3)=$subKategorie and personalkategorie='1']/jahresvollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,3)=$subKategorie and personalkategorie='3']/jahresvollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,3)=$subKategorie and personalkategorie='2']/jahresvollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,3)=$subKategorie and personalkategorie='6']/jahresvollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,3)=$subKategorie and personalkategorie='5']/jahresvollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>
		</tr>

		<xsl:for-each select="$isceds">
			<xsl:sort select="." order="ascending" />
			<xsl:variable name="isced" select="." />
			<xsl:if
				test="generate-id() = generate-id($isceds[. = current()][1]) and $isced != 9000">
				<tr class="tr">
					<td class="bez" style="padding-left: 15;">
						<xsl:value-of select="$isced" />
						<xsl:text> </xsl:text>
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxiscedf13.xml')//ISCEDBEZ_DT[../ISCEDKODE = $isced]" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(../../zeitzeile[iscedf13=$isced and personalkategorie='1']/vollzeitaequivalent), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(../../zeitzeile[iscedf13=$isced and personalkategorie='3']/vollzeitaequivalent), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(../../zeitzeile[iscedf13=$isced and personalkategorie='2']/vollzeitaequivalent), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(../../zeitzeile[iscedf13=$isced and personalkategorie='6']/vollzeitaequivalent), '#.##0,00', 'euro')" />
					</td>
					<td class="werte" style="border-right: 1px solid;">
						<xsl:value-of
							select="format-number(number(../../zeitzeile[iscedf13=$isced and personalkategorie='5']/vollzeitaequivalent), '#.##0,00', 'euro')" />
					</td>

					<td class="werte">
						<xsl:value-of
							select="format-number(number(../../zeitzeile[iscedf13=$isced and personalkategorie='1']/jahresvollzeitaequivalent), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(../../zeitzeile[iscedf13=$isced and personalkategorie='3']/jahresvollzeitaequivalent), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(../../zeitzeile[iscedf13=$isced and personalkategorie='2']/jahresvollzeitaequivalent), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(../../zeitzeile[iscedf13=$isced and personalkategorie='6']/jahresvollzeitaequivalent), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(../../zeitzeile[iscedf13=$isced and personalkategorie='5']/jahresvollzeitaequivalent), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="printIscedByKategorie">
		<xsl:param name="kategorie" />

		<tr class="tr">
			<td class="bez">
				<xsl:value-of select="$kategorie"
					disable-output-escaping="yes" />
				<xsl:text> </xsl:text>
				<xsl:value-of
					select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxiscedf13.xml')//ISCEDBEZ_DT[../ISCEDKODE = $kategorie]" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,2)=$kategorie and personalkategorie='1']/vollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,2)=$kategorie and personalkategorie='3']/vollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,2)=$kategorie and personalkategorie='2']/vollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,2)=$kategorie and personalkategorie='6']/vollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte" style="border-right: 1px solid;">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,2)=$kategorie and personalkategorie='5']/vollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>

			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,2)=$kategorie and personalkategorie='1']/jahresvollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,2)=$kategorie and personalkategorie='3']/jahresvollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,2)=$kategorie and personalkategorie='2']/jahresvollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,2)=$kategorie and personalkategorie='6']/jahresvollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zeitzeile[substring(iscedf13,1,2)=$kategorie and personalkategorie='5']/jahresvollzeitaequivalent)), '#.##0,00', 'euro')" />
			</td>
		</tr>

		<xsl:variable name="isceds"
			select="../../zeitzeile/iscedf13[substring(.,1,2)=$kategorie]" />
		<xsl:for-each select="$isceds">
			<xsl:sort select="." order="ascending" />
			<xsl:variable name="isced" select="." />
			<xsl:if
				test="generate-id() = generate-id($isceds[substring(.,1,3) = substring(current(),1,3)][1]) and $isced != 9000">
				<xsl:call-template name="printIscedBySubKategorie">
					<xsl:with-param name="subKategorie"
						select="substring($isced,1,3)" />
				</xsl:call-template>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>


	<xsl:template
		name="printIscedVerfahrensschritteBySubKategorie">
		<xsl:param name="subKategorie" />

		<tr class="tr">
			<td class="bez" style="padding-left: 10;">
				<xsl:value-of select="$subKategorie"
					disable-output-escaping="yes" />
				<xsl:text> </xsl:text>
				<xsl:value-of
					select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxiscedf13.xml')//ISCEDBEZ_DT[../ISCEDKODE = $subKategorie]" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zulassungzeile[substring(iscedf13,1,3)=$subKategorie and verfahrensschritt=1]/anzahlen/@frauen)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zulassungzeile[substring(iscedf13,1,3)=$subKategorie and verfahrensschritt=1]/anzahlen/@maenner)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zulassungzeile[substring(iscedf13,1,3)=$subKategorie and verfahrensschritt=1]/anzahlen/@gesamt)), '#.##0,00', 'euro')" />
			</td>

			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zulassungzeile[substring(iscedf13,1,3)=$subKategorie and verfahrensschritt=2]/anzahlen/@frauen[.!=-2])), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zulassungzeile[substring(iscedf13,1,3)=$subKategorie and verfahrensschritt=2]/anzahlen/@maenner[.!=-2])), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zulassungzeile[substring(iscedf13,1,3)=$subKategorie and verfahrensschritt=2]/anzahlen/@gesamt[.!=-2])), '#.##0,00', 'euro')" />
			</td>

			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zulassungzeile[substring(iscedf13,1,3)=$subKategorie and verfahrensschritt=3]/anzahlen/@frauen)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zulassungzeile[substring(iscedf13,1,3)=$subKategorie and verfahrensschritt=3]/anzahlen/@maenner)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zulassungzeile[substring(iscedf13,1,3)=$subKategorie and verfahrensschritt=3]/anzahlen/@gesamt)), '#.##0,00', 'euro')" />
			</td>
		</tr>

		<xsl:variable name="zulassungen"
			select="../../zulassungzeile/iscedf13[substring(.,1,3)=$subKategorie]" />
		<xsl:for-each select="$zulassungen">
			<xsl:sort select="." order="ascending" />
			<xsl:variable name="isced" select="." />
			<xsl:if
				test="generate-id() = generate-id($zulassungen[. = current()][1])">
				<tr class="tr">
					<td class="bez" style="padding-left: 15;">
						<xsl:value-of select="$isced" />
						<xsl:text> </xsl:text>
						<xsl:value-of
							select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxiscedf13.xml')//ISCEDBEZ_DT[../ISCEDKODE = $isced]" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(../../zulassungzeile[iscedf13=$isced and verfahrensschritt=1]/anzahlen/@frauen), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(../../zulassungzeile[iscedf13=$isced and verfahrensschritt=1]/anzahlen/@maenner), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(../../zulassungzeile[iscedf13=$isced and verfahrensschritt=1]/anzahlen/@gesamt), '#.##0,00', 'euro')" />
					</td>

					<td class="werte">
						<xsl:variable name="anzValue"
							select="../../zulassungzeile[iscedf13=$isced and verfahrensschritt=2]/anzahlen/@frauen" />
						<xsl:if test="number($anzValue) = -2">
							---
						</xsl:if>
						<xsl:if test="number($anzValue) != -2">
							<xsl:value-of
								select="format-number($anzValue, '#.##0,00', 'euro')" />
						</xsl:if>
					</td>
					<td class="werte">
						<xsl:variable name="anzValue"
							select="../../zulassungzeile[iscedf13=$isced and verfahrensschritt=2]/anzahlen/@maenner" />
						<xsl:if test="number($anzValue) = -2">
							---
						</xsl:if>
						<xsl:if test="number($anzValue) != -2">
							<xsl:value-of
								select="format-number($anzValue, '#.##0,00', 'euro')" />
						</xsl:if>
					</td>
					<td class="werte">
						<xsl:variable name="anzValue"
							select="../../zulassungzeile[iscedf13=$isced and verfahrensschritt=2]/anzahlen/@gesamt" />
						<xsl:if test="number($anzValue) = -2">
							---
						</xsl:if>
						<xsl:if test="number($anzValue) != -2">
							<xsl:value-of
								select="format-number($anzValue, '#.##0,00', 'euro')" />
						</xsl:if>
					</td>

					<td class="werte">
						<xsl:value-of
							select="format-number(number(../../zulassungzeile[iscedf13=$isced and verfahrensschritt=3]/anzahlen/@frauen), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(../../zulassungzeile[iscedf13=$isced and verfahrensschritt=3]/anzahlen/@maenner), '#.##0,00', 'euro')" />
					</td>
					<td class="werte">
						<xsl:value-of
							select="format-number(number(../../zulassungzeile[iscedf13=$isced and verfahrensschritt=3]/anzahlen/@gesamt), '#.##0,00', 'euro')" />
					</td>
				</tr>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<xsl:template
		name="printIscedVerfahrensschritteByKategorie">
		<xsl:param name="kategorie" />

		<tr class="tr">
			<td class="bez">
				<xsl:value-of select="$kategorie"
					disable-output-escaping="yes" />
				<xsl:text> </xsl:text>
				<xsl:value-of
					select="document('http://wissensbilanz.noc-science.at/wibi/2025/codxiscedf13.xml')//ISCEDBEZ_DT[../ISCEDKODE = $kategorie]" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zulassungzeile[substring(iscedf13,1,2)=$kategorie and verfahrensschritt=1]/anzahlen/@frauen)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zulassungzeile[substring(iscedf13,1,2)=$kategorie and verfahrensschritt=1]/anzahlen/@maenner)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zulassungzeile[substring(iscedf13,1,2)=$kategorie and verfahrensschritt=1]/anzahlen/@gesamt)), '#.##0,00', 'euro')" />
			</td>

			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zulassungzeile[substring(iscedf13,1,2)=$kategorie and verfahrensschritt=2]/anzahlen/@frauen[.!=-2])), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zulassungzeile[substring(iscedf13,1,2)=$kategorie and verfahrensschritt=2]/anzahlen/@maenner[.!=-2])), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zulassungzeile[substring(iscedf13,1,2)=$kategorie and verfahrensschritt=2]/anzahlen/@gesamt[.!=-2])), '#.##0,00', 'euro')" />
			</td>

			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zulassungzeile[substring(iscedf13,1,2)=$kategorie and verfahrensschritt=3]/anzahlen/@frauen)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zulassungzeile[substring(iscedf13,1,2)=$kategorie and verfahrensschritt=3]/anzahlen/@maenner)), '#.##0,00', 'euro')" />
			</td>
			<td class="werte">
				<xsl:value-of
					select="format-number(number(sum(../../zulassungzeile[substring(iscedf13,1,2)=$kategorie and verfahrensschritt=3]/anzahlen/@gesamt)), '#.##0,00', 'euro')" />
			</td>
		</tr>

		<xsl:variable name="isceds"
			select="../../zulassungzeile/iscedf13[substring(.,1,2)=$kategorie]" />
		<xsl:for-each select="$isceds">
			<xsl:sort select="." order="ascending" />
			<xsl:variable name="isced" select="." />
			<xsl:if
				test="generate-id() = generate-id($isceds[substring(.,1,3) = substring(current(),1,3)][1]) and $isced != 9000">
				<xsl:call-template
					name="printIscedVerfahrensschritteBySubKategorie">
					<xsl:with-param name="subKategorie"
						select="substring($isced,1,3)" />
				</xsl:call-template>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
