# 2024-03-19 Triage Log

Even though the summary might not look like it, this was actually a relatively quiet week,
with a few small regressions. The large regression that is also shown in the summary table was
caused by extending the verification of incremental compilation results.
However, this verification is not actually fully enabled by default, so these regressions are mostly
only visible in our benchmarking suite, which enables the verification to achieve more deterministic
benchmarking results. One small regression was also caused by enabling frame pointers for the Rust
standard library, which should improve profiling of Rust programs.

Triage done by **@kobzol**.
Revision
range: [e919669d..21d94a3d](https://perf.rust-lang.org/?start=e919669d42dfb8950866d4cb268c5359eb3f7c54&end=21d94a3d2c63cacf8eaf9d0ca770c0b450c558d4&absolute=false&stat=instructions%3Au)

**Summary**:

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 2.5%  |  [0.4%, 7.8%]  |  207  |
| Regressions ❌ <br /> (secondary)  | 2.9%  |  [0.2%, 8.3%]  |  128  |
|  Improvements ✅ <br /> (primary)  |   -   |       -        |   0   |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.3%, -0.4%] |   4   |
|         All ❌✅ (primary)          | 2.5%  |  [0.4%, 7.8%]  |  207  |

4 Regressions, 1 Improvements, 6 Mixed; 4 of them in rollups
67 artifact comparisons made in total

#### Regressions

Make `DefiningAnchor::Bind` only store the opaque types that may be constrained, instead of the
current infcx root
item. [#121796](https://github.com/rust-lang/rust/pull/121796) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6554a5645a13e4d9331fd028960d69be91d7492d&end=4ccbb7dc95596c7fc0c5756fdc47a17a56c085d3&stat=instructions:u)

|         (instructions:u)          | mean |    range     | count |
|:---------------------------------:|:----:|:------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 0.6% | [0.2%, 1.8%] |  112  |
| Regressions ❌ <br /> (secondary)  | 0.7% | [0.2%, 1.8%] |  27   |
|  Improvements ✅ <br /> (primary)  |  -   |      -       |   0   |
| Improvements ✅ <br /> (secondary) |  -   |      -       |   0   |
|         All ❌✅ (primary)          | 0.6% | [0.2%, 1.8%] |  112  |

* This is a refactoring of the "old" trait solver that was necessary for follow-up compiler changes.

Rollup of 12 pull
requests [#122389](https://github.com/rust-lang/rust/pull/122389) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7de1a1f6db26cf7af43cca74819118428e6317ee&end=6b1e5d9db3b0d569bd847fdcb98c85ee8f7a8ef1&stat=instructions:u)

|         (instructions:u)          | mean |    range     | count |
|:---------------------------------:|:----:|:------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 0.7% | [0.7%, 0.7%] |   3   |
| Regressions ❌ <br /> (secondary)  | 1.1% | [0.5%, 2.1%] |   3   |
|  Improvements ✅ <br /> (primary)  |  -   |      -       |   0   |
| Improvements ✅ <br /> (secondary) |  -   |      -       |   0   |
|         All ❌✅ (primary)          | 0.7% | [0.7%, 0.7%] |   3   |

* Noise, marked as triaged.

Verify that query keys result in unique dep
nodes [#122227](https://github.com/rust-lang/rust/pull/122227) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e61dcc7a0ac33ef054d76453307124233edcf545&end=d3555f3d8e555ce488bbf8eee5eccdb66a464e14&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 2.0%  |  [0.2%, 7.8%]  |  193  |
| Regressions ❌ <br /> (secondary)  | 2.4%  |  [0.3%, 7.8%]  |  153  |
|  Improvements ✅ <br /> (primary)  |   -   |       -        |   0   |
| Improvements ✅ <br /> (secondary) | -1.3% | [-1.3%, -1.3%] |   1   |
|         All ❌✅ (primary)          | 2.0%  |  [0.2%, 7.8%]  |  193  |

* This PR adds additional verification to the compiler that checks if incremental compilation didn't
  encounter problems.
* This result looks quite bad, but that is mostly caused by the configuration of our benchmark
  suite, which fully enables this verification to make benchmarking more deterministic.
* Normal builds of user code should not be affected by this change.

Enable frame pointers for the standard
library [#122646](https://github.com/rust-lang/rust/pull/122646) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=13abc0ac9b2b77299cf02d634fc409e26a180ef3&end=3cdcdaf31b45f8045164aae9604573d23091970b&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 0.3%  |  [0.2%, 0.6%]  |  70   |
| Regressions ❌ <br /> (secondary)  | 0.3%  |  [0.2%, 0.5%]  |  22   |
|  Improvements ✅ <br /> (primary)  |   -   |       -        |   0   |
| Improvements ✅ <br /> (secondary) | -2.0% | [-2.0%, -2.0%] |   1   |
|         All ❌✅ (primary)          | 0.3%  |  [0.2%, 0.6%]  |  70   |

* This PR has a small instruction count cost across the board, but cycles and walltime were affected
  much less.
* It enables frame pointers for the Rust standard library, which should make profiling of Rust code
  more robust and accurate, which should be worth this small perf. hit.
* Marked as triaged.

#### Improvements

Rollup of 15 pull
requests [#122338](https://github.com/rust-lang/rust/pull/122338) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=65cd843ae06ad00123c131a431ed5304e4cd577a&end=6554a5645a13e4d9331fd028960d69be91d7492d&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   |   -   |       -        |   0   |
| Regressions ❌ <br /> (secondary)  |   -   |       -        |   0   |
|  Improvements ✅ <br /> (primary)  | -1.2% | [-1.2%, -1.1%] |   4   |
| Improvements ✅ <br /> (secondary) | -0.8% | [-1.2%, -0.4%] |  13   |
|         All ❌✅ (primary)          | -1.2% | [-1.2%, -1.1%] |   4   |

#### Mixed

Update
cargo [#122394](https://github.com/rust-lang/rust/pull/122394) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6b1e5d9db3b0d569bd847fdcb98c85ee8f7a8ef1&end=a165f1f65015b1bd4afd2ec50700aaacf2e0c485&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   |   -   |       -        |   0   |
| Regressions ❌ <br /> (secondary)  | 1.1%  |  [1.1%, 1.1%]  |   1   |
|  Improvements ✅ <br /> (primary)  | -0.7% | [-0.7%, -0.7%] |   3   |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.3%] |   5   |
|         All ❌✅ (primary)          | -0.7% | [-0.7%, -0.7%] |   3   |

* Most likely noise.

more eagerly instantiate
binders [#119849](https://github.com/rust-lang/rust/pull/119849) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=30f74ff0dc4d66debc8b50724c446f817e5f75f4&end=fd27e8745f0f04dc7c289893ef54a618c7c9e1da&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 0.7%  |  [0.2%, 1.1%]  |  14   |
| Regressions ❌ <br /> (secondary)  | 0.5%  |  [0.4%, 1.0%]  |   7   |
|  Improvements ✅ <br /> (primary)  |   -   |       -        |   0   |
| Improvements ✅ <br /> (secondary) | -1.2% | [-1.4%, -1.1%] |   6   |
|         All ❌✅ (primary)          | 0.7%  |  [0.2%, 1.1%]  |  14   |

* A small regression for trait-heavy crates, caused by a fix to the trait solver.
* Marked as triaged.

Rollup of 9 pull
requests [#122607](https://github.com/rust-lang/rust/pull/122607) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4c1b9c3e2f402efe27a24e424c9b59aa2fa5c83f&end=c8813ddd6d2602ae5473752031fd16ba70a6e4a7&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 1.7%  |  [1.7%, 1.7%]  |   1   |
| Regressions ❌ <br /> (secondary)  | 2.7%  |  [2.7%, 2.7%]  |   1   |
|  Improvements ✅ <br /> (primary)  |   -   |       -        |   0   |
| Improvements ✅ <br /> (secondary) | -5.3% | [-5.3%, -5.3%] |   1   |
|         All ❌✅ (primary)          | 1.7%  |  [1.7%, 1.7%]  |   1   |

* The largest regression was caused by [#122601](https://github.com/rust-lang/rust/pull/122601),
  which should enable more LLVM optimizations, so some regressions to `opt` benchmarks is expected.
* Marked as triaged.

Move generic `NonZero` `rustc_layout_scalar_valid_range_start` attribute to inner
type. [#121885](https://github.com/rust-lang/rust/pull/121885) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c8813ddd6d2602ae5473752031fd16ba70a6e4a7&end=a615cea3339046c7ab2d75cd253727d1fd42dd0b&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 0.4%  |  [0.3%, 0.6%]  |   9   |
| Regressions ❌ <br /> (secondary)  | 0.2%  |  [0.2%, 0.2%]  |   1   |
|  Improvements ✅ <br /> (primary)  |   -   |       -        |   0   |
| Improvements ✅ <br /> (secondary) | -2.8% | [-2.8%, -2.8%] |   1   |
|         All ❌✅ (primary)          | 0.4%  |  [0.3%, 0.6%]  |   9   |

* A small regression caused by internal refactoring in the compiler. Marked as triaged.

Rollup of 8 pull
requests [#122690](https://github.com/rust-lang/rust/pull/122690) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3cdcdaf31b45f8045164aae9604573d23091970b&end=d31b6fb8c06b43536ac5be38462d2a55784e2199&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   |   -   |       -        |   0   |
| Regressions ❌ <br /> (secondary)  | 2.7%  |  [0.2%, 5.3%]  |   2   |
|  Improvements ✅ <br /> (primary)  | -0.2% | [-0.3%, -0.2%] |   7   |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.3%] |   9   |
|         All ❌✅ (primary)          | -0.2% | [-0.3%, -0.2%] |   7   |

* Most likely noise, marked as triaged.

Rollup of 11 pull
requests [#122713](https://github.com/rust-lang/rust/pull/122713) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d31b6fb8c06b43536ac5be38462d2a55784e2199&end=3c85e56249b0b1942339a6a989a971bf6f1c9e0f&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 1.0%  |  [0.5%, 1.4%]  |   3   |
| Regressions ❌ <br /> (secondary)  |   -   |       -        |   0   |
|  Improvements ✅ <br /> (primary)  |   -   |       -        |   0   |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.9%, -0.4%] |   7   |
|         All ❌✅ (primary)          | 1.0%  |  [0.5%, 1.4%]  |   3   |

* Small regression in match checking caused
  by [#121823](https://github.com/rust-lang/rust/pull/121823),
  which improves compiler diagnostics.
* Marked as triaged.
