library(officer)

# ph_location_label demo ----

doc <- read_pptx()
doc <- add_slide(doc, layout = "Title and Content")

# all ph_label can be read here
layout_properties(doc, layout = "Title and Content")

doc <- ph_with(
  doc,
  head(iris),
  location = ph_location_label(ph_label = "Content Placeholder 2")
)
doc <- ph_with(
  doc,
  format(Sys.Date()),
  location = ph_location_label(ph_label = "Date Placeholder 3")
)
doc <- ph_with(
  doc,
  "This is a title",
  location = ph_location_label(ph_label = "Title 1")
)

print(doc, target = tempfile(fileext = ".pptx"))
