% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colwise.R
\name{all_vars}
\alias{all_vars}
\alias{any_vars}
\title{Apply predicate to all variables}
\usage{
all_vars(expr)

any_vars(expr)
}
\arguments{
\item{expr}{<\code{\link[rlang:args_data_masking]{data-masking}}> An expression that
returns a logical vector, using \code{.} to refer to the "current" variable.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

\code{all_vars()} and \code{any_vars()} were only needed for the scoped verbs, which
have been superseded by the use of \code{\link[=across]{across()}} in an existing verb. See
\code{vignette("colwise")} for details.

These quoting functions signal to scoped filtering verbs
(e.g. \code{\link[=filter_if]{filter_if()}} or \code{\link[=filter_all]{filter_all()}}) that a predicate expression
should be applied to all relevant variables. The \code{all_vars()}
variant takes the intersection of the predicate expressions with
\code{&} while the \code{any_vars()} variant takes the union with \code{|}.
}
\seealso{
\code{\link[=vars]{vars()}} for other quoting functions that you
can use with scoped verbs.
}
