// Templates from the following files:
//   12-Crown-4.mol
//   1293.mol
//   13-Crown-4.mol
//   14-Crown-4.mol
//   15-Crown-5.mol
//   16-Crown-5.mol
//   17-Crown-5.mol
//   18-Crown-6.mol
//   20-Crown-6.mol
//   21-Crown-7.mol
//   24-Crown-8.mol
//   27-Crown-9.mol
//   30-Crown-10.mol
//   adamantane.mol
//   aw00196.mol
//   big-ring-correct.mol
//   big_semicube.mol
//   btb12419.mol
//   cd00846.mol
//   complexring1.mol
//   complexring2.mol
//   complexring3.mol
//   complexring4.mol
//   complexring5.mol
//   complexring6.mol
//   complexring7.mol
//   cube.mol
//   highvalence.mol
//   krabe.mol
//   krabe2.mol
//   Rings-tmpls.sdf
//   s13133.mol
//   sphere.mol
//   sphere2.mol
//   sphere_mod1.mol
//   superstar.mol
static const char* layout_templates[] =
{
  "12-Crown-4.mol\n"
  "  Ketcher 07271614182D 1   1.00000     0.00000     0\n"
  "\n"
  " 12 12  0     0  0            999 V2000\n"
  "    9.6950   -4.9978    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.6961   -3.9955    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.7230   -3.7807    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.4895   -2.8165    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.4888   -2.8252    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.2724   -3.7946    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.3039   -4.0292    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.3039   -5.0370    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.2718   -5.2624    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.4935   -6.2335    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.4934   -6.2191    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.7126   -5.2320    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0     0  0\n"
  "  2  3  1  0     0  0\n"
  "  3  4  1  0     0  0\n"
  "  4  5  1  0     0  0\n"
  "  5  6  1  0     0  0\n"
  "  6  7  1  0     0  0\n"
  "  7  8  1  0     0  0\n"
  "  8  9  1  0     0  0\n"
  "  9 10  1  0     0  0\n"
  " 10 11  1  0     0  0\n"
  " 11 12  1  0     0  0\n"
  " 12  1  1  0     0  0\n"
  "M  END\n"
  "\n",

  "1293.mol\n"
  "  Marvin  05180922082D          \n"
  "\n"
  "  7  8  0  0  0  0            999 V2000\n"
  "   -0.3123   -0.6177    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.3470    0.9485    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.1198   -0.5992    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.4350   -0.8884    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.0046    0.2337    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.1198   -0.6431    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.7866    0.0000    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0  0  0  0\n"
  "  1  3  1  0  0  0  0\n"
  "  1  4  1  0  0  0  0\n"
  "  5  2  1  0  0  0  0\n"
  "  4  6  2  0  0  0  0\n"
  "  5  7  1  0  0  0  0\n"
  "  5  3  1  0  0  0  0\n"
  "  6  7  1  0  0  0  0\n"
  "M  END\n"
  "\n"
  "\n",

  "13-Crown-4.mol\n"
  "  Ketcher 07271614182D 1   1.00000     0.00000     0\n"
  "\n"
  " 13 13  0     0  0            999 V2000\n"
  "    6.2108   -5.8522    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.2098   -4.8784    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.1789   -6.0710    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.1735   -4.6689    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.3479   -7.0179    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.3527   -3.7257    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.3428   -7.0999    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.3459   -3.6501    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.7617   -6.1569    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.7571   -4.5979    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.7493   -6.2607    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.7528   -4.4917    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.2902   -5.3776    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  3  1  0     0  0\n"
  "  2  4  1  0     0  0\n"
  "  3  5  1  0     0  0\n"
  "  4  6  1  0     0  0\n"
  "  5  7  1  0     0  0\n"
  "  6  8  1  0     0  0\n"
  "  7  9  1  0     0  0\n"
  "  8 10  1  0     0  0\n"
  "  9 11  1  0     0  0\n"
  " 10 12  1  0     0  0\n"
  " 11 13  1  0     0  0\n"
  " 12 13  1  0     0  0\n"
  "  1  2  1  0     0  0\n"
  "M  END\n"
  "\n",

  "14-Crown-4.mol\n"
  "  Ketcher 07271614192D 1   1.00000     0.00000     0\n"
  "\n"
  " 14 14  0     0  0            999 V2000\n"
  "   11.4453   -5.1251    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.9013   -4.2723    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.9150   -5.9676    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.9132   -4.4080    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.9274   -5.8351    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.5059   -3.4886    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.5286   -6.7560    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.4978   -3.4979    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.5308   -6.7614    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.1114   -4.4181    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.1336   -5.8403    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.1388   -4.2937    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.1473   -5.9857    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.6047   -5.1430    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0     0  0\n"
  "  1  3  1  0     0  0\n"
  "  2  4  1  0     0  0\n"
  "  3  5  1  0     0  0\n"
  "  4  6  1  0     0  0\n"
  "  5  7  1  0     0  0\n"
  "  6  8  1  0     0  0\n"
  "  7  9  1  0     0  0\n"
  "  8 10  1  0     0  0\n"
  "  9 11  1  0     0  0\n"
  " 10 12  1  0     0  0\n"
  " 11 13  1  0     0  0\n"
  " 12 14  1  0     0  0\n"
  " 13 14  1  0     0  0\n"
  "M  END\n"
  "\n",

  "15-Crown-5.mol\n"
  "  Ketcher 07271614192D 1   1.00000     0.00000     0\n"
  "\n"
  " 15 15  0     0  0            999 V2000\n"
  "    9.3051   -3.6194    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.1168   -4.1865    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.4997   -4.1934    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.8472   -5.1345    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.6861   -3.6269    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.6483   -5.7210    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.8859   -4.1972    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.3419   -6.6998    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.1594   -5.1457    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.3292   -6.7279    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.3517   -5.7489    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.0217   -7.6806    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.6728   -6.7074    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.0073   -7.6806    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.6647   -6.7239    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0     0  0\n"
  "  1  3  1  0     0  0\n"
  "  2  4  1  0     0  0\n"
  "  3  5  1  0     0  0\n"
  "  4  6  1  0     0  0\n"
  "  5  7  1  0     0  0\n"
  "  6  8  1  0     0  0\n"
  "  7  9  1  0     0  0\n"
  "  8 10  1  0     0  0\n"
  "  9 11  1  0     0  0\n"
  " 10 12  1  0     0  0\n"
  " 11 13  1  0     0  0\n"
  " 12 14  1  0     0  0\n"
  " 13 15  1  0     0  0\n"
  " 14 15  1  0     0  0\n"
  "M  END\n"
  "\n",

  "16-Crown-5.mol\n"
  "  Ketcher 07271614202D 1   1.00000     0.00000     0\n"
  "\n"
  " 16 16  0     0  0            999 V2000\n"
  "   10.1579   -7.9802    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.3604   -8.5644    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.8558   -7.0304    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.5517   -7.9928    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.6502   -6.4638    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.7522   -8.5665    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.4079   -5.4912    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.9519   -7.9997    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.3921   -5.2815    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.2224   -7.0336    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.3715   -4.2847    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.3998   -6.4989    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.4688   -3.7835    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.5949   -5.5179    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.5786   -4.2984    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.5857   -5.2815    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0     0  0\n"
  "  1  3  1  0     0  0\n"
  "  2  4  1  0     0  0\n"
  "  3  5  1  0     0  0\n"
  "  4  6  1  0     0  0\n"
  "  5  7  1  0     0  0\n"
  "  6  8  1  0     0  0\n"
  "  7  9  1  0     0  0\n"
  "  8 10  1  0     0  0\n"
  "  9 11  1  0     0  0\n"
  " 10 12  1  0     0  0\n"
  " 11 13  1  0     0  0\n"
  " 12 14  1  0     0  0\n"
  " 13 15  1  0     0  0\n"
  " 14 16  1  0     0  0\n"
  " 15 16  1  0     0  0\n"
  "M  END\n"
  "\n",

  "17-Crown-5.mol\n"
  "  Ketcher 07271614202D 1   1.00000     0.00000     0\n"
  "\n"
  " 17 17  0     0  0            999 V2000\n"
  "   11.0779   -6.2549    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.1260   -6.4972    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.2569   -7.9159    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.4815   -7.2799    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.7011   -7.8978    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.8165   -7.4802    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.8151   -6.4943    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.8549   -6.2786    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.6443   -5.3223    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.4333   -4.6975    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.3911   -5.0835    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.9204   -4.2341    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.9543   -4.2341    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.4969   -5.0788    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.4504   -4.6735    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.2557   -5.2828    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.1487   -7.4881    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0     0  0\n"
  "  3  4  1  0     0  0\n"
  "  4  5  1  0     0  0\n"
  "  5  6  1  0     0  0\n"
  "  7  8  1  0     0  0\n"
  "  8  9  1  0     0  0\n"
  "  9 10  1  0     0  0\n"
  "  6  7  1  0     0  0\n"
  " 11 12  1  0     0  0\n"
  " 12 13  1  0     0  0\n"
  " 13 14  1  0     0  0\n"
  " 10 11  1  0     0  0\n"
  " 15 16  1  0     0  0\n"
  " 14 15  1  0     0  0\n"
  " 16  1  1  0     0  0\n"
  "  2 17  1  0     0  0\n"
  " 17  3  1  0     0  0\n"
  "M  END\n"
  "\n",

  "18-Crown-6.mol\n"
  "  Ketcher 07271614212D 1   1.00000     0.00000     0\n"
  "\n"
  " 18 18  0     0  0            999 V2000\n"
  "   12.0989   -6.5157    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   12.0984   -7.5223    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.1742   -7.8983    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.2561   -8.8885    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.3671   -9.3684    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.5542   -8.7612    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.7470   -9.3729    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.8655   -8.8820    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.9673   -7.9010    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.0511   -7.5248    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.0591   -6.5276    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.9807   -6.1495    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.8891   -5.1717    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.7538   -4.6802    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.5585   -5.2838    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.3625   -4.6771    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.2539   -5.1612    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.1740   -6.1413    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0     0  0\n"
  "  2  3  1  0     0  0\n"
  "  4  5  1  0     0  0\n"
  "  5  6  1  0     0  0\n"
  "  6  7  1  0     0  0\n"
  "  3  4  1  0     0  0\n"
  "  8  9  1  0     0  0\n"
  "  9 10  1  0     0  0\n"
  " 10 11  1  0     0  0\n"
  "  7  8  1  0     0  0\n"
  " 12 13  1  0     0  0\n"
  " 13 14  1  0     0  0\n"
  " 14 15  1  0     0  0\n"
  " 11 12  1  0     0  0\n"
  " 16 17  1  0     0  0\n"
  " 17 18  1  0     0  0\n"
  " 15 16  1  0     0  0\n"
  "  1 18  1  0     0  0\n"
  "M  END\n"
  "\n",

  "20-Crown-6.mol\n"
  "  Ketcher 07271614212D 1   1.00000     0.00000     0\n"
  "\n"
  " 20 20  0     0  0            999 V2000\n"
  "   12.9696   -6.7231    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   12.4562   -7.5685    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   12.4568   -5.8692    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.4567   -7.5264    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.4506   -5.9049    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.2686   -8.5088    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.2545   -4.9333    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.3166   -8.8267    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.3019   -4.6233    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.5590   -8.1616    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.5486   -5.2850    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.7892   -4.6263    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.8656   -8.5059    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.8443   -4.9441    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.6577   -7.5325    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.6557   -5.9166    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.6451   -7.5828    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.6382   -5.8785    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.1304   -6.7355    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.8033   -8.8212    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0     0  0\n"
  "  2  4  1  0     0  0\n"
  "  3  5  1  0     0  0\n"
  "  4  6  1  0     0  0\n"
  "  5  7  1  0     0  0\n"
  "  6  8  1  0     0  0\n"
  "  7  9  1  0     0  0\n"
  "  8 10  1  0     0  0\n"
  "  9 11  1  0     0  0\n"
  " 11 12  1  0     0  0\n"
  " 13 15  1  0     0  0\n"
  " 14 16  1  0     0  0\n"
  " 15 17  1  0     0  0\n"
  " 16 18  1  0     0  0\n"
  " 17 19  1  0     0  0\n"
  " 18 19  1  0     0  0\n"
  " 12 14  1  0     0  0\n"
  " 13 20  1  0     0  0\n"
  " 10 20  1  0     0  0\n"
  "  3  1  1  0     0  0\n"
  "M  END\n"
  "\n",

  "21-Crown-7.mol\n"
  "  Ketcher 07271614222D 1   1.00000     0.00000     0\n"
  "\n"
  " 21 21  0     0  0            999 V2000\n"
  "    9.2476   -4.0933    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.3448   -4.5154    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.3272   -5.5163    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.3374   -5.7205    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.0975   -6.6848    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.8706   -7.3222    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.4253   -8.2201    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.0491   -8.9972    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.0215   -8.7675    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.4631   -9.6613    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.4605   -9.6613    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.8988   -8.7577    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.8812   -8.9945    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   12.5114   -8.2256    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.7121   -4.5149    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.8084   -4.0887    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.0256   -4.7163    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   12.1044   -7.3150    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.7139   -5.5116    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   12.9025   -6.7100    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   12.6937   -5.7379    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0     0  0\n"
  "  2  3  1  0     0  0\n"
  "  4  5  1  0     0  0\n"
  "  5  6  1  0     0  0\n"
  "  6  7  1  0     0  0\n"
  "  3  4  1  0     0  0\n"
  "  8  9  1  0     0  0\n"
  "  9 10  1  0     0  0\n"
  " 10 11  1  0     0  0\n"
  "  7  8  1  0     0  0\n"
  " 12 13  1  0     0  0\n"
  " 13 14  1  0     0  0\n"
  " 11 12  1  0     0  0\n"
  " 15 16  1  0     0  0\n"
  " 16 17  1  0     0  0\n"
  "  1 17  1  0     0  0\n"
  " 14 18  1  0     0  0\n"
  " 19 15  1  0     0  0\n"
  " 18 20  1  0     0  0\n"
  " 19 21  1  0     0  0\n"
  " 20 21  1  0     0  0\n"
  "M  END\n"
  "\n",

  "24-Crown-8.mol\n"
  "  Ketcher 07271614222D 1   1.00000     0.00000     0\n"
  "\n"
  " 24 24  0     0  0            999 V2000\n"
  "    9.0714   -9.5538    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.5688   -8.6839    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.0589   -9.5538    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.5317   -9.0088    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.5767   -8.6753    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.2612   -8.3147    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.6218   -8.9758    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.9970   -7.3518    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.9000   -8.2659    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.8824   -6.8882    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.1947   -7.2962    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.8855   -5.8841    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.3145   -6.8085    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.0044   -5.4160    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.3384   -5.8124    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.2885   -4.4573    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.2280   -5.3744    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.5636   -3.7853    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.9695   -4.4189    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.6083   -4.1102    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.7013   -3.7643    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.1273   -3.2484    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.6397   -4.1023    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.1264   -3.2462    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0     0  0\n"
  "  1  3  1  0     0  0\n"
  "  2  4  1  0     0  0\n"
  "  3  5  1  0     0  0\n"
  "  4  6  1  0     0  0\n"
  "  5  7  1  0     0  0\n"
  "  6  8  1  0     0  0\n"
  "  7  9  1  0     0  0\n"
  "  8 10  1  0     0  0\n"
  "  9 11  1  0     0  0\n"
  " 10 12  1  0     0  0\n"
  " 11 13  1  0     0  0\n"
  " 12 14  1  0     0  0\n"
  " 13 15  1  0     0  0\n"
  " 14 16  1  0     0  0\n"
  " 15 17  1  0     0  0\n"
  " 16 18  1  0     0  0\n"
  " 17 19  1  0     0  0\n"
  " 18 20  1  0     0  0\n"
  " 19 21  1  0     0  0\n"
  " 20 22  1  0     0  0\n"
  " 21 23  1  0     0  0\n"
  " 22 24  1  0     0  0\n"
  " 23 24  1  0     0  0\n"
  "M  END\n"
  "\n",

  "27-Crown-9.mol\n"
  "  Ketcher 07271614232D 1   1.00000     0.00000     0\n"
  "\n"
  " 27 27  0     0  0            999 V2000\n"
  "   12.8715   -5.4793    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   12.4227   -6.3542    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   12.3172   -4.6439    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   13.2176   -6.9623    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.3116   -4.7071    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   13.0558   -7.9420    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.0873   -3.7356    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   12.1143   -8.2518    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   12.2476   -9.2356    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.3689   -4.0852    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.6009   -3.4377    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.1290   -3.4254    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.5183   -9.4192    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.6486   -3.7570    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.9884  -10.2746    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.4426   -9.8295    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.4301   -4.7338    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.9807  -10.2746    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.4253   -4.6828    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.4473   -9.4221    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.8996   -5.5250    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.5287   -9.8321    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.3912   -6.3772    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.7155   -9.2528    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.6324   -7.0243    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.8191   -8.2642    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.8489   -7.9911    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0     0  0\n"
  "  1  3  1  0     0  0\n"
  "  2  4  1  0     0  0\n"
  "  3  5  1  0     0  0\n"
  "  4  6  1  0     0  0\n"
  "  5  7  1  0     0  0\n"
  "  6  8  1  0     0  0\n"
  "  8  9  1  0     0  0\n"
  " 10 11  1  0     0  0\n"
  " 10 12  1  0     0  0\n"
  " 11 14  1  0     0  0\n"
  " 13 15  1  0     0  0\n"
  " 13 16  1  0     0  0\n"
  " 14 17  1  0     0  0\n"
  " 15 18  1  0     0  0\n"
  " 17 19  1  0     0  0\n"
  " 18 20  1  0     0  0\n"
  " 19 21  1  0     0  0\n"
  " 20 22  1  0     0  0\n"
  " 21 23  1  0     0  0\n"
  " 22 24  1  0     0  0\n"
  " 23 25  1  0     0  0\n"
  " 24 26  1  0     0  0\n"
  " 26 27  1  0     0  0\n"
  " 12  7  1  0     0  0\n"
  "  9 16  1  0     0  0\n"
  " 27 25  1  0     0  0\n"
  "M  END\n"
  "\n",

  "30-Crown-10.mol\n"
  "  Ketcher 07271614232D 1   1.00000     0.00000     0\n"
  "\n"
  " 30 30  0     0  0            999 V2000\n"
  "   10.5968   -3.4933    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.5443   -3.8013    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.8344   -4.1370    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.7938   -4.7628    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.1029   -3.4529    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   12.7946   -4.6212    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.1487   -3.7257    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   13.4230   -5.3890    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.8987   -4.6893    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   13.0643   -6.3145    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.9078   -4.5662    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   13.9365   -6.8065    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.3013   -5.3520    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   13.9385   -7.7974    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.6787   -6.2795    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   13.0639   -8.2936    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.8115   -6.7735    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   13.4322   -9.2202    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.8115   -7.7678    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   12.8108  -10.0124    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.6722   -8.2700    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.8119   -9.8780    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.2940   -9.1976    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.5637  -10.8535    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.8989   -9.9918    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.5955  -11.1458    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.9003   -9.8692    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.1417  -10.8495    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.0967  -11.1471    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.8494  -10.4845    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0     0  0\n"
  "  1  3  1  0     0  0\n"
  "  2  4  1  0     0  0\n"
  "  4  6  1  0     0  0\n"
  "  6  8  1  0     0  0\n"
  "  7  9  1  0     0  0\n"
  "  8 10  1  0     0  0\n"
  "  9 11  1  0     0  0\n"
  " 10 12  1  0     0  0\n"
  " 11 13  1  0     0  0\n"
  " 12 14  1  0     0  0\n"
  " 14 16  1  0     0  0\n"
  " 15 17  1  0     0  0\n"
  " 16 18  1  0     0  0\n"
  " 17 19  1  0     0  0\n"
  " 19 21  1  0     0  0\n"
  " 20 22  1  0     0  0\n"
  " 21 23  1  0     0  0\n"
  " 22 24  1  0     0  0\n"
  " 23 25  1  0     0  0\n"
  " 24 26  1  0     0  0\n"
  " 27 28  1  0     0  0\n"
  " 29 30  1  0     0  0\n"
  "  5  7  1  0     0  0\n"
  " 18 20  1  0     0  0\n"
  " 25 27  1  0     0  0\n"
  " 28 29  1  0     0  0\n"
  " 26 30  1  0     0  0\n"
  " 15 13  1  0     0  0\n"
  "  5  3  1  0     0  0\n"
  "M  END\n"
  "\n",

  "adamantane.mol\n"
  "  Ketcher  3131815452D 1   1.00000     0.00000     0\n"
  "\n"
  " 10 12  0     0  0            999 V2000\n"
  "   17.4384   -9.3311    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   18.3280   -8.8790    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   18.3280   -7.9749    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   18.8718   -7.0189    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   17.9820   -7.4709    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   17.9820   -8.3751    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   18.8718   -8.8272    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   19.7616   -8.3751    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   19.2178   -9.3311    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   19.7616   -7.4709    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0     0  0\n"
  "  4 10  1  0     0  0\n"
  "  3  4  1  0     0  0\n"
  "  4  5  1  0     0  0\n"
  "  2  9  1  0     0  0\n"
  "  1  6  1  0     0  0\n"
  "  6  7  1  0     0  0\n"
  "  7  8  1  0     0  0\n"
  "  8  9  1  0     0  0\n"
  "  5  6  1  0     0  0\n"
  "  8 10  1  0     0  0\n"
  "  2  3  1  0     0  0\n"
  "M  END\n"
  "\n",

  "aw00196.mol\n"
  "  Marvin  06090921352D          \n"
  "\n"
  "  7  8  0  0  0  0            999 V2000\n"
  "   -2.0388   -0.2887    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.6962    0.0642    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.5610    1.6539    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.6608    0.4673    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.3686    0.8957    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.4681   -0.2199    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.1452    0.4856    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  2  1  1  0  0  0  0\n"
  "  3  2  1  0  0  0  0\n"
  "  4  1  1  0  0  0  0\n"
  "  5  4  1  0  0  0  0\n"
  "  6  2  1  0  0  0  0\n"
  "  7  5  1  0  0  0  0\n"
  "  5  3  1  0  0  0  0\n"
  "  7  6  1  0  0  0  0\n"
  "M  END\n"
  "\n"
  "\n",

  "big-ring-correct.mol\n"
  "  SMMXDraw01191617002D\n"
  "\n"
  " 20 20  0  0  0  0  0  0  0  0999 V2000\n"
  "    2.5814   -5.4893    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5814   -6.6291    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.5243   -7.2216    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.5243   -8.4170    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5521   -9.0203    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5521  -10.2277    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.5680  -10.8306    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.5680  -12.0177    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.6168  -12.6147    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.6441  -12.0294    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.6441  -10.8483    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.6182  -10.2681    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.6182   -9.0872    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.6338   -8.4989    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.6338   -7.3181    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.6203   -6.7142    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.6203   -5.5375    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.6191   -4.9363    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.5878   -5.5089    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.5668   -4.9103    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  " 20  1  1  0  0  0  0\n"
  "  2  1  1  0  0  0  0\n"
  "  3  2  1  0  0  0  0\n"
  "  4  3  2  0  0  0  0\n"
  "  5  4  1  0  0  0  0\n"
  "  6  5  2  0  0  0  0\n"
  "  7  6  1  0  0  0  0\n"
  "  8  7  1  0  0  0  0\n"
  "  9  8  2  0  0  0  0\n"
  " 10  9  1  0  0  0  0\n"
  " 11 10  2  0  0  0  0\n"
  " 12 11  1  0  0  0  0\n"
  " 13 12  2  0  0  0  0\n"
  " 14 13  1  0  0  0  0\n"
  " 15 14  1  0  0  0  0\n"
  " 16 15  2  0  0  0  0\n"
  " 17 16  1  0  0  0  0\n"
  " 18 17  2  0  0  0  0\n"
  " 19 18  1  0  0  0  0\n"
  " 20 19  2  0  0  0  0\n"
  "M  END\n"
  "\n",

  "big_semicube.mol\n"
  "  Marvin  06090922152D          \n"
  "\n"
  " 10 12  0  0  0  0            999 V2000\n"
  "   12.5528    8.6716    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.9697    7.3910    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.5527   11.5607    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   12.5528    2.8847    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.5133    6.0185    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5351    8.6716    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.5527    0.0000    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.2406    7.2947    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.5133    3.2738    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5351    2.8847    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0  0  0  0\n"
  "  1  3  1  0  0  0  0\n"
  "  1  4  1  0  0  0  0\n"
  "  2  5  1  0  0  0  0\n"
  "  3  6  1  0  0  0  0\n"
  "  4  7  1  0  0  0  0\n"
  "  5  8  1  0  0  0  0\n"
  "  5  9  1  0  0  0  0\n"
  "  6  8  1  0  0  0  0\n"
  "  6 10  1  0  0  0  0\n"
  "  7  9  1  0  0  0  0\n"
  "  7 10  1  0  0  0  0\n"
  "M  END\n"
  "\n",

  "btb12419.mol\n"
  "  Marvin  06090923042D          \n"
  "\n"
  " 12 17  0  0  1  0            999 V2000\n"
  "    4.5956  -45.8571    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4328  -45.4936    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.0438  -44.9212    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4328  -44.7021    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.0438  -44.0962    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.6697  -44.9212    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.0638  -45.4936    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.0638  -44.3695    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.6697  -43.7636    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.8398  -44.3695    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4380  -43.7636    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.2162  -42.7762    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  2  1  1  0  0  0  0\n"
  "  3  1  1  0  0  0  0\n"
  "  4  2  1  0  0  0  0\n"
  "  5  3  1  0  0  0  0\n"
  "  6  3  1  0  0  0  0\n"
  "  7  2  1  0  0  0  0\n"
  "  8  7  1  0  0  0  0\n"
  "  9  6  1  0  0  0  0\n"
  " 10  4  1  0  0  0  0\n"
  " 11  5  1  0  0  0  0\n"
  " 12 11  1  0  0  0  0\n"
  "  5  4  1  0  0  0  0\n"
  "  6  7  1  0  0  0  0\n"
  " 11  9  1  0  0  0  0\n"
  "  9  8  1  0  0  0  0\n"
  " 10  8  1  0  0  0  0\n"
  " 12 10  1  0  0  0  0\n"
  "M  END\n"
  "\n",

  "cd00846.mol\n"
  "  Marvin  05180922142D          \n"
  "\n"
  " 10 12  0  0  0  0            999 V2000\n"
  "   -2.6370    0.3582    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.8659    0.3582    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.2481    1.4304    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.7204   -0.2216    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.6370    1.0722    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.1742   -0.7141    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.2481    0.0045    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.8659    1.0722    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.5106   -0.5171    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.7204    0.6783    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  2  7  1  0  0  0  0\n"
  "  3  5  1  0  0  0  0\n"
  "  4  6  1  0  0  0  0\n"
  "  5  1  1  0  0  0  0\n"
  "  6  1  1  0  0  0  0\n"
  "  7  1  1  0  0  0  0\n"
  "  8  2  1  0  0  0  0\n"
  "  9  2  1  0  0  0  0\n"
  " 10  4  1  0  0  0  0\n"
  "  9  4  1  0  0  0  0\n"
  "  8  3  1  0  0  0  0\n"
  " 10  3  1  0  0  0  0\n"
  "M  END\n"
  "\n"
  "\n",

  "complexring1.mol\n"
  "  Marvin  06090923582D          \n"
  "\n"
  " 49 56  0  0  1  0            999 V2000\n"
  "    8.3868    5.5208    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.6526    5.9130    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.4069    4.6962    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.9488    5.4806    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.6325    6.7476    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.6929    4.2637    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.9689    4.6560    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.0493    7.3409    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.7230    3.4392    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.2806    8.1253    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.2549    7.1297    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.1297    2.8660    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.6873    8.7186    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.6716    7.7130    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.3208    2.0715    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.3353    3.0972    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.8928    8.5275    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.7275    1.4883    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.7420    2.5240    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.3297    9.1007    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.9331    1.7196    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.5152    8.8996    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.3398    1.1464    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.9319    9.4929    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.2939    8.1052    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.5353    1.3676    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.1375    9.2818    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4895    7.8940    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.9520    0.7843    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.3241    2.1621    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.9163    8.4873    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.1576    1.0056    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.5297    2.3833    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.1117    8.2761    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.9464    1.8000    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.8503    7.4214    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.2828    1.9710    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0458    7.2404    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.4135    6.8080    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.9911    2.7453    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.7944    6.4560    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.1520    6.0135    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.1665    2.8761    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5039    3.3889    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.3475    5.8426    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.8648    3.6503    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.2023    4.1632    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0860    5.0582    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.3878    4.2838    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0  0  0  0\n"
  "  1  3  1  0  0  0  0\n"
  "  2  4  1  0  0  0  0\n"
  "  2  5  1  0  0  0  0\n"
  "  3  6  1  0  0  0  0\n"
  "  4  7  1  0  0  0  0\n"
  "  8  5  1  0  0  0  0\n"
  "  6  7  1  0  0  0  0\n"
  "  6  9  1  0  0  0  0\n"
  "  8 10  1  0  0  0  0\n"
  "  8 11  1  0  0  0  0\n"
  " 12  9  1  0  0  0  0\n"
  " 10 13  1  0  0  0  0\n"
  " 11 14  1  0  0  0  0\n"
  " 12 15  1  0  0  0  0\n"
  " 12 16  1  0  0  0  0\n"
  " 13 17  1  0  0  0  0\n"
  " 14 17  1  0  0  0  0\n"
  " 15 18  1  0  0  0  0\n"
  " 16 19  1  0  0  0  0\n"
  " 17 20  1  0  0  0  0\n"
  " 18 21  1  0  0  0  0\n"
  " 19 21  1  0  0  0  0\n"
  " 22 20  1  0  0  0  0\n"
  " 21 23  1  0  0  0  0\n"
  " 22 24  1  0  0  0  0\n"
  " 22 25  1  0  0  0  0\n"
  " 26 23  1  0  0  0  0\n"
  " 24 27  1  0  0  0  0\n"
  " 25 28  1  0  0  0  0\n"
  " 26 29  1  0  0  0  0\n"
  " 26 30  1  0  0  0  0\n"
  " 27 31  1  0  0  0  0\n"
  " 28 31  1  0  0  0  0\n"
  " 29 32  1  0  0  0  0\n"
  " 30 33  1  0  0  0  0\n"
  " 31 34  1  0  0  0  0\n"
  " 32 35  1  0  0  0  0\n"
  " 33 35  1  0  0  0  0\n"
  " 36 34  1  0  0  0  0\n"
  " 35 37  1  0  0  0  0\n"
  " 36 38  1  0  0  0  0\n"
  " 36 39  1  0  0  0  0\n"
  " 40 37  1  0  0  0  0\n"
  " 38 41  1  0  0  0  0\n"
  " 39 42  1  0  0  0  0\n"
  " 40 43  1  0  0  0  0\n"
  " 40 44  1  0  0  0  0\n"
  " 41 45  1  0  0  0  0\n"
  " 42 45  1  0  0  0  0\n"
  " 43 46  1  0  0  0  0\n"
  " 44 47  1  0  0  0  0\n"
  " 45 48  1  0  0  0  0\n"
  " 46 49  1  0  0  0  0\n"
  " 47 49  1  0  0  0  0\n"
  " 49 48  1  0  0  0  0\n"
  "M  END\n"
  "\n",

  "complexring2.mol\n"
  "  Marvin  06090923582D          \n"
  "\n"
  " 56 64  0  0  0  0            999 V2000\n"
  "  -13.2758  -47.4415    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -12.4922  -47.1624    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -13.4099  -48.2143    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -14.0592  -47.0605    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -11.8751  -47.6885    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -12.8464  -48.7671    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -14.0914  -46.0248    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -12.0575  -48.4988    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -14.9125  -45.8584    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -13.5441  -45.3755    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -11.4458  -49.1696    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -15.1593  -45.1125    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -13.8284  -44.6509    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -10.6408  -48.9658    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -14.6602  -44.4900    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -10.3133  -48.1983    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -10.1310  -49.6310    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -15.1593  -43.6152    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -9.5138  -48.1339    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -9.3421  -49.5345    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -14.3920  -43.0893    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -9.0308  -48.8153    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -14.6602  -42.3219    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -13.5441  -43.2503    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -8.2150  -48.7349    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -14.1289  -41.7047    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -13.0610  -42.5849    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -7.6302  -47.8978    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -13.3240  -41.8335    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -8.0111  -47.1786    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -6.8306  -47.9513    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -12.9430  -41.0876    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -7.5818  -46.4757    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -6.3797  -47.2591    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -12.0252  -41.0876    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -6.7286  -46.5453    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -11.7087  -40.3363    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -11.4940  -41.7369    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -6.1489  -45.8746    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -10.8929  -40.2343    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -10.7051  -41.5974    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -6.3474  -45.0588    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  -10.4207  -40.8139    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -7.1471  -44.8494    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -5.7626  -44.5060    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -9.5138  -40.5188    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -7.3457  -44.0499    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -5.9450  -43.7064    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -8.8483  -41.2700    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -6.7286  -43.4865    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -8.1292  -40.9158    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -8.9824  -42.0697    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -6.7286  -42.6170    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -7.4799  -41.3989    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -8.2794  -42.5527    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -7.5658  -42.2145    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0  0  0  0\n"
  "  1  3  1  0  0  0  0\n"
  "  1  4  1  0  0  0  0\n"
  "  2  5  1  0  0  0  0\n"
  "  3  6  1  0  0  0  0\n"
  "  4  7  1  0  0  0  0\n"
  "  8  5  1  0  0  0  0\n"
  "  7  9  1  0  0  0  0\n"
  "  7 10  1  0  0  0  0\n"
  "  8 11  1  0  0  0  0\n"
  "  9 12  1  0  0  0  0\n"
  " 10 13  1  0  0  0  0\n"
  " 14 11  1  0  0  0  0\n"
  " 12 15  1  0  0  0  0\n"
  " 14 16  1  0  0  0  0\n"
  " 14 17  1  0  0  0  0\n"
  " 15 18  1  0  0  0  0\n"
  " 16 19  1  0  0  0  0\n"
  " 17 20  1  0  0  0  0\n"
  " 18 21  1  0  0  0  0\n"
  " 22 19  1  0  0  0  0\n"
  " 21 23  1  0  0  0  0\n"
  " 21 24  1  0  0  0  0\n"
  " 22 25  1  0  0  0  0\n"
  " 23 26  1  0  0  0  0\n"
  " 24 27  1  0  0  0  0\n"
  " 28 25  1  0  0  0  0\n"
  " 26 29  1  0  0  0  0\n"
  " 28 30  1  0  0  0  0\n"
  " 28 31  1  0  0  0  0\n"
  " 29 32  1  0  0  0  0\n"
  " 30 33  1  0  0  0  0\n"
  " 31 34  1  0  0  0  0\n"
  " 32 35  1  0  0  0  0\n"
  " 36 33  1  0  0  0  0\n"
  " 35 37  1  0  0  0  0\n"
  " 35 38  1  0  0  0  0\n"
  " 36 39  1  0  0  0  0\n"
  " 37 40  1  0  0  0  0\n"
  " 38 41  1  0  0  0  0\n"
  " 42 39  1  0  0  0  0\n"
  " 40 43  1  0  0  0  0\n"
  " 42 44  1  0  0  0  0\n"
  " 42 45  1  0  0  0  0\n"
  " 43 46  1  0  0  0  0\n"
  " 44 47  1  0  0  0  0\n"
  " 45 48  1  0  0  0  0\n"
  " 46 49  1  0  0  0  0\n"
  " 50 47  1  0  0  0  0\n"
  " 49 51  1  0  0  0  0\n"
  " 49 52  1  0  0  0  0\n"
  " 50 53  1  0  0  0  0\n"
  " 51 54  1  0  0  0  0\n"
  " 52 55  1  0  0  0  0\n"
  " 56 53  1  0  0  0  0\n"
  "  6  8  1  0  0  0  0\n"
  " 13 15  1  0  0  0  0\n"
  " 20 22  1  0  0  0  0\n"
  " 27 29  1  0  0  0  0\n"
  " 34 36  1  0  0  0  0\n"
  " 41 43  1  0  0  0  0\n"
  " 48 50  1  0  0  0  0\n"
  " 54 56  1  0  0  0  0\n"
  " 55 56  1  0  0  0  0\n"
  "M  END\n"
  "\n",

  "complexring3.mol\n"
  "  Marvin  06240919342D          \n"
  "\n"
  " 42 48  0  0  1  0            999 V2000\n"
  "    2.1300    0.8164    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.7843    0.4083    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.1300    2.0254    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.4025    0.4083    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.7843   -0.4187    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0624    2.6377    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.4025   -0.3925    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.0829   -0.8269    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0624    3.4228    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.3820    2.2191    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.0829   -2.0515    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.3350    3.8467    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.3297    2.6221    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0519   -2.6063    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.3297    3.4228    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0519   -3.4070    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.3350   -2.1981    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.4812    4.0194    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.3350   -3.8309    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.3297   -2.5906    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.5487    3.4228    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.3297   -3.4228    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.2291    3.8728    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.5487    2.6221    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.3974   -3.9305    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.9566    3.4228    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.2606    2.1719    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.5487   -3.3181    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.9566    2.5958    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.1977   -3.8153    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.5487   -2.5331    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -5.0714    2.0254    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.9566   -3.4228    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.2762   -2.1509    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -5.0714    0.8164    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.9566   -2.5906    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -5.7674    0.4083    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.3386    0.4083    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -5.0714   -2.0096    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -5.7674   -0.4187    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.3386   -0.4187    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -5.0714   -0.8269    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0  0  0  0\n"
  "  1  3  1  0  0  0  0\n"
  "  1  4  1  0  0  0  0\n"
  "  2  5  1  0  0  0  0\n"
  "  6  3  1  0  0  0  0\n"
  "  4  7  1  0  0  0  0\n"
  "  5  8  1  0  0  0  0\n"
  "  6  9  1  0  0  0  0\n"
  "  6 10  1  0  0  0  0\n"
  "  8 11  1  0  0  0  0\n"
  "  9 12  1  0  0  0  0\n"
  " 10 13  1  0  0  0  0\n"
  " 14 11  1  0  0  0  0\n"
  " 12 15  1  0  0  0  0\n"
  " 14 16  1  0  0  0  0\n"
  " 14 17  1  0  0  0  0\n"
  " 15 18  1  0  0  0  0\n"
  " 16 19  1  0  0  0  0\n"
  " 17 20  1  0  0  0  0\n"
  " 21 18  1  0  0  0  0\n"
  " 19 22  1  0  0  0  0\n"
  " 21 23  1  0  0  0  0\n"
  " 21 24  1  0  0  0  0\n"
  " 22 25  1  0  0  0  0\n"
  " 23 26  1  0  0  0  0\n"
  " 24 27  1  0  0  0  0\n"
  " 28 25  1  0  0  0  0\n"
  " 26 29  1  0  0  0  0\n"
  " 28 30  1  0  0  0  0\n"
  " 28 31  1  0  0  0  0\n"
  " 29 32  1  0  0  0  0\n"
  " 30 33  1  0  0  0  0\n"
  " 31 34  1  0  0  0  0\n"
  " 35 32  1  0  0  0  0\n"
  " 33 36  1  0  0  0  0\n"
  " 35 37  1  0  0  0  0\n"
  " 35 38  1  0  0  0  0\n"
  " 36 39  1  0  0  0  0\n"
  " 37 40  1  0  0  0  0\n"
  " 38 41  1  0  0  0  0\n"
  " 42 39  1  0  0  0  0\n"
  "  7  8  1  0  0  0  0\n"
  " 13 15  1  0  0  0  0\n"
  " 20 22  1  0  0  0  0\n"
  " 27 29  1  0  0  0  0\n"
  " 34 36  1  0  0  0  0\n"
  " 40 42  1  0  0  0  0\n"
  " 41 42  1  0  0  0  0\n"
  "M  END\n"
  "\n",

  "complexring4.mol\n"
  "  Mrv0541 03181118532D          \n"
  "\n"
  " 80104  0  0  1  0            999 V2000\n"
  "   -2.4750    0.0000    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.9599    0.6674    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.7446    0.4125    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.5292    0.6675    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -5.0141    0.0000    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.9599   -0.6675    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.7445   -0.4126    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.5291   -0.6676    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.0140   -0.0001    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.5291    0.6673    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.7445    0.4124    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.9599    0.6673    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.4749    0.0000    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.6210   -2.5650    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.3561   -2.9396    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.7305   -3.6746    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.5454   -3.5456    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.6745   -2.7308    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.9394   -2.3562    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5648   -1.6211    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.7500   -1.7502    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.6746    2.7307    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.9395    2.3561    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.5649    1.6210    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.7501    1.7501    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.6210    2.5649    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.3561    2.9395    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.7306    3.6745    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.5455    3.5455    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.7307    3.6745    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.3561    2.9394    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.6210    2.5648    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.7501    1.7500    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5649    1.6209    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.9395    2.3561    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.6745    2.7305    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.5455    3.5454    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.5456   -3.5455    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.7308   -3.6746    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.3562   -2.9395    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.6211   -2.5649    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.7502   -1.7501    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.6674    4.5291    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.4125    3.7445    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.6674    2.9599    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0000    2.4749    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.6674    2.9599    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.4125    3.7445    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.6675    4.5291    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0000    5.0140    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.6675   -2.9599    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.4126   -3.7446    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.6676   -4.5292    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.0001   -5.0141    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.6673   -4.5292    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.4124   -3.7446    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.6673   -2.9600    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0000   -2.4750    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5868    1.0714    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.4346    1.8368    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.6746   -2.7306    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.9396   -2.3562    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.5650   -1.6210    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.9600   -0.6674    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.7446   -0.4125    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.5292   -0.6674    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.5869   -1.0715    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.4347   -1.8369    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0715    2.5868    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.8369    4.4345    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.0715    2.5868    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.8369    4.4346    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.5869    1.0715    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.4346    1.8369    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5868   -1.0716    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.4346   -1.8369    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0714   -2.5869    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.8368   -4.4347    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.0716   -2.5869    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.8370   -4.4346    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  " 64  1  1  0  0  0  0\n"
  "  1  2  1  0  0  0  0\n"
  " 65  3  1  0  0  0  0\n"
  "  5  4  1  0  0  0  0\n"
  " 66  5  1  0  0  0  0\n"
  "  8  9  1  0  0  0  0\n"
  "  9 10  1  0  0  0  0\n"
  " 11 10  1  0  0  0  0\n"
  "  7 11  1  0  0  0  0\n"
  " 11 12  1  0  0  0  0\n"
  " 13 12  1  0  0  0  0\n"
  "  6 13  1  0  0  0  0\n"
  " 16 17  1  0  0  0  0\n"
  " 17 18  1  0  0  0  0\n"
  " 15 19  1  0  0  0  0\n"
  " 21 20  1  0  0  0  0\n"
  " 14 21  1  0  0  0  0\n"
  " 24 25  1  0  0  0  0\n"
  " 25 26  1  0  0  0  0\n"
  " 27 23  1  0  0  0  0\n"
  " 29 28  1  0  0  0  0\n"
  " 22 29  1  0  0  0  0\n"
  " 32 33  1  0  0  0  0\n"
  " 33 34  1  0  0  0  0\n"
  " 35 34  1  0  0  0  0\n"
  " 35 31  1  0  0  0  0\n"
  " 35 36  1  0  0  0  0\n"
  " 37 36  1  0  0  0  0\n"
  " 30 37  1  0  0  0  0\n"
  " 61 38  1  0  0  0  0\n"
  " 38 39  1  0  0  0  0\n"
  " 62 40  1  0  0  0  0\n"
  " 42 41  1  0  0  0  0\n"
  " 63 42  1  0  0  0  0\n"
  " 45 46  1  0  0  0  0\n"
  " 46 47  1  0  0  0  0\n"
  " 48 44  1  0  0  0  0\n"
  " 50 49  1  0  0  0  0\n"
  " 43 50  1  0  0  0  0\n"
  " 53 54  1  0  0  0  0\n"
  " 54 55  1  0  0  0  0\n"
  " 52 56  1  0  0  0  0\n"
  " 58 57  1  0  0  0  0\n"
  " 51 58  1  0  0  0  0\n"
  " 36 60  1  0  0  0  0\n"
  " 10 60  1  0  0  0  0\n"
  " 34 59  1  0  0  0  0\n"
  " 12 59  1  0  0  0  0\n"
  " 66 68  1  0  0  0  0\n"
  " 61 68  1  0  0  0  0\n"
  " 64 67  1  0  0  0  0\n"
  " 63 67  1  0  0  0  0\n"
  " 62 61  1  0  0  0  0\n"
  " 62 63  1  0  0  0  0\n"
  " 65 64  1  0  0  0  0\n"
  " 65 66  1  0  0  0  0\n"
  " 32 69  1  0  0  0  0\n"
  " 31 32  1  0  0  0  0\n"
  " 31 30  1  0  0  0  0\n"
  " 30 70  1  0  0  0  0\n"
  " 47 69  1  0  0  0  0\n"
  " 48 47  1  0  0  0  0\n"
  " 48 49  1  0  0  0  0\n"
  " 49 70  1  0  0  0  0\n"
  " 26 71  1  0  0  0  0\n"
  " 27 26  1  0  0  0  0\n"
  " 43 72  1  0  0  0  0\n"
  " 44 43  1  0  0  0  0\n"
  " 44 45  1  0  0  0  0\n"
  " 45 71  1  0  0  0  0\n"
  " 27 28  1  0  0  0  0\n"
  " 28 72  1  0  0  0  0\n"
  "  2 73  1  0  0  0  0\n"
  "  3  2  1  0  0  0  0\n"
  " 22 74  1  0  0  0  0\n"
  " 23 22  1  0  0  0  0\n"
  " 23 24  1  0  0  0  0\n"
  " 24 73  1  0  0  0  0\n"
  "  3  4  1  0  0  0  0\n"
  "  4 74  1  0  0  0  0\n"
  " 20 75  1  0  0  0  0\n"
  " 19 20  1  0  0  0  0\n"
  "  8 76  1  0  0  0  0\n"
  "  7  8  1  0  0  0  0\n"
  "  7  6  1  0  0  0  0\n"
  "  6 75  1  0  0  0  0\n"
  " 19 18  1  0  0  0  0\n"
  " 18 76  1  0  0  0  0\n"
  " 14 77  1  0  0  0  0\n"
  " 15 14  1  0  0  0  0\n"
  " 15 16  1  0  0  0  0\n"
  " 16 78  1  0  0  0  0\n"
  " 57 77  1  0  0  0  0\n"
  " 56 57  1  0  0  0  0\n"
  " 56 55  1  0  0  0  0\n"
  " 55 78  1  0  0  0  0\n"
  " 51 79  1  0  0  0  0\n"
  " 52 51  1  0  0  0  0\n"
  " 52 53  1  0  0  0  0\n"
  " 53 80  1  0  0  0  0\n"
  " 41 79  1  0  0  0  0\n"
  " 40 41  1  0  0  0  0\n"
  " 40 39  1  0  0  0  0\n"
  " 39 80  1  0  0  0  0\n"
  "M  END\n"
  "\n",

  "complexring5.mol\n"
  "  Mrv0541 03181119082D          \n"
  "\n"
  " 70 91  0  0  1  0            999 V2000\n"
  "    1.9966   -3.1947    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.2532   -3.5526    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.3640   -4.3701    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.1758   -4.5174    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5667   -3.7909    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.8858   -2.3771    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0740   -2.2299    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.6831   -2.9563    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.2528   -3.5528    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.9961   -3.1949    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.5663   -3.7912    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.1753   -4.5176    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.3635   -4.3703    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.6827   -2.9564    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.0737   -2.2300    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.8855   -2.3773    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.5588   -1.2356    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.7424   -0.4312    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.5640   -0.3573    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.8883   -1.1159    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.2670   -1.6587    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.7371   -1.3094    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.4129   -0.5509    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.0341   -0.0081    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.1849    2.0121    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.6705    2.6571    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.1250    3.3456    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.9203    3.1261    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.9573    2.3019    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.7303    1.3235    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.9350    1.5431    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.8981    2.3672    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.4126    3.7445    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.4124    3.7446    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.6673    4.5292    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.0003    5.0141    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.6676    4.5291    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.6675    2.9599    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.0001    2.4750    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.6673    2.9600    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.6703    2.6573    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.1847    2.0123    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.9571    2.3023    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.9200    3.1264    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.1248    3.3459    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.8979    2.3674    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.9350    1.5432    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.7303    1.3238    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.7425   -0.4309    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.5590   -1.2352    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.2672   -1.6583    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.8885   -1.1155    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.5641   -0.3569    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.0343   -0.0078    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.4130   -0.5507    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.7373   -1.3092    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.1111   -1.6833    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.7530   -2.9925    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.6323    0.6009    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.6796    1.0684    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.1714    2.4327    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.0825    4.3248    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.1715    2.4325    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.0829    4.3244    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.6322    0.6006    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.6796    1.0679    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.1107   -1.6834    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.7524   -2.9930    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0001   -2.6999    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0005   -4.7999    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  2  1  1  0  0  0  0\n"
  "  3  4  1  0  0  0  0\n"
  "  5  4  1  0  0  0  0\n"
  "  1  5  1  0  0  0  0\n"
  "  1  6  1  0  0  0  0\n"
  "  6  7  1  0  0  0  0\n"
  "  8  7  1  0  0  0  0\n"
  " 10  9  1  0  0  0  0\n"
  " 11 12  1  0  0  0  0\n"
  " 13 12  1  0  0  0  0\n"
  " 14 15  1  0  0  0  0\n"
  " 16 15  1  0  0  0  0\n"
  " 18 17  1  0  0  0  0\n"
  " 19 20  1  0  0  0  0\n"
  " 21 20  1  0  0  0  0\n"
  " 22 23  1  0  0  0  0\n"
  " 24 23  1  0  0  0  0\n"
  " 26 25  1  0  0  0  0\n"
  " 27 28  1  0  0  0  0\n"
  " 29 28  1  0  0  0  0\n"
  " 30 31  1  0  0  0  0\n"
  " 32 31  1  0  0  0  0\n"
  " 34 33  1  0  0  0  0\n"
  " 35 36  1  0  0  0  0\n"
  " 37 36  1  0  0  0  0\n"
  " 38 39  1  0  0  0  0\n"
  " 40 39  1  0  0  0  0\n"
  " 41 42  1  0  0  0  0\n"
  " 43 44  1  0  0  0  0\n"
  " 45 44  1  0  0  0  0\n"
  " 46 47  1  0  0  0  0\n"
  " 48 47  1  0  0  0  0\n"
  " 50 49  1  0  0  0  0\n"
  " 50 51  1  0  0  0  0\n"
  " 51 52  1  0  0  0  0\n"
  " 53 52  1  0  0  0  0\n"
  " 54 55  1  0  0  0  0\n"
  " 56 55  1  0  0  0  0\n"
  " 50 56  1  0  0  0  0\n"
  " 56 57  1  0  0  0  0\n"
  "  6 57  1  0  0  0  0\n"
  " 51 58  1  0  0  0  0\n"
  "  5 58  1  0  0  0  0\n"
  " 54 59  1  0  0  0  0\n"
  " 49 54  1  0  0  0  0\n"
  " 49 53  1  0  0  0  0\n"
  " 53 60  1  0  0  0  0\n"
  " 42 43  1  0  0  0  0\n"
  " 43 60  1  0  0  0  0\n"
  " 42 48  1  0  0  0  0\n"
  " 48 59  1  0  0  0  0\n"
  " 45 62  1  0  0  0  0\n"
  " 41 45  1  0  0  0  0\n"
  " 41 46  1  0  0  0  0\n"
  " 46 61  1  0  0  0  0\n"
  " 34 35  1  0  0  0  0\n"
  " 35 62  1  0  0  0  0\n"
  " 34 40  1  0  0  0  0\n"
  " 40 61  1  0  0  0  0\n"
  " 38 63  1  0  0  0  0\n"
  " 33 38  1  0  0  0  0\n"
  " 33 37  1  0  0  0  0\n"
  " 37 64  1  0  0  0  0\n"
  " 26 27  1  0  0  0  0\n"
  " 27 64  1  0  0  0  0\n"
  " 26 32  1  0  0  0  0\n"
  " 32 63  1  0  0  0  0\n"
  " 18 19  1  0  0  0  0\n"
  " 19 66  1  0  0  0  0\n"
  " 25 29  1  0  0  0  0\n"
  " 29 66  1  0  0  0  0\n"
  " 25 30  1  0  0  0  0\n"
  " 30 65  1  0  0  0  0\n"
  " 18 24  1  0  0  0  0\n"
  " 24 65  1  0  0  0  0\n"
  " 17 22  1  0  0  0  0\n"
  " 22 67  1  0  0  0  0\n"
  " 17 21  1  0  0  0  0\n"
  " 21 68  1  0  0  0  0\n"
  " 10 11  1  0  0  0  0\n"
  " 11 68  1  0  0  0  0\n"
  " 10 16  1  0  0  0  0\n"
  " 16 67  1  0  0  0  0\n"
  " 14 69  1  0  0  0  0\n"
  "  9 14  1  0  0  0  0\n"
  "  9 13  1  0  0  0  0\n"
  " 13 70  1  0  0  0  0\n"
  "  2  3  1  0  0  0  0\n"
  "  3 70  1  0  0  0  0\n"
  "  2  8  1  0  0  0  0\n"
  "  8 69  1  0  0  0  0\n"
  "M  END\n"
  "\n",

  "complexring6.mol\n"
  "  Mrv0541 03181119092D          \n"
  "\n"
  "100130  0  0  1  0            999 V2000\n"
  "    1.8047   -4.2183    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0201   -4.4733    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0201   -5.2983    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.8047   -5.5532    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.2896   -4.8857    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.8046   -3.3933    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0201   -3.1385    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.5351   -3.8059    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.0200    4.4732    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.8047    4.2182    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.8047    3.3932    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.0200    3.1383    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.5351    3.8058    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.0203    5.2981    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.8048    5.5530    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.2897    4.8856    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.0194   -4.4734    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.8039   -5.5534    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.0193   -5.2984    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.5346   -3.8060    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.0194   -3.1386    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.8042    4.2185    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0195    4.4734    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.5346    3.8059    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0195    3.1385    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.8042    3.3935    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.2889    4.8859    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.8040    5.5533    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0193    5.2984    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.9390    2.3525    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4541    3.0198    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.6695    2.7648    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.6696    1.9398    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4542    1.6850    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.7237    2.6075    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.7235    3.4324    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.9390    3.6873    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.9390   -2.3525    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.7237   -2.6073    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.7235   -3.4324    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.6696   -1.9399    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.4543   -1.6849    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.5695   -0.4127    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.5695    0.4122    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -5.3541    0.6672    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -5.8389   -0.0003    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -5.3541   -0.6677    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.7849   -0.6676    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.3000   -0.0003    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.7849    0.6673    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.5695   -0.4122    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.5695    0.4127    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.7848    0.6677    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.3000    0.0002    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.7849   -0.6672    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.3541   -0.6671    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.8389    0.0003    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.3541    0.6678    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.9394    2.3520    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.4545    3.0194    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.9393    3.6869    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.7240    3.4319    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.7240    2.6070    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.4545    1.6846    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.6699    1.9395    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.6698    2.7646    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4545   -3.0195    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.9394   -2.3520    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4545   -1.6845    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.6699   -1.9395    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.6699   -2.7645    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.9394   -3.6869    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.7240   -3.4319    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.7240   -2.6069    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.1160    2.9124    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.3798    4.6518    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.4541   -3.0199    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.6696   -2.7648    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.9390   -3.6872    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.8040   -4.2185    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.8042   -3.3936    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.2889   -4.8859    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.1156   -2.9127    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.3791   -4.6523    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0000    3.5999    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.0001    5.7499    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.1161    2.9125    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.3797    4.6519    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.4239    1.1125    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -5.4686    1.7772    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.4240   -1.1124    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -5.4686   -1.7773    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4237    1.1130    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.4683    1.7777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4239   -1.1122    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.4688   -1.7762    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.1164   -2.9123    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.3804   -4.6515    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0004   -3.6000    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0009   -5.7500    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  2  1  1  0  0  0  0\n"
  "  3  4  1  0  0  0  0\n"
  "  5  4  1  0  0  0  0\n"
  "  6  7  1  0  0  0  0\n"
  "  8  7  1  0  0  0  0\n"
  "  9 10  1  0  0  0  0\n"
  " 11 12  1  0  0  0  0\n"
  " 13 12  1  0  0  0  0\n"
  " 14 15  1  0  0  0  0\n"
  " 16 15  1  0  0  0  0\n"
  " 80 17  1  0  0  0  0\n"
  " 82 18  1  0  0  0  0\n"
  " 19 18  1  0  0  0  0\n"
  " 20 21  1  0  0  0  0\n"
  " 81 21  1  0  0  0  0\n"
  " 22 23  1  0  0  0  0\n"
  " 24 25  1  0  0  0  0\n"
  " 26 25  1  0  0  0  0\n"
  " 22 26  1  0  0  0  0\n"
  " 22 27  1  0  0  0  0\n"
  " 27 28  1  0  0  0  0\n"
  " 29 28  1  0  0  0  0\n"
  " 30 31  1  0  0  0  0\n"
  " 32 33  1  0  0  0  0\n"
  " 34 33  1  0  0  0  0\n"
  " 35 36  1  0  0  0  0\n"
  " 37 36  1  0  0  0  0\n"
  " 31 32  1  0  0  0  0\n"
  " 31 37  1  0  0  0  0\n"
  " 77 38  1  0  0  0  0\n"
  " 39 40  1  0  0  0  0\n"
  " 79 40  1  0  0  0  0\n"
  " 78 41  1  0  0  0  0\n"
  " 42 41  1  0  0  0  0\n"
  " 44 43  1  0  0  0  0\n"
  " 45 46  1  0  0  0  0\n"
  " 47 46  1  0  0  0  0\n"
  " 48 49  1  0  0  0  0\n"
  " 50 49  1  0  0  0  0\n"
  " 51 52  1  0  0  0  0\n"
  " 53 54  1  0  0  0  0\n"
  " 55 54  1  0  0  0  0\n"
  " 56 57  1  0  0  0  0\n"
  " 58 57  1  0  0  0  0\n"
  " 60 59  1  0  0  0  0\n"
  " 61 62  1  0  0  0  0\n"
  " 63 62  1  0  0  0  0\n"
  " 64 65  1  0  0  0  0\n"
  " 66 65  1  0  0  0  0\n"
  " 67 68  1  0  0  0  0\n"
  " 69 70  1  0  0  0  0\n"
  " 71 70  1  0  0  0  0\n"
  " 72 73  1  0  0  0  0\n"
  " 74 73  1  0  0  0  0\n"
  " 27 76  1  0  0  0  0\n"
  " 37 76  1  0  0  0  0\n"
  " 26 75  1  0  0  0  0\n"
  " 32 75  1  0  0  0  0\n"
  " 79 84  1  0  0  0  0\n"
  " 82 84  1  0  0  0  0\n"
  " 78 83  1  0  0  0  0\n"
  " 81 83  1  0  0  0  0\n"
  " 77 79  1  0  0  0  0\n"
  " 77 78  1  0  0  0  0\n"
  " 80 81  1  0  0  0  0\n"
  " 80 82  1  0  0  0  0\n"
  "  9 13  1  0  0  0  0\n"
  " 13 85  1  0  0  0  0\n"
  "  9 14  1  0  0  0  0\n"
  " 14 86  1  0  0  0  0\n"
  " 23 24  1  0  0  0  0\n"
  " 24 85  1  0  0  0  0\n"
  " 23 29  1  0  0  0  0\n"
  " 29 86  1  0  0  0  0\n"
  " 11 87  1  0  0  0  0\n"
  " 10 11  1  0  0  0  0\n"
  " 60 66  1  0  0  0  0\n"
  " 66 87  1  0  0  0  0\n"
  " 60 61  1  0  0  0  0\n"
  " 61 88  1  0  0  0  0\n"
  " 10 16  1  0  0  0  0\n"
  " 16 88  1  0  0  0  0\n"
  " 63 90  1  0  0  0  0\n"
  " 59 63  1  0  0  0  0\n"
  " 44 50  1  0  0  0  0\n"
  " 50 89  1  0  0  0  0\n"
  " 44 45  1  0  0  0  0\n"
  " 45 90  1  0  0  0  0\n"
  " 59 64  1  0  0  0  0\n"
  " 64 89  1  0  0  0  0\n"
  " 38 42  1  0  0  0  0\n"
  " 42 91  1  0  0  0  0\n"
  " 38 39  1  0  0  0  0\n"
  " 39 92  1  0  0  0  0\n"
  " 43 48  1  0  0  0  0\n"
  " 48 91  1  0  0  0  0\n"
  " 43 47  1  0  0  0  0\n"
  " 47 92  1  0  0  0  0\n"
  " 35 94  1  0  0  0  0\n"
  " 30 35  1  0  0  0  0\n"
  " 52 53  1  0  0  0  0\n"
  " 53 93  1  0  0  0  0\n"
  " 52 58  1  0  0  0  0\n"
  " 58 94  1  0  0  0  0\n"
  " 30 34  1  0  0  0  0\n"
  " 34 93  1  0  0  0  0\n"
  " 74 96  1  0  0  0  0\n"
  " 68 74  1  0  0  0  0\n"
  " 68 69  1  0  0  0  0\n"
  " 69 95  1  0  0  0  0\n"
  " 51 55  1  0  0  0  0\n"
  " 55 95  1  0  0  0  0\n"
  " 51 56  1  0  0  0  0\n"
  " 56 96  1  0  0  0  0\n"
  "  5 98  1  0  0  0  0\n"
  "  1  5  1  0  0  0  0\n"
  "  1  6  1  0  0  0  0\n"
  "  6 97  1  0  0  0  0\n"
  " 67 71  1  0  0  0  0\n"
  " 71 97  1  0  0  0  0\n"
  " 67 72  1  0  0  0  0\n"
  " 72 98  1  0  0  0  0\n"
  " 19100  1  0  0  0  0\n"
  " 17 19  1  0  0  0  0\n"
  " 17 20  1  0  0  0  0\n"
  " 20 99  1  0  0  0  0\n"
  "  2  8  1  0  0  0  0\n"
  "  8 99  1  0  0  0  0\n"
  "  2  3  1  0  0  0  0\n"
  "  3100  1  0  0  0  0\n"
  "M  END\n"
  "\n",

  "complexring7.mol\n"
  "  Mrv0541 03181119072D          \n"
  "\n"
  " 50 65  0  0  1  0            999 V2000\n"
  "   12.3772    5.5954    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.8922    4.9280    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   12.3770    4.2606    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   13.1618    4.5155    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   13.1618    5.3404    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.8923    6.2630    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.1077    6.0080    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.1077    5.1830    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.2628    4.0739    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.4782    4.3289    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.9933    3.6615    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.4781    2.9939    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.2627    3.2489    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.7478    4.7413    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.2629    5.4087    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.4782    5.1538    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.2632    9.8821    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.4785    9.6273    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.4785    8.8022    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.2631    8.5472    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.7481    9.2146    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.2632   10.7071    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.4787   10.9620    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.9937   10.2946    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.8534    6.5657    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.8534    7.3907    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.0688    7.6457    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.5838    6.9783    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.0688    6.3107    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.6379    6.3106    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.1229    6.9781    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.6380    7.6456    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.8925    9.0276    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   12.3773    8.3601    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   13.1621    8.6150    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   13.1621    9.4400    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   12.3774    9.6949    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.1079    8.7727    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.1078    7.9477    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.8924    7.6927    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.6229    6.9778    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   13.7729    6.9777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.3448    8.7375    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.0091   10.7823    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.2763    8.0654    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.5371    9.3293    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.2762    5.8907    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.5367    4.6269    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.3444    5.2183    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.0087    3.1736    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  2  1  1  0  0  0  0\n"
  "  3  4  1  0  0  0  0\n"
  "  5  4  1  0  0  0  0\n"
  "  1  5  1  0  0  0  0\n"
  "  1  6  1  0  0  0  0\n"
  "  6  7  1  0  0  0  0\n"
  "  8  7  1  0  0  0  0\n"
  "  9 10  1  0  0  0  0\n"
  " 11 12  1  0  0  0  0\n"
  " 13 12  1  0  0  0  0\n"
  " 14 15  1  0  0  0  0\n"
  " 16 15  1  0  0  0  0\n"
  " 18 17  1  0  0  0  0\n"
  " 19 20  1  0  0  0  0\n"
  " 21 20  1  0  0  0  0\n"
  " 22 23  1  0  0  0  0\n"
  " 24 23  1  0  0  0  0\n"
  " 25 26  1  0  0  0  0\n"
  " 27 28  1  0  0  0  0\n"
  " 29 28  1  0  0  0  0\n"
  " 30 31  1  0  0  0  0\n"
  " 32 31  1  0  0  0  0\n"
  " 33 34  1  0  0  0  0\n"
  " 35 36  1  0  0  0  0\n"
  " 37 36  1  0  0  0  0\n"
  " 38 39  1  0  0  0  0\n"
  " 40 39  1  0  0  0  0\n"
  " 34 35  1  0  0  0  0\n"
  " 34 40  1  0  0  0  0\n"
  " 40 41  1  0  0  0  0\n"
  "  6 41  1  0  0  0  0\n"
  " 35 42  1  0  0  0  0\n"
  "  5 42  1  0  0  0  0\n"
  " 21 43  1  0  0  0  0\n"
  " 17 21  1  0  0  0  0\n"
  " 33 37  1  0  0  0  0\n"
  " 37 44  1  0  0  0  0\n"
  " 33 38  1  0  0  0  0\n"
  " 38 43  1  0  0  0  0\n"
  " 17 22  1  0  0  0  0\n"
  " 22 44  1  0  0  0  0\n"
  " 27 46  1  0  0  0  0\n"
  " 26 27  1  0  0  0  0\n"
  " 18 24  1  0  0  0  0\n"
  " 24 46  1  0  0  0  0\n"
  " 18 19  1  0  0  0  0\n"
  " 19 45  1  0  0  0  0\n"
  " 26 32  1  0  0  0  0\n"
  " 32 45  1  0  0  0  0\n"
  " 29 48  1  0  0  0  0\n"
  " 25 29  1  0  0  0  0\n"
  " 25 30  1  0  0  0  0\n"
  " 30 47  1  0  0  0  0\n"
  " 10 11  1  0  0  0  0\n"
  " 11 48  1  0  0  0  0\n"
  " 10 16  1  0  0  0  0\n"
  " 16 47  1  0  0  0  0\n"
  "  8 49  1  0  0  0  0\n"
  "  2  8  1  0  0  0  0\n"
  "  9 13  1  0  0  0  0\n"
  " 13 50  1  0  0  0  0\n"
  "  9 14  1  0  0  0  0\n"
  " 14 49  1  0  0  0  0\n"
  "  2  3  1  0  0  0  0\n"
  "  3 50  1  0  0  0  0\n"
  "M  END\n"
  "\n",

  "cube.mol\n"
  "  Marvin  06090922082D          \n"
  "\n"
  "  8 12  0  0  1  0            999 V2000\n"
  "    2.4259    2.6815    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.5174    3.6054    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.8338    2.6815    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.4469    4.1186    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.7891    3.6054    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4965    4.8519    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.8338    4.0684    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.7471    4.8079    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  8  0  0  0  0\n"
  "  1  3  8  0  0  0  0\n"
  "  1  4  8  0  0  0  0\n"
  "  2  5  8  0  0  0  0\n"
  "  2  6  8  0  0  0  0\n"
  "  3  5  8  0  0  0  0\n"
  "  3  7  8  0  0  0  0\n"
  "  4  6  8  0  0  0  0\n"
  "  4  7  8  0  0  0  0\n"
  "  5  8  8  0  0  0  0\n"
  "  6  8  8  0  0  0  0\n"
  "  7  8  8  0  0  0  0\n"
  "M  END\n"
  "\n",

  "highvalence.mol\n"
  "  Marvin  06090922252D          \n"
  "\n"
  "  7 11  0  0  0  0            999 V2000\n"
  "   -1.9726    0.1034    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.5000    0.8659    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.1691    1.6091    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.0826    1.2023    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.9780    0.2079    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0000    0.0000    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.0770    1.0795    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  2  3  1  0  0  0  0\n"
  "  3  4  1  0  0  0  0\n"
  "  4  5  1  0  0  0  0\n"
  "  5  1  1  0  0  0  0\n"
  "  5  6  1  0  0  0  0\n"
  "  6  2  1  0  0  0  0\n"
  "  7  6  1  0  0  0  0\n"
  "  7  1  1  0  0  0  0\n"
  "  7  2  1  0  0  0  0\n"
  "  7  3  1  0  0  0  0\n"
  "  7  4  1  0  0  0  0\n"
  "M  END\n"
  "\n",

  "krabe.mol\n"
  "  Marvin  06090922252D          \n"
  "\n"
  "  9 10  0  0  0  0            999 V2000\n"
  "    1.6290   -1.9119    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.8127   -2.0914    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.2248   -1.5105    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.1634   -0.5574    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.2444   -0.5581    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.1175   -1.3600    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.6220   -0.9357    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.5820   -0.9250    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.7132   -0.1214    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0  0  0  0\n"
  "  2  3  1  0  0  0  0\n"
  "  3  4  1  0  0  0  0\n"
  "  4  5  1  0  0  0  0\n"
  "  5  6  1  0  0  0  0\n"
  "  6  7  1  0  0  0  0\n"
  "  7  8  1  0  0  0  0\n"
  "  1  8  1  0  0  0  0\n"
  "  8  9  1  0  0  0  0\n"
  "  4  9  1  0  0  0  0\n"
  "M  END\n"
  "\n",

  "krabe2.mol\n"
  "  Mrv0541 03181118022D          \n"
  "\n"
  "  8  9  0  0  0  0            999 V2000\n"
  "   -0.2228   -1.6501    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.3975   -1.2732    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.7180   -0.5646    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.1574   -0.1247    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.2971   -0.9378    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.2688   -0.9378    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.7850   -1.3665    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.6468   -0.5491    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0  0  0  0\n"
  "  2  3  1  0  0  0  0\n"
  "  3  4  1  0  0  0  0\n"
  "  4  5  1  0  0  0  0\n"
  "  1  5  1  0  0  0  0\n"
  "  5  6  1  0  0  0  0\n"
  "  6  7  1  0  0  0  0\n"
  "  7  8  1  0  0  0  0\n"
  "  3  8  1  0  0  0  0\n"
  "M  END\n"
  "\n",

  "Ring10\n"
  "  Ketcher  1311818 92D 1   1.00000     0.00000     0\n"
  "\n"
  " 10 10  0     0  0            999 V2000\n"
  "    3.5215    2.9499    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.3132    2.5249    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.3132    1.6750    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.0493    2.9499    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.7854    2.5249    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.7854    1.6750    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.5215    1.2500    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.2575    1.6750    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.2575    2.5249    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.0493    1.2500    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  8  9  1  0     0  0\n"
  "  3 10  1  0     0  0\n"
  " 10  6  1  0     0  0\n"
  "  5  4  1  0     0  0\n"
  "  4  2  1  0     0  0\n"
  "  6  7  1  0     0  0\n"
  "  7  8  1  0     0  0\n"
  "  2  3  1  0     0  0\n"
  "  9  1  1  0     0  0\n"
  "  1  5  1  0     0  0\n"
  "M  END\n"
  "> <group>\n"
  "Rings\n"
  "\n"
  "> <prerender>\n"
  "#tmpl236\n"
  "\n"
  "> <atomid>\n"
  "0\n"
  "\n"
  "> <bondid>\n"
  "0\n",

  "Ring11\n"
  "  Ketcher  1311818 92D 1   1.00000     0.00000     0\n"
  "\n"
  " 11 11  0     0  0            999 V2000\n"
  "    3.7115    0.9202    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.6673    0.9202    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.8179    1.8392    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.7664    2.5772    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.8179    3.2138    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.6382    4.1686    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.6721    4.1677    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4599    3.2440    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5335    3.0226    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5480    2.0636    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4840    1.8574    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0     0  0\n"
  "  2  3  1  0     0  0\n"
  "  3  4  1  0     0  0\n"
  "  5  6  1  0     0  0\n"
  "  6  7  1  0     0  0\n"
  "  7  8  1  0     0  0\n"
  "  8  9  1  0     0  0\n"
  "  9 10  1  0     0  0\n"
  " 10 11  1  0     0  0\n"
  " 11  1  1  0     0  0\n"
  "  4  5  1  0     0  0\n"
  "M  END\n"
  "> <group>\n"
  "Rings\n"
  "\n"
  "> <prerender>\n"
  "#tmpl237\n",

  "Ring12\n"
  "  Ketcher  1311818 92D 1   1.00000     0.00000     0\n"
  "\n"
  " 12 12  0     0  0            999 V2000\n"
  "    3.7276    1.1285    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.7247    1.1285    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.9441    2.1019    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.9082    2.3309    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.9040    3.3264    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.9232    3.5474    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.6929    4.5158    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.6906    4.5147    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4660    3.5463    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5063    3.3181    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5162    2.3234    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4980    2.1108    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0     0  0\n"
  "  2  3  1  0     0  0\n"
  "  3  4  1  0     0  0\n"
  "  4  5  1  0     0  0\n"
  "  5  6  1  0     0  0\n"
  "  6  7  1  0     0  0\n"
  "  7  8  1  0     0  0\n"
  "  8  9  1  0     0  0\n"
  "  9 10  1  0     0  0\n"
  " 10 11  1  0     0  0\n"
  " 11 12  1  0     0  0\n"
  " 12  1  1  0     0  0\n"
  "M  END\n"
  "> <group>\n"
  "Rings\n"
  "\n"
  "> <prerender>\n"
  "#tmpl238\n"
  "\n"
  "> <atomid>\n"
  "0\n"
  "\n"
  "> <bondid>\n"
  "0\n",

  "Ring13\n"
  "  Ketcher  1311818 92D 1   1.00000     0.00000     0\n"
  "\n"
  " 13 13  0     0  0            999 V2000\n"
  "    3.2666    4.9710    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.4574    4.9486    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.9755    4.0189    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.7213    3.9768    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.0441    3.6774    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.6650    3.7016    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.0441    2.6968    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.7099    2.6175    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.9763    2.4069    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.6652    2.4096    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.0491    1.4518    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.6845    1.4484    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.9051    1.1289    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  3  1  0     0  0\n"
  "  2  4  1  0     0  0\n"
  "  3  5  1  0     0  0\n"
  "  4  6  1  0     0  0\n"
  "  5  7  1  0     0  0\n"
  "  6  8  1  0     0  0\n"
  "  7  9  1  0     0  0\n"
  "  8 10  1  0     0  0\n"
  "  9 11  1  0     0  0\n"
  " 10 12  1  0     0  0\n"
  " 11 13  1  0     0  0\n"
  " 12 13  1  0     0  0\n"
  "  1  2  1  0     0  0\n"
  "M  END\n"
  "> <group>\n"
  "Rings\n"
  "\n"
  "> <prerender>\n"
  "#tmpl239\n"
  "\n"
  "> <atomid>\n"
  "0\n"
  "\n"
  "> <bondid>\n"
  "12\n",

  "Ring14\n"
  "  Ketcher  1311818 92D 1   1.00000     0.00000     0\n"
  "\n"
  " 14 14  0     0  0            999 V2000\n"
  "    6.8995    3.2081    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.3539    4.0579    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.3678    2.3687    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.3685    3.9274    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.3883    2.5015    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.9655    4.8438    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.9885    1.5835    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.9602    4.8347    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.9932    1.5783    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.5727    3.9117    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.5892    2.4908    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5971    4.0366    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.6111    2.3505    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.0671    3.1903    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0     0  0\n"
  "  1  3  1  0     0  0\n"
  "  2  4  1  0     0  0\n"
  "  3  5  1  0     0  0\n"
  "  4  6  1  0     0  0\n"
  "  5  7  1  0     0  0\n"
  "  6  8  1  0     0  0\n"
  "  7  9  1  0     0  0\n"
  "  8 10  1  0     0  0\n"
  "  9 11  1  0     0  0\n"
  " 10 12  1  0     0  0\n"
  " 11 13  1  0     0  0\n"
  " 12 14  1  0     0  0\n"
  " 13 14  1  0     0  0\n"
  "M  END\n"
  "> <group>\n"
  "Rings\n"
  "\n"
  "> <prerender>\n"
  "#tmpl240\n",

  "Ring15\n"
  "  Ketcher  1311818 92D 1   1.00000     0.00000     0\n"
  "\n"
  " 15 15  0     0  0            999 V2000\n"
  "    6.3839    2.8393    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.0478    1.8979    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.0286    1.8979    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.6750    0.9634    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.6672    0.9934    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.3752    1.9525    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.3912    2.0190    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.1293    2.9718    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.9384    3.5389    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.6710    4.4863    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4746    5.0532    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.2796    4.4781    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.1008    5.0326    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.9121    4.4093    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.5968    3.4606    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0     0  0\n"
  "  2  3  1  0     0  0\n"
  "  4  5  1  0     0  0\n"
  "  5  6  1  0     0  0\n"
  "  6  7  1  0     0  0\n"
  "  3  4  1  0     0  0\n"
  "  8  9  1  0     0  0\n"
  "  9 10  1  0     0  0\n"
  " 10 11  1  0     0  0\n"
  "  7  8  1  0     0  0\n"
  " 12 13  1  0     0  0\n"
  " 13 14  1  0     0  0\n"
  " 14 15  1  0     0  0\n"
  " 11 12  1  0     0  0\n"
  "  1 15  1  0     0  0\n"
  "M  END\n"
  "> <group>\n"
  "Rings\n"
  "\n"
  "> <prerender>\n"
  "#tmpl241\n",

  "Ring16\n"
  "  Ketcher  1311818 92D 1   1.00000     0.00000     0\n"
  "\n"
  " 16 16  0     0  0            999 V2000\n"
  "    5.3307    1.4944    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.8666    2.4944    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.4647    0.9944    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.8666    4.4944    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0006    3.9944    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0006    2.9944    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.8666    1.4944    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.7326    0.9944    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.5987    1.4944    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.7326    3.9944    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.5987    4.4944    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.4647    3.9944    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.3307    2.4944    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.1967    2.9944    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.1967    3.9944    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.3307    4.4944    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  9  3  1  0     0  0\n"
  "  3  1  1  0     0  0\n"
  "  1 13  1  0     0  0\n"
  " 10  4  1  0     0  0\n"
  "  4  5  1  0     0  0\n"
  "  5  6  1  0     0  0\n"
  "  6  2  1  0     0  0\n"
  "  2  7  1  0     0  0\n"
  "  7  8  1  0     0  0\n"
  "  8  9  1  0     0  0\n"
  " 12 11  1  0     0  0\n"
  " 11 10  1  0     0  0\n"
  " 13 14  1  0     0  0\n"
  " 14 15  1  0     0  0\n"
  " 15 16  1  0     0  0\n"
  " 16 12  1  0     0  0\n"
  "M  END\n"
  "> <group>\n"
  "Rings\n"
  "\n"
  "> <prerender>\n"
  "#tmpl242\n"
  "\n"
  "> <atomid>\n"
  "0\n"
  "\n"
  "> <bondid>\n"
  "1\n",

  "Ring18\n"
  "  Ketcher  1311818 92D 1   1.00000     0.00000     0\n"
  "\n"
  " 18 18  0     0  0            999 V2000\n"
  "    6.7675    4.0116    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.7675    3.0235    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.8338    2.6634    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.9136    1.6865    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.0241    1.2306    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.2362    1.8639    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4295    1.2651    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5501    1.7405    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.6379    2.7240    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.7034    3.0885    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.7024    4.0770    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.6366    4.4288    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5561    5.4110    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4362    5.8637    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.2239    5.2349    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.0336    5.8456    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.9184    5.3645    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.8307    4.3812    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  1  0     0  0\n"
  "  2  3  1  0     0  0\n"
  "  4  5  1  0     0  0\n"
  "  5  6  1  0     0  0\n"
  "  6  7  1  0     0  0\n"
  "  3  4  1  0     0  0\n"
  "  8  9  1  0     0  0\n"
  "  9 10  1  0     0  0\n"
  " 10 11  1  0     0  0\n"
  "  7  8  1  0     0  0\n"
  " 12 13  1  0     0  0\n"
  " 13 14  1  0     0  0\n"
  " 14 15  1  0     0  0\n"
  " 11 12  1  0     0  0\n"
  " 16 17  1  0     0  0\n"
  " 17 18  1  0     0  0\n"
  " 15 16  1  0     0  0\n"
  "  1 18  1  0     0  0\n"
  "M  END\n"
  "> <group>\n"
  "Rings\n"
  "\n"
  "> <prerender>\n"
  "#tmpl243\n"
  "\n"
  "> <atomid>\n"
  "0\n"
  "\n"
  "> <bondid>\n"
  "0\n",

  "Ring20\n"
  "  Ketcher  1311818 92D 1   1.00000     0.00000     0\n"
  "\n"
  " 20 20  0     0  0            999 V2000\n"
  "    5.1641    6.8777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.7000    5.8777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.7000    6.8777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5660    7.3777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4320    6.8777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.2980    7.3777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.1641    5.8777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.0301    4.3777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.0301    5.3777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.1641    3.8777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.1641    2.8777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.2980    2.3777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5660    1.3777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4320    0.8777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.2980    1.3777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.8339    5.3777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.8339    4.3777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.7000    3.8777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.6999    2.8777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5660    2.3777    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  3  2  1  0     0  0\n"
  "  5  4  1  0     0  0\n"
  "  4  3  1  0     0  0\n"
  "  7  1  1  0     0  0\n"
  "  1  6  1  0     0  0\n"
  "  6  5  1  0     0  0\n"
  " 10  8  1  0     0  0\n"
  "  8  9  1  0     0  0\n"
  "  9  7  1  0     0  0\n"
  " 12 11  1  0     0  0\n"
  " 11 10  1  0     0  0\n"
  " 20 13  1  0     0  0\n"
  " 13 14  1  0     0  0\n"
  " 14 15  1  0     0  0\n"
  " 15 12  1  0     0  0\n"
  "  2 16  1  0     0  0\n"
  " 16 17  1  0     0  0\n"
  " 17 18  1  0     0  0\n"
  " 18 19  1  0     0  0\n"
  " 19 20  1  0     0  0\n"
  "M  END\n"
  "> <group>\n"
  "Rings\n"
  "\n"
  "> <prerender>\n"
  "#tmpl244\n"
  "\n"
  "> <atomid>\n"
  "13\n"
  "\n"
  "> <bondid>\n"
  "13\n",

  "Ring21\n"
  "  Ketcher  1311818 92D 1   1.00000     0.00000     0\n"
  "\n"
  " 21 21  0     0  0            999 V2000\n"
  "   13.0927    4.9401    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.7000    5.4856    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.7000    4.3856    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.4537    6.0258    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.4631    7.1298    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.5095    7.6878    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.5428    7.1369    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.5875    7.6838    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.6370    7.1269    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.6419    6.0230    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.6614    3.8372    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.6675    2.7393    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.6235    2.1978    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    8.5583    2.7574    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    9.5110    2.2085    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.4619    2.7621    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   10.4601    3.8647    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.4049    5.4888    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   11.4047    4.3920    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   12.4478    4.0529    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   12.4480    5.8274    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  2  3  1  0     0  0\n"
  "  2 10  1  0     0  0\n"
  "  3 11  1  0     0  0\n"
  " 17 19  1  0     0  0\n"
  " 18  4  1  0     0  0\n"
  "  4  5  1  0     0  0\n"
  "  5  6  1  0     0  0\n"
  "  6  7  1  0     0  0\n"
  "  7  8  1  0     0  0\n"
  "  8  9  1  0     0  0\n"
  "  9 10  1  0     0  0\n"
  " 11 12  1  0     0  0\n"
  " 12 13  1  0     0  0\n"
  " 13 14  1  0     0  0\n"
  " 14 15  1  0     0  0\n"
  " 15 16  1  0     0  0\n"
  " 16 17  1  0     0  0\n"
  " 19 20  1  0     0  0\n"
  " 20  1  1  0     0  0\n"
  "  1 21  1  0     0  0\n"
  " 21 18  1  0     0  0\n"
  "M  END\n"
  "> <group>\n"
  "Rings\n"
  "\n"
  "> <prerender>\n"
  "#tmpl245\n"
  "\n"
  "> <atomid>\n"
  "0\n"
  "\n"
  "> <bondid>\n"
  "0\n",

  "s13133.mol\n"
  "  Marvin  06090923072D          \n"
  "\n"
  " 14 17  0  0  0  0            999 V2000\n"
  "    1.9945   -0.4532    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.9967   -0.4685    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.5150   -1.1100    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.5150    0.1861    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.4866   -1.1472    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.4800    0.2277    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.1948   -0.2145    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.6480   -0.0460    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.7663   -0.0657    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.6480   -0.8736    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.7663   -0.8582    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0635    0.3569    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0700   -1.2808    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.0503   -0.4970    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  2  5  1  0  0  0  0\n"
  "  3  1  1  0  0  0  0\n"
  "  4  1  1  0  0  0  0\n"
  "  5 10  1  0  0  0  0\n"
  "  6  8  1  0  0  0  0\n"
  "  7 12  1  0  0  0  0\n"
  "  8 12  1  0  0  0  0\n"
  "  9  4  1  0  0  0  0\n"
  " 10 13  1  0  0  0  0\n"
  " 11  3  1  0  0  0  0\n"
  " 12  9  1  0  0  0  0\n"
  " 13 11  1  0  0  0  0\n"
  " 14 13  1  0  0  0  0\n"
  " 11  9  1  0  0  0  0\n"
  " 14  7  2  0  0  0  0\n"
  " 10  8  1  0  0  0  0\n"
  "  2  6  1  0  0  0  0\n"
  "M  END\n"
  "\n",

  "sphere.mol\n"
  "  Marvin  06090921502D          \n"
  "\n"
  " 60 90  0  0  0  0            999 V2000\n"
  "    4.2810    2.6747    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.2707    1.7703    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.7968    3.1409    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.1888    3.1640    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.7840    1.3066    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.2016    1.3271    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.3151    2.6797    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4483    3.8839    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.1093    2.7131    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.6917    3.9018    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.3100    1.7703    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4279    0.5662    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.1145    1.7882    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.6815    0.5918    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.4876    2.9616    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.6158    4.1683    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.5585    2.9923    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.1204    4.1913    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.4825    1.4987    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5978    0.2869    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.5431    1.5116    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.0795    0.3125    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.9727    2.2340    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.1290    3.7045    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.0444    4.4680    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.1999    2.2571    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.0513    3.7327    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.2980    4.4782    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.1290    0.7532    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.0162    0.0000    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.0307    0.7839    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.2442    0.0128    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0990    2.2442    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.2554    3.7199    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.1990    4.1888    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.3314    2.2571    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.1828    3.7276    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.6858    4.2016    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.2323    0.7558    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.1887    0.2818    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.1546    0.7890    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.6627    0.3356    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.7353    2.9847    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.7225    1.4910    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.6405    3.8839    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.8241    2.9872    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.8164    1.5295    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.8506    3.9300    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.6097    0.5662    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.8352    0.6251    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.1717    2.6797    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.1511    1.7652    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.1307    3.1307    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.9914    2.7156    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.9863    1.8164    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.4996    3.1768    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0897    1.3040    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.4919    1.3706    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0051    2.7336    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0000    1.8292    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  8  0  0  0  0\n"
  "  1  3  8  0  0  0  0\n"
  "  1  4  8  0  0  0  0\n"
  "  2  5  8  0  0  0  0\n"
  "  2  6  8  0  0  0  0\n"
  "  3  7  8  0  0  0  0\n"
  "  3  8  8  0  0  0  0\n"
  "  4  9  8  0  0  0  0\n"
  "  4 10  8  0  0  0  0\n"
  "  5 11  8  0  0  0  0\n"
  "  5 12  8  0  0  0  0\n"
  "  6 13  8  0  0  0  0\n"
  "  6 14  8  0  0  0  0\n"
  "  7 11  8  0  0  0  0\n"
  "  7 15  8  0  0  0  0\n"
  "  8 10  8  0  0  0  0\n"
  "  8 16  8  0  0  0  0\n"
  "  9 13  8  0  0  0  0\n"
  "  9 17  8  0  0  0  0\n"
  " 10 18  8  0  0  0  0\n"
  " 11 19  8  0  0  0  0\n"
  " 12 14  8  0  0  0  0\n"
  " 12 20  8  0  0  0  0\n"
  " 13 21  8  0  0  0  0\n"
  " 14 22  8  0  0  0  0\n"
  " 15 23  8  0  0  0  0\n"
  " 15 24  8  0  0  0  0\n"
  " 16 24  8  0  0  0  0\n"
  " 16 25  8  0  0  0  0\n"
  " 17 26  8  0  0  0  0\n"
  " 17 27  8  0  0  0  0\n"
  " 18 27  8  0  0  0  0\n"
  " 18 28  8  0  0  0  0\n"
  " 19 23  8  0  0  0  0\n"
  " 19 29  8  0  0  0  0\n"
  " 20 29  8  0  0  0  0\n"
  " 20 30  8  0  0  0  0\n"
  " 21 26  8  0  0  0  0\n"
  " 21 31  8  0  0  0  0\n"
  " 22 31  8  0  0  0  0\n"
  " 22 32  8  0  0  0  0\n"
  " 23 33  8  0  0  0  0\n"
  " 24 34  8  0  0  0  0\n"
  " 25 28  8  0  0  0  0\n"
  " 25 35  8  0  0  0  0\n"
  " 26 36  8  0  0  0  0\n"
  " 27 37  8  0  0  0  0\n"
  " 28 38  8  0  0  0  0\n"
  " 29 39  8  0  0  0  0\n"
  " 30 32  8  0  0  0  0\n"
  " 30 40  8  0  0  0  0\n"
  " 31 41  8  0  0  0  0\n"
  " 32 42  8  0  0  0  0\n"
  " 33 43  8  0  0  0  0\n"
  " 33 44  8  0  0  0  0\n"
  " 34 35  8  0  0  0  0\n"
  " 34 43  8  0  0  0  0\n"
  " 35 45  8  0  0  0  0\n"
  " 36 46  8  0  0  0  0\n"
  " 36 47  8  0  0  0  0\n"
  " 37 38  8  0  0  0  0\n"
  " 37 46  8  0  0  0  0\n"
  " 38 48  8  0  0  0  0\n"
  " 39 40  8  0  0  0  0\n"
  " 39 44  8  0  0  0  0\n"
  " 40 49  8  0  0  0  0\n"
  " 41 42  8  0  0  0  0\n"
  " 41 47  8  0  0  0  0\n"
  " 42 50  8  0  0  0  0\n"
  " 43 51  8  0  0  0  0\n"
  " 44 52  8  0  0  0  0\n"
  " 45 48  8  0  0  0  0\n"
  " 45 53  8  0  0  0  0\n"
  " 46 54  8  0  0  0  0\n"
  " 47 55  8  0  0  0  0\n"
  " 48 56  8  0  0  0  0\n"
  " 49 50  8  0  0  0  0\n"
  " 49 57  8  0  0  0  0\n"
  " 50 58  8  0  0  0  0\n"
  " 51 52  8  0  0  0  0\n"
  " 51 53  8  0  0  0  0\n"
  " 52 57  8  0  0  0  0\n"
  " 53 59  8  0  0  0  0\n"
  " 54 55  8  0  0  0  0\n"
  " 54 56  8  0  0  0  0\n"
  " 55 58  8  0  0  0  0\n"
  " 56 59  8  0  0  0  0\n"
  " 57 60  8  0  0  0  0\n"
  " 58 60  8  0  0  0  0\n"
  " 59 60  8  0  0  0  0\n"
  "M  END\n"
  "\n",

  "sphere2.mol\n"
  "  -INDIGO-12271017453D\n"
  "\n"
  " 80210  0  0  0  0  0  0  0  0999 V2000\n"
  "   -0.3637    4.0495    1.3474 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.7474    3.3091    2.0890 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.9201    3.0169    0.8453 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.2629    3.5789   -0.6621 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.6814    4.2189   -0.3519 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.5821    3.9816   -1.4933 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.1769    3.5719   -0.9460 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.4913    3.4047    0.7356 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.2166    3.6445    1.8883 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.4263    2.4963    3.1745 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0553    1.7636    3.9082 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.5397    2.1724    3.3618 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.5045    0.7298    3.4053 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.6673    0.4397    2.1731 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.8756    1.5890    0.8871 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.1812    0.7094   -0.5760 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.5308    1.2645   -2.0670 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.5671    2.7067   -2.1117 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.2921    2.4669   -3.2665 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.2759    3.1015   -2.9592 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.6827    2.1481   -3.3188 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.8564    2.4392   -2.0732 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.8425    1.1512   -1.5043 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.1590    0.9830    0.1944 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4867    2.1049    1.3091 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.8304    1.5442    2.8158 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.8523   -0.1324    3.1937 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.4687   -0.8743    3.9353 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0763    0.0691    4.2909 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.5070   -0.5708    3.9808 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.6825   -2.1475    3.3180 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.8568   -2.4392    2.0731 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.8437   -1.1516    1.5046 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.1597   -0.9833   -0.1941 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.4865   -2.1050   -1.3087 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.8294   -1.5438   -2.8150 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.8515    0.1328   -3.1927 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.4682    0.8745   -3.9353 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.0759   -0.0689   -4.2914 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.5073    0.5714   -3.9818 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.6660   -0.4396   -2.1732 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.8749   -1.5882   -0.8869 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.1808   -0.7093    0.5766 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.5310   -1.2647    2.0677 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5673   -2.7070    2.1116 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.2922   -2.4666    3.2660 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.2759   -3.1008    2.9584 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.5820   -3.9816    1.4930 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.1770   -3.5721    0.9462 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.4915   -3.4049   -0.7353 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.2167   -3.6446   -1.8883 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.4257   -2.4959   -3.1742 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.0548   -1.7634   -3.9080 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.5399   -2.1732   -3.3617 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.7474   -3.3097   -2.0888 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.9204   -3.0168   -0.8452 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.2630   -3.5791    0.6618 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.6814   -4.2193    0.3517 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.3634   -4.0501   -1.3477 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.1136   -1.6520    3.9523 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.5829    0.8845    3.8734 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.1721    3.1685    2.8645 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.9541    2.0450    2.3181 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.5135    2.3375   -0.6688 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.0809    3.6439   -1.9706 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.9849    4.1555    0.2157 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4549    2.4802   -0.4143 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.9187    0.9335   -2.9900 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.5134   -2.3376    0.6690 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.4554   -2.4806    0.4144 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.9192   -0.9334    2.9896 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.8222   -0.4596   -1.8445 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.9851   -4.1559   -0.2157 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.1723   -3.1689   -2.8645 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.9537   -2.0450   -2.3180 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0810   -3.6440    1.9702 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.8227    0.4596    1.8450 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.1138    1.6525   -3.9533 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.5820   -0.8843   -3.8728 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5037   -0.7298   -3.4058 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  " 12  2  1  0  0  0  0\n"
  "  3  2  1  0  0  0  0\n"
  " 13 12  1  0  0  0  0\n"
  " 15  3  1  0  0  0  0\n"
  " 14 15  1  0  0  0  0\n"
  "  4  3  1  0  0  0  0\n"
  " 16 15  1  0  0  0  0\n"
  " 18  4  1  0  0  0  0\n"
  " 17 18  1  0  0  0  0\n"
  "  6  5  1  0  0  0  0\n"
  "  4  5  1  0  0  0  0\n"
  " 20  6  1  0  0  0  0\n"
  " 19 18  1  0  0  0  0\n"
  "  9  1  1  0  0  0  0\n"
  "  5  1  1  0  0  0  0\n"
  "  8  9  1  0  0  0  0\n"
  "  7  6  1  0  0  0  0\n"
  "  2  1  1  0  0  0  0\n"
  " 10  9  1  0  0  0  0\n"
  " 11 12  1  0  0  0  0\n"
  " 26 10  1  0  0  0  0\n"
  " 11 10  1  0  0  0  0\n"
  " 27 26  1  0  0  0  0\n"
  " 29 11  1  0  0  0  0\n"
  " 28 29  1  0  0  0  0\n"
  " 30 13  1  0  0  0  0\n"
  " 14 13  1  0  0  0  0\n"
  " 31 30  1  0  0  0  0\n"
  " 33 14  1  0  0  0  0\n"
  " 32 33  1  0  0  0  0\n"
  " 34 16  1  0  0  0  0\n"
  " 17 16  1  0  0  0  0\n"
  " 35 34  1  0  0  0  0\n"
  " 37 17  1  0  0  0  0\n"
  " 36 37  1  0  0  0  0\n"
  " 21 20  1  0  0  0  0\n"
  " 19 20  1  0  0  0  0\n"
  " 40 21  1  0  0  0  0\n"
  " 38 19  1  0  0  0  0\n"
  " 39 38  1  0  0  0  0\n"
  " 25  8  1  0  0  0  0\n"
  "  7  8  1  0  0  0  0\n"
  " 24 25  1  0  0  0  0\n"
  " 22  7  1  0  0  0  0\n"
  " 23 22  1  0  0  0  0\n"
  " 25 26  1  0  0  0  0\n"
  " 29 30  1  0  0  0  0\n"
  " 33 34  1  0  0  0  0\n"
  " 37 38  1  0  0  0  0\n"
  " 21 22  1  0  0  0  0\n"
  " 27 44  1  0  0  0  0\n"
  " 28 27  1  0  0  0  0\n"
  " 28 46  1  0  0  0  0\n"
  " 45 46  1  0  0  0  0\n"
  " 44 45  1  0  0  0  0\n"
  " 57 45  1  0  0  0  0\n"
  " 31 47  1  0  0  0  0\n"
  " 32 31  1  0  0  0  0\n"
  " 32 49  1  0  0  0  0\n"
  " 48 49  1  0  0  0  0\n"
  " 47 48  1  0  0  0  0\n"
  " 58 48  1  0  0  0  0\n"
  " 24 43  1  0  0  0  0\n"
  " 23 24  1  0  0  0  0\n"
  " 23 41  1  0  0  0  0\n"
  " 42 41  1  0  0  0  0\n"
  " 43 42  1  0  0  0  0\n"
  " 56 42  1  0  0  0  0\n"
  " 40 80  1  0  0  0  0\n"
  " 39 40  1  0  0  0  0\n"
  " 39 53  1  0  0  0  0\n"
  " 54 53  1  0  0  0  0\n"
  " 80 54  1  0  0  0  0\n"
  " 55 54  1  0  0  0  0\n"
  " 35 50  1  0  0  0  0\n"
  " 36 35  1  0  0  0  0\n"
  " 36 52  1  0  0  0  0\n"
  " 51 52  1  0  0  0  0\n"
  " 50 51  1  0  0  0  0\n"
  " 59 51  1  0  0  0  0\n"
  " 43 44  1  0  0  0  0\n"
  " 46 47  1  0  0  0  0\n"
  " 49 50  1  0  0  0  0\n"
  " 52 53  1  0  0  0  0\n"
  " 80 41  1  0  0  0  0\n"
  " 56 57  1  0  0  0  0\n"
  " 57 58  1  0  0  0  0\n"
  " 58 59  1  0  0  0  0\n"
  " 59 55  1  0  0  0  0\n"
  " 55 56  1  0  0  0  0\n"
  " 56 69  1  0  0  0  0\n"
  " 69 57  1  0  0  0  0\n"
  " 37 72  1  0  0  0  0\n"
  " 72 36  1  0  0  0  0\n"
  " 72 35  1  0  0  0  0\n"
  " 72 34  1  0  0  0  0\n"
  " 17 72  1  0  0  0  0\n"
  " 16 72  1  0  0  0  0\n"
  " 42 69  1  0  0  0  0\n"
  " 43 69  1  0  0  0  0\n"
  " 44 69  1  0  0  0  0\n"
  " 69 45  1  0  0  0  0\n"
  " 23 67  1  0  0  0  0\n"
  " 24 67  1  0  0  0  0\n"
  " 25 67  1  0  0  0  0\n"
  " 22 67  1  0  0  0  0\n"
  "  7 67  1  0  0  0  0\n"
  "  8 67  1  0  0  0  0\n"
  "  7 66  1  0  0  0  0\n"
  "  8 66  1  0  0  0  0\n"
  "  6 66  1  0  0  0  0\n"
  "  5 66  1  0  0  0  0\n"
  "  1 66  1  0  0  0  0\n"
  "  9 66  1  0  0  0  0\n"
  "  1 62  1  0  0  0  0\n"
  "  9 62  1  0  0  0  0\n"
  " 10 62  1  0  0  0  0\n"
  " 11 62  1  0  0  0  0\n"
  "  2 62  1  0  0  0  0\n"
  " 12 62  1  0  0  0  0\n"
  " 14 71  1  0  0  0  0\n"
  " 33 71  1  0  0  0  0\n"
  " 13 71  1  0  0  0  0\n"
  " 30 71  1  0  0  0  0\n"
  " 31 71  1  0  0  0  0\n"
  " 32 71  1  0  0  0  0\n"
  " 20 65  1  0  0  0  0\n"
  "  6 65  1  0  0  0  0\n"
  "  5 65  1  0  0  0  0\n"
  " 19 65  1  0  0  0  0\n"
  " 18 65  1  0  0  0  0\n"
  "  4 65  1  0  0  0  0\n"
  " 18 64  1  0  0  0  0\n"
  " 17 64  1  0  0  0  0\n"
  "  4 64  1  0  0  0  0\n"
  "  3 64  1  0  0  0  0\n"
  " 15 64  1  0  0  0  0\n"
  " 16 64  1  0  0  0  0\n"
  "  3 63  1  0  0  0  0\n"
  " 15 63  1  0  0  0  0\n"
  " 14 63  1  0  0  0  0\n"
  " 13 63  1  0  0  0  0\n"
  "  2 63  1  0  0  0  0\n"
  " 12 63  1  0  0  0  0\n"
  " 10 61  1  0  0  0  0\n"
  " 26 61  1  0  0  0  0\n"
  " 27 61  1  0  0  0  0\n"
  " 28 61  1  0  0  0  0\n"
  " 11 61  1  0  0  0  0\n"
  " 29 61  1  0  0  0  0\n"
  " 68 21  1  0  0  0  0\n"
  " 68 40  1  0  0  0  0\n"
  " 68 80  1  0  0  0  0\n"
  " 41 68  1  0  0  0  0\n"
  " 23 68  1  0  0  0  0\n"
  " 22 68  1  0  0  0  0\n"
  " 45 76  1  0  0  0  0\n"
  " 57 76  1  0  0  0  0\n"
  " 76 47  1  0  0  0  0\n"
  " 76 48  1  0  0  0  0\n"
  " 76 58  1  0  0  0  0\n"
  " 34 70  1  0  0  0  0\n"
  " 35 70  1  0  0  0  0\n"
  " 50 70  1  0  0  0  0\n"
  " 33 70  1  0  0  0  0\n"
  " 32 70  1  0  0  0  0\n"
  " 49 70  1  0  0  0  0\n"
  " 51 73  1  0  0  0  0\n"
  " 50 73  1  0  0  0  0\n"
  " 49 73  1  0  0  0  0\n"
  " 59 73  1  0  0  0  0\n"
  " 48 73  1  0  0  0  0\n"
  " 58 73  1  0  0  0  0\n"
  " 56 75  1  0  0  0  0\n"
  " 42 75  1  0  0  0  0\n"
  " 75 54  1  0  0  0  0\n"
  " 75 55  1  0  0  0  0\n"
  " 75 41  1  0  0  0  0\n"
  " 53 74  1  0  0  0  0\n"
  " 51 74  1  0  0  0  0\n"
  " 52 74  1  0  0  0  0\n"
  " 54 74  1  0  0  0  0\n"
  " 55 74  1  0  0  0  0\n"
  " 74 59  1  0  0  0  0\n"
  " 43 77  1  0  0  0  0\n"
  " 24 77  1  0  0  0  0\n"
  " 25 77  1  0  0  0  0\n"
  " 44 77  1  0  0  0  0\n"
  " 26 77  1  0  0  0  0\n"
  " 27 77  1  0  0  0  0\n"
  " 46 60  1  0  0  0  0\n"
  " 28 60  1  0  0  0  0\n"
  " 29 60  1  0  0  0  0\n"
  " 60 30  1  0  0  0  0\n"
  " 60 47  1  0  0  0  0\n"
  " 60 31  1  0  0  0  0\n"
  " 40 78  1  0  0  0  0\n"
  " 21 78  1  0  0  0  0\n"
  " 20 78  1  0  0  0  0\n"
  " 19 78  1  0  0  0  0\n"
  " 39 78  1  0  0  0  0\n"
  " 38 78  1  0  0  0  0\n"
  " 39 79  1  0  0  0  0\n"
  " 38 79  1  0  0  0  0\n"
  " 37 79  1  0  0  0  0\n"
  " 36 79  1  0  0  0  0\n"
  " 52 79  1  0  0  0  0\n"
  " 53 79  1  0  0  0  0\n"
  " 46 76  1  0  0  0  0\n"
  " 75 80  1  0  0  0  0\n"
  "M  END\n"
  "\n",

  "sphere_mod1.mol\n"
  "  Marvin  06090921502D          \n"
  "\n"
  " 68100  0  0  0  0            999 V2000\n"
  "    4.2810    2.6747    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.2707    1.7703    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.7968    3.1409    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.1888    3.1640    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.0650    3.1179    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.7840    1.3066    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.2016    1.3271    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.0521    1.3092    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.3151    2.6797    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4483    3.8839    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.1093    2.7131    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.6917    3.9018    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.8489    2.6568    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.3100    1.7703    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4279    0.5662    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.1145    1.7882    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.6815    0.5918    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.8386    1.7524    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.4876    2.9616    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.6158    4.1683    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.5585    2.9923    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.1204    4.1913    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.6329    3.1025    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.4825    1.4987    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5978    0.2869    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.5431    1.5116    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.0795    0.3125    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.6149    1.2963    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.9727    2.2340    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.1290    3.7045    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.0444    4.4680    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.1999    2.2571    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.0513    3.7327    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.2980    4.4782    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.4117    2.6439    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.1290    0.7532    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.0162    0.0000    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.0307    0.7839    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.2442    0.0128    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    7.4014    1.7421    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.0990    2.2442    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.2554    3.7199    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.1990    4.1888    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.3314    2.2571    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.1828    3.7276    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.6858    4.2016    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.2323    0.7558    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.1887    0.2818    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.1546    0.7890    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.6627    0.3356    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.7353    2.9847    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.7225    1.4910    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.6405    3.8839    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.8241    2.9872    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.8164    1.5295    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.8506    3.9300    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.6097    0.5662    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.8352    0.6251    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.1717    2.6797    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.1511    1.7652    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.1307    3.1307    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.9914    2.7156    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.9863    1.8164    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.4996    3.1768    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0897    1.3040    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.4919    1.3706    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0051    2.7336    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0000    1.8292    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  1  2  8  0  0  0  0\n"
  "  1  3  8  0  0  0  0\n"
  "  1  4  8  0  0  0  0\n"
  "  1  5  8  0  0  0  0\n"
  "  2  6  8  0  0  0  0\n"
  "  2  7  8  0  0  0  0\n"
  "  2  8  8  0  0  0  0\n"
  "  3  9  8  0  0  0  0\n"
  "  3 10  8  0  0  0  0\n"
  "  4 11  8  0  0  0  0\n"
  "  4 12  8  0  0  0  0\n"
  "  5 13  8  0  0  0  0\n"
  "  6 14  8  0  0  0  0\n"
  "  6 15  8  0  0  0  0\n"
  "  7 16  8  0  0  0  0\n"
  "  7 17  8  0  0  0  0\n"
  "  8 18  8  0  0  0  0\n"
  "  9 14  8  0  0  0  0\n"
  "  9 19  8  0  0  0  0\n"
  " 10 12  8  0  0  0  0\n"
  " 10 20  8  0  0  0  0\n"
  " 11 16  8  0  0  0  0\n"
  " 11 21  8  0  0  0  0\n"
  " 12 22  8  0  0  0  0\n"
  " 13 18  8  0  0  0  0\n"
  " 13 23  8  0  0  0  0\n"
  " 14 24  8  0  0  0  0\n"
  " 15 17  8  0  0  0  0\n"
  " 15 25  8  0  0  0  0\n"
  " 16 26  8  0  0  0  0\n"
  " 17 27  8  0  0  0  0\n"
  " 18 28  8  0  0  0  0\n"
  " 19 29  8  0  0  0  0\n"
  " 19 30  8  0  0  0  0\n"
  " 20 30  8  0  0  0  0\n"
  " 20 31  8  0  0  0  0\n"
  " 21 32  8  0  0  0  0\n"
  " 21 33  8  0  0  0  0\n"
  " 22 33  8  0  0  0  0\n"
  " 22 34  8  0  0  0  0\n"
  " 23 35  8  0  0  0  0\n"
  " 24 29  8  0  0  0  0\n"
  " 24 36  8  0  0  0  0\n"
  " 25 36  8  0  0  0  0\n"
  " 25 37  8  0  0  0  0\n"
  " 26 32  8  0  0  0  0\n"
  " 26 38  8  0  0  0  0\n"
  " 27 38  8  0  0  0  0\n"
  " 27 39  8  0  0  0  0\n"
  " 28 40  8  0  0  0  0\n"
  " 29 41  8  0  0  0  0\n"
  " 30 42  8  0  0  0  0\n"
  " 31 34  8  0  0  0  0\n"
  " 31 43  8  0  0  0  0\n"
  " 32 44  8  0  0  0  0\n"
  " 33 45  8  0  0  0  0\n"
  " 34 46  8  0  0  0  0\n"
  " 35 40  8  0  0  0  0\n"
  " 36 47  8  0  0  0  0\n"
  " 37 39  8  0  0  0  0\n"
  " 37 48  8  0  0  0  0\n"
  " 38 49  8  0  0  0  0\n"
  " 39 50  8  0  0  0  0\n"
  " 41 51  8  0  0  0  0\n"
  " 41 52  8  0  0  0  0\n"
  " 42 43  8  0  0  0  0\n"
  " 42 51  8  0  0  0  0\n"
  " 43 53  8  0  0  0  0\n"
  " 44 54  8  0  0  0  0\n"
  " 44 55  8  0  0  0  0\n"
  " 45 46  8  0  0  0  0\n"
  " 45 54  8  0  0  0  0\n"
  " 46 56  8  0  0  0  0\n"
  " 47 48  8  0  0  0  0\n"
  " 47 52  8  0  0  0  0\n"
  " 48 57  8  0  0  0  0\n"
  " 49 50  8  0  0  0  0\n"
  " 49 55  8  0  0  0  0\n"
  " 50 58  8  0  0  0  0\n"
  " 51 59  8  0  0  0  0\n"
  " 52 60  8  0  0  0  0\n"
  " 53 56  8  0  0  0  0\n"
  " 53 61  8  0  0  0  0\n"
  " 54 62  8  0  0  0  0\n"
  " 55 63  8  0  0  0  0\n"
  " 56 64  8  0  0  0  0\n"
  " 57 58  8  0  0  0  0\n"
  " 57 65  8  0  0  0  0\n"
  " 58 66  8  0  0  0  0\n"
  " 59 60  8  0  0  0  0\n"
  " 59 61  8  0  0  0  0\n"
  " 60 65  8  0  0  0  0\n"
  " 61 67  8  0  0  0  0\n"
  " 62 63  8  0  0  0  0\n"
  " 62 64  8  0  0  0  0\n"
  " 63 66  8  0  0  0  0\n"
  " 64 67  8  0  0  0  0\n"
  " 65 68  8  0  0  0  0\n"
  " 66 68  8  0  0  0  0\n"
  " 67 68  8  0  0  0  0\n"
  "M  END\n"
  "\n",

  "superstar.mol\n"
  "  Mrv0541 03181119032D          \n"
  "\n"
  " 70105  0  0  0  0            999 V2000\n"
  "   -0.6526    0.2101    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.3992   -0.5750    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0157    0.6937    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.4258   -0.5766    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.6823    0.2074    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.8854   -1.2416    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.7104   -1.2399    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.6320   -2.0266    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.9668   -2.0241    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.3004   -2.5103    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.9094   -1.2451    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.6529   -2.0291    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.7344   -1.2467    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.3193   -2.5154    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.9878   -2.0318    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.4673    0.4608    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.1339   -0.0255    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.7240    1.2448    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.8023    0.4581    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.5490    1.2432    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0173    1.5187    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.6857    2.0023    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.6492    2.0049    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.4324    2.7874    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.3926    2.7891    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.4368    0.4665    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.6902    1.2516    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.1052   -0.0172    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.5151    1.2531    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.7716    0.4691    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    1.4039   -3.3359    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.1568   -3.6730    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.7406   -2.3690    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.8251   -3.1895    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.6088    0.2849    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.1621    0.8968    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.1022    1.8550    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.9087    1.6819    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.8462    3.5009    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.4352    4.2162    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.8036    3.5043    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.3898    4.2178    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.0659    1.8673    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.8732    1.6974    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.5788    0.2993    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.1297    0.9134    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.7211   -2.3581    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.8089   -3.1784    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -1.3883   -3.3304    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.1425   -3.6646    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.4772   -3.6618    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -2.3990   -4.4484    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.3904   -4.6891    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    2.4100   -4.4579    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4913   -3.6758    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.4137   -4.6930    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.9869    0.8951    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    4.5771    2.1651    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    5.5205    1.7770    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.6917    5.0002    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -0.6430    5.0028    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0177    5.7802    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.5394    2.1835    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -4.9544    0.9151    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -5.4895    1.7837    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -6.2753    2.0354    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "   -3.8726   -5.3584    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    3.9014   -5.3584    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    6.2978    2.0264    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "    0.0206    6.6138    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n"
  "  2  1  8  0  0  0  0\n"
  "  3  1  8  0  0  0  0\n"
  "  4  2  8  0  0  0  0\n"
  "  5  3  8  0  0  0  0\n"
  "  5  4  8  0  0  0  0\n"
  "  7  6  8  0  0  0  0\n"
  "  8  6  8  0  0  0  0\n"
  "  9  7  8  0  0  0  0\n"
  " 10  8  8  0  0  0  0\n"
  "  2  6  8  0  0  0  0\n"
  " 12 11  8  0  0  0  0\n"
  " 13 11  8  0  0  0  0\n"
  " 14 12  8  0  0  0  0\n"
  " 15 13  8  0  0  0  0\n"
  "  4 11  8  0  0  0  0\n"
  " 17 16  8  0  0  0  0\n"
  " 18 16  8  0  0  0  0\n"
  " 19 17  8  0  0  0  0\n"
  " 20 18  8  0  0  0  0\n"
  "  5 16  8  0  0  0  0\n"
  " 22 21  8  0  0  0  0\n"
  " 23 21  8  0  0  0  0\n"
  " 24 22  8  0  0  0  0\n"
  " 25 23  8  0  0  0  0\n"
  "  3 21  8  0  0  0  0\n"
  " 27 26  8  0  0  0  0\n"
  " 28 26  8  0  0  0  0\n"
  " 29 27  8  0  0  0  0\n"
  " 30 28  8  0  0  0  0\n"
  "  1 26  8  0  0  0  0\n"
  "  7 28  8  0  0  0  0\n"
  "  8 12  8  0  0  0  0\n"
  " 13 17  8  0  0  0  0\n"
  " 18 22  8  0  0  0  0\n"
  " 23 27  8  0  0  0  0\n"
  " 31 14  8  0  0  0  0\n"
  " 15 14  8  0  0  0  0\n"
  " 32 31  8  0  0  0  0\n"
  " 33 15  8  0  0  0  0\n"
  " 34 33  8  0  0  0  0\n"
  " 35 19  8  0  0  0  0\n"
  " 20 19  8  0  0  0  0\n"
  " 36 35  8  0  0  0  0\n"
  " 37 20  8  0  0  0  0\n"
  " 38 37  8  0  0  0  0\n"
  " 39 24  8  0  0  0  0\n"
  " 25 24  8  0  0  0  0\n"
  " 40 39  8  0  0  0  0\n"
  " 41 25  8  0  0  0  0\n"
  " 42 41  8  0  0  0  0\n"
  " 43 29  8  0  0  0  0\n"
  " 30 29  8  0  0  0  0\n"
  " 44 43  8  0  0  0  0\n"
  " 45 30  8  0  0  0  0\n"
  " 46 45  8  0  0  0  0\n"
  " 47  9  8  0  0  0  0\n"
  " 10  9  8  0  0  0  0\n"
  " 48 47  8  0  0  0  0\n"
  " 49 10  8  0  0  0  0\n"
  " 50 49  8  0  0  0  0\n"
  " 45 47  8  0  0  0  0\n"
  " 49 31  8  0  0  0  0\n"
  " 33 35  8  0  0  0  0\n"
  " 37 39  8  0  0  0  0\n"
  " 41 43  8  0  0  0  0\n"
  " 48 51  8  0  0  0  0\n"
  " 50 48  8  0  0  0  0\n"
  " 50 52  8  0  0  0  0\n"
  " 53 52  8  0  0  0  0\n"
  " 51 53  8  0  0  0  0\n"
  " 32 54  8  0  0  0  0\n"
  " 34 32  8  0  0  0  0\n"
  " 34 55  8  0  0  0  0\n"
  " 56 55  8  0  0  0  0\n"
  " 54 56  8  0  0  0  0\n"
  " 36 57  8  0  0  0  0\n"
  " 38 36  8  0  0  0  0\n"
  " 38 58  8  0  0  0  0\n"
  " 59 58  8  0  0  0  0\n"
  " 57 59  8  0  0  0  0\n"
  " 40 60  8  0  0  0  0\n"
  " 42 40  8  0  0  0  0\n"
  " 42 61  8  0  0  0  0\n"
  " 62 61  8  0  0  0  0\n"
  " 60 62  8  0  0  0  0\n"
  " 44 63  8  0  0  0  0\n"
  " 46 44  8  0  0  0  0\n"
  " 46 64  8  0  0  0  0\n"
  " 65 64  8  0  0  0  0\n"
  " 63 65  8  0  0  0  0\n"
  " 64 51  8  0  0  0  0\n"
  " 52 54  8  0  0  0  0\n"
  " 55 57  8  0  0  0  0\n"
  " 58 60  8  0  0  0  0\n"
  " 61 63  8  0  0  0  0\n"
  " 66 65  8  0  0  0  0\n"
  " 67 53  8  0  0  0  0\n"
  " 68 56  8  0  0  0  0\n"
  " 69 59  8  0  0  0  0\n"
  " 70 62  8  0  0  0  0\n"
  " 70 66  8  0  0  0  0\n"
  " 66 67  8  0  0  0  0\n"
  " 67 68  8  0  0  0  0\n"
  " 68 69  8  0  0  0  0\n"
  " 69 70  8  0  0  0  0\n"
  "M  END\n"
  "\n",

};
