// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/visionai/v1/lva_service.proto

package visionaipb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The enum of the types of the Registry.
type Registry int32

const (
	// Registry is unspecified.
	Registry_REGISTRY_UNSPECIFIED Registry = 0
	// Public Registry containing the public Operators released by Google.
	Registry_PUBLIC Registry = 1
	// Private Registry containing the local registered operators.
	Registry_PRIVATE Registry = 2
)

// Enum value maps for Registry.
var (
	Registry_name = map[int32]string{
		0: "REGISTRY_UNSPECIFIED",
		1: "PUBLIC",
		2: "PRIVATE",
	}
	Registry_value = map[string]int32{
		"REGISTRY_UNSPECIFIED": 0,
		"PUBLIC":               1,
		"PRIVATE":              2,
	}
)

func (x Registry) Enum() *Registry {
	p := new(Registry)
	*p = x
	return p
}

func (x Registry) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Registry) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_visionai_v1_lva_service_proto_enumTypes[0].Descriptor()
}

func (Registry) Type() protoreflect.EnumType {
	return &file_google_cloud_visionai_v1_lva_service_proto_enumTypes[0]
}

func (x Registry) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Registry.Descriptor instead.
func (Registry) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{0}
}

// Message for requesting list of Operators.
type ListOperatorsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListOperatorsRequest.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Hint for how to order the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListOperatorsRequest) Reset() {
	*x = ListOperatorsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOperatorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOperatorsRequest) ProtoMessage() {}

func (x *ListOperatorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOperatorsRequest.ProtoReflect.Descriptor instead.
func (*ListOperatorsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{0}
}

func (x *ListOperatorsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListOperatorsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListOperatorsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListOperatorsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListOperatorsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing Operators.
type ListOperatorsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Operator
	Operators []*Operator `protobuf:"bytes,1,rep,name=operators,proto3" json:"operators,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListOperatorsResponse) Reset() {
	*x = ListOperatorsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOperatorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOperatorsResponse) ProtoMessage() {}

func (x *ListOperatorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOperatorsResponse.ProtoReflect.Descriptor instead.
func (*ListOperatorsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListOperatorsResponse) GetOperators() []*Operator {
	if x != nil {
		return x.Operators
	}
	return nil
}

func (x *ListOperatorsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListOperatorsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a Operator.
type GetOperatorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetOperatorRequest) Reset() {
	*x = GetOperatorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetOperatorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOperatorRequest) ProtoMessage() {}

func (x *GetOperatorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOperatorRequest.ProtoReflect.Descriptor instead.
func (*GetOperatorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetOperatorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a Operator.
type CreateOperatorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Id of the requesting object.
	OperatorId string `protobuf:"bytes,2,opt,name=operator_id,json=operatorId,proto3" json:"operator_id,omitempty"`
	// Required. The resource being created.
	Operator *Operator `protobuf:"bytes,3,opt,name=operator,proto3" json:"operator,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateOperatorRequest) Reset() {
	*x = CreateOperatorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateOperatorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOperatorRequest) ProtoMessage() {}

func (x *CreateOperatorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateOperatorRequest.ProtoReflect.Descriptor instead.
func (*CreateOperatorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateOperatorRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateOperatorRequest) GetOperatorId() string {
	if x != nil {
		return x.OperatorId
	}
	return ""
}

func (x *CreateOperatorRequest) GetOperator() *Operator {
	if x != nil {
		return x.Operator
	}
	return nil
}

func (x *CreateOperatorRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for updating a Operator.
type UpdateOperatorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// Operator resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated
	Operator *Operator `protobuf:"bytes,2,opt,name=operator,proto3" json:"operator,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateOperatorRequest) Reset() {
	*x = UpdateOperatorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateOperatorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateOperatorRequest) ProtoMessage() {}

func (x *UpdateOperatorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateOperatorRequest.ProtoReflect.Descriptor instead.
func (*UpdateOperatorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateOperatorRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateOperatorRequest) GetOperator() *Operator {
	if x != nil {
		return x.Operator
	}
	return nil
}

func (x *UpdateOperatorRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for deleting a Operator
type DeleteOperatorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteOperatorRequest) Reset() {
	*x = DeleteOperatorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteOperatorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteOperatorRequest) ProtoMessage() {}

func (x *DeleteOperatorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteOperatorRequest.ProtoReflect.Descriptor instead.
func (*DeleteOperatorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteOperatorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteOperatorRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for requesting list of Analyses
type ListAnalysesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListAnalysesRequest
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Hint for how to order the results
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListAnalysesRequest) Reset() {
	*x = ListAnalysesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAnalysesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnalysesRequest) ProtoMessage() {}

func (x *ListAnalysesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnalysesRequest.ProtoReflect.Descriptor instead.
func (*ListAnalysesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{6}
}

func (x *ListAnalysesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAnalysesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAnalysesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAnalysesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAnalysesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing Analyses
type ListAnalysesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Analysis
	Analyses []*Analysis `protobuf:"bytes,1,rep,name=analyses,proto3" json:"analyses,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListAnalysesResponse) Reset() {
	*x = ListAnalysesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAnalysesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAnalysesResponse) ProtoMessage() {}

func (x *ListAnalysesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAnalysesResponse.ProtoReflect.Descriptor instead.
func (*ListAnalysesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{7}
}

func (x *ListAnalysesResponse) GetAnalyses() []*Analysis {
	if x != nil {
		return x.Analyses
	}
	return nil
}

func (x *ListAnalysesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListAnalysesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting an Analysis.
type GetAnalysisRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAnalysisRequest) Reset() {
	*x = GetAnalysisRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAnalysisRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAnalysisRequest) ProtoMessage() {}

func (x *GetAnalysisRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAnalysisRequest.ProtoReflect.Descriptor instead.
func (*GetAnalysisRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{8}
}

func (x *GetAnalysisRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating an Analysis.
type CreateAnalysisRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Id of the requesting object.
	AnalysisId string `protobuf:"bytes,2,opt,name=analysis_id,json=analysisId,proto3" json:"analysis_id,omitempty"`
	// Required. The resource being created.
	Analysis *Analysis `protobuf:"bytes,3,opt,name=analysis,proto3" json:"analysis,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateAnalysisRequest) Reset() {
	*x = CreateAnalysisRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAnalysisRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAnalysisRequest) ProtoMessage() {}

func (x *CreateAnalysisRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAnalysisRequest.ProtoReflect.Descriptor instead.
func (*CreateAnalysisRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{9}
}

func (x *CreateAnalysisRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAnalysisRequest) GetAnalysisId() string {
	if x != nil {
		return x.AnalysisId
	}
	return ""
}

func (x *CreateAnalysisRequest) GetAnalysis() *Analysis {
	if x != nil {
		return x.Analysis
	}
	return nil
}

func (x *CreateAnalysisRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for updating an Analysis.
type UpdateAnalysisRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// Analysis resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated.
	Analysis *Analysis `protobuf:"bytes,2,opt,name=analysis,proto3" json:"analysis,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateAnalysisRequest) Reset() {
	*x = UpdateAnalysisRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAnalysisRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAnalysisRequest) ProtoMessage() {}

func (x *UpdateAnalysisRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAnalysisRequest.ProtoReflect.Descriptor instead.
func (*UpdateAnalysisRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{10}
}

func (x *UpdateAnalysisRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateAnalysisRequest) GetAnalysis() *Analysis {
	if x != nil {
		return x.Analysis
	}
	return nil
}

func (x *UpdateAnalysisRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for deleting an Analysis.
type DeleteAnalysisRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteAnalysisRequest) Reset() {
	*x = DeleteAnalysisRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAnalysisRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAnalysisRequest) ProtoMessage() {}

func (x *DeleteAnalysisRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAnalysisRequest.ProtoReflect.Descriptor instead.
func (*DeleteAnalysisRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{11}
}

func (x *DeleteAnalysisRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteAnalysisRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for requesting list of Processes.
type ListProcessesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListProcessesRequest.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Hint for how to order the results
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListProcessesRequest) Reset() {
	*x = ListProcessesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProcessesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProcessesRequest) ProtoMessage() {}

func (x *ListProcessesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProcessesRequest.ProtoReflect.Descriptor instead.
func (*ListProcessesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{12}
}

func (x *ListProcessesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListProcessesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProcessesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListProcessesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListProcessesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing Processes.
type ListProcessesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Processes.
	Processes []*Process `protobuf:"bytes,1,rep,name=processes,proto3" json:"processes,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListProcessesResponse) Reset() {
	*x = ListProcessesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListProcessesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProcessesResponse) ProtoMessage() {}

func (x *ListProcessesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProcessesResponse.ProtoReflect.Descriptor instead.
func (*ListProcessesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{13}
}

func (x *ListProcessesResponse) GetProcesses() []*Process {
	if x != nil {
		return x.Processes
	}
	return nil
}

func (x *ListProcessesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListProcessesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a Process.
type GetProcessRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetProcessRequest) Reset() {
	*x = GetProcessRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetProcessRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProcessRequest) ProtoMessage() {}

func (x *GetProcessRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProcessRequest.ProtoReflect.Descriptor instead.
func (*GetProcessRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{14}
}

func (x *GetProcessRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a Process.
type CreateProcessRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Id of the requesting object.
	ProcessId string `protobuf:"bytes,2,opt,name=process_id,json=processId,proto3" json:"process_id,omitempty"`
	// Required. The resource being created.
	Process *Process `protobuf:"bytes,3,opt,name=process,proto3" json:"process,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateProcessRequest) Reset() {
	*x = CreateProcessRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateProcessRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateProcessRequest) ProtoMessage() {}

func (x *CreateProcessRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateProcessRequest.ProtoReflect.Descriptor instead.
func (*CreateProcessRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{15}
}

func (x *CreateProcessRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateProcessRequest) GetProcessId() string {
	if x != nil {
		return x.ProcessId
	}
	return ""
}

func (x *CreateProcessRequest) GetProcess() *Process {
	if x != nil {
		return x.Process
	}
	return nil
}

func (x *CreateProcessRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for updating a Process.
type UpdateProcessRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// Process resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated.
	Process *Process `protobuf:"bytes,2,opt,name=process,proto3" json:"process,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateProcessRequest) Reset() {
	*x = UpdateProcessRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateProcessRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateProcessRequest) ProtoMessage() {}

func (x *UpdateProcessRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateProcessRequest.ProtoReflect.Descriptor instead.
func (*UpdateProcessRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{16}
}

func (x *UpdateProcessRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateProcessRequest) GetProcess() *Process {
	if x != nil {
		return x.Process
	}
	return nil
}

func (x *UpdateProcessRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for deleting a Process.
type DeleteProcessRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteProcessRequest) Reset() {
	*x = DeleteProcessRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteProcessRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteProcessRequest) ProtoMessage() {}

func (x *DeleteProcessRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteProcessRequest.ProtoReflect.Descriptor instead.
func (*DeleteProcessRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{17}
}

func (x *DeleteProcessRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteProcessRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for running the processes in a batch.
type BatchRunProcessRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource shared by all processes being created.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The create process requests.
	Requests []*CreateProcessRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
	// Optional. Options for batch processes.
	Options *BatchRunProcessRequest_BatchRunProcessOptions `protobuf:"bytes,3,opt,name=options,proto3" json:"options,omitempty"`
	// Output only. The batch ID.
	BatchId string `protobuf:"bytes,4,opt,name=batch_id,json=batchId,proto3" json:"batch_id,omitempty"`
}

func (x *BatchRunProcessRequest) Reset() {
	*x = BatchRunProcessRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchRunProcessRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRunProcessRequest) ProtoMessage() {}

func (x *BatchRunProcessRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRunProcessRequest.ProtoReflect.Descriptor instead.
func (*BatchRunProcessRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{18}
}

func (x *BatchRunProcessRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchRunProcessRequest) GetRequests() []*CreateProcessRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

func (x *BatchRunProcessRequest) GetOptions() *BatchRunProcessRequest_BatchRunProcessOptions {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *BatchRunProcessRequest) GetBatchId() string {
	if x != nil {
		return x.BatchId
	}
	return ""
}

// Response message for running the processes in a batch.
type BatchRunProcessResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The batch ID.
	BatchId string `protobuf:"bytes,1,opt,name=batch_id,json=batchId,proto3" json:"batch_id,omitempty"`
	// Processes created.
	Processes []*Process `protobuf:"bytes,2,rep,name=processes,proto3" json:"processes,omitempty"`
}

func (x *BatchRunProcessResponse) Reset() {
	*x = BatchRunProcessResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchRunProcessResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRunProcessResponse) ProtoMessage() {}

func (x *BatchRunProcessResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRunProcessResponse.ProtoReflect.Descriptor instead.
func (*BatchRunProcessResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{19}
}

func (x *BatchRunProcessResponse) GetBatchId() string {
	if x != nil {
		return x.BatchId
	}
	return ""
}

func (x *BatchRunProcessResponse) GetProcesses() []*Process {
	if x != nil {
		return x.Processes
	}
	return nil
}

// Request message for querying operator info.
type ResolveOperatorInfoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ResolveOperatorInfoRequest.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The operator queries.
	Queries []*OperatorQuery `protobuf:"bytes,2,rep,name=queries,proto3" json:"queries,omitempty"`
}

func (x *ResolveOperatorInfoRequest) Reset() {
	*x = ResolveOperatorInfoRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResolveOperatorInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResolveOperatorInfoRequest) ProtoMessage() {}

func (x *ResolveOperatorInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResolveOperatorInfoRequest.ProtoReflect.Descriptor instead.
func (*ResolveOperatorInfoRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{20}
}

func (x *ResolveOperatorInfoRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ResolveOperatorInfoRequest) GetQueries() []*OperatorQuery {
	if x != nil {
		return x.Queries
	}
	return nil
}

// OperatorQuery represents one query to a Operator.
type OperatorQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The canonical Name of the operator. e.g. OccupancyCounting.
	Operator string `protobuf:"bytes,1,opt,name=operator,proto3" json:"operator,omitempty"`
	// Optional. Tag of the operator.
	Tag string `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
	// Optional. Registry of the operator.
	Registry Registry `protobuf:"varint,3,opt,name=registry,proto3,enum=google.cloud.visionai.v1.Registry" json:"registry,omitempty"`
}

func (x *OperatorQuery) Reset() {
	*x = OperatorQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperatorQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperatorQuery) ProtoMessage() {}

func (x *OperatorQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperatorQuery.ProtoReflect.Descriptor instead.
func (*OperatorQuery) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{21}
}

func (x *OperatorQuery) GetOperator() string {
	if x != nil {
		return x.Operator
	}
	return ""
}

func (x *OperatorQuery) GetTag() string {
	if x != nil {
		return x.Tag
	}
	return ""
}

func (x *OperatorQuery) GetRegistry() Registry {
	if x != nil {
		return x.Registry
	}
	return Registry_REGISTRY_UNSPECIFIED
}

// Response message of ResolveOperatorInfo API.
type ResolveOperatorInfoResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operators with detailed information.
	Operators []*Operator `protobuf:"bytes,1,rep,name=operators,proto3" json:"operators,omitempty"`
}

func (x *ResolveOperatorInfoResponse) Reset() {
	*x = ResolveOperatorInfoResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResolveOperatorInfoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResolveOperatorInfoResponse) ProtoMessage() {}

func (x *ResolveOperatorInfoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResolveOperatorInfoResponse.ProtoReflect.Descriptor instead.
func (*ResolveOperatorInfoResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{22}
}

func (x *ResolveOperatorInfoResponse) GetOperators() []*Operator {
	if x != nil {
		return x.Operators
	}
	return nil
}

// Request message of ListPublicOperatorsRequest API.
type ListPublicOperatorsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListPublicOperatorsRequest.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Hint for how to order the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListPublicOperatorsRequest) Reset() {
	*x = ListPublicOperatorsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPublicOperatorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPublicOperatorsRequest) ProtoMessage() {}

func (x *ListPublicOperatorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPublicOperatorsRequest.ProtoReflect.Descriptor instead.
func (*ListPublicOperatorsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{23}
}

func (x *ListPublicOperatorsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPublicOperatorsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPublicOperatorsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPublicOperatorsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListPublicOperatorsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message of ListPublicOperators API.
type ListPublicOperatorsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Operator
	Operators []*Operator `protobuf:"bytes,1,rep,name=operators,proto3" json:"operators,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPublicOperatorsResponse) Reset() {
	*x = ListPublicOperatorsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPublicOperatorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPublicOperatorsResponse) ProtoMessage() {}

func (x *ListPublicOperatorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPublicOperatorsResponse.ProtoReflect.Descriptor instead.
func (*ListPublicOperatorsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{24}
}

func (x *ListPublicOperatorsResponse) GetOperators() []*Operator {
	if x != nil {
		return x.Operators
	}
	return nil
}

func (x *ListPublicOperatorsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Options for batch processes.
type BatchRunProcessRequest_BatchRunProcessOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The retry counts per process. Default: 3.
	RetryCount int32 `protobuf:"varint,1,opt,name=retry_count,json=retryCount,proto3" json:"retry_count,omitempty"`
	// The batch size. Default: 5, maximum: 100.
	BatchSize int32 `protobuf:"varint,2,opt,name=batch_size,json=batchSize,proto3" json:"batch_size,omitempty"`
}

func (x *BatchRunProcessRequest_BatchRunProcessOptions) Reset() {
	*x = BatchRunProcessRequest_BatchRunProcessOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchRunProcessRequest_BatchRunProcessOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchRunProcessRequest_BatchRunProcessOptions) ProtoMessage() {}

func (x *BatchRunProcessRequest_BatchRunProcessOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_visionai_v1_lva_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchRunProcessRequest_BatchRunProcessOptions.ProtoReflect.Descriptor instead.
func (*BatchRunProcessRequest_BatchRunProcessOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP(), []int{18, 0}
}

func (x *BatchRunProcessRequest_BatchRunProcessOptions) GetRetryCount() int32 {
	if x != nil {
		return x.RetryCount
	}
	return 0
}

func (x *BatchRunProcessRequest_BatchRunProcessOptions) GetBatchSize() int32 {
	if x != nil {
		return x.BatchSize
	}
	return 0
}

var File_google_cloud_visionai_v1_lva_service_proto protoreflect.FileDescriptor

var file_google_cloud_visionai_v1_lva_service_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x76, 0x61, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x76, 0x61, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xc8, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xa3, 0x01,
	0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x09,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x22, 0x52, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a,
	0x20, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe9, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x49, 0x64, 0x12, 0x43, 0x0a, 0x08, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12,
	0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0xc2, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12,
	0x43, 0x0a, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x79, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0xc5, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xa0, 0x01, 0x0a, 0x14,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x08, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x52,
	0x0a, 0x12, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xe7, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x24, 0x0a,
	0x0b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x49, 0x64, 0x12, 0x43, 0x0a, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xc2, 0x01, 0x0a,
	0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x43, 0x0a, 0x08, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x22, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x22, 0x79, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22,
	0x0a, 0x20, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xc6, 0x01, 0x0a,
	0x14, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xa2, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3f, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x50, 0x0a, 0x11, 0x47, 0x65,
	0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe1, 0x01, 0x0a,
	0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x07, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x22, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0xbe, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x40, 0x0a, 0x07, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x22, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x22, 0x77, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a,
	0x1f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x8c, 0x03, 0x0a, 0x16, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4f, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x66, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x52, 0x75, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x1e, 0x0a, 0x08, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x62, 0x61, 0x74, 0x63, 0x68, 0x49, 0x64, 0x1a,
	0x58, 0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x74,
	0x72, 0x79, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a,
	0x72, 0x65, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x75, 0x0a, 0x17, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x52, 0x75, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x62, 0x61, 0x74, 0x63, 0x68, 0x49, 0x64, 0x12,
	0x3f, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73,
	0x22, 0xa7, 0x01, 0x0a, 0x1a, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x46, 0x0a, 0x07, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x51, 0x75, 0x65, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x07, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x22, 0x8c, 0x01, 0x0a, 0x0d, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1f, 0x0a, 0x08,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x15, 0x0a,
	0x03, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x03, 0x74, 0x61, 0x67, 0x12, 0x43, 0x0a, 0x08, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x22, 0x5f, 0x0a, 0x1b, 0x52, 0x65, 0x73,
	0x6f, 0x6c, 0x76, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52,
	0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x22, 0xce, 0x01, 0x0a, 0x1a, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x87, 0x01, 0x0a, 0x1b,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x09, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x2a, 0x3d, 0x0a, 0x08, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x50,
	0x55, 0x42, 0x4c, 0x49, 0x43, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x52, 0x49, 0x56, 0x41,
	0x54, 0x45, 0x10, 0x02, 0x32, 0x8d, 0x1e, 0x0a, 0x12, 0x4c, 0x69, 0x76, 0x65, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x12, 0xcc, 0x01, 0x0a, 0x13,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x48, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0xd7, 0x01, 0x0a, 0x13, 0x52,
	0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x6c, 0x76, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x53, 0xda, 0x41, 0x0e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x69,
	0x65, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x01, 0x2a, 0x22, 0x37, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0xb0, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x9d, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x22, 0x3c, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdf, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7d, 0xca, 0x41, 0x1d, 0x0a,
	0x08, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x2c, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39,
	0x3a, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x22, 0x2d, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0xe1, 0x01, 0x0a, 0x0e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7f, 0xca, 0x41,
	0x1d, 0x0a, 0x08, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x14, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x08, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x32, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcb, 0x01,
	0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x69, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x2a, 0x2d, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb7, 0x01, 0x0a, 0x0c,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x12, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x48, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x65, 0x73, 0x12, 0xa7, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x22, 0x46, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xea, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x87, 0x01, 0xca, 0x41, 0x1d, 0x0a, 0x08, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x2c, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x3a, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x12, 0xec, 0x01, 0x0a,
	0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x89, 0x01, 0xca, 0x41, 0x1d, 0x0a, 0x08, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x14, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x3a,
	0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x32, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd5, 0x01, 0x0a, 0x0e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x73,
	0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x2a, 0x37, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xbb, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x49, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65,
	0x73, 0x12, 0xa5, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x22, 0x47, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x12,
	0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe5, 0x01, 0x0a, 0x0d, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x84, 0x01, 0xca, 0x41, 0x1c,
	0x0a, 0x07, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x19, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x2c, 0x70, 0x72,
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x3a, 0x07,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65,
	0x73, 0x12, 0xe7, 0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x86, 0x01, 0xca, 0x41, 0x1c, 0x0a, 0x07, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x13, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b,
	0x3a, 0x07, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x32, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd4, 0x01, 0x0a, 0x0d,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x74, 0xca, 0x41,
	0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x2a, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xf2, 0x01, 0x0a, 0x0f, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x50,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8d, 0x01, 0xca, 0x41, 0x2c, 0x0a, 0x17, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0f, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x46, 0x3a, 0x01, 0x2a, 0x22, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x3a, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x52, 0x75, 0x6e, 0x1a, 0x4b, 0xca, 0x41, 0x17, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x42, 0xbf, 0x01, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x42, 0x0f, 0x4c, 0x76, 0x61, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x61, 0x69, 0x70, 0x62, 0x3b, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x69,
	0x70, 0x62, 0xaa, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x56, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x49, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x18,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x56, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x41, 0x49, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x56, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x41, 0x49, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_visionai_v1_lva_service_proto_rawDescOnce sync.Once
	file_google_cloud_visionai_v1_lva_service_proto_rawDescData = file_google_cloud_visionai_v1_lva_service_proto_rawDesc
)

func file_google_cloud_visionai_v1_lva_service_proto_rawDescGZIP() []byte {
	file_google_cloud_visionai_v1_lva_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_visionai_v1_lva_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_visionai_v1_lva_service_proto_rawDescData)
	})
	return file_google_cloud_visionai_v1_lva_service_proto_rawDescData
}

var file_google_cloud_visionai_v1_lva_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_visionai_v1_lva_service_proto_msgTypes = make([]protoimpl.MessageInfo, 26)
var file_google_cloud_visionai_v1_lva_service_proto_goTypes = []interface{}{
	(Registry)(0),                                         // 0: google.cloud.visionai.v1.Registry
	(*ListOperatorsRequest)(nil),                          // 1: google.cloud.visionai.v1.ListOperatorsRequest
	(*ListOperatorsResponse)(nil),                         // 2: google.cloud.visionai.v1.ListOperatorsResponse
	(*GetOperatorRequest)(nil),                            // 3: google.cloud.visionai.v1.GetOperatorRequest
	(*CreateOperatorRequest)(nil),                         // 4: google.cloud.visionai.v1.CreateOperatorRequest
	(*UpdateOperatorRequest)(nil),                         // 5: google.cloud.visionai.v1.UpdateOperatorRequest
	(*DeleteOperatorRequest)(nil),                         // 6: google.cloud.visionai.v1.DeleteOperatorRequest
	(*ListAnalysesRequest)(nil),                           // 7: google.cloud.visionai.v1.ListAnalysesRequest
	(*ListAnalysesResponse)(nil),                          // 8: google.cloud.visionai.v1.ListAnalysesResponse
	(*GetAnalysisRequest)(nil),                            // 9: google.cloud.visionai.v1.GetAnalysisRequest
	(*CreateAnalysisRequest)(nil),                         // 10: google.cloud.visionai.v1.CreateAnalysisRequest
	(*UpdateAnalysisRequest)(nil),                         // 11: google.cloud.visionai.v1.UpdateAnalysisRequest
	(*DeleteAnalysisRequest)(nil),                         // 12: google.cloud.visionai.v1.DeleteAnalysisRequest
	(*ListProcessesRequest)(nil),                          // 13: google.cloud.visionai.v1.ListProcessesRequest
	(*ListProcessesResponse)(nil),                         // 14: google.cloud.visionai.v1.ListProcessesResponse
	(*GetProcessRequest)(nil),                             // 15: google.cloud.visionai.v1.GetProcessRequest
	(*CreateProcessRequest)(nil),                          // 16: google.cloud.visionai.v1.CreateProcessRequest
	(*UpdateProcessRequest)(nil),                          // 17: google.cloud.visionai.v1.UpdateProcessRequest
	(*DeleteProcessRequest)(nil),                          // 18: google.cloud.visionai.v1.DeleteProcessRequest
	(*BatchRunProcessRequest)(nil),                        // 19: google.cloud.visionai.v1.BatchRunProcessRequest
	(*BatchRunProcessResponse)(nil),                       // 20: google.cloud.visionai.v1.BatchRunProcessResponse
	(*ResolveOperatorInfoRequest)(nil),                    // 21: google.cloud.visionai.v1.ResolveOperatorInfoRequest
	(*OperatorQuery)(nil),                                 // 22: google.cloud.visionai.v1.OperatorQuery
	(*ResolveOperatorInfoResponse)(nil),                   // 23: google.cloud.visionai.v1.ResolveOperatorInfoResponse
	(*ListPublicOperatorsRequest)(nil),                    // 24: google.cloud.visionai.v1.ListPublicOperatorsRequest
	(*ListPublicOperatorsResponse)(nil),                   // 25: google.cloud.visionai.v1.ListPublicOperatorsResponse
	(*BatchRunProcessRequest_BatchRunProcessOptions)(nil), // 26: google.cloud.visionai.v1.BatchRunProcessRequest.BatchRunProcessOptions
	(*Operator)(nil),                                      // 27: google.cloud.visionai.v1.Operator
	(*fieldmaskpb.FieldMask)(nil),                         // 28: google.protobuf.FieldMask
	(*Analysis)(nil),                                      // 29: google.cloud.visionai.v1.Analysis
	(*Process)(nil),                                       // 30: google.cloud.visionai.v1.Process
	(*longrunningpb.Operation)(nil),                       // 31: google.longrunning.Operation
}
var file_google_cloud_visionai_v1_lva_service_proto_depIdxs = []int32{
	27, // 0: google.cloud.visionai.v1.ListOperatorsResponse.operators:type_name -> google.cloud.visionai.v1.Operator
	27, // 1: google.cloud.visionai.v1.CreateOperatorRequest.operator:type_name -> google.cloud.visionai.v1.Operator
	28, // 2: google.cloud.visionai.v1.UpdateOperatorRequest.update_mask:type_name -> google.protobuf.FieldMask
	27, // 3: google.cloud.visionai.v1.UpdateOperatorRequest.operator:type_name -> google.cloud.visionai.v1.Operator
	29, // 4: google.cloud.visionai.v1.ListAnalysesResponse.analyses:type_name -> google.cloud.visionai.v1.Analysis
	29, // 5: google.cloud.visionai.v1.CreateAnalysisRequest.analysis:type_name -> google.cloud.visionai.v1.Analysis
	28, // 6: google.cloud.visionai.v1.UpdateAnalysisRequest.update_mask:type_name -> google.protobuf.FieldMask
	29, // 7: google.cloud.visionai.v1.UpdateAnalysisRequest.analysis:type_name -> google.cloud.visionai.v1.Analysis
	30, // 8: google.cloud.visionai.v1.ListProcessesResponse.processes:type_name -> google.cloud.visionai.v1.Process
	30, // 9: google.cloud.visionai.v1.CreateProcessRequest.process:type_name -> google.cloud.visionai.v1.Process
	28, // 10: google.cloud.visionai.v1.UpdateProcessRequest.update_mask:type_name -> google.protobuf.FieldMask
	30, // 11: google.cloud.visionai.v1.UpdateProcessRequest.process:type_name -> google.cloud.visionai.v1.Process
	16, // 12: google.cloud.visionai.v1.BatchRunProcessRequest.requests:type_name -> google.cloud.visionai.v1.CreateProcessRequest
	26, // 13: google.cloud.visionai.v1.BatchRunProcessRequest.options:type_name -> google.cloud.visionai.v1.BatchRunProcessRequest.BatchRunProcessOptions
	30, // 14: google.cloud.visionai.v1.BatchRunProcessResponse.processes:type_name -> google.cloud.visionai.v1.Process
	22, // 15: google.cloud.visionai.v1.ResolveOperatorInfoRequest.queries:type_name -> google.cloud.visionai.v1.OperatorQuery
	0,  // 16: google.cloud.visionai.v1.OperatorQuery.registry:type_name -> google.cloud.visionai.v1.Registry
	27, // 17: google.cloud.visionai.v1.ResolveOperatorInfoResponse.operators:type_name -> google.cloud.visionai.v1.Operator
	27, // 18: google.cloud.visionai.v1.ListPublicOperatorsResponse.operators:type_name -> google.cloud.visionai.v1.Operator
	24, // 19: google.cloud.visionai.v1.LiveVideoAnalytics.ListPublicOperators:input_type -> google.cloud.visionai.v1.ListPublicOperatorsRequest
	21, // 20: google.cloud.visionai.v1.LiveVideoAnalytics.ResolveOperatorInfo:input_type -> google.cloud.visionai.v1.ResolveOperatorInfoRequest
	1,  // 21: google.cloud.visionai.v1.LiveVideoAnalytics.ListOperators:input_type -> google.cloud.visionai.v1.ListOperatorsRequest
	3,  // 22: google.cloud.visionai.v1.LiveVideoAnalytics.GetOperator:input_type -> google.cloud.visionai.v1.GetOperatorRequest
	4,  // 23: google.cloud.visionai.v1.LiveVideoAnalytics.CreateOperator:input_type -> google.cloud.visionai.v1.CreateOperatorRequest
	5,  // 24: google.cloud.visionai.v1.LiveVideoAnalytics.UpdateOperator:input_type -> google.cloud.visionai.v1.UpdateOperatorRequest
	6,  // 25: google.cloud.visionai.v1.LiveVideoAnalytics.DeleteOperator:input_type -> google.cloud.visionai.v1.DeleteOperatorRequest
	7,  // 26: google.cloud.visionai.v1.LiveVideoAnalytics.ListAnalyses:input_type -> google.cloud.visionai.v1.ListAnalysesRequest
	9,  // 27: google.cloud.visionai.v1.LiveVideoAnalytics.GetAnalysis:input_type -> google.cloud.visionai.v1.GetAnalysisRequest
	10, // 28: google.cloud.visionai.v1.LiveVideoAnalytics.CreateAnalysis:input_type -> google.cloud.visionai.v1.CreateAnalysisRequest
	11, // 29: google.cloud.visionai.v1.LiveVideoAnalytics.UpdateAnalysis:input_type -> google.cloud.visionai.v1.UpdateAnalysisRequest
	12, // 30: google.cloud.visionai.v1.LiveVideoAnalytics.DeleteAnalysis:input_type -> google.cloud.visionai.v1.DeleteAnalysisRequest
	13, // 31: google.cloud.visionai.v1.LiveVideoAnalytics.ListProcesses:input_type -> google.cloud.visionai.v1.ListProcessesRequest
	15, // 32: google.cloud.visionai.v1.LiveVideoAnalytics.GetProcess:input_type -> google.cloud.visionai.v1.GetProcessRequest
	16, // 33: google.cloud.visionai.v1.LiveVideoAnalytics.CreateProcess:input_type -> google.cloud.visionai.v1.CreateProcessRequest
	17, // 34: google.cloud.visionai.v1.LiveVideoAnalytics.UpdateProcess:input_type -> google.cloud.visionai.v1.UpdateProcessRequest
	18, // 35: google.cloud.visionai.v1.LiveVideoAnalytics.DeleteProcess:input_type -> google.cloud.visionai.v1.DeleteProcessRequest
	19, // 36: google.cloud.visionai.v1.LiveVideoAnalytics.BatchRunProcess:input_type -> google.cloud.visionai.v1.BatchRunProcessRequest
	25, // 37: google.cloud.visionai.v1.LiveVideoAnalytics.ListPublicOperators:output_type -> google.cloud.visionai.v1.ListPublicOperatorsResponse
	23, // 38: google.cloud.visionai.v1.LiveVideoAnalytics.ResolveOperatorInfo:output_type -> google.cloud.visionai.v1.ResolveOperatorInfoResponse
	2,  // 39: google.cloud.visionai.v1.LiveVideoAnalytics.ListOperators:output_type -> google.cloud.visionai.v1.ListOperatorsResponse
	27, // 40: google.cloud.visionai.v1.LiveVideoAnalytics.GetOperator:output_type -> google.cloud.visionai.v1.Operator
	31, // 41: google.cloud.visionai.v1.LiveVideoAnalytics.CreateOperator:output_type -> google.longrunning.Operation
	31, // 42: google.cloud.visionai.v1.LiveVideoAnalytics.UpdateOperator:output_type -> google.longrunning.Operation
	31, // 43: google.cloud.visionai.v1.LiveVideoAnalytics.DeleteOperator:output_type -> google.longrunning.Operation
	8,  // 44: google.cloud.visionai.v1.LiveVideoAnalytics.ListAnalyses:output_type -> google.cloud.visionai.v1.ListAnalysesResponse
	29, // 45: google.cloud.visionai.v1.LiveVideoAnalytics.GetAnalysis:output_type -> google.cloud.visionai.v1.Analysis
	31, // 46: google.cloud.visionai.v1.LiveVideoAnalytics.CreateAnalysis:output_type -> google.longrunning.Operation
	31, // 47: google.cloud.visionai.v1.LiveVideoAnalytics.UpdateAnalysis:output_type -> google.longrunning.Operation
	31, // 48: google.cloud.visionai.v1.LiveVideoAnalytics.DeleteAnalysis:output_type -> google.longrunning.Operation
	14, // 49: google.cloud.visionai.v1.LiveVideoAnalytics.ListProcesses:output_type -> google.cloud.visionai.v1.ListProcessesResponse
	30, // 50: google.cloud.visionai.v1.LiveVideoAnalytics.GetProcess:output_type -> google.cloud.visionai.v1.Process
	31, // 51: google.cloud.visionai.v1.LiveVideoAnalytics.CreateProcess:output_type -> google.longrunning.Operation
	31, // 52: google.cloud.visionai.v1.LiveVideoAnalytics.UpdateProcess:output_type -> google.longrunning.Operation
	31, // 53: google.cloud.visionai.v1.LiveVideoAnalytics.DeleteProcess:output_type -> google.longrunning.Operation
	31, // 54: google.cloud.visionai.v1.LiveVideoAnalytics.BatchRunProcess:output_type -> google.longrunning.Operation
	37, // [37:55] is the sub-list for method output_type
	19, // [19:37] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_google_cloud_visionai_v1_lva_service_proto_init() }
func file_google_cloud_visionai_v1_lva_service_proto_init() {
	if File_google_cloud_visionai_v1_lva_service_proto != nil {
		return
	}
	file_google_cloud_visionai_v1_common_proto_init()
	file_google_cloud_visionai_v1_lva_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOperatorsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOperatorsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetOperatorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateOperatorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateOperatorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteOperatorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAnalysesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAnalysesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAnalysisRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAnalysisRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAnalysisRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAnalysisRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProcessesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListProcessesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetProcessRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateProcessRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateProcessRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteProcessRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchRunProcessRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchRunProcessResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResolveOperatorInfoRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperatorQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResolveOperatorInfoResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPublicOperatorsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPublicOperatorsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_visionai_v1_lva_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchRunProcessRequest_BatchRunProcessOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_visionai_v1_lva_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   26,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_visionai_v1_lva_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_visionai_v1_lva_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_visionai_v1_lva_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_visionai_v1_lva_service_proto_msgTypes,
	}.Build()
	File_google_cloud_visionai_v1_lva_service_proto = out.File
	file_google_cloud_visionai_v1_lva_service_proto_rawDesc = nil
	file_google_cloud_visionai_v1_lva_service_proto_goTypes = nil
	file_google_cloud_visionai_v1_lva_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// LiveVideoAnalyticsClient is the client API for LiveVideoAnalytics service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type LiveVideoAnalyticsClient interface {
	// ListPublicOperators returns all the operators in public registry.
	ListPublicOperators(ctx context.Context, in *ListPublicOperatorsRequest, opts ...grpc.CallOption) (*ListPublicOperatorsResponse, error)
	// ResolveOperatorInfo returns the operator information based on the request.
	ResolveOperatorInfo(ctx context.Context, in *ResolveOperatorInfoRequest, opts ...grpc.CallOption) (*ResolveOperatorInfoResponse, error)
	// Lists Operators in a given project and location.
	ListOperators(ctx context.Context, in *ListOperatorsRequest, opts ...grpc.CallOption) (*ListOperatorsResponse, error)
	// Gets details of a single Operator.
	GetOperator(ctx context.Context, in *GetOperatorRequest, opts ...grpc.CallOption) (*Operator, error)
	// Creates a new Operator in a given project and location.
	CreateOperator(ctx context.Context, in *CreateOperatorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Operator.
	UpdateOperator(ctx context.Context, in *UpdateOperatorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Operator.
	DeleteOperator(ctx context.Context, in *DeleteOperatorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists Analyses in a given project and location.
	ListAnalyses(ctx context.Context, in *ListAnalysesRequest, opts ...grpc.CallOption) (*ListAnalysesResponse, error)
	// Gets details of a single Analysis.
	GetAnalysis(ctx context.Context, in *GetAnalysisRequest, opts ...grpc.CallOption) (*Analysis, error)
	// Creates a new Analysis in a given project and location.
	CreateAnalysis(ctx context.Context, in *CreateAnalysisRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Analysis.
	UpdateAnalysis(ctx context.Context, in *UpdateAnalysisRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Analysis.
	DeleteAnalysis(ctx context.Context, in *DeleteAnalysisRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists Processes in a given project and location.
	ListProcesses(ctx context.Context, in *ListProcessesRequest, opts ...grpc.CallOption) (*ListProcessesResponse, error)
	// Gets details of a single Process.
	GetProcess(ctx context.Context, in *GetProcessRequest, opts ...grpc.CallOption) (*Process, error)
	// Creates a new Process in a given project and location.
	CreateProcess(ctx context.Context, in *CreateProcessRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Process.
	UpdateProcess(ctx context.Context, in *UpdateProcessRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Process.
	DeleteProcess(ctx context.Context, in *DeleteProcessRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Run all of the processes to "completion". Max time for each process is
	// the LRO time limit.
	BatchRunProcess(ctx context.Context, in *BatchRunProcessRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type liveVideoAnalyticsClient struct {
	cc grpc.ClientConnInterface
}

func NewLiveVideoAnalyticsClient(cc grpc.ClientConnInterface) LiveVideoAnalyticsClient {
	return &liveVideoAnalyticsClient{cc}
}

func (c *liveVideoAnalyticsClient) ListPublicOperators(ctx context.Context, in *ListPublicOperatorsRequest, opts ...grpc.CallOption) (*ListPublicOperatorsResponse, error) {
	out := new(ListPublicOperatorsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.LiveVideoAnalytics/ListPublicOperators", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoAnalyticsClient) ResolveOperatorInfo(ctx context.Context, in *ResolveOperatorInfoRequest, opts ...grpc.CallOption) (*ResolveOperatorInfoResponse, error) {
	out := new(ResolveOperatorInfoResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.LiveVideoAnalytics/ResolveOperatorInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoAnalyticsClient) ListOperators(ctx context.Context, in *ListOperatorsRequest, opts ...grpc.CallOption) (*ListOperatorsResponse, error) {
	out := new(ListOperatorsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.LiveVideoAnalytics/ListOperators", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoAnalyticsClient) GetOperator(ctx context.Context, in *GetOperatorRequest, opts ...grpc.CallOption) (*Operator, error) {
	out := new(Operator)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.LiveVideoAnalytics/GetOperator", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoAnalyticsClient) CreateOperator(ctx context.Context, in *CreateOperatorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.LiveVideoAnalytics/CreateOperator", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoAnalyticsClient) UpdateOperator(ctx context.Context, in *UpdateOperatorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.LiveVideoAnalytics/UpdateOperator", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoAnalyticsClient) DeleteOperator(ctx context.Context, in *DeleteOperatorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.LiveVideoAnalytics/DeleteOperator", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoAnalyticsClient) ListAnalyses(ctx context.Context, in *ListAnalysesRequest, opts ...grpc.CallOption) (*ListAnalysesResponse, error) {
	out := new(ListAnalysesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.LiveVideoAnalytics/ListAnalyses", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoAnalyticsClient) GetAnalysis(ctx context.Context, in *GetAnalysisRequest, opts ...grpc.CallOption) (*Analysis, error) {
	out := new(Analysis)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.LiveVideoAnalytics/GetAnalysis", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoAnalyticsClient) CreateAnalysis(ctx context.Context, in *CreateAnalysisRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.LiveVideoAnalytics/CreateAnalysis", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoAnalyticsClient) UpdateAnalysis(ctx context.Context, in *UpdateAnalysisRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.LiveVideoAnalytics/UpdateAnalysis", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoAnalyticsClient) DeleteAnalysis(ctx context.Context, in *DeleteAnalysisRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.LiveVideoAnalytics/DeleteAnalysis", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoAnalyticsClient) ListProcesses(ctx context.Context, in *ListProcessesRequest, opts ...grpc.CallOption) (*ListProcessesResponse, error) {
	out := new(ListProcessesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.LiveVideoAnalytics/ListProcesses", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoAnalyticsClient) GetProcess(ctx context.Context, in *GetProcessRequest, opts ...grpc.CallOption) (*Process, error) {
	out := new(Process)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.LiveVideoAnalytics/GetProcess", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoAnalyticsClient) CreateProcess(ctx context.Context, in *CreateProcessRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.LiveVideoAnalytics/CreateProcess", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoAnalyticsClient) UpdateProcess(ctx context.Context, in *UpdateProcessRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.LiveVideoAnalytics/UpdateProcess", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoAnalyticsClient) DeleteProcess(ctx context.Context, in *DeleteProcessRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.LiveVideoAnalytics/DeleteProcess", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *liveVideoAnalyticsClient) BatchRunProcess(ctx context.Context, in *BatchRunProcessRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.visionai.v1.LiveVideoAnalytics/BatchRunProcess", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LiveVideoAnalyticsServer is the server API for LiveVideoAnalytics service.
type LiveVideoAnalyticsServer interface {
	// ListPublicOperators returns all the operators in public registry.
	ListPublicOperators(context.Context, *ListPublicOperatorsRequest) (*ListPublicOperatorsResponse, error)
	// ResolveOperatorInfo returns the operator information based on the request.
	ResolveOperatorInfo(context.Context, *ResolveOperatorInfoRequest) (*ResolveOperatorInfoResponse, error)
	// Lists Operators in a given project and location.
	ListOperators(context.Context, *ListOperatorsRequest) (*ListOperatorsResponse, error)
	// Gets details of a single Operator.
	GetOperator(context.Context, *GetOperatorRequest) (*Operator, error)
	// Creates a new Operator in a given project and location.
	CreateOperator(context.Context, *CreateOperatorRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Operator.
	UpdateOperator(context.Context, *UpdateOperatorRequest) (*longrunningpb.Operation, error)
	// Deletes a single Operator.
	DeleteOperator(context.Context, *DeleteOperatorRequest) (*longrunningpb.Operation, error)
	// Lists Analyses in a given project and location.
	ListAnalyses(context.Context, *ListAnalysesRequest) (*ListAnalysesResponse, error)
	// Gets details of a single Analysis.
	GetAnalysis(context.Context, *GetAnalysisRequest) (*Analysis, error)
	// Creates a new Analysis in a given project and location.
	CreateAnalysis(context.Context, *CreateAnalysisRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Analysis.
	UpdateAnalysis(context.Context, *UpdateAnalysisRequest) (*longrunningpb.Operation, error)
	// Deletes a single Analysis.
	DeleteAnalysis(context.Context, *DeleteAnalysisRequest) (*longrunningpb.Operation, error)
	// Lists Processes in a given project and location.
	ListProcesses(context.Context, *ListProcessesRequest) (*ListProcessesResponse, error)
	// Gets details of a single Process.
	GetProcess(context.Context, *GetProcessRequest) (*Process, error)
	// Creates a new Process in a given project and location.
	CreateProcess(context.Context, *CreateProcessRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Process.
	UpdateProcess(context.Context, *UpdateProcessRequest) (*longrunningpb.Operation, error)
	// Deletes a single Process.
	DeleteProcess(context.Context, *DeleteProcessRequest) (*longrunningpb.Operation, error)
	// Run all of the processes to "completion". Max time for each process is
	// the LRO time limit.
	BatchRunProcess(context.Context, *BatchRunProcessRequest) (*longrunningpb.Operation, error)
}

// UnimplementedLiveVideoAnalyticsServer can be embedded to have forward compatible implementations.
type UnimplementedLiveVideoAnalyticsServer struct {
}

func (*UnimplementedLiveVideoAnalyticsServer) ListPublicOperators(context.Context, *ListPublicOperatorsRequest) (*ListPublicOperatorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPublicOperators not implemented")
}
func (*UnimplementedLiveVideoAnalyticsServer) ResolveOperatorInfo(context.Context, *ResolveOperatorInfoRequest) (*ResolveOperatorInfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResolveOperatorInfo not implemented")
}
func (*UnimplementedLiveVideoAnalyticsServer) ListOperators(context.Context, *ListOperatorsRequest) (*ListOperatorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOperators not implemented")
}
func (*UnimplementedLiveVideoAnalyticsServer) GetOperator(context.Context, *GetOperatorRequest) (*Operator, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOperator not implemented")
}
func (*UnimplementedLiveVideoAnalyticsServer) CreateOperator(context.Context, *CreateOperatorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateOperator not implemented")
}
func (*UnimplementedLiveVideoAnalyticsServer) UpdateOperator(context.Context, *UpdateOperatorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateOperator not implemented")
}
func (*UnimplementedLiveVideoAnalyticsServer) DeleteOperator(context.Context, *DeleteOperatorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteOperator not implemented")
}
func (*UnimplementedLiveVideoAnalyticsServer) ListAnalyses(context.Context, *ListAnalysesRequest) (*ListAnalysesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAnalyses not implemented")
}
func (*UnimplementedLiveVideoAnalyticsServer) GetAnalysis(context.Context, *GetAnalysisRequest) (*Analysis, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAnalysis not implemented")
}
func (*UnimplementedLiveVideoAnalyticsServer) CreateAnalysis(context.Context, *CreateAnalysisRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAnalysis not implemented")
}
func (*UnimplementedLiveVideoAnalyticsServer) UpdateAnalysis(context.Context, *UpdateAnalysisRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAnalysis not implemented")
}
func (*UnimplementedLiveVideoAnalyticsServer) DeleteAnalysis(context.Context, *DeleteAnalysisRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAnalysis not implemented")
}
func (*UnimplementedLiveVideoAnalyticsServer) ListProcesses(context.Context, *ListProcessesRequest) (*ListProcessesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProcesses not implemented")
}
func (*UnimplementedLiveVideoAnalyticsServer) GetProcess(context.Context, *GetProcessRequest) (*Process, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProcess not implemented")
}
func (*UnimplementedLiveVideoAnalyticsServer) CreateProcess(context.Context, *CreateProcessRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateProcess not implemented")
}
func (*UnimplementedLiveVideoAnalyticsServer) UpdateProcess(context.Context, *UpdateProcessRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProcess not implemented")
}
func (*UnimplementedLiveVideoAnalyticsServer) DeleteProcess(context.Context, *DeleteProcessRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProcess not implemented")
}
func (*UnimplementedLiveVideoAnalyticsServer) BatchRunProcess(context.Context, *BatchRunProcessRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchRunProcess not implemented")
}

func RegisterLiveVideoAnalyticsServer(s *grpc.Server, srv LiveVideoAnalyticsServer) {
	s.RegisterService(&_LiveVideoAnalytics_serviceDesc, srv)
}

func _LiveVideoAnalytics_ListPublicOperators_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPublicOperatorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LiveVideoAnalyticsServer).ListPublicOperators(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.LiveVideoAnalytics/ListPublicOperators",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LiveVideoAnalyticsServer).ListPublicOperators(ctx, req.(*ListPublicOperatorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LiveVideoAnalytics_ResolveOperatorInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResolveOperatorInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LiveVideoAnalyticsServer).ResolveOperatorInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.LiveVideoAnalytics/ResolveOperatorInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LiveVideoAnalyticsServer).ResolveOperatorInfo(ctx, req.(*ResolveOperatorInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LiveVideoAnalytics_ListOperators_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOperatorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LiveVideoAnalyticsServer).ListOperators(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.LiveVideoAnalytics/ListOperators",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LiveVideoAnalyticsServer).ListOperators(ctx, req.(*ListOperatorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LiveVideoAnalytics_GetOperator_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOperatorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LiveVideoAnalyticsServer).GetOperator(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.LiveVideoAnalytics/GetOperator",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LiveVideoAnalyticsServer).GetOperator(ctx, req.(*GetOperatorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LiveVideoAnalytics_CreateOperator_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateOperatorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LiveVideoAnalyticsServer).CreateOperator(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.LiveVideoAnalytics/CreateOperator",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LiveVideoAnalyticsServer).CreateOperator(ctx, req.(*CreateOperatorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LiveVideoAnalytics_UpdateOperator_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateOperatorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LiveVideoAnalyticsServer).UpdateOperator(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.LiveVideoAnalytics/UpdateOperator",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LiveVideoAnalyticsServer).UpdateOperator(ctx, req.(*UpdateOperatorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LiveVideoAnalytics_DeleteOperator_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteOperatorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LiveVideoAnalyticsServer).DeleteOperator(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.LiveVideoAnalytics/DeleteOperator",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LiveVideoAnalyticsServer).DeleteOperator(ctx, req.(*DeleteOperatorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LiveVideoAnalytics_ListAnalyses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnalysesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LiveVideoAnalyticsServer).ListAnalyses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.LiveVideoAnalytics/ListAnalyses",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LiveVideoAnalyticsServer).ListAnalyses(ctx, req.(*ListAnalysesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LiveVideoAnalytics_GetAnalysis_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnalysisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LiveVideoAnalyticsServer).GetAnalysis(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.LiveVideoAnalytics/GetAnalysis",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LiveVideoAnalyticsServer).GetAnalysis(ctx, req.(*GetAnalysisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LiveVideoAnalytics_CreateAnalysis_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnalysisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LiveVideoAnalyticsServer).CreateAnalysis(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.LiveVideoAnalytics/CreateAnalysis",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LiveVideoAnalyticsServer).CreateAnalysis(ctx, req.(*CreateAnalysisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LiveVideoAnalytics_UpdateAnalysis_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAnalysisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LiveVideoAnalyticsServer).UpdateAnalysis(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.LiveVideoAnalytics/UpdateAnalysis",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LiveVideoAnalyticsServer).UpdateAnalysis(ctx, req.(*UpdateAnalysisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LiveVideoAnalytics_DeleteAnalysis_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAnalysisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LiveVideoAnalyticsServer).DeleteAnalysis(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.LiveVideoAnalytics/DeleteAnalysis",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LiveVideoAnalyticsServer).DeleteAnalysis(ctx, req.(*DeleteAnalysisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LiveVideoAnalytics_ListProcesses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProcessesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LiveVideoAnalyticsServer).ListProcesses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.LiveVideoAnalytics/ListProcesses",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LiveVideoAnalyticsServer).ListProcesses(ctx, req.(*ListProcessesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LiveVideoAnalytics_GetProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LiveVideoAnalyticsServer).GetProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.LiveVideoAnalytics/GetProcess",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LiveVideoAnalyticsServer).GetProcess(ctx, req.(*GetProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LiveVideoAnalytics_CreateProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LiveVideoAnalyticsServer).CreateProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.LiveVideoAnalytics/CreateProcess",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LiveVideoAnalyticsServer).CreateProcess(ctx, req.(*CreateProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LiveVideoAnalytics_UpdateProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LiveVideoAnalyticsServer).UpdateProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.LiveVideoAnalytics/UpdateProcess",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LiveVideoAnalyticsServer).UpdateProcess(ctx, req.(*UpdateProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LiveVideoAnalytics_DeleteProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LiveVideoAnalyticsServer).DeleteProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.LiveVideoAnalytics/DeleteProcess",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LiveVideoAnalyticsServer).DeleteProcess(ctx, req.(*DeleteProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LiveVideoAnalytics_BatchRunProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchRunProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LiveVideoAnalyticsServer).BatchRunProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.visionai.v1.LiveVideoAnalytics/BatchRunProcess",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LiveVideoAnalyticsServer).BatchRunProcess(ctx, req.(*BatchRunProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LiveVideoAnalytics_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.visionai.v1.LiveVideoAnalytics",
	HandlerType: (*LiveVideoAnalyticsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListPublicOperators",
			Handler:    _LiveVideoAnalytics_ListPublicOperators_Handler,
		},
		{
			MethodName: "ResolveOperatorInfo",
			Handler:    _LiveVideoAnalytics_ResolveOperatorInfo_Handler,
		},
		{
			MethodName: "ListOperators",
			Handler:    _LiveVideoAnalytics_ListOperators_Handler,
		},
		{
			MethodName: "GetOperator",
			Handler:    _LiveVideoAnalytics_GetOperator_Handler,
		},
		{
			MethodName: "CreateOperator",
			Handler:    _LiveVideoAnalytics_CreateOperator_Handler,
		},
		{
			MethodName: "UpdateOperator",
			Handler:    _LiveVideoAnalytics_UpdateOperator_Handler,
		},
		{
			MethodName: "DeleteOperator",
			Handler:    _LiveVideoAnalytics_DeleteOperator_Handler,
		},
		{
			MethodName: "ListAnalyses",
			Handler:    _LiveVideoAnalytics_ListAnalyses_Handler,
		},
		{
			MethodName: "GetAnalysis",
			Handler:    _LiveVideoAnalytics_GetAnalysis_Handler,
		},
		{
			MethodName: "CreateAnalysis",
			Handler:    _LiveVideoAnalytics_CreateAnalysis_Handler,
		},
		{
			MethodName: "UpdateAnalysis",
			Handler:    _LiveVideoAnalytics_UpdateAnalysis_Handler,
		},
		{
			MethodName: "DeleteAnalysis",
			Handler:    _LiveVideoAnalytics_DeleteAnalysis_Handler,
		},
		{
			MethodName: "ListProcesses",
			Handler:    _LiveVideoAnalytics_ListProcesses_Handler,
		},
		{
			MethodName: "GetProcess",
			Handler:    _LiveVideoAnalytics_GetProcess_Handler,
		},
		{
			MethodName: "CreateProcess",
			Handler:    _LiveVideoAnalytics_CreateProcess_Handler,
		},
		{
			MethodName: "UpdateProcess",
			Handler:    _LiveVideoAnalytics_UpdateProcess_Handler,
		},
		{
			MethodName: "DeleteProcess",
			Handler:    _LiveVideoAnalytics_DeleteProcess_Handler,
		},
		{
			MethodName: "BatchRunProcess",
			Handler:    _LiveVideoAnalytics_BatchRunProcess_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/visionai/v1/lva_service.proto",
}
