//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsql_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentRuleBaselineGet.json
func ExampleManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient().Get(ctx, "vulnerabilityaseessmenttest-4711", "vulnerabilityaseessmenttest-6411", "testdb", armsql.VulnerabilityAssessmentNameDefault, "VA1001", armsql.VulnerabilityAssessmentPolicyBaselineNameMaster, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseVulnerabilityAssessmentRuleBaseline = armsql.DatabaseVulnerabilityAssessmentRuleBaseline{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/databases/vulnerabilityAssessments/rules/baselines"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/managedInstances/vulnerabilityaseessmenttest-6440/databases/testdb/vulnerabilityAssessments/default/rules/VA1001/baselines/default"),
	// 	Properties: &armsql.DatabaseVulnerabilityAssessmentRuleBaselineProperties{
	// 		BaselineResults: []*armsql.DatabaseVulnerabilityAssessmentRuleBaselineItem{
	// 			{
	// 				Result: []*string{
	// 					to.Ptr("userA"),
	// 					to.Ptr("SELECT")},
	// 				},
	// 				{
	// 					Result: []*string{
	// 						to.Ptr("userB"),
	// 						to.Ptr("SELECT")},
	// 					},
	// 					{
	// 						Result: []*string{
	// 							to.Ptr("userC"),
	// 							to.Ptr("SELECT"),
	// 							to.Ptr("tableId_4")},
	// 					}},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentRuleBaselineCreate.json
func ExampleManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient().CreateOrUpdate(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", "testdb", armsql.VulnerabilityAssessmentNameDefault, "VA1001", armsql.VulnerabilityAssessmentPolicyBaselineNameDefault, armsql.DatabaseVulnerabilityAssessmentRuleBaseline{
		Properties: &armsql.DatabaseVulnerabilityAssessmentRuleBaselineProperties{
			BaselineResults: []*armsql.DatabaseVulnerabilityAssessmentRuleBaselineItem{
				{
					Result: []*string{
						to.Ptr("userA"),
						to.Ptr("SELECT")},
				},
				{
					Result: []*string{
						to.Ptr("userB"),
						to.Ptr("SELECT")},
				},
				{
					Result: []*string{
						to.Ptr("userC"),
						to.Ptr("SELECT"),
						to.Ptr("tableId_4")},
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseVulnerabilityAssessmentRuleBaseline = armsql.DatabaseVulnerabilityAssessmentRuleBaseline{
	// 	Name: to.Ptr("default"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/databases/vulnerabilityAssessments/rules/baselines"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityaseessmenttest-4799/providers/Microsoft.Sql/managedInstances/vulnerabilityaseessmenttest-6440/databases/testdb/vulnerabilityAssessments/default/rules/VA1001/baselines/default"),
	// 	Properties: &armsql.DatabaseVulnerabilityAssessmentRuleBaselineProperties{
	// 		BaselineResults: []*armsql.DatabaseVulnerabilityAssessmentRuleBaselineItem{
	// 			{
	// 				Result: []*string{
	// 					to.Ptr("userA"),
	// 					to.Ptr("SELECT")},
	// 				},
	// 				{
	// 					Result: []*string{
	// 						to.Ptr("userB"),
	// 						to.Ptr("SELECT")},
	// 					},
	// 					{
	// 						Result: []*string{
	// 							to.Ptr("userC"),
	// 							to.Ptr("SELECT"),
	// 							to.Ptr("tableId_4")},
	// 					}},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/ManagedDatabaseVulnerabilityAssessmentRuleBaselineDelete.json
func ExampleManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient().Delete(ctx, "vulnerabilityaseessmenttest-4799", "vulnerabilityaseessmenttest-6440", "testdb", armsql.VulnerabilityAssessmentNameDefault, "VA1001", armsql.VulnerabilityAssessmentPolicyBaselineNameDefault, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
