//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armservicefabricmesh

import "time"

// AddRemoveReplicaScalingMechanism - Describes the horizontal auto scaling mechanism that adds or removes replicas (containers
// or container groups).
type AddRemoveReplicaScalingMechanism struct {
	// REQUIRED; The type of auto scaling mechanism.
	Kind *AutoScalingMechanismKind

	// REQUIRED; Maximum number of containers (scale up won't be performed above this number).
	MaxCount *int32

	// REQUIRED; Minimum number of containers (scale down won't be performed below this number).
	MinCount *int32

	// REQUIRED; Each time auto scaling is performed, this number of containers will be added or removed.
	ScaleIncrement *int32
}

// GetAutoScalingMechanism implements the AutoScalingMechanismClassification interface for type AddRemoveReplicaScalingMechanism.
func (a *AddRemoveReplicaScalingMechanism) GetAutoScalingMechanism() *AutoScalingMechanism {
	return &AutoScalingMechanism{
		Kind: a.Kind,
	}
}

// ApplicationClientCreateOptions contains the optional parameters for the ApplicationClient.Create method.
type ApplicationClientCreateOptions struct {
	// placeholder for future optional parameters
}

// ApplicationClientDeleteOptions contains the optional parameters for the ApplicationClient.Delete method.
type ApplicationClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ApplicationClientGetOptions contains the optional parameters for the ApplicationClient.Get method.
type ApplicationClientGetOptions struct {
	// placeholder for future optional parameters
}

// ApplicationClientListByResourceGroupOptions contains the optional parameters for the ApplicationClient.NewListByResourceGroupPager
// method.
type ApplicationClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ApplicationClientListBySubscriptionOptions contains the optional parameters for the ApplicationClient.NewListBySubscriptionPager
// method.
type ApplicationClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ApplicationProperties - Describes properties of a application resource.
type ApplicationProperties struct {
	// Internal - used by Visual Studio to setup the debugging session on the local development environment.
	DebugParams *string

	// User readable description of the application.
	Description *string

	// Describes the diagnostics definition and usage for an application resource.
	Diagnostics *DiagnosticsDescription

	// Describes the services in the application. This property is used to create or modify services of the application. On get
	// only the name of the service is returned. The service description can be
	// obtained by querying for the service resource.
	Services []*ServiceResourceDescription

	// READ-ONLY; Describes the health state of an application resource.
	HealthState *HealthState

	// READ-ONLY; Names of the services in the application.
	ServiceNames []*string

	// READ-ONLY; Status of the application.
	Status *ResourceStatus

	// READ-ONLY; Gives additional information about the current status of the application.
	StatusDetails *string

	// READ-ONLY; When the application's health state is not 'Ok', this additional details from service fabric Health Manager
	// for the user to know why the application is marked unhealthy.
	UnhealthyEvaluation *string
}

// ApplicationResourceDescription - This type describes an application resource.
type ApplicationResourceDescription struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; This type describes properties of an application resource.
	Properties *ApplicationResourceProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// ApplicationResourceDescriptionList - A pageable list of application resources.
type ApplicationResourceDescriptionList struct {
	// URI to fetch the next page of the list.
	NextLink *string

	// One page of the list.
	Value []*ApplicationResourceDescription
}

// ApplicationResourceProperties - This type describes properties of an application resource.
type ApplicationResourceProperties struct {
	// Internal - used by Visual Studio to setup the debugging session on the local development environment.
	DebugParams *string

	// User readable description of the application.
	Description *string

	// Describes the diagnostics definition and usage for an application resource.
	Diagnostics *DiagnosticsDescription

	// Describes the services in the application. This property is used to create or modify services of the application. On get
	// only the name of the service is returned. The service description can be
	// obtained by querying for the service resource.
	Services []*ServiceResourceDescription

	// READ-ONLY; Describes the health state of an application resource.
	HealthState *HealthState

	// READ-ONLY; State of the resource.
	ProvisioningState *string

	// READ-ONLY; Names of the services in the application.
	ServiceNames []*string

	// READ-ONLY; Status of the application.
	Status *ResourceStatus

	// READ-ONLY; Gives additional information about the current status of the application.
	StatusDetails *string

	// READ-ONLY; When the application's health state is not 'Ok', this additional details from service fabric Health Manager
	// for the user to know why the application is marked unhealthy.
	UnhealthyEvaluation *string
}

// ApplicationScopedVolume - Describes a volume whose lifetime is scoped to the application's lifetime.
type ApplicationScopedVolume struct {
	// REQUIRED; Describes parameters for creating application-scoped volumes.
	CreationParameters ApplicationScopedVolumeCreationParametersClassification

	// REQUIRED; The path within the container at which the volume should be mounted. Only valid path characters are allowed.
	DestinationPath *string

	// REQUIRED; Name of the volume being referenced.
	Name *string

	// The flag indicating whether the volume is read only. Default is 'false'.
	ReadOnly *bool
}

// ApplicationScopedVolumeCreationParametersClassification provides polymorphic access to related types.
// Call the interface's GetApplicationScopedVolumeCreationParameters() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ApplicationScopedVolumeCreationParameters, *ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk
type ApplicationScopedVolumeCreationParametersClassification interface {
	// GetApplicationScopedVolumeCreationParameters returns the ApplicationScopedVolumeCreationParameters content of the underlying type.
	GetApplicationScopedVolumeCreationParameters() *ApplicationScopedVolumeCreationParameters
}

// ApplicationScopedVolumeCreationParameters - Describes parameters for creating application-scoped volumes.
type ApplicationScopedVolumeCreationParameters struct {
	// REQUIRED; Specifies the application-scoped volume kind.
	Kind *ApplicationScopedVolumeKind

	// User readable description of the volume.
	Description *string
}

// GetApplicationScopedVolumeCreationParameters implements the ApplicationScopedVolumeCreationParametersClassification interface
// for type ApplicationScopedVolumeCreationParameters.
func (a *ApplicationScopedVolumeCreationParameters) GetApplicationScopedVolumeCreationParameters() *ApplicationScopedVolumeCreationParameters {
	return a
}

// ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk - Describes parameters for creating application-scoped
// volumes provided by Service Fabric Volume Disks
type ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk struct {
	// REQUIRED; Specifies the application-scoped volume kind.
	Kind *ApplicationScopedVolumeKind

	// REQUIRED; Volume size
	SizeDisk *SizeTypes

	// User readable description of the volume.
	Description *string
}

// GetApplicationScopedVolumeCreationParameters implements the ApplicationScopedVolumeCreationParametersClassification interface
// for type ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk.
func (a *ApplicationScopedVolumeCreationParametersServiceFabricVolumeDisk) GetApplicationScopedVolumeCreationParameters() *ApplicationScopedVolumeCreationParameters {
	return &ApplicationScopedVolumeCreationParameters{
		Kind:        a.Kind,
		Description: a.Description,
	}
}

// AutoScalingMechanismClassification provides polymorphic access to related types.
// Call the interface's GetAutoScalingMechanism() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AddRemoveReplicaScalingMechanism, *AutoScalingMechanism
type AutoScalingMechanismClassification interface {
	// GetAutoScalingMechanism returns the AutoScalingMechanism content of the underlying type.
	GetAutoScalingMechanism() *AutoScalingMechanism
}

// AutoScalingMechanism - Describes the mechanism for performing auto scaling operation. Derived classes will describe the
// actual mechanism.
type AutoScalingMechanism struct {
	// REQUIRED; The type of auto scaling mechanism.
	Kind *AutoScalingMechanismKind
}

// GetAutoScalingMechanism implements the AutoScalingMechanismClassification interface for type AutoScalingMechanism.
func (a *AutoScalingMechanism) GetAutoScalingMechanism() *AutoScalingMechanism { return a }

// AutoScalingMetricClassification provides polymorphic access to related types.
// Call the interface's GetAutoScalingMetric() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AutoScalingMetric, *AutoScalingResourceMetric
type AutoScalingMetricClassification interface {
	// GetAutoScalingMetric returns the AutoScalingMetric content of the underlying type.
	GetAutoScalingMetric() *AutoScalingMetric
}

// AutoScalingMetric - Describes the metric that is used for triggering auto scaling operation. Derived classes will describe
// resources or metrics.
type AutoScalingMetric struct {
	// REQUIRED; The type of auto scaling metric
	Kind *AutoScalingMetricKind
}

// GetAutoScalingMetric implements the AutoScalingMetricClassification interface for type AutoScalingMetric.
func (a *AutoScalingMetric) GetAutoScalingMetric() *AutoScalingMetric { return a }

// AutoScalingPolicy - Describes the auto scaling policy
type AutoScalingPolicy struct {
	// REQUIRED; The mechanism that is used to scale when auto scaling operation is invoked.
	Mechanism AutoScalingMechanismClassification

	// REQUIRED; The name of the auto scaling policy.
	Name *string

	// REQUIRED; Determines when auto scaling operation will be invoked.
	Trigger AutoScalingTriggerClassification
}

// AutoScalingResourceMetric - Describes the resource that is used for triggering auto scaling.
type AutoScalingResourceMetric struct {
	// REQUIRED; The type of auto scaling metric
	Kind *AutoScalingMetricKind

	// REQUIRED; Name of the resource.
	Name *AutoScalingResourceMetricName
}

// GetAutoScalingMetric implements the AutoScalingMetricClassification interface for type AutoScalingResourceMetric.
func (a *AutoScalingResourceMetric) GetAutoScalingMetric() *AutoScalingMetric {
	return &AutoScalingMetric{
		Kind: a.Kind,
	}
}

// AutoScalingTriggerClassification provides polymorphic access to related types.
// Call the interface's GetAutoScalingTrigger() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AutoScalingTrigger, *AverageLoadScalingTrigger
type AutoScalingTriggerClassification interface {
	// GetAutoScalingTrigger returns the AutoScalingTrigger content of the underlying type.
	GetAutoScalingTrigger() *AutoScalingTrigger
}

// AutoScalingTrigger - Describes the trigger for performing auto scaling operation.
type AutoScalingTrigger struct {
	// REQUIRED; The type of auto scaling trigger
	Kind *AutoScalingTriggerKind
}

// GetAutoScalingTrigger implements the AutoScalingTriggerClassification interface for type AutoScalingTrigger.
func (a *AutoScalingTrigger) GetAutoScalingTrigger() *AutoScalingTrigger { return a }

// AvailableOperationDisplay - An operation available at the listed Azure resource provider.
type AvailableOperationDisplay struct {
	// Description of the available operation.
	Description *string

	// Name of the available operation.
	Operation *string

	// Name of the operation provider.
	Provider *string

	// Name of the resource on which the operation is available.
	Resource *string
}

// AverageLoadScalingTrigger - Describes the average load trigger used for auto scaling.
type AverageLoadScalingTrigger struct {
	// REQUIRED; The type of auto scaling trigger
	Kind *AutoScalingTriggerKind

	// REQUIRED; Lower load threshold (if average load is below this threshold, service will scale down).
	LowerLoadThreshold *float64

	// REQUIRED; Description of the metric that is used for scaling.
	Metric AutoScalingMetricClassification

	// REQUIRED; Scale interval that indicates how often will this trigger be checked.
	ScaleIntervalInSeconds *int32

	// REQUIRED; Upper load threshold (if average load is above this threshold, service will scale up).
	UpperLoadThreshold *float64
}

// GetAutoScalingTrigger implements the AutoScalingTriggerClassification interface for type AverageLoadScalingTrigger.
func (a *AverageLoadScalingTrigger) GetAutoScalingTrigger() *AutoScalingTrigger {
	return &AutoScalingTrigger{
		Kind: a.Kind,
	}
}

// AzureInternalMonitoringPipelineSinkDescription - Diagnostics settings for Geneva.
type AzureInternalMonitoringPipelineSinkDescription struct {
	// REQUIRED; The kind of DiagnosticsSink.
	Kind *DiagnosticsSinkKind

	// Azure Internal monitoring pipeline account.
	AccountName *string

	// Azure Internal monitoring pipeline autokey associated with the certificate.
	AutoKeyConfigURL *string

	// A description of the sink.
	Description *string

	// Azure Internal monitoring agent fluentd configuration.
	FluentdConfigURL any

	// Azure Internal monitoring agent configuration.
	MaConfigURL *string

	// Name of the sink. This value is referenced by DiagnosticsReferenceDescription
	Name *string

	// Azure Internal monitoring pipeline account namespace.
	Namespace *string
}

// GetDiagnosticsSinkProperties implements the DiagnosticsSinkPropertiesClassification interface for type AzureInternalMonitoringPipelineSinkDescription.
func (a *AzureInternalMonitoringPipelineSinkDescription) GetDiagnosticsSinkProperties() *DiagnosticsSinkProperties {
	return &DiagnosticsSinkProperties{
		Kind:        a.Kind,
		Name:        a.Name,
		Description: a.Description,
	}
}

// CodePackageClientGetContainerLogsOptions contains the optional parameters for the CodePackageClient.GetContainerLogs method.
type CodePackageClientGetContainerLogsOptions struct {
	// Number of lines to show from the end of the logs. Default is 100.
	Tail *int32
}

// ContainerCodePackageProperties - Describes a container and its runtime properties.
type ContainerCodePackageProperties struct {
	// REQUIRED; The Container image to use.
	Image *string

	// REQUIRED; The name of the code package.
	Name *string

	// REQUIRED; The resources required by this container.
	Resources *ResourceRequirements

	// Command array to execute within the container in exec form.
	Commands []*string

	// Reference to sinks in DiagnosticsDescription.
	Diagnostics *DiagnosticsRef

	// The endpoints exposed by this container.
	Endpoints []*EndpointProperties

	// Override for the default entry point in the container.
	Entrypoint *string

	// The environment variables to set in this container
	EnvironmentVariables []*EnvironmentVariable

	// Image registry credential.
	ImageRegistryCredential *ImageRegistryCredential

	// The labels to set in this container.
	Labels []*ContainerLabel

	// A list of ReliableCollection resources used by this particular code package. Please refer to ReliableCollectionsRef for
	// more details.
	ReliableCollectionsRefs []*ReliableCollectionsRef

	// The settings to set in this container. The setting file path can be fetched from environment variable "Fabric_SettingPath".
	// The path for Windows container is "C:\secrets". The path for Linux container
	// is "/var/secrets".
	Settings []*Setting

	// Volumes to be attached to the container. The lifetime of these volumes is independent of the application's lifetime.
	VolumeRefs []*VolumeReference

	// Volumes to be attached to the container. The lifetime of these volumes is scoped to the application's lifetime.
	Volumes []*ApplicationScopedVolume

	// READ-ONLY; Runtime information of a container instance.
	InstanceView *ContainerInstanceView
}

// ContainerEvent - A container event.
type ContainerEvent struct {
	// The count of the event.
	Count *int32

	// Date/time of the first event.
	FirstTimestamp *string

	// Date/time of the last event.
	LastTimestamp *string

	// The event message
	Message *string

	// The name of the container event.
	Name *string

	// The event type.
	Type *string
}

// ContainerInstanceView - Runtime information of a container instance.
type ContainerInstanceView struct {
	// Current container instance state.
	CurrentState *ContainerState

	// The events of this container instance.
	Events []*ContainerEvent

	// Previous container instance state.
	PreviousState *ContainerState

	// The number of times the container has been restarted.
	RestartCount *int32
}

// ContainerLabel - Describes a container label.
type ContainerLabel struct {
	// REQUIRED; The name of the container label.
	Name *string

	// REQUIRED; The value of the container label.
	Value *string
}

// ContainerLogs - Container logs.
type ContainerLogs struct {
	// Container logs.
	Content *string
}

// ContainerState - The container state.
type ContainerState struct {
	// Human-readable status of this state.
	DetailStatus *string

	// The container exit code.
	ExitCode *string

	// Date/time when the container state finished.
	FinishTime *time.Time

	// Date/time when the container state started.
	StartTime *time.Time

	// The state of this container
	State *string
}

// DiagnosticsDescription - Describes the diagnostics options available
type DiagnosticsDescription struct {
	// The sinks to be used if diagnostics is enabled. Sink choices can be overridden at the service and code package level.
	DefaultSinkRefs []*string

	// Status of whether or not sinks are enabled.
	Enabled *bool

	// List of supported sinks that can be referenced.
	Sinks []DiagnosticsSinkPropertiesClassification
}

// DiagnosticsRef - Reference to sinks in DiagnosticsDescription.
type DiagnosticsRef struct {
	// Status of whether or not sinks are enabled.
	Enabled *bool

	// List of sinks to be used if enabled. References the list of sinks in DiagnosticsDescription.
	SinkRefs []*string
}

// DiagnosticsSinkPropertiesClassification provides polymorphic access to related types.
// Call the interface's GetDiagnosticsSinkProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureInternalMonitoringPipelineSinkDescription, *DiagnosticsSinkProperties
type DiagnosticsSinkPropertiesClassification interface {
	// GetDiagnosticsSinkProperties returns the DiagnosticsSinkProperties content of the underlying type.
	GetDiagnosticsSinkProperties() *DiagnosticsSinkProperties
}

// DiagnosticsSinkProperties - Properties of a DiagnosticsSink.
type DiagnosticsSinkProperties struct {
	// REQUIRED; The kind of DiagnosticsSink.
	Kind *DiagnosticsSinkKind

	// A description of the sink.
	Description *string

	// Name of the sink. This value is referenced by DiagnosticsReferenceDescription
	Name *string
}

// GetDiagnosticsSinkProperties implements the DiagnosticsSinkPropertiesClassification interface for type DiagnosticsSinkProperties.
func (d *DiagnosticsSinkProperties) GetDiagnosticsSinkProperties() *DiagnosticsSinkProperties {
	return d
}

// EndpointProperties - Describes a container endpoint.
type EndpointProperties struct {
	// REQUIRED; The name of the endpoint.
	Name *string

	// Port used by the container.
	Port *int32
}

// EndpointRef - Describes a reference to a service endpoint.
type EndpointRef struct {
	// Name of the endpoint.
	Name *string
}

// EnvironmentVariable - Describes an environment variable for the container.
type EnvironmentVariable struct {
	// The name of the environment variable.
	Name *string

	// The value of the environment variable.
	Value *string
}

// ErrorDetailsModel - Error model details information
type ErrorDetailsModel struct {
	// REQUIRED
	Code *string

	// REQUIRED; Error message.
	Message *string
}

// ErrorErrorModel - Error model information
type ErrorErrorModel struct {
	// REQUIRED
	Code *string

	// List of error message details.
	Details    []*ErrorDetailsModel
	InnerError *string

	// Error message.
	Message *string
}

// ErrorModel - The error details.
type ErrorModel struct {
	// REQUIRED; Error model information
	Error *ErrorErrorModel
}

// GatewayClientCreateOptions contains the optional parameters for the GatewayClient.Create method.
type GatewayClientCreateOptions struct {
	// placeholder for future optional parameters
}

// GatewayClientDeleteOptions contains the optional parameters for the GatewayClient.Delete method.
type GatewayClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GatewayClientGetOptions contains the optional parameters for the GatewayClient.Get method.
type GatewayClientGetOptions struct {
	// placeholder for future optional parameters
}

// GatewayClientListByResourceGroupOptions contains the optional parameters for the GatewayClient.NewListByResourceGroupPager
// method.
type GatewayClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// GatewayClientListBySubscriptionOptions contains the optional parameters for the GatewayClient.NewListBySubscriptionPager
// method.
type GatewayClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// GatewayDestination - Describes destination endpoint for routing traffic.
type GatewayDestination struct {
	// REQUIRED; Name of the service fabric Mesh application.
	ApplicationName *string

	// REQUIRED; name of the endpoint in the service.
	EndpointName *string

	// REQUIRED; service that contains the endpoint.
	ServiceName *string
}

// GatewayProperties - Describes properties of a gateway resource.
type GatewayProperties struct {
	// REQUIRED; Network that the Application is using.
	DestinationNetwork *NetworkRef

	// REQUIRED; Network the gateway should listen on for requests.
	SourceNetwork *NetworkRef

	// User readable description of the gateway.
	Description *string

	// Configuration for http connectivity for this gateway.
	HTTP []*HTTPConfig

	// Configuration for tcp connectivity for this gateway.
	TCP []*TCPConfig

	// READ-ONLY; IP address of the gateway. This is populated in the response and is ignored for incoming requests.
	IPAddress *string

	// READ-ONLY; Status of the resource.
	Status *ResourceStatus

	// READ-ONLY; Gives additional information about the current status of the gateway.
	StatusDetails *string
}

// GatewayResourceDescription - This type describes a gateway resource.
type GatewayResourceDescription struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; This type describes properties of a gateway resource.
	Properties *GatewayResourceProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// GatewayResourceDescriptionList - A pageable list of gateway resources.
type GatewayResourceDescriptionList struct {
	// URI to fetch the next page of the list.
	NextLink *string

	// One page of the list.
	Value []*GatewayResourceDescription
}

// GatewayResourceProperties - This type describes properties of a gateway resource.
type GatewayResourceProperties struct {
	// REQUIRED; Network that the Application is using.
	DestinationNetwork *NetworkRef

	// REQUIRED; Network the gateway should listen on for requests.
	SourceNetwork *NetworkRef

	// User readable description of the gateway.
	Description *string

	// Configuration for http connectivity for this gateway.
	HTTP []*HTTPConfig

	// Configuration for tcp connectivity for this gateway.
	TCP []*TCPConfig

	// READ-ONLY; IP address of the gateway. This is populated in the response and is ignored for incoming requests.
	IPAddress *string

	// READ-ONLY; State of the resource.
	ProvisioningState *string

	// READ-ONLY; Status of the resource.
	Status *ResourceStatus

	// READ-ONLY; Gives additional information about the current status of the gateway.
	StatusDetails *string
}

// HTTPConfig - Describes the http configuration for external connectivity for this network.
type HTTPConfig struct {
	// REQUIRED; description for routing.
	Hosts []*HTTPHostConfig

	// REQUIRED; http gateway config name.
	Name *string

	// REQUIRED; Specifies the port at which the service endpoint below needs to be exposed.
	Port *int32
}

// HTTPHostConfig - Describes the hostname properties for http routing.
type HTTPHostConfig struct {
	// REQUIRED; http hostname config name.
	Name *string

	// REQUIRED; Route information to use for routing. Routes are processed in the order they are specified. Specify routes that
	// are more specific before routes that can handle general cases.
	Routes []*HTTPRouteConfig
}

// HTTPRouteConfig - Describes the hostname properties for http routing.
type HTTPRouteConfig struct {
	// REQUIRED; Describes destination endpoint for routing traffic.
	Destination *GatewayDestination

	// REQUIRED; Describes a rule for http route matching.
	Match *HTTPRouteMatchRule

	// REQUIRED; http route name.
	Name *string
}

// HTTPRouteMatchHeader - Describes header information for http route matching.
type HTTPRouteMatchHeader struct {
	// REQUIRED; Name of header to match in request.
	Name *string

	// how to match header value
	Type *HeaderMatchType

	// Value of header to match in request.
	Value *string
}

// HTTPRouteMatchPath - Path to match for routing.
type HTTPRouteMatchPath struct {
	// REQUIRED; how to match value in the Uri
	Type *PathMatchType

	// REQUIRED; Uri path to match for request.
	Value *string

	// replacement string for matched part of the Uri.
	Rewrite *string
}

// HTTPRouteMatchRule - Describes a rule for http route matching.
type HTTPRouteMatchRule struct {
	// REQUIRED; Path to match for routing.
	Path *HTTPRouteMatchPath

	// headers and their values to match in request.
	Headers []*HTTPRouteMatchHeader
}

// ImageRegistryCredential - Image registry credential.
type ImageRegistryCredential struct {
	// REQUIRED; Docker image registry server, without protocol such as http and https.
	Server *string

	// REQUIRED; The username for the private registry.
	Username *string

	// The password for the private registry. The password is required for create or update operations, however it is not returned
	// in the get or list operations.
	Password *string
}

// InlinedValueSecretResourceProperties - Describes the properties of a secret resource whose value is provided explicitly
// as plaintext. The secret resource may have multiple values, each being uniquely versioned. The secret value of each
// version is stored encrypted, and delivered as plaintext into the context of applications referencing it.
type InlinedValueSecretResourceProperties struct {
	// REQUIRED; Describes the kind of secret.
	Kind *SecretKind

	// The type of the content stored in the secret value. The value of this property is opaque to Service Fabric. Once set, the
	// value of this property cannot be changed.
	ContentType *string

	// User readable description of the secret.
	Description *string

	// READ-ONLY; State of the resource.
	ProvisioningState *string

	// READ-ONLY; Status of the resource.
	Status *ResourceStatus

	// READ-ONLY; Gives additional information about the current status of the secret.
	StatusDetails *string
}

// GetSecretResourceProperties implements the SecretResourcePropertiesClassification interface for type InlinedValueSecretResourceProperties.
func (i *InlinedValueSecretResourceProperties) GetSecretResourceProperties() *SecretResourceProperties {
	return &SecretResourceProperties{
		Description:       i.Description,
		Status:            i.Status,
		StatusDetails:     i.StatusDetails,
		ContentType:       i.ContentType,
		Kind:              i.Kind,
		ProvisioningState: i.ProvisioningState,
	}
}

// GetSecretResourcePropertiesBase implements the SecretResourcePropertiesBaseClassification interface for type InlinedValueSecretResourceProperties.
func (i *InlinedValueSecretResourceProperties) GetSecretResourcePropertiesBase() *SecretResourcePropertiesBase {
	return &SecretResourcePropertiesBase{
		Kind:              i.Kind,
		ProvisioningState: i.ProvisioningState,
	}
}

// LocalNetworkResourceProperties - Information about a Service Fabric container network local to a single Service Fabric
// cluster.
type LocalNetworkResourceProperties struct {
	// REQUIRED; The type of a Service Fabric container network.
	Kind *NetworkKind

	// User readable description of the network.
	Description *string

	// Address space for the local container network.
	NetworkAddressPrefix *string

	// READ-ONLY; State of the resource.
	ProvisioningState *string

	// READ-ONLY; Status of the network.
	Status *ResourceStatus

	// READ-ONLY; Gives additional information about the current status of the network.
	StatusDetails *string
}

// GetNetworkResourceProperties implements the NetworkResourcePropertiesClassification interface for type LocalNetworkResourceProperties.
func (l *LocalNetworkResourceProperties) GetNetworkResourceProperties() *NetworkResourceProperties {
	return &NetworkResourceProperties{
		Description:       l.Description,
		Status:            l.Status,
		StatusDetails:     l.StatusDetails,
		Kind:              l.Kind,
		ProvisioningState: l.ProvisioningState,
	}
}

// GetNetworkResourcePropertiesBase implements the NetworkResourcePropertiesBaseClassification interface for type LocalNetworkResourceProperties.
func (l *LocalNetworkResourceProperties) GetNetworkResourcePropertiesBase() *NetworkResourcePropertiesBase {
	return &NetworkResourcePropertiesBase{
		Kind:              l.Kind,
		ProvisioningState: l.ProvisioningState,
	}
}

// ManagedProxyResource - The resource model definition for Azure Resource Manager proxy resource. It will have everything
// other than required location and tags. This proxy resource is explicitly created or updated by
// including it in the parent resource.
type ManagedProxyResource struct {
	// The name of the resource
	Name *string

	// READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// NetworkClientCreateOptions contains the optional parameters for the NetworkClient.Create method.
type NetworkClientCreateOptions struct {
	// placeholder for future optional parameters
}

// NetworkClientDeleteOptions contains the optional parameters for the NetworkClient.Delete method.
type NetworkClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// NetworkClientGetOptions contains the optional parameters for the NetworkClient.Get method.
type NetworkClientGetOptions struct {
	// placeholder for future optional parameters
}

// NetworkClientListByResourceGroupOptions contains the optional parameters for the NetworkClient.NewListByResourceGroupPager
// method.
type NetworkClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// NetworkClientListBySubscriptionOptions contains the optional parameters for the NetworkClient.NewListBySubscriptionPager
// method.
type NetworkClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// NetworkRef - Describes a network reference in a service.
type NetworkRef struct {
	// A list of endpoints that are exposed on this network.
	EndpointRefs []*EndpointRef

	// Name of the network
	Name *string
}

// NetworkResourceDescription - This type describes a network resource.
type NetworkResourceDescription struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Describes properties of a network resource.
	Properties NetworkResourcePropertiesClassification

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// NetworkResourceDescriptionList - A pageable list of network resources.
type NetworkResourceDescriptionList struct {
	// URI to fetch the next page of the list.
	NextLink *string

	// One page of the list.
	Value []*NetworkResourceDescription
}

// NetworkResourcePropertiesClassification provides polymorphic access to related types.
// Call the interface's GetNetworkResourceProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *LocalNetworkResourceProperties, *NetworkResourceProperties
type NetworkResourcePropertiesClassification interface {
	NetworkResourcePropertiesBaseClassification
	// GetNetworkResourceProperties returns the NetworkResourceProperties content of the underlying type.
	GetNetworkResourceProperties() *NetworkResourceProperties
}

// NetworkResourceProperties - Describes properties of a network resource.
type NetworkResourceProperties struct {
	// REQUIRED; The type of a Service Fabric container network.
	Kind *NetworkKind

	// User readable description of the network.
	Description *string

	// READ-ONLY; State of the resource.
	ProvisioningState *string

	// READ-ONLY; Status of the network.
	Status *ResourceStatus

	// READ-ONLY; Gives additional information about the current status of the network.
	StatusDetails *string
}

// GetNetworkResourceProperties implements the NetworkResourcePropertiesClassification interface for type NetworkResourceProperties.
func (n *NetworkResourceProperties) GetNetworkResourceProperties() *NetworkResourceProperties {
	return n
}

// GetNetworkResourcePropertiesBase implements the NetworkResourcePropertiesBaseClassification interface for type NetworkResourceProperties.
func (n *NetworkResourceProperties) GetNetworkResourcePropertiesBase() *NetworkResourcePropertiesBase {
	return &NetworkResourcePropertiesBase{
		Kind:              n.Kind,
		ProvisioningState: n.ProvisioningState,
	}
}

// NetworkResourcePropertiesBaseClassification provides polymorphic access to related types.
// Call the interface's GetNetworkResourcePropertiesBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *LocalNetworkResourceProperties, *NetworkResourceProperties, *NetworkResourcePropertiesBase
type NetworkResourcePropertiesBaseClassification interface {
	// GetNetworkResourcePropertiesBase returns the NetworkResourcePropertiesBase content of the underlying type.
	GetNetworkResourcePropertiesBase() *NetworkResourcePropertiesBase
}

// NetworkResourcePropertiesBase - This type describes the properties of a network resource, including its kind.
type NetworkResourcePropertiesBase struct {
	// REQUIRED; The type of a Service Fabric container network.
	Kind *NetworkKind

	// READ-ONLY; State of the resource.
	ProvisioningState *string
}

// GetNetworkResourcePropertiesBase implements the NetworkResourcePropertiesBaseClassification interface for type NetworkResourcePropertiesBase.
func (n *NetworkResourcePropertiesBase) GetNetworkResourcePropertiesBase() *NetworkResourcePropertiesBase {
	return n
}

// OperationListResult - Describes the result of the request to list Service Fabric operations.
type OperationListResult struct {
	// List of Service Fabric operations supported by the Microsoft.ServiceFabric resource provider.
	Value []*OperationResult

	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string
}

// OperationResult - List of operations available at the listed Azure resource provider.
type OperationResult struct {
	// The object that represents the operation.
	Display *AvailableOperationDisplay

	// The name of the operation.
	Name *string

	// The URL to use for getting the next set of results.
	NextLink *string

	// Origin result
	Origin *string
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.NewListPager method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ProvisionedResourceProperties - Describes common properties of a provisioned resource.
type ProvisionedResourceProperties struct {
	// READ-ONLY; State of the resource.
	ProvisioningState *string
}

// ProxyResource - The resource model definition for Azure Resource Manager proxy resource. It will have everything other
// than required location and tags.
type ProxyResource struct {
	// READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// ReliableCollectionsRef - Specifying this parameter adds support for reliable collections
type ReliableCollectionsRef struct {
	// REQUIRED; Name of ReliableCollection resource. Right now it's not used and you can use any string.
	Name *string

	// False (the default) if ReliableCollections state is persisted to disk as usual. True if you do not want to persist state,
	// in which case replication is still enabled and you can use ReliableCollections
	// as distributed cache.
	DoNotPersistState *bool
}

// Resource - The resource model definition for Azure Resource Manager resource.
type Resource struct {
	// READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// ResourceLimits - This type describes the resource limits for a given container. It describes the most amount of resources
// a container is allowed to use before being restarted.
type ResourceLimits struct {
	// CPU limits in cores. At present, only full cores are supported.
	CPU *float64

	// The memory limit in GB.
	MemoryInGB *float64
}

// ResourceRequests - This type describes the requested resources for a given container. It describes the least amount of
// resources required for the container. A container can consume more than requested resources up to
// the specified limits before being restarted. Currently, the requested resources are treated as limits.
type ResourceRequests struct {
	// REQUIRED; Requested number of CPU cores. At present, only full cores are supported.
	CPU *float64

	// REQUIRED; The memory request in GB for this container.
	MemoryInGB *float64
}

// ResourceRequirements - This type describes the resource requirements for a container or a service.
type ResourceRequirements struct {
	// REQUIRED; Describes the requested resources for a given container.
	Requests *ResourceRequests

	// Describes the maximum limits on the resources for a given container.
	Limits *ResourceLimits
}

// SecretClientCreateOptions contains the optional parameters for the SecretClient.Create method.
type SecretClientCreateOptions struct {
	// placeholder for future optional parameters
}

// SecretClientDeleteOptions contains the optional parameters for the SecretClient.Delete method.
type SecretClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SecretClientGetOptions contains the optional parameters for the SecretClient.Get method.
type SecretClientGetOptions struct {
	// placeholder for future optional parameters
}

// SecretClientListByResourceGroupOptions contains the optional parameters for the SecretClient.NewListByResourceGroupPager
// method.
type SecretClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// SecretClientListBySubscriptionOptions contains the optional parameters for the SecretClient.NewListBySubscriptionPager
// method.
type SecretClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// SecretResourceDescription - This type describes a secret resource.
type SecretResourceDescription struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Describes the properties of a secret resource.
	Properties SecretResourcePropertiesClassification

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// SecretResourceDescriptionList - A pageable list of secret resources.
type SecretResourceDescriptionList struct {
	// URI to fetch the next page of the list.
	NextLink *string

	// One page of the list.
	Value []*SecretResourceDescription
}

// SecretResourcePropertiesClassification provides polymorphic access to related types.
// Call the interface's GetSecretResourceProperties() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *InlinedValueSecretResourceProperties, *SecretResourceProperties
type SecretResourcePropertiesClassification interface {
	SecretResourcePropertiesBaseClassification
	// GetSecretResourceProperties returns the SecretResourceProperties content of the underlying type.
	GetSecretResourceProperties() *SecretResourceProperties
}

// SecretResourceProperties - Describes the properties of a secret resource.
type SecretResourceProperties struct {
	// REQUIRED; Describes the kind of secret.
	Kind *SecretKind

	// The type of the content stored in the secret value. The value of this property is opaque to Service Fabric. Once set, the
	// value of this property cannot be changed.
	ContentType *string

	// User readable description of the secret.
	Description *string

	// READ-ONLY; State of the resource.
	ProvisioningState *string

	// READ-ONLY; Status of the resource.
	Status *ResourceStatus

	// READ-ONLY; Gives additional information about the current status of the secret.
	StatusDetails *string
}

// GetSecretResourceProperties implements the SecretResourcePropertiesClassification interface for type SecretResourceProperties.
func (s *SecretResourceProperties) GetSecretResourceProperties() *SecretResourceProperties { return s }

// GetSecretResourcePropertiesBase implements the SecretResourcePropertiesBaseClassification interface for type SecretResourceProperties.
func (s *SecretResourceProperties) GetSecretResourcePropertiesBase() *SecretResourcePropertiesBase {
	return &SecretResourcePropertiesBase{
		Kind:              s.Kind,
		ProvisioningState: s.ProvisioningState,
	}
}

// SecretResourcePropertiesBaseClassification provides polymorphic access to related types.
// Call the interface's GetSecretResourcePropertiesBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *InlinedValueSecretResourceProperties, *SecretResourceProperties, *SecretResourcePropertiesBase
type SecretResourcePropertiesBaseClassification interface {
	// GetSecretResourcePropertiesBase returns the SecretResourcePropertiesBase content of the underlying type.
	GetSecretResourcePropertiesBase() *SecretResourcePropertiesBase
}

// SecretResourcePropertiesBase - This type describes the properties of a secret resource, including its kind.
type SecretResourcePropertiesBase struct {
	// REQUIRED; Describes the kind of secret.
	Kind *SecretKind

	// READ-ONLY; State of the resource.
	ProvisioningState *string
}

// GetSecretResourcePropertiesBase implements the SecretResourcePropertiesBaseClassification interface for type SecretResourcePropertiesBase.
func (s *SecretResourcePropertiesBase) GetSecretResourcePropertiesBase() *SecretResourcePropertiesBase {
	return s
}

// SecretValue - This type represents the unencrypted value of the secret.
type SecretValue struct {
	// The actual value of the secret.
	Value *string
}

// SecretValueClientCreateOptions contains the optional parameters for the SecretValueClient.Create method.
type SecretValueClientCreateOptions struct {
	// placeholder for future optional parameters
}

// SecretValueClientDeleteOptions contains the optional parameters for the SecretValueClient.Delete method.
type SecretValueClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// SecretValueClientGetOptions contains the optional parameters for the SecretValueClient.Get method.
type SecretValueClientGetOptions struct {
	// placeholder for future optional parameters
}

// SecretValueClientListOptions contains the optional parameters for the SecretValueClient.NewListPager method.
type SecretValueClientListOptions struct {
	// placeholder for future optional parameters
}

// SecretValueClientListValueOptions contains the optional parameters for the SecretValueClient.ListValue method.
type SecretValueClientListValueOptions struct {
	// placeholder for future optional parameters
}

// SecretValueProperties - This type describes properties of secret value resource.
type SecretValueProperties struct {
	// The actual value of the secret.
	Value *string
}

// SecretValueResourceDescription - This type describes a value of a secret resource. The name of this resource is the version
// identifier corresponding to this secret value.
type SecretValueResourceDescription struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; This type describes properties of a secret value resource.
	Properties *SecretValueResourceProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// SecretValueResourceDescriptionList - A pageable list of values of a secret resource. The information does not include only
// the name of the value and not the actual unencrypted value.
type SecretValueResourceDescriptionList struct {
	// URI to fetch the next page of the list.
	NextLink *string

	// One page of the list.
	Value []*SecretValueResourceDescription
}

// SecretValueResourceProperties - This type describes properties of a secret value resource.
type SecretValueResourceProperties struct {
	// The actual value of the secret.
	Value *string

	// READ-ONLY; State of the resource.
	ProvisioningState *string
}

// ServiceClientGetOptions contains the optional parameters for the ServiceClient.Get method.
type ServiceClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServiceClientListOptions contains the optional parameters for the ServiceClient.NewListPager method.
type ServiceClientListOptions struct {
	// placeholder for future optional parameters
}

// ServiceProperties - Describes properties of a service resource.
type ServiceProperties struct {
	// Auto scaling policies
	AutoScalingPolicies []*AutoScalingPolicy

	// User readable description of the service.
	Description *string

	// The number of replicas of the service to create. Defaults to 1 if not specified.
	ReplicaCount *int32

	// READ-ONLY; Describes the health state of an application resource.
	HealthState *HealthState

	// READ-ONLY; Status of the service.
	Status *ResourceStatus

	// READ-ONLY; Gives additional information about the current status of the service.
	StatusDetails *string

	// READ-ONLY; When the service's health state is not 'Ok', this additional details from service fabric Health Manager for
	// the user to know why the service is marked unhealthy.
	UnhealthyEvaluation *string
}

// ServiceReplicaClientGetOptions contains the optional parameters for the ServiceReplicaClient.Get method.
type ServiceReplicaClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServiceReplicaClientListOptions contains the optional parameters for the ServiceReplicaClient.NewListPager method.
type ServiceReplicaClientListOptions struct {
	// placeholder for future optional parameters
}

// ServiceReplicaDescription - Describes a replica of a service resource.
type ServiceReplicaDescription struct {
	// REQUIRED; Describes the set of code packages that forms the service. A code package describes the container and the properties
	// for running it. All the code packages are started together on the same host and
	// share the same context (network, process etc.).
	CodePackages []*ContainerCodePackageProperties

	// REQUIRED; The operation system required by the code in service.
	OSType *OperatingSystemType

	// REQUIRED; Name of the replica.
	ReplicaName *string

	// Reference to sinks in DiagnosticsDescription.
	Diagnostics *DiagnosticsRef

	// The names of the private networks that this service needs to be part of.
	NetworkRefs []*NetworkRef
}

// ServiceReplicaDescriptionList - A pageable list of service replicas.
type ServiceReplicaDescriptionList struct {
	// URI to fetch the next page of the list.
	NextLink *string

	// One page of the list.
	Value []*ServiceReplicaDescription
}

// ServiceReplicaProperties - Describes the properties of a service replica.
type ServiceReplicaProperties struct {
	// REQUIRED; Describes the set of code packages that forms the service. A code package describes the container and the properties
	// for running it. All the code packages are started together on the same host and
	// share the same context (network, process etc.).
	CodePackages []*ContainerCodePackageProperties

	// REQUIRED; The operation system required by the code in service.
	OSType *OperatingSystemType

	// Reference to sinks in DiagnosticsDescription.
	Diagnostics *DiagnosticsRef

	// The names of the private networks that this service needs to be part of.
	NetworkRefs []*NetworkRef
}

// ServiceResourceDescription - This type describes a service resource.
type ServiceResourceDescription struct {
	// REQUIRED; This type describes properties of a service resource.
	Properties *ServiceResourceProperties

	// The name of the resource
	Name *string

	// READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// ServiceResourceDescriptionList - A pageable list of service resources.
type ServiceResourceDescriptionList struct {
	// URI to fetch the next page of the list.
	NextLink *string

	// One page of the list.
	Value []*ServiceResourceDescription
}

// ServiceResourceProperties - This type describes properties of a service resource.
type ServiceResourceProperties struct {
	// REQUIRED; Describes the set of code packages that forms the service. A code package describes the container and the properties
	// for running it. All the code packages are started together on the same host and
	// share the same context (network, process etc.).
	CodePackages []*ContainerCodePackageProperties

	// REQUIRED; The operation system required by the code in service.
	OSType *OperatingSystemType

	// Auto scaling policies
	AutoScalingPolicies []*AutoScalingPolicy

	// User readable description of the service.
	Description *string

	// Reference to sinks in DiagnosticsDescription.
	Diagnostics *DiagnosticsRef

	// The names of the private networks that this service needs to be part of.
	NetworkRefs []*NetworkRef

	// The number of replicas of the service to create. Defaults to 1 if not specified.
	ReplicaCount *int32

	// READ-ONLY; Describes the health state of an application resource.
	HealthState *HealthState

	// READ-ONLY; State of the resource.
	ProvisioningState *string

	// READ-ONLY; Status of the service.
	Status *ResourceStatus

	// READ-ONLY; Gives additional information about the current status of the service.
	StatusDetails *string

	// READ-ONLY; When the service's health state is not 'Ok', this additional details from service fabric Health Manager for
	// the user to know why the service is marked unhealthy.
	UnhealthyEvaluation *string
}

// Setting - Describes a setting for the container. The setting file path can be fetched from environment variable "Fabric_SettingPath".
// The path for Windows container is "C:\secrets". The path for Linux container
// is "/var/secrets".
type Setting struct {
	// The name of the setting.
	Name *string

	// The value of the setting.
	Value *string
}

// TCPConfig - Describes the tcp configuration for external connectivity for this network.
type TCPConfig struct {
	// REQUIRED; Describes destination endpoint for routing traffic.
	Destination *GatewayDestination

	// REQUIRED; tcp gateway config name.
	Name *string

	// REQUIRED; Specifies the port at which the service endpoint below needs to be exposed.
	Port *int32
}

// TrackedResource - The resource model definition for Azure Resource Manager tracked top-level resource.
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// VolumeClientCreateOptions contains the optional parameters for the VolumeClient.Create method.
type VolumeClientCreateOptions struct {
	// placeholder for future optional parameters
}

// VolumeClientDeleteOptions contains the optional parameters for the VolumeClient.Delete method.
type VolumeClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// VolumeClientGetOptions contains the optional parameters for the VolumeClient.Get method.
type VolumeClientGetOptions struct {
	// placeholder for future optional parameters
}

// VolumeClientListByResourceGroupOptions contains the optional parameters for the VolumeClient.NewListByResourceGroupPager
// method.
type VolumeClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// VolumeClientListBySubscriptionOptions contains the optional parameters for the VolumeClient.NewListBySubscriptionPager
// method.
type VolumeClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// VolumeProperties - Describes properties of a volume resource.
type VolumeProperties struct {
	// REQUIRED; Provider of the volume.
	Provider *VolumeProvider

	// This type describes a volume provided by an Azure Files file share.
	AzureFileParameters *VolumeProviderParametersAzureFile

	// User readable description of the volume.
	Description *string

	// READ-ONLY; Status of the volume.
	Status *ResourceStatus

	// READ-ONLY; Gives additional information about the current status of the volume.
	StatusDetails *string
}

// VolumeProviderParametersAzureFile - This type describes a volume provided by an Azure Files file share.
type VolumeProviderParametersAzureFile struct {
	// REQUIRED; Name of the Azure storage account for the File Share.
	AccountName *string

	// REQUIRED; Name of the Azure Files file share that provides storage for the volume.
	ShareName *string

	// Access key of the Azure storage account for the File Share.
	AccountKey *string
}

// VolumeReference - Describes a reference to a volume resource.
type VolumeReference struct {
	// REQUIRED; The path within the container at which the volume should be mounted. Only valid path characters are allowed.
	DestinationPath *string

	// REQUIRED; Name of the volume being referenced.
	Name *string

	// The flag indicating whether the volume is read only. Default is 'false'.
	ReadOnly *bool
}

// VolumeResourceDescription - This type describes a volume resource.
type VolumeResourceDescription struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; This type describes properties of a volume resource.
	Properties *VolumeResourceProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified identifier for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
	Type *string
}

// VolumeResourceDescriptionList - A pageable list of volume resources.
type VolumeResourceDescriptionList struct {
	// URI to fetch the next page of the list.
	NextLink *string

	// One page of the list.
	Value []*VolumeResourceDescription
}

// VolumeResourceProperties - This type describes properties of a volume resource.
type VolumeResourceProperties struct {
	// REQUIRED; Provider of the volume.
	Provider *VolumeProvider

	// This type describes a volume provided by an Azure Files file share.
	AzureFileParameters *VolumeProviderParametersAzureFile

	// User readable description of the volume.
	Description *string

	// READ-ONLY; State of the resource.
	ProvisioningState *string

	// READ-ONLY; Status of the volume.
	Status *ResourceStatus

	// READ-ONLY; Gives additional information about the current status of the volume.
	StatusDetails *string
}
