//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armpolicy"
	"net/http"
	"net/url"
	"regexp"
)

// ExemptionsServer is a fake server for instances of the armpolicy.ExemptionsClient type.
type ExemptionsServer struct {
	// CreateOrUpdate is the fake for method ExemptionsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, scope string, policyExemptionName string, parameters armpolicy.Exemption, options *armpolicy.ExemptionsClientCreateOrUpdateOptions) (resp azfake.Responder[armpolicy.ExemptionsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ExemptionsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, scope string, policyExemptionName string, options *armpolicy.ExemptionsClientDeleteOptions) (resp azfake.Responder[armpolicy.ExemptionsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ExemptionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, scope string, policyExemptionName string, options *armpolicy.ExemptionsClientGetOptions) (resp azfake.Responder[armpolicy.ExemptionsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ExemptionsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armpolicy.ExemptionsClientListOptions) (resp azfake.PagerResponder[armpolicy.ExemptionsClientListResponse])

	// NewListForManagementGroupPager is the fake for method ExemptionsClient.NewListForManagementGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForManagementGroupPager func(managementGroupID string, options *armpolicy.ExemptionsClientListForManagementGroupOptions) (resp azfake.PagerResponder[armpolicy.ExemptionsClientListForManagementGroupResponse])

	// NewListForResourcePager is the fake for method ExemptionsClient.NewListForResourcePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForResourcePager func(resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, options *armpolicy.ExemptionsClientListForResourceOptions) (resp azfake.PagerResponder[armpolicy.ExemptionsClientListForResourceResponse])

	// NewListForResourceGroupPager is the fake for method ExemptionsClient.NewListForResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForResourceGroupPager func(resourceGroupName string, options *armpolicy.ExemptionsClientListForResourceGroupOptions) (resp azfake.PagerResponder[armpolicy.ExemptionsClientListForResourceGroupResponse])

	// Update is the fake for method ExemptionsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, scope string, policyExemptionName string, parameters armpolicy.ExemptionUpdate, options *armpolicy.ExemptionsClientUpdateOptions) (resp azfake.Responder[armpolicy.ExemptionsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewExemptionsServerTransport creates a new instance of ExemptionsServerTransport with the provided implementation.
// The returned ExemptionsServerTransport instance is connected to an instance of armpolicy.ExemptionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewExemptionsServerTransport(srv *ExemptionsServer) *ExemptionsServerTransport {
	return &ExemptionsServerTransport{
		srv:                            srv,
		newListPager:                   newTracker[azfake.PagerResponder[armpolicy.ExemptionsClientListResponse]](),
		newListForManagementGroupPager: newTracker[azfake.PagerResponder[armpolicy.ExemptionsClientListForManagementGroupResponse]](),
		newListForResourcePager:        newTracker[azfake.PagerResponder[armpolicy.ExemptionsClientListForResourceResponse]](),
		newListForResourceGroupPager:   newTracker[azfake.PagerResponder[armpolicy.ExemptionsClientListForResourceGroupResponse]](),
	}
}

// ExemptionsServerTransport connects instances of armpolicy.ExemptionsClient to instances of ExemptionsServer.
// Don't use this type directly, use NewExemptionsServerTransport instead.
type ExemptionsServerTransport struct {
	srv                            *ExemptionsServer
	newListPager                   *tracker[azfake.PagerResponder[armpolicy.ExemptionsClientListResponse]]
	newListForManagementGroupPager *tracker[azfake.PagerResponder[armpolicy.ExemptionsClientListForManagementGroupResponse]]
	newListForResourcePager        *tracker[azfake.PagerResponder[armpolicy.ExemptionsClientListForResourceResponse]]
	newListForResourceGroupPager   *tracker[azfake.PagerResponder[armpolicy.ExemptionsClientListForResourceGroupResponse]]
}

// Do implements the policy.Transporter interface for ExemptionsServerTransport.
func (e *ExemptionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ExemptionsClient.CreateOrUpdate":
		resp, err = e.dispatchCreateOrUpdate(req)
	case "ExemptionsClient.Delete":
		resp, err = e.dispatchDelete(req)
	case "ExemptionsClient.Get":
		resp, err = e.dispatchGet(req)
	case "ExemptionsClient.NewListPager":
		resp, err = e.dispatchNewListPager(req)
	case "ExemptionsClient.NewListForManagementGroupPager":
		resp, err = e.dispatchNewListForManagementGroupPager(req)
	case "ExemptionsClient.NewListForResourcePager":
		resp, err = e.dispatchNewListForResourcePager(req)
	case "ExemptionsClient.NewListForResourceGroupPager":
		resp, err = e.dispatchNewListForResourceGroupPager(req)
	case "ExemptionsClient.Update":
		resp, err = e.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *ExemptionsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if e.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/policyExemptions/(?P<policyExemptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpolicy.Exemption](req)
	if err != nil {
		return nil, err
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	policyExemptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyExemptionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.CreateOrUpdate(req.Context(), scopeParam, policyExemptionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Exemption, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *ExemptionsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if e.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/policyExemptions/(?P<policyExemptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	policyExemptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyExemptionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Delete(req.Context(), scopeParam, policyExemptionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *ExemptionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if e.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/policyExemptions/(?P<policyExemptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	policyExemptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyExemptionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Get(req.Context(), scopeParam, policyExemptionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Exemption, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *ExemptionsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := e.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/policyExemptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armpolicy.ExemptionsClientListOptions
		if filterParam != nil {
			options = &armpolicy.ExemptionsClientListOptions{
				Filter: filterParam,
			}
		}
		resp := e.srv.NewListPager(options)
		newListPager = &resp
		e.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armpolicy.ExemptionsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		e.newListPager.remove(req)
	}
	return resp, nil
}

func (e *ExemptionsServerTransport) dispatchNewListForManagementGroupPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListForManagementGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForManagementGroupPager not implemented")}
	}
	newListForManagementGroupPager := e.newListForManagementGroupPager.get(req)
	if newListForManagementGroupPager == nil {
		const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/policyExemptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armpolicy.ExemptionsClientListForManagementGroupOptions
		if filterParam != nil {
			options = &armpolicy.ExemptionsClientListForManagementGroupOptions{
				Filter: filterParam,
			}
		}
		resp := e.srv.NewListForManagementGroupPager(managementGroupIDParam, options)
		newListForManagementGroupPager = &resp
		e.newListForManagementGroupPager.add(req, newListForManagementGroupPager)
		server.PagerResponderInjectNextLinks(newListForManagementGroupPager, req, func(page *armpolicy.ExemptionsClientListForManagementGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForManagementGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListForManagementGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForManagementGroupPager) {
		e.newListForManagementGroupPager.remove(req)
	}
	return resp, nil
}

func (e *ExemptionsServerTransport) dispatchNewListForResourcePager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListForResourcePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForResourcePager not implemented")}
	}
	newListForResourcePager := e.newListForResourcePager.get(req)
	if newListForResourcePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceProviderNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResourcePath>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/policyExemptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceProviderNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceProviderNamespace")])
		if err != nil {
			return nil, err
		}
		parentResourcePathParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResourcePath")])
		if err != nil {
			return nil, err
		}
		resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armpolicy.ExemptionsClientListForResourceOptions
		if filterParam != nil {
			options = &armpolicy.ExemptionsClientListForResourceOptions{
				Filter: filterParam,
			}
		}
		resp := e.srv.NewListForResourcePager(resourceGroupNameParam, resourceProviderNamespaceParam, parentResourcePathParam, resourceTypeParam, resourceNameParam, options)
		newListForResourcePager = &resp
		e.newListForResourcePager.add(req, newListForResourcePager)
		server.PagerResponderInjectNextLinks(newListForResourcePager, req, func(page *armpolicy.ExemptionsClientListForResourceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForResourcePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListForResourcePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForResourcePager) {
		e.newListForResourcePager.remove(req)
	}
	return resp, nil
}

func (e *ExemptionsServerTransport) dispatchNewListForResourceGroupPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListForResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForResourceGroupPager not implemented")}
	}
	newListForResourceGroupPager := e.newListForResourceGroupPager.get(req)
	if newListForResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/policyExemptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armpolicy.ExemptionsClientListForResourceGroupOptions
		if filterParam != nil {
			options = &armpolicy.ExemptionsClientListForResourceGroupOptions{
				Filter: filterParam,
			}
		}
		resp := e.srv.NewListForResourceGroupPager(resourceGroupNameParam, options)
		newListForResourceGroupPager = &resp
		e.newListForResourceGroupPager.add(req, newListForResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListForResourceGroupPager, req, func(page *armpolicy.ExemptionsClientListForResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListForResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForResourceGroupPager) {
		e.newListForResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (e *ExemptionsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if e.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/policyExemptions/(?P<policyExemptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpolicy.ExemptionUpdate](req)
	if err != nil {
		return nil, err
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	policyExemptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyExemptionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Update(req.Context(), scopeParam, policyExemptionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Exemption, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
