//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpowerplatform

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// PrivateLinkResourcesClient contains the methods for the PrivateLinkResources group.
// Don't use this type directly, use NewPrivateLinkResourcesClient() instead.
type PrivateLinkResourcesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewPrivateLinkResourcesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*PrivateLinkResourcesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &PrivateLinkResourcesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Gets the private link resources that need to be created for an EnterprisePolicy.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-10-30-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - enterprisePolicyName - EnterprisePolicy for the Microsoft Azure subscription.
//   - groupName - The name of the private link resource.
//   - options - PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get
//     method.
func (client *PrivateLinkResourcesClient) Get(ctx context.Context, resourceGroupName string, enterprisePolicyName string, groupName string, options *PrivateLinkResourcesClientGetOptions) (PrivateLinkResourcesClientGetResponse, error) {
	var err error
	const operationName = "PrivateLinkResourcesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, enterprisePolicyName, groupName, options)
	if err != nil {
		return PrivateLinkResourcesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PrivateLinkResourcesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PrivateLinkResourcesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *PrivateLinkResourcesClient) getCreateRequest(ctx context.Context, resourceGroupName string, enterprisePolicyName string, groupName string, options *PrivateLinkResourcesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerPlatform/enterprisePolicies/{enterprisePolicyName}/privateLinkResources/{groupName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if enterprisePolicyName == "" {
		return nil, errors.New("parameter enterprisePolicyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{enterprisePolicyName}", url.PathEscape(enterprisePolicyName))
	if groupName == "" {
		return nil, errors.New("parameter groupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupName}", url.PathEscape(groupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-30-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *PrivateLinkResourcesClient) getHandleResponse(resp *http.Response) (PrivateLinkResourcesClientGetResponse, error) {
	result := PrivateLinkResourcesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateLinkResource); err != nil {
		return PrivateLinkResourcesClientGetResponse{}, err
	}
	return result, nil
}

// NewListByEnterprisePolicyPager - Gets the private link resources that need to be created for enterprisePolicy.
//
// Generated from API version 2020-10-30-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - enterprisePolicyName - EnterprisePolicy for the Microsoft Azure subscription.
//   - options - PrivateLinkResourcesClientListByEnterprisePolicyOptions contains the optional parameters for the PrivateLinkResourcesClient.NewListByEnterprisePolicyPager
//     method.
func (client *PrivateLinkResourcesClient) NewListByEnterprisePolicyPager(resourceGroupName string, enterprisePolicyName string, options *PrivateLinkResourcesClientListByEnterprisePolicyOptions) *runtime.Pager[PrivateLinkResourcesClientListByEnterprisePolicyResponse] {
	return runtime.NewPager(runtime.PagingHandler[PrivateLinkResourcesClientListByEnterprisePolicyResponse]{
		More: func(page PrivateLinkResourcesClientListByEnterprisePolicyResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *PrivateLinkResourcesClientListByEnterprisePolicyResponse) (PrivateLinkResourcesClientListByEnterprisePolicyResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PrivateLinkResourcesClient.NewListByEnterprisePolicyPager")
			req, err := client.listByEnterprisePolicyCreateRequest(ctx, resourceGroupName, enterprisePolicyName, options)
			if err != nil {
				return PrivateLinkResourcesClientListByEnterprisePolicyResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return PrivateLinkResourcesClientListByEnterprisePolicyResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return PrivateLinkResourcesClientListByEnterprisePolicyResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByEnterprisePolicyHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByEnterprisePolicyCreateRequest creates the ListByEnterprisePolicy request.
func (client *PrivateLinkResourcesClient) listByEnterprisePolicyCreateRequest(ctx context.Context, resourceGroupName string, enterprisePolicyName string, options *PrivateLinkResourcesClientListByEnterprisePolicyOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerPlatform/enterprisePolicies/{enterprisePolicyName}/privateLinkResources"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if enterprisePolicyName == "" {
		return nil, errors.New("parameter enterprisePolicyName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{enterprisePolicyName}", url.PathEscape(enterprisePolicyName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-30-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByEnterprisePolicyHandleResponse handles the ListByEnterprisePolicy response.
func (client *PrivateLinkResourcesClient) listByEnterprisePolicyHandleResponse(resp *http.Response) (PrivateLinkResourcesClientListByEnterprisePolicyResponse, error) {
	result := PrivateLinkResourcesClientListByEnterprisePolicyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PrivateLinkResourceListResult); err != nil {
		return PrivateLinkResourcesClientListByEnterprisePolicyResponse{}, err
	}
	return result, nil
}
