//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/policyinsights/armpolicyinsights"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// RemediationsServer is a fake server for instances of the armpolicyinsights.RemediationsClient type.
type RemediationsServer struct {
	// CancelAtManagementGroup is the fake for method RemediationsClient.CancelAtManagementGroup
	// HTTP status codes to indicate success: http.StatusOK
	CancelAtManagementGroup func(ctx context.Context, managementGroupID string, remediationName string, options *armpolicyinsights.RemediationsClientCancelAtManagementGroupOptions) (resp azfake.Responder[armpolicyinsights.RemediationsClientCancelAtManagementGroupResponse], errResp azfake.ErrorResponder)

	// CancelAtResource is the fake for method RemediationsClient.CancelAtResource
	// HTTP status codes to indicate success: http.StatusOK
	CancelAtResource func(ctx context.Context, resourceID string, remediationName string, options *armpolicyinsights.RemediationsClientCancelAtResourceOptions) (resp azfake.Responder[armpolicyinsights.RemediationsClientCancelAtResourceResponse], errResp azfake.ErrorResponder)

	// CancelAtResourceGroup is the fake for method RemediationsClient.CancelAtResourceGroup
	// HTTP status codes to indicate success: http.StatusOK
	CancelAtResourceGroup func(ctx context.Context, resourceGroupName string, remediationName string, options *armpolicyinsights.RemediationsClientCancelAtResourceGroupOptions) (resp azfake.Responder[armpolicyinsights.RemediationsClientCancelAtResourceGroupResponse], errResp azfake.ErrorResponder)

	// CancelAtSubscription is the fake for method RemediationsClient.CancelAtSubscription
	// HTTP status codes to indicate success: http.StatusOK
	CancelAtSubscription func(ctx context.Context, remediationName string, options *armpolicyinsights.RemediationsClientCancelAtSubscriptionOptions) (resp azfake.Responder[armpolicyinsights.RemediationsClientCancelAtSubscriptionResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateAtManagementGroup is the fake for method RemediationsClient.CreateOrUpdateAtManagementGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdateAtManagementGroup func(ctx context.Context, managementGroupID string, remediationName string, parameters armpolicyinsights.Remediation, options *armpolicyinsights.RemediationsClientCreateOrUpdateAtManagementGroupOptions) (resp azfake.Responder[armpolicyinsights.RemediationsClientCreateOrUpdateAtManagementGroupResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateAtResource is the fake for method RemediationsClient.CreateOrUpdateAtResource
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdateAtResource func(ctx context.Context, resourceID string, remediationName string, parameters armpolicyinsights.Remediation, options *armpolicyinsights.RemediationsClientCreateOrUpdateAtResourceOptions) (resp azfake.Responder[armpolicyinsights.RemediationsClientCreateOrUpdateAtResourceResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateAtResourceGroup is the fake for method RemediationsClient.CreateOrUpdateAtResourceGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdateAtResourceGroup func(ctx context.Context, resourceGroupName string, remediationName string, parameters armpolicyinsights.Remediation, options *armpolicyinsights.RemediationsClientCreateOrUpdateAtResourceGroupOptions) (resp azfake.Responder[armpolicyinsights.RemediationsClientCreateOrUpdateAtResourceGroupResponse], errResp azfake.ErrorResponder)

	// CreateOrUpdateAtSubscription is the fake for method RemediationsClient.CreateOrUpdateAtSubscription
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdateAtSubscription func(ctx context.Context, remediationName string, parameters armpolicyinsights.Remediation, options *armpolicyinsights.RemediationsClientCreateOrUpdateAtSubscriptionOptions) (resp azfake.Responder[armpolicyinsights.RemediationsClientCreateOrUpdateAtSubscriptionResponse], errResp azfake.ErrorResponder)

	// DeleteAtManagementGroup is the fake for method RemediationsClient.DeleteAtManagementGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteAtManagementGroup func(ctx context.Context, managementGroupID string, remediationName string, options *armpolicyinsights.RemediationsClientDeleteAtManagementGroupOptions) (resp azfake.Responder[armpolicyinsights.RemediationsClientDeleteAtManagementGroupResponse], errResp azfake.ErrorResponder)

	// DeleteAtResource is the fake for method RemediationsClient.DeleteAtResource
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteAtResource func(ctx context.Context, resourceID string, remediationName string, options *armpolicyinsights.RemediationsClientDeleteAtResourceOptions) (resp azfake.Responder[armpolicyinsights.RemediationsClientDeleteAtResourceResponse], errResp azfake.ErrorResponder)

	// DeleteAtResourceGroup is the fake for method RemediationsClient.DeleteAtResourceGroup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteAtResourceGroup func(ctx context.Context, resourceGroupName string, remediationName string, options *armpolicyinsights.RemediationsClientDeleteAtResourceGroupOptions) (resp azfake.Responder[armpolicyinsights.RemediationsClientDeleteAtResourceGroupResponse], errResp azfake.ErrorResponder)

	// DeleteAtSubscription is the fake for method RemediationsClient.DeleteAtSubscription
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteAtSubscription func(ctx context.Context, remediationName string, options *armpolicyinsights.RemediationsClientDeleteAtSubscriptionOptions) (resp azfake.Responder[armpolicyinsights.RemediationsClientDeleteAtSubscriptionResponse], errResp azfake.ErrorResponder)

	// GetAtManagementGroup is the fake for method RemediationsClient.GetAtManagementGroup
	// HTTP status codes to indicate success: http.StatusOK
	GetAtManagementGroup func(ctx context.Context, managementGroupID string, remediationName string, options *armpolicyinsights.RemediationsClientGetAtManagementGroupOptions) (resp azfake.Responder[armpolicyinsights.RemediationsClientGetAtManagementGroupResponse], errResp azfake.ErrorResponder)

	// GetAtResource is the fake for method RemediationsClient.GetAtResource
	// HTTP status codes to indicate success: http.StatusOK
	GetAtResource func(ctx context.Context, resourceID string, remediationName string, options *armpolicyinsights.RemediationsClientGetAtResourceOptions) (resp azfake.Responder[armpolicyinsights.RemediationsClientGetAtResourceResponse], errResp azfake.ErrorResponder)

	// GetAtResourceGroup is the fake for method RemediationsClient.GetAtResourceGroup
	// HTTP status codes to indicate success: http.StatusOK
	GetAtResourceGroup func(ctx context.Context, resourceGroupName string, remediationName string, options *armpolicyinsights.RemediationsClientGetAtResourceGroupOptions) (resp azfake.Responder[armpolicyinsights.RemediationsClientGetAtResourceGroupResponse], errResp azfake.ErrorResponder)

	// GetAtSubscription is the fake for method RemediationsClient.GetAtSubscription
	// HTTP status codes to indicate success: http.StatusOK
	GetAtSubscription func(ctx context.Context, remediationName string, options *armpolicyinsights.RemediationsClientGetAtSubscriptionOptions) (resp azfake.Responder[armpolicyinsights.RemediationsClientGetAtSubscriptionResponse], errResp azfake.ErrorResponder)

	// NewListDeploymentsAtManagementGroupPager is the fake for method RemediationsClient.NewListDeploymentsAtManagementGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListDeploymentsAtManagementGroupPager func(managementGroupID string, remediationName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.RemediationsClientListDeploymentsAtManagementGroupOptions) (resp azfake.PagerResponder[armpolicyinsights.RemediationsClientListDeploymentsAtManagementGroupResponse])

	// NewListDeploymentsAtResourcePager is the fake for method RemediationsClient.NewListDeploymentsAtResourcePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListDeploymentsAtResourcePager func(resourceID string, remediationName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.RemediationsClientListDeploymentsAtResourceOptions) (resp azfake.PagerResponder[armpolicyinsights.RemediationsClientListDeploymentsAtResourceResponse])

	// NewListDeploymentsAtResourceGroupPager is the fake for method RemediationsClient.NewListDeploymentsAtResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListDeploymentsAtResourceGroupPager func(resourceGroupName string, remediationName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.RemediationsClientListDeploymentsAtResourceGroupOptions) (resp azfake.PagerResponder[armpolicyinsights.RemediationsClientListDeploymentsAtResourceGroupResponse])

	// NewListDeploymentsAtSubscriptionPager is the fake for method RemediationsClient.NewListDeploymentsAtSubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListDeploymentsAtSubscriptionPager func(remediationName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.RemediationsClientListDeploymentsAtSubscriptionOptions) (resp azfake.PagerResponder[armpolicyinsights.RemediationsClientListDeploymentsAtSubscriptionResponse])

	// NewListForManagementGroupPager is the fake for method RemediationsClient.NewListForManagementGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForManagementGroupPager func(managementGroupID string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.RemediationsClientListForManagementGroupOptions) (resp azfake.PagerResponder[armpolicyinsights.RemediationsClientListForManagementGroupResponse])

	// NewListForResourcePager is the fake for method RemediationsClient.NewListForResourcePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForResourcePager func(resourceID string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.RemediationsClientListForResourceOptions) (resp azfake.PagerResponder[armpolicyinsights.RemediationsClientListForResourceResponse])

	// NewListForResourceGroupPager is the fake for method RemediationsClient.NewListForResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForResourceGroupPager func(resourceGroupName string, queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.RemediationsClientListForResourceGroupOptions) (resp azfake.PagerResponder[armpolicyinsights.RemediationsClientListForResourceGroupResponse])

	// NewListForSubscriptionPager is the fake for method RemediationsClient.NewListForSubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForSubscriptionPager func(queryOptions *armpolicyinsights.QueryOptions, options *armpolicyinsights.RemediationsClientListForSubscriptionOptions) (resp azfake.PagerResponder[armpolicyinsights.RemediationsClientListForSubscriptionResponse])
}

// NewRemediationsServerTransport creates a new instance of RemediationsServerTransport with the provided implementation.
// The returned RemediationsServerTransport instance is connected to an instance of armpolicyinsights.RemediationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewRemediationsServerTransport(srv *RemediationsServer) *RemediationsServerTransport {
	return &RemediationsServerTransport{
		srv:                                      srv,
		newListDeploymentsAtManagementGroupPager: newTracker[azfake.PagerResponder[armpolicyinsights.RemediationsClientListDeploymentsAtManagementGroupResponse]](),
		newListDeploymentsAtResourcePager:        newTracker[azfake.PagerResponder[armpolicyinsights.RemediationsClientListDeploymentsAtResourceResponse]](),
		newListDeploymentsAtResourceGroupPager:   newTracker[azfake.PagerResponder[armpolicyinsights.RemediationsClientListDeploymentsAtResourceGroupResponse]](),
		newListDeploymentsAtSubscriptionPager:    newTracker[azfake.PagerResponder[armpolicyinsights.RemediationsClientListDeploymentsAtSubscriptionResponse]](),
		newListForManagementGroupPager:           newTracker[azfake.PagerResponder[armpolicyinsights.RemediationsClientListForManagementGroupResponse]](),
		newListForResourcePager:                  newTracker[azfake.PagerResponder[armpolicyinsights.RemediationsClientListForResourceResponse]](),
		newListForResourceGroupPager:             newTracker[azfake.PagerResponder[armpolicyinsights.RemediationsClientListForResourceGroupResponse]](),
		newListForSubscriptionPager:              newTracker[azfake.PagerResponder[armpolicyinsights.RemediationsClientListForSubscriptionResponse]](),
	}
}

// RemediationsServerTransport connects instances of armpolicyinsights.RemediationsClient to instances of RemediationsServer.
// Don't use this type directly, use NewRemediationsServerTransport instead.
type RemediationsServerTransport struct {
	srv                                      *RemediationsServer
	newListDeploymentsAtManagementGroupPager *tracker[azfake.PagerResponder[armpolicyinsights.RemediationsClientListDeploymentsAtManagementGroupResponse]]
	newListDeploymentsAtResourcePager        *tracker[azfake.PagerResponder[armpolicyinsights.RemediationsClientListDeploymentsAtResourceResponse]]
	newListDeploymentsAtResourceGroupPager   *tracker[azfake.PagerResponder[armpolicyinsights.RemediationsClientListDeploymentsAtResourceGroupResponse]]
	newListDeploymentsAtSubscriptionPager    *tracker[azfake.PagerResponder[armpolicyinsights.RemediationsClientListDeploymentsAtSubscriptionResponse]]
	newListForManagementGroupPager           *tracker[azfake.PagerResponder[armpolicyinsights.RemediationsClientListForManagementGroupResponse]]
	newListForResourcePager                  *tracker[azfake.PagerResponder[armpolicyinsights.RemediationsClientListForResourceResponse]]
	newListForResourceGroupPager             *tracker[azfake.PagerResponder[armpolicyinsights.RemediationsClientListForResourceGroupResponse]]
	newListForSubscriptionPager              *tracker[azfake.PagerResponder[armpolicyinsights.RemediationsClientListForSubscriptionResponse]]
}

// Do implements the policy.Transporter interface for RemediationsServerTransport.
func (r *RemediationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "RemediationsClient.CancelAtManagementGroup":
		resp, err = r.dispatchCancelAtManagementGroup(req)
	case "RemediationsClient.CancelAtResource":
		resp, err = r.dispatchCancelAtResource(req)
	case "RemediationsClient.CancelAtResourceGroup":
		resp, err = r.dispatchCancelAtResourceGroup(req)
	case "RemediationsClient.CancelAtSubscription":
		resp, err = r.dispatchCancelAtSubscription(req)
	case "RemediationsClient.CreateOrUpdateAtManagementGroup":
		resp, err = r.dispatchCreateOrUpdateAtManagementGroup(req)
	case "RemediationsClient.CreateOrUpdateAtResource":
		resp, err = r.dispatchCreateOrUpdateAtResource(req)
	case "RemediationsClient.CreateOrUpdateAtResourceGroup":
		resp, err = r.dispatchCreateOrUpdateAtResourceGroup(req)
	case "RemediationsClient.CreateOrUpdateAtSubscription":
		resp, err = r.dispatchCreateOrUpdateAtSubscription(req)
	case "RemediationsClient.DeleteAtManagementGroup":
		resp, err = r.dispatchDeleteAtManagementGroup(req)
	case "RemediationsClient.DeleteAtResource":
		resp, err = r.dispatchDeleteAtResource(req)
	case "RemediationsClient.DeleteAtResourceGroup":
		resp, err = r.dispatchDeleteAtResourceGroup(req)
	case "RemediationsClient.DeleteAtSubscription":
		resp, err = r.dispatchDeleteAtSubscription(req)
	case "RemediationsClient.GetAtManagementGroup":
		resp, err = r.dispatchGetAtManagementGroup(req)
	case "RemediationsClient.GetAtResource":
		resp, err = r.dispatchGetAtResource(req)
	case "RemediationsClient.GetAtResourceGroup":
		resp, err = r.dispatchGetAtResourceGroup(req)
	case "RemediationsClient.GetAtSubscription":
		resp, err = r.dispatchGetAtSubscription(req)
	case "RemediationsClient.NewListDeploymentsAtManagementGroupPager":
		resp, err = r.dispatchNewListDeploymentsAtManagementGroupPager(req)
	case "RemediationsClient.NewListDeploymentsAtResourcePager":
		resp, err = r.dispatchNewListDeploymentsAtResourcePager(req)
	case "RemediationsClient.NewListDeploymentsAtResourceGroupPager":
		resp, err = r.dispatchNewListDeploymentsAtResourceGroupPager(req)
	case "RemediationsClient.NewListDeploymentsAtSubscriptionPager":
		resp, err = r.dispatchNewListDeploymentsAtSubscriptionPager(req)
	case "RemediationsClient.NewListForManagementGroupPager":
		resp, err = r.dispatchNewListForManagementGroupPager(req)
	case "RemediationsClient.NewListForResourcePager":
		resp, err = r.dispatchNewListForResourcePager(req)
	case "RemediationsClient.NewListForResourceGroupPager":
		resp, err = r.dispatchNewListForResourceGroupPager(req)
	case "RemediationsClient.NewListForSubscriptionPager":
		resp, err = r.dispatchNewListForSubscriptionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *RemediationsServerTransport) dispatchCancelAtManagementGroup(req *http.Request) (*http.Response, error) {
	if r.srv.CancelAtManagementGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method CancelAtManagementGroup not implemented")}
	}
	const regexStr = `/providers/(?P<managementGroupsNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cancel`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
	if err != nil {
		return nil, err
	}
	remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.CancelAtManagementGroup(req.Context(), managementGroupIDParam, remediationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Remediation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchCancelAtResource(req *http.Request) (*http.Response, error) {
	if r.srv.CancelAtResource == nil {
		return nil, &nonRetriableError{errors.New("fake for method CancelAtResource not implemented")}
	}
	const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cancel`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.CancelAtResource(req.Context(), resourceIDParam, remediationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Remediation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchCancelAtResourceGroup(req *http.Request) (*http.Response, error) {
	if r.srv.CancelAtResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method CancelAtResourceGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cancel`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.CancelAtResourceGroup(req.Context(), resourceGroupNameParam, remediationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Remediation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchCancelAtSubscription(req *http.Request) (*http.Response, error) {
	if r.srv.CancelAtSubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method CancelAtSubscription not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cancel`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.CancelAtSubscription(req.Context(), remediationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Remediation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchCreateOrUpdateAtManagementGroup(req *http.Request) (*http.Response, error) {
	if r.srv.CreateOrUpdateAtManagementGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateAtManagementGroup not implemented")}
	}
	const regexStr = `/providers/(?P<managementGroupsNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpolicyinsights.Remediation](req)
	if err != nil {
		return nil, err
	}
	managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
	if err != nil {
		return nil, err
	}
	remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.CreateOrUpdateAtManagementGroup(req.Context(), managementGroupIDParam, remediationNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Remediation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchCreateOrUpdateAtResource(req *http.Request) (*http.Response, error) {
	if r.srv.CreateOrUpdateAtResource == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateAtResource not implemented")}
	}
	const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpolicyinsights.Remediation](req)
	if err != nil {
		return nil, err
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.CreateOrUpdateAtResource(req.Context(), resourceIDParam, remediationNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Remediation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchCreateOrUpdateAtResourceGroup(req *http.Request) (*http.Response, error) {
	if r.srv.CreateOrUpdateAtResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateAtResourceGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpolicyinsights.Remediation](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.CreateOrUpdateAtResourceGroup(req.Context(), resourceGroupNameParam, remediationNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Remediation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchCreateOrUpdateAtSubscription(req *http.Request) (*http.Response, error) {
	if r.srv.CreateOrUpdateAtSubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdateAtSubscription not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpolicyinsights.Remediation](req)
	if err != nil {
		return nil, err
	}
	remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.CreateOrUpdateAtSubscription(req.Context(), remediationNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Remediation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchDeleteAtManagementGroup(req *http.Request) (*http.Response, error) {
	if r.srv.DeleteAtManagementGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteAtManagementGroup not implemented")}
	}
	const regexStr = `/providers/(?P<managementGroupsNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
	if err != nil {
		return nil, err
	}
	remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.DeleteAtManagementGroup(req.Context(), managementGroupIDParam, remediationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Remediation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchDeleteAtResource(req *http.Request) (*http.Response, error) {
	if r.srv.DeleteAtResource == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteAtResource not implemented")}
	}
	const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.DeleteAtResource(req.Context(), resourceIDParam, remediationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Remediation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchDeleteAtResourceGroup(req *http.Request) (*http.Response, error) {
	if r.srv.DeleteAtResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteAtResourceGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.DeleteAtResourceGroup(req.Context(), resourceGroupNameParam, remediationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Remediation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchDeleteAtSubscription(req *http.Request) (*http.Response, error) {
	if r.srv.DeleteAtSubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteAtSubscription not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.DeleteAtSubscription(req.Context(), remediationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Remediation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchGetAtManagementGroup(req *http.Request) (*http.Response, error) {
	if r.srv.GetAtManagementGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAtManagementGroup not implemented")}
	}
	const regexStr = `/providers/(?P<managementGroupsNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
	if err != nil {
		return nil, err
	}
	remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetAtManagementGroup(req.Context(), managementGroupIDParam, remediationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Remediation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchGetAtResource(req *http.Request) (*http.Response, error) {
	if r.srv.GetAtResource == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAtResource not implemented")}
	}
	const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
	if err != nil {
		return nil, err
	}
	remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetAtResource(req.Context(), resourceIDParam, remediationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Remediation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchGetAtResourceGroup(req *http.Request) (*http.Response, error) {
	if r.srv.GetAtResourceGroup == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAtResourceGroup not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetAtResourceGroup(req.Context(), resourceGroupNameParam, remediationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Remediation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchGetAtSubscription(req *http.Request) (*http.Response, error) {
	if r.srv.GetAtSubscription == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAtSubscription not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetAtSubscription(req.Context(), remediationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Remediation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchNewListDeploymentsAtManagementGroupPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListDeploymentsAtManagementGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListDeploymentsAtManagementGroupPager not implemented")}
	}
	newListDeploymentsAtManagementGroupPager := r.newListDeploymentsAtManagementGroupPager.get(req)
	if newListDeploymentsAtManagementGroupPager == nil {
		const regexStr = `/providers/(?P<managementGroupsNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listDeployments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
		if err != nil {
			return nil, err
		}
		remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top: topParam,
			}
		}
		resp := r.srv.NewListDeploymentsAtManagementGroupPager(managementGroupIDParam, remediationNameParam, queryOptions, nil)
		newListDeploymentsAtManagementGroupPager = &resp
		r.newListDeploymentsAtManagementGroupPager.add(req, newListDeploymentsAtManagementGroupPager)
		server.PagerResponderInjectNextLinks(newListDeploymentsAtManagementGroupPager, req, func(page *armpolicyinsights.RemediationsClientListDeploymentsAtManagementGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListDeploymentsAtManagementGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListDeploymentsAtManagementGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListDeploymentsAtManagementGroupPager) {
		r.newListDeploymentsAtManagementGroupPager.remove(req)
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchNewListDeploymentsAtResourcePager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListDeploymentsAtResourcePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListDeploymentsAtResourcePager not implemented")}
	}
	newListDeploymentsAtResourcePager := r.newListDeploymentsAtResourcePager.get(req)
	if newListDeploymentsAtResourcePager == nil {
		const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listDeployments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
		if err != nil {
			return nil, err
		}
		remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top: topParam,
			}
		}
		resp := r.srv.NewListDeploymentsAtResourcePager(resourceIDParam, remediationNameParam, queryOptions, nil)
		newListDeploymentsAtResourcePager = &resp
		r.newListDeploymentsAtResourcePager.add(req, newListDeploymentsAtResourcePager)
		server.PagerResponderInjectNextLinks(newListDeploymentsAtResourcePager, req, func(page *armpolicyinsights.RemediationsClientListDeploymentsAtResourceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListDeploymentsAtResourcePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListDeploymentsAtResourcePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListDeploymentsAtResourcePager) {
		r.newListDeploymentsAtResourcePager.remove(req)
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchNewListDeploymentsAtResourceGroupPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListDeploymentsAtResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListDeploymentsAtResourceGroupPager not implemented")}
	}
	newListDeploymentsAtResourceGroupPager := r.newListDeploymentsAtResourceGroupPager.get(req)
	if newListDeploymentsAtResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listDeployments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top: topParam,
			}
		}
		resp := r.srv.NewListDeploymentsAtResourceGroupPager(resourceGroupNameParam, remediationNameParam, queryOptions, nil)
		newListDeploymentsAtResourceGroupPager = &resp
		r.newListDeploymentsAtResourceGroupPager.add(req, newListDeploymentsAtResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListDeploymentsAtResourceGroupPager, req, func(page *armpolicyinsights.RemediationsClientListDeploymentsAtResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListDeploymentsAtResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListDeploymentsAtResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListDeploymentsAtResourceGroupPager) {
		r.newListDeploymentsAtResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchNewListDeploymentsAtSubscriptionPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListDeploymentsAtSubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListDeploymentsAtSubscriptionPager not implemented")}
	}
	newListDeploymentsAtSubscriptionPager := r.newListDeploymentsAtSubscriptionPager.get(req)
	if newListDeploymentsAtSubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations/(?P<remediationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listDeployments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		remediationNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("remediationName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top: topParam,
			}
		}
		resp := r.srv.NewListDeploymentsAtSubscriptionPager(remediationNameParam, queryOptions, nil)
		newListDeploymentsAtSubscriptionPager = &resp
		r.newListDeploymentsAtSubscriptionPager.add(req, newListDeploymentsAtSubscriptionPager)
		server.PagerResponderInjectNextLinks(newListDeploymentsAtSubscriptionPager, req, func(page *armpolicyinsights.RemediationsClientListDeploymentsAtSubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListDeploymentsAtSubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListDeploymentsAtSubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListDeploymentsAtSubscriptionPager) {
		r.newListDeploymentsAtSubscriptionPager.remove(req)
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchNewListForManagementGroupPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListForManagementGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForManagementGroupPager not implemented")}
	}
	newListForManagementGroupPager := r.newListForManagementGroupPager.get(req)
	if newListForManagementGroupPager == nil {
		const regexStr = `/providers/(?P<managementGroupsNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || filterParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:    topParam,
				Filter: filterParam,
			}
		}
		resp := r.srv.NewListForManagementGroupPager(managementGroupIDParam, queryOptions, nil)
		newListForManagementGroupPager = &resp
		r.newListForManagementGroupPager.add(req, newListForManagementGroupPager)
		server.PagerResponderInjectNextLinks(newListForManagementGroupPager, req, func(page *armpolicyinsights.RemediationsClientListForManagementGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForManagementGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListForManagementGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForManagementGroupPager) {
		r.newListForManagementGroupPager.remove(req)
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchNewListForResourcePager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListForResourcePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForResourcePager not implemented")}
	}
	newListForResourcePager := r.newListForResourcePager.get(req)
	if newListForResourcePager == nil {
		const regexStr = `/(?P<resourceId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceId")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || filterParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:    topParam,
				Filter: filterParam,
			}
		}
		resp := r.srv.NewListForResourcePager(resourceIDParam, queryOptions, nil)
		newListForResourcePager = &resp
		r.newListForResourcePager.add(req, newListForResourcePager)
		server.PagerResponderInjectNextLinks(newListForResourcePager, req, func(page *armpolicyinsights.RemediationsClientListForResourceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForResourcePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListForResourcePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForResourcePager) {
		r.newListForResourcePager.remove(req)
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchNewListForResourceGroupPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListForResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForResourceGroupPager not implemented")}
	}
	newListForResourceGroupPager := r.newListForResourceGroupPager.get(req)
	if newListForResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || filterParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:    topParam,
				Filter: filterParam,
			}
		}
		resp := r.srv.NewListForResourceGroupPager(resourceGroupNameParam, queryOptions, nil)
		newListForResourceGroupPager = &resp
		r.newListForResourceGroupPager.add(req, newListForResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListForResourceGroupPager, req, func(page *armpolicyinsights.RemediationsClientListForResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListForResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForResourceGroupPager) {
		r.newListForResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (r *RemediationsServerTransport) dispatchNewListForSubscriptionPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListForSubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForSubscriptionPager not implemented")}
	}
	newListForSubscriptionPager := r.newListForSubscriptionPager.get(req)
	if newListForSubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.PolicyInsights/remediations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var queryOptions *armpolicyinsights.QueryOptions
		if topParam != nil || filterParam != nil {
			queryOptions = &armpolicyinsights.QueryOptions{
				Top:    topParam,
				Filter: filterParam,
			}
		}
		resp := r.srv.NewListForSubscriptionPager(queryOptions, nil)
		newListForSubscriptionPager = &resp
		r.newListForSubscriptionPager.add(req, newListForSubscriptionPager)
		server.PagerResponderInjectNextLinks(newListForSubscriptionPager, req, func(page *armpolicyinsights.RemediationsClientListForSubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForSubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListForSubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForSubscriptionPager) {
		r.newListForSubscriptionPager.remove(req)
	}
	return resp, nil
}
