//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hybriddatamanager/armhybriddatamanager"
	"net/http"
	"net/url"
	"regexp"
)

// DataStoresServer is a fake server for instances of the armhybriddatamanager.DataStoresClient type.
type DataStoresServer struct {
	// BeginCreateOrUpdate is the fake for method DataStoresClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, dataStoreName string, resourceGroupName string, dataManagerName string, dataStore armhybriddatamanager.DataStore, options *armhybriddatamanager.DataStoresClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armhybriddatamanager.DataStoresClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method DataStoresClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, dataStoreName string, resourceGroupName string, dataManagerName string, options *armhybriddatamanager.DataStoresClientBeginDeleteOptions) (resp azfake.PollerResponder[armhybriddatamanager.DataStoresClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DataStoresClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, dataStoreName string, resourceGroupName string, dataManagerName string, options *armhybriddatamanager.DataStoresClientGetOptions) (resp azfake.Responder[armhybriddatamanager.DataStoresClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByDataManagerPager is the fake for method DataStoresClient.NewListByDataManagerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDataManagerPager func(resourceGroupName string, dataManagerName string, options *armhybriddatamanager.DataStoresClientListByDataManagerOptions) (resp azfake.PagerResponder[armhybriddatamanager.DataStoresClientListByDataManagerResponse])
}

// NewDataStoresServerTransport creates a new instance of DataStoresServerTransport with the provided implementation.
// The returned DataStoresServerTransport instance is connected to an instance of armhybriddatamanager.DataStoresClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDataStoresServerTransport(srv *DataStoresServer) *DataStoresServerTransport {
	return &DataStoresServerTransport{
		srv:                       srv,
		beginCreateOrUpdate:       newTracker[azfake.PollerResponder[armhybriddatamanager.DataStoresClientCreateOrUpdateResponse]](),
		beginDelete:               newTracker[azfake.PollerResponder[armhybriddatamanager.DataStoresClientDeleteResponse]](),
		newListByDataManagerPager: newTracker[azfake.PagerResponder[armhybriddatamanager.DataStoresClientListByDataManagerResponse]](),
	}
}

// DataStoresServerTransport connects instances of armhybriddatamanager.DataStoresClient to instances of DataStoresServer.
// Don't use this type directly, use NewDataStoresServerTransport instead.
type DataStoresServerTransport struct {
	srv                       *DataStoresServer
	beginCreateOrUpdate       *tracker[azfake.PollerResponder[armhybriddatamanager.DataStoresClientCreateOrUpdateResponse]]
	beginDelete               *tracker[azfake.PollerResponder[armhybriddatamanager.DataStoresClientDeleteResponse]]
	newListByDataManagerPager *tracker[azfake.PagerResponder[armhybriddatamanager.DataStoresClientListByDataManagerResponse]]
}

// Do implements the policy.Transporter interface for DataStoresServerTransport.
func (d *DataStoresServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DataStoresClient.BeginCreateOrUpdate":
		resp, err = d.dispatchBeginCreateOrUpdate(req)
	case "DataStoresClient.BeginDelete":
		resp, err = d.dispatchBeginDelete(req)
	case "DataStoresClient.Get":
		resp, err = d.dispatchGet(req)
	case "DataStoresClient.NewListByDataManagerPager":
		resp, err = d.dispatchNewListByDataManagerPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DataStoresServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := d.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataStores/(?P<dataStoreName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armhybriddatamanager.DataStore](req)
		if err != nil {
			return nil, err
		}
		dataStoreNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataStoreName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginCreateOrUpdate(req.Context(), dataStoreNameParam, resourceGroupNameParam, dataManagerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		d.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		d.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (d *DataStoresServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := d.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataStores/(?P<dataStoreName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		dataStoreNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataStoreName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDelete(req.Context(), dataStoreNameParam, resourceGroupNameParam, dataManagerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		d.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		d.beginDelete.remove(req)
	}

	return resp, nil
}

func (d *DataStoresServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataStores/(?P<dataStoreName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	dataStoreNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataStoreName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), dataStoreNameParam, resourceGroupNameParam, dataManagerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DataStore, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DataStoresServerTransport) dispatchNewListByDataManagerPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByDataManagerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDataManagerPager not implemented")}
	}
	newListByDataManagerPager := d.newListByDataManagerPager.get(req)
	if newListByDataManagerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataStores`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armhybriddatamanager.DataStoresClientListByDataManagerOptions
		if filterParam != nil {
			options = &armhybriddatamanager.DataStoresClientListByDataManagerOptions{
				Filter: filterParam,
			}
		}
		resp := d.srv.NewListByDataManagerPager(resourceGroupNameParam, dataManagerNameParam, options)
		newListByDataManagerPager = &resp
		d.newListByDataManagerPager.add(req, newListByDataManagerPager)
		server.PagerResponderInjectNextLinks(newListByDataManagerPager, req, func(page *armhybriddatamanager.DataStoresClientListByDataManagerResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDataManagerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByDataManagerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDataManagerPager) {
		d.newListByDataManagerPager.remove(req)
	}
	return resp, nil
}
