//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdigitaltwins

const (
	moduleName    = "github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/digitaltwins/armdigitaltwins"
	moduleVersion = "v1.2.0"
)

// AuthenticationType - Specifies the authentication type being used for connecting to the endpoint. Defaults to 'KeyBased'.
// If 'KeyBased' is selected, a connection string must be specified (at least the primary connection
// string). If 'IdentityBased' is select, the endpointUri and entityPath properties must be specified.
type AuthenticationType string

const (
	AuthenticationTypeIdentityBased AuthenticationType = "IdentityBased"
	AuthenticationTypeKeyBased      AuthenticationType = "KeyBased"
)

// PossibleAuthenticationTypeValues returns the possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{
		AuthenticationTypeIdentityBased,
		AuthenticationTypeKeyBased,
	}
}

type CleanupConnectionArtifacts string

const (
	CleanupConnectionArtifactsFalse CleanupConnectionArtifacts = "false"
	CleanupConnectionArtifactsTrue  CleanupConnectionArtifacts = "true"
)

// PossibleCleanupConnectionArtifactsValues returns the possible values for the CleanupConnectionArtifacts const type.
func PossibleCleanupConnectionArtifactsValues() []CleanupConnectionArtifacts {
	return []CleanupConnectionArtifacts{
		CleanupConnectionArtifactsFalse,
		CleanupConnectionArtifactsTrue,
	}
}

// ConnectionPropertiesProvisioningState - The provisioning state.
type ConnectionPropertiesProvisioningState string

const (
	ConnectionPropertiesProvisioningStateApproved     ConnectionPropertiesProvisioningState = "Approved"
	ConnectionPropertiesProvisioningStateDisconnected ConnectionPropertiesProvisioningState = "Disconnected"
	ConnectionPropertiesProvisioningStatePending      ConnectionPropertiesProvisioningState = "Pending"
	ConnectionPropertiesProvisioningStateRejected     ConnectionPropertiesProvisioningState = "Rejected"
)

// PossibleConnectionPropertiesProvisioningStateValues returns the possible values for the ConnectionPropertiesProvisioningState const type.
func PossibleConnectionPropertiesProvisioningStateValues() []ConnectionPropertiesProvisioningState {
	return []ConnectionPropertiesProvisioningState{
		ConnectionPropertiesProvisioningStateApproved,
		ConnectionPropertiesProvisioningStateDisconnected,
		ConnectionPropertiesProvisioningStatePending,
		ConnectionPropertiesProvisioningStateRejected,
	}
}

// ConnectionType - The type of time series connection resource.
type ConnectionType string

const (
	ConnectionTypeAzureDataExplorer ConnectionType = "AzureDataExplorer"
)

// PossibleConnectionTypeValues returns the possible values for the ConnectionType const type.
func PossibleConnectionTypeValues() []ConnectionType {
	return []ConnectionType{
		ConnectionTypeAzureDataExplorer,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DigitalTwinsIdentityType - The type of Managed Identity used by the DigitalTwinsInstance.
type DigitalTwinsIdentityType string

const (
	DigitalTwinsIdentityTypeNone                       DigitalTwinsIdentityType = "None"
	DigitalTwinsIdentityTypeSystemAssigned             DigitalTwinsIdentityType = "SystemAssigned"
	DigitalTwinsIdentityTypeSystemAssignedUserAssigned DigitalTwinsIdentityType = "SystemAssigned,UserAssigned"
	DigitalTwinsIdentityTypeUserAssigned               DigitalTwinsIdentityType = "UserAssigned"
)

// PossibleDigitalTwinsIdentityTypeValues returns the possible values for the DigitalTwinsIdentityType const type.
func PossibleDigitalTwinsIdentityTypeValues() []DigitalTwinsIdentityType {
	return []DigitalTwinsIdentityType{
		DigitalTwinsIdentityTypeNone,
		DigitalTwinsIdentityTypeSystemAssigned,
		DigitalTwinsIdentityTypeSystemAssignedUserAssigned,
		DigitalTwinsIdentityTypeUserAssigned,
	}
}

// EndpointProvisioningState - The provisioning state.
type EndpointProvisioningState string

const (
	EndpointProvisioningStateCanceled     EndpointProvisioningState = "Canceled"
	EndpointProvisioningStateDeleted      EndpointProvisioningState = "Deleted"
	EndpointProvisioningStateDeleting     EndpointProvisioningState = "Deleting"
	EndpointProvisioningStateDisabled     EndpointProvisioningState = "Disabled"
	EndpointProvisioningStateFailed       EndpointProvisioningState = "Failed"
	EndpointProvisioningStateMoving       EndpointProvisioningState = "Moving"
	EndpointProvisioningStateProvisioning EndpointProvisioningState = "Provisioning"
	EndpointProvisioningStateRestoring    EndpointProvisioningState = "Restoring"
	EndpointProvisioningStateSucceeded    EndpointProvisioningState = "Succeeded"
	EndpointProvisioningStateSuspending   EndpointProvisioningState = "Suspending"
	EndpointProvisioningStateUpdating     EndpointProvisioningState = "Updating"
	EndpointProvisioningStateWarning      EndpointProvisioningState = "Warning"
)

// PossibleEndpointProvisioningStateValues returns the possible values for the EndpointProvisioningState const type.
func PossibleEndpointProvisioningStateValues() []EndpointProvisioningState {
	return []EndpointProvisioningState{
		EndpointProvisioningStateCanceled,
		EndpointProvisioningStateDeleted,
		EndpointProvisioningStateDeleting,
		EndpointProvisioningStateDisabled,
		EndpointProvisioningStateFailed,
		EndpointProvisioningStateMoving,
		EndpointProvisioningStateProvisioning,
		EndpointProvisioningStateRestoring,
		EndpointProvisioningStateSucceeded,
		EndpointProvisioningStateSuspending,
		EndpointProvisioningStateUpdating,
		EndpointProvisioningStateWarning,
	}
}

// EndpointType - The type of Digital Twins endpoint
type EndpointType string

const (
	EndpointTypeEventGrid  EndpointType = "EventGrid"
	EndpointTypeEventHub   EndpointType = "EventHub"
	EndpointTypeServiceBus EndpointType = "ServiceBus"
)

// PossibleEndpointTypeValues returns the possible values for the EndpointType const type.
func PossibleEndpointTypeValues() []EndpointType {
	return []EndpointType{
		EndpointTypeEventGrid,
		EndpointTypeEventHub,
		EndpointTypeServiceBus,
	}
}

// IdentityType - The type of managed identity used.
type IdentityType string

const (
	IdentityTypeSystemAssigned IdentityType = "SystemAssigned"
	IdentityTypeUserAssigned   IdentityType = "UserAssigned"
)

// PossibleIdentityTypeValues returns the possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{
		IdentityTypeSystemAssigned,
		IdentityTypeUserAssigned,
	}
}

// PrivateLinkServiceConnectionStatus - The status of a private endpoint connection.
type PrivateLinkServiceConnectionStatus string

const (
	PrivateLinkServiceConnectionStatusApproved     PrivateLinkServiceConnectionStatus = "Approved"
	PrivateLinkServiceConnectionStatusDisconnected PrivateLinkServiceConnectionStatus = "Disconnected"
	PrivateLinkServiceConnectionStatusPending      PrivateLinkServiceConnectionStatus = "Pending"
	PrivateLinkServiceConnectionStatusRejected     PrivateLinkServiceConnectionStatus = "Rejected"
)

// PossiblePrivateLinkServiceConnectionStatusValues returns the possible values for the PrivateLinkServiceConnectionStatus const type.
func PossiblePrivateLinkServiceConnectionStatusValues() []PrivateLinkServiceConnectionStatus {
	return []PrivateLinkServiceConnectionStatus{
		PrivateLinkServiceConnectionStatusApproved,
		PrivateLinkServiceConnectionStatusDisconnected,
		PrivateLinkServiceConnectionStatusPending,
		PrivateLinkServiceConnectionStatusRejected,
	}
}

// ProvisioningState - The provisioning state.
type ProvisioningState string

const (
	ProvisioningStateCanceled     ProvisioningState = "Canceled"
	ProvisioningStateDeleted      ProvisioningState = "Deleted"
	ProvisioningStateDeleting     ProvisioningState = "Deleting"
	ProvisioningStateFailed       ProvisioningState = "Failed"
	ProvisioningStateMoving       ProvisioningState = "Moving"
	ProvisioningStateProvisioning ProvisioningState = "Provisioning"
	ProvisioningStateRestoring    ProvisioningState = "Restoring"
	ProvisioningStateSucceeded    ProvisioningState = "Succeeded"
	ProvisioningStateSuspending   ProvisioningState = "Suspending"
	ProvisioningStateUpdating     ProvisioningState = "Updating"
	ProvisioningStateWarning      ProvisioningState = "Warning"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateCanceled,
		ProvisioningStateDeleted,
		ProvisioningStateDeleting,
		ProvisioningStateFailed,
		ProvisioningStateMoving,
		ProvisioningStateProvisioning,
		ProvisioningStateRestoring,
		ProvisioningStateSucceeded,
		ProvisioningStateSuspending,
		ProvisioningStateUpdating,
		ProvisioningStateWarning,
	}
}

// PublicNetworkAccess - Public network access for the DigitalTwinsInstance.
type PublicNetworkAccess string

const (
	PublicNetworkAccessDisabled PublicNetworkAccess = "Disabled"
	PublicNetworkAccessEnabled  PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns the possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{
		PublicNetworkAccessDisabled,
		PublicNetworkAccessEnabled,
	}
}

// Reason - Message providing the reason why the given name is invalid.
type Reason string

const (
	ReasonAlreadyExists Reason = "AlreadyExists"
	ReasonInvalid       Reason = "Invalid"
)

// PossibleReasonValues returns the possible values for the Reason const type.
func PossibleReasonValues() []Reason {
	return []Reason{
		ReasonAlreadyExists,
		ReasonInvalid,
	}
}

// RecordPropertyAndItemRemovals - Specifies whether or not to record twin / relationship property and item removals, including
// removals of indexed or keyed values (such as map entries, array elements, etc.). This feature is
// de-activated unless explicitly set to 'true'. Setting this property to 'true' will generate an additional column in the
// property events table in ADX.
type RecordPropertyAndItemRemovals string

const (
	RecordPropertyAndItemRemovalsFalse RecordPropertyAndItemRemovals = "false"
	RecordPropertyAndItemRemovalsTrue  RecordPropertyAndItemRemovals = "true"
)

// PossibleRecordPropertyAndItemRemovalsValues returns the possible values for the RecordPropertyAndItemRemovals const type.
func PossibleRecordPropertyAndItemRemovalsValues() []RecordPropertyAndItemRemovals {
	return []RecordPropertyAndItemRemovals{
		RecordPropertyAndItemRemovalsFalse,
		RecordPropertyAndItemRemovalsTrue,
	}
}

// TimeSeriesDatabaseConnectionState - The provisioning state.
type TimeSeriesDatabaseConnectionState string

const (
	TimeSeriesDatabaseConnectionStateCanceled     TimeSeriesDatabaseConnectionState = "Canceled"
	TimeSeriesDatabaseConnectionStateDeleted      TimeSeriesDatabaseConnectionState = "Deleted"
	TimeSeriesDatabaseConnectionStateDeleting     TimeSeriesDatabaseConnectionState = "Deleting"
	TimeSeriesDatabaseConnectionStateDisabled     TimeSeriesDatabaseConnectionState = "Disabled"
	TimeSeriesDatabaseConnectionStateFailed       TimeSeriesDatabaseConnectionState = "Failed"
	TimeSeriesDatabaseConnectionStateMoving       TimeSeriesDatabaseConnectionState = "Moving"
	TimeSeriesDatabaseConnectionStateProvisioning TimeSeriesDatabaseConnectionState = "Provisioning"
	TimeSeriesDatabaseConnectionStateRestoring    TimeSeriesDatabaseConnectionState = "Restoring"
	TimeSeriesDatabaseConnectionStateSucceeded    TimeSeriesDatabaseConnectionState = "Succeeded"
	TimeSeriesDatabaseConnectionStateSuspending   TimeSeriesDatabaseConnectionState = "Suspending"
	TimeSeriesDatabaseConnectionStateUpdating     TimeSeriesDatabaseConnectionState = "Updating"
	TimeSeriesDatabaseConnectionStateWarning      TimeSeriesDatabaseConnectionState = "Warning"
)

// PossibleTimeSeriesDatabaseConnectionStateValues returns the possible values for the TimeSeriesDatabaseConnectionState const type.
func PossibleTimeSeriesDatabaseConnectionStateValues() []TimeSeriesDatabaseConnectionState {
	return []TimeSeriesDatabaseConnectionState{
		TimeSeriesDatabaseConnectionStateCanceled,
		TimeSeriesDatabaseConnectionStateDeleted,
		TimeSeriesDatabaseConnectionStateDeleting,
		TimeSeriesDatabaseConnectionStateDisabled,
		TimeSeriesDatabaseConnectionStateFailed,
		TimeSeriesDatabaseConnectionStateMoving,
		TimeSeriesDatabaseConnectionStateProvisioning,
		TimeSeriesDatabaseConnectionStateRestoring,
		TimeSeriesDatabaseConnectionStateSucceeded,
		TimeSeriesDatabaseConnectionStateSuspending,
		TimeSeriesDatabaseConnectionStateUpdating,
		TimeSeriesDatabaseConnectionStateWarning,
	}
}
