//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/billing/armbilling"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// ProductsServer is a fake server for instances of the armbilling.ProductsClient type.
type ProductsServer struct {
	// Get is the fake for method ProductsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, billingAccountName string, productName string, options *armbilling.ProductsClientGetOptions) (resp azfake.Responder[armbilling.ProductsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByBillingAccountPager is the fake for method ProductsClient.NewListByBillingAccountPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBillingAccountPager func(billingAccountName string, options *armbilling.ProductsClientListByBillingAccountOptions) (resp azfake.PagerResponder[armbilling.ProductsClientListByBillingAccountResponse])

	// NewListByBillingProfilePager is the fake for method ProductsClient.NewListByBillingProfilePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByBillingProfilePager func(billingAccountName string, billingProfileName string, options *armbilling.ProductsClientListByBillingProfileOptions) (resp azfake.PagerResponder[armbilling.ProductsClientListByBillingProfileResponse])

	// NewListByCustomerPager is the fake for method ProductsClient.NewListByCustomerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByCustomerPager func(billingAccountName string, customerName string, options *armbilling.ProductsClientListByCustomerOptions) (resp azfake.PagerResponder[armbilling.ProductsClientListByCustomerResponse])

	// NewListByInvoiceSectionPager is the fake for method ProductsClient.NewListByInvoiceSectionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByInvoiceSectionPager func(billingAccountName string, billingProfileName string, invoiceSectionName string, options *armbilling.ProductsClientListByInvoiceSectionOptions) (resp azfake.PagerResponder[armbilling.ProductsClientListByInvoiceSectionResponse])

	// Move is the fake for method ProductsClient.Move
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	Move func(ctx context.Context, billingAccountName string, productName string, parameters armbilling.TransferProductRequestProperties, options *armbilling.ProductsClientMoveOptions) (resp azfake.Responder[armbilling.ProductsClientMoveResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method ProductsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, billingAccountName string, productName string, parameters armbilling.Product, options *armbilling.ProductsClientUpdateOptions) (resp azfake.Responder[armbilling.ProductsClientUpdateResponse], errResp azfake.ErrorResponder)

	// ValidateMove is the fake for method ProductsClient.ValidateMove
	// HTTP status codes to indicate success: http.StatusOK
	ValidateMove func(ctx context.Context, billingAccountName string, productName string, parameters armbilling.TransferProductRequestProperties, options *armbilling.ProductsClientValidateMoveOptions) (resp azfake.Responder[armbilling.ProductsClientValidateMoveResponse], errResp azfake.ErrorResponder)
}

// NewProductsServerTransport creates a new instance of ProductsServerTransport with the provided implementation.
// The returned ProductsServerTransport instance is connected to an instance of armbilling.ProductsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewProductsServerTransport(srv *ProductsServer) *ProductsServerTransport {
	return &ProductsServerTransport{
		srv:                          srv,
		newListByBillingAccountPager: newTracker[azfake.PagerResponder[armbilling.ProductsClientListByBillingAccountResponse]](),
		newListByBillingProfilePager: newTracker[azfake.PagerResponder[armbilling.ProductsClientListByBillingProfileResponse]](),
		newListByCustomerPager:       newTracker[azfake.PagerResponder[armbilling.ProductsClientListByCustomerResponse]](),
		newListByInvoiceSectionPager: newTracker[azfake.PagerResponder[armbilling.ProductsClientListByInvoiceSectionResponse]](),
	}
}

// ProductsServerTransport connects instances of armbilling.ProductsClient to instances of ProductsServer.
// Don't use this type directly, use NewProductsServerTransport instead.
type ProductsServerTransport struct {
	srv                          *ProductsServer
	newListByBillingAccountPager *tracker[azfake.PagerResponder[armbilling.ProductsClientListByBillingAccountResponse]]
	newListByBillingProfilePager *tracker[azfake.PagerResponder[armbilling.ProductsClientListByBillingProfileResponse]]
	newListByCustomerPager       *tracker[azfake.PagerResponder[armbilling.ProductsClientListByCustomerResponse]]
	newListByInvoiceSectionPager *tracker[azfake.PagerResponder[armbilling.ProductsClientListByInvoiceSectionResponse]]
}

// Do implements the policy.Transporter interface for ProductsServerTransport.
func (p *ProductsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ProductsClient.Get":
		resp, err = p.dispatchGet(req)
	case "ProductsClient.NewListByBillingAccountPager":
		resp, err = p.dispatchNewListByBillingAccountPager(req)
	case "ProductsClient.NewListByBillingProfilePager":
		resp, err = p.dispatchNewListByBillingProfilePager(req)
	case "ProductsClient.NewListByCustomerPager":
		resp, err = p.dispatchNewListByCustomerPager(req)
	case "ProductsClient.NewListByInvoiceSectionPager":
		resp, err = p.dispatchNewListByInvoiceSectionPager(req)
	case "ProductsClient.Move":
		resp, err = p.dispatchMove(req)
	case "ProductsClient.Update":
		resp, err = p.dispatchUpdate(req)
	case "ProductsClient.ValidateMove":
		resp, err = p.dispatchValidateMove(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *ProductsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/products/(?P<productName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	productNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("productName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), billingAccountNameParam, productNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Product, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *ProductsServerTransport) dispatchNewListByBillingAccountPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByBillingAccountPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBillingAccountPager not implemented")}
	}
	newListByBillingAccountPager := p.newListByBillingAccountPager.get(req)
	if newListByBillingAccountPager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/products`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armbilling.ProductsClientListByBillingAccountOptions
		if filterParam != nil {
			options = &armbilling.ProductsClientListByBillingAccountOptions{
				Filter: filterParam,
			}
		}
		resp := p.srv.NewListByBillingAccountPager(billingAccountNameParam, options)
		newListByBillingAccountPager = &resp
		p.newListByBillingAccountPager.add(req, newListByBillingAccountPager)
		server.PagerResponderInjectNextLinks(newListByBillingAccountPager, req, func(page *armbilling.ProductsClientListByBillingAccountResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBillingAccountPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByBillingAccountPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBillingAccountPager) {
		p.newListByBillingAccountPager.remove(req)
	}
	return resp, nil
}

func (p *ProductsServerTransport) dispatchNewListByBillingProfilePager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByBillingProfilePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByBillingProfilePager not implemented")}
	}
	newListByBillingProfilePager := p.newListByBillingProfilePager.get(req)
	if newListByBillingProfilePager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/products`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armbilling.ProductsClientListByBillingProfileOptions
		if filterParam != nil {
			options = &armbilling.ProductsClientListByBillingProfileOptions{
				Filter: filterParam,
			}
		}
		resp := p.srv.NewListByBillingProfilePager(billingAccountNameParam, billingProfileNameParam, options)
		newListByBillingProfilePager = &resp
		p.newListByBillingProfilePager.add(req, newListByBillingProfilePager)
		server.PagerResponderInjectNextLinks(newListByBillingProfilePager, req, func(page *armbilling.ProductsClientListByBillingProfileResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByBillingProfilePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByBillingProfilePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByBillingProfilePager) {
		p.newListByBillingProfilePager.remove(req)
	}
	return resp, nil
}

func (p *ProductsServerTransport) dispatchNewListByCustomerPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByCustomerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByCustomerPager not implemented")}
	}
	newListByCustomerPager := p.newListByCustomerPager.get(req)
	if newListByCustomerPager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/customers/(?P<customerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/products`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		customerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("customerName")])
		if err != nil {
			return nil, err
		}
		resp := p.srv.NewListByCustomerPager(billingAccountNameParam, customerNameParam, nil)
		newListByCustomerPager = &resp
		p.newListByCustomerPager.add(req, newListByCustomerPager)
		server.PagerResponderInjectNextLinks(newListByCustomerPager, req, func(page *armbilling.ProductsClientListByCustomerResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByCustomerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByCustomerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByCustomerPager) {
		p.newListByCustomerPager.remove(req)
	}
	return resp, nil
}

func (p *ProductsServerTransport) dispatchNewListByInvoiceSectionPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByInvoiceSectionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByInvoiceSectionPager not implemented")}
	}
	newListByInvoiceSectionPager := p.newListByInvoiceSectionPager.get(req)
	if newListByInvoiceSectionPager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoiceSections/(?P<invoiceSectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/products`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
		if err != nil {
			return nil, err
		}
		invoiceSectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceSectionName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armbilling.ProductsClientListByInvoiceSectionOptions
		if filterParam != nil {
			options = &armbilling.ProductsClientListByInvoiceSectionOptions{
				Filter: filterParam,
			}
		}
		resp := p.srv.NewListByInvoiceSectionPager(billingAccountNameParam, billingProfileNameParam, invoiceSectionNameParam, options)
		newListByInvoiceSectionPager = &resp
		p.newListByInvoiceSectionPager.add(req, newListByInvoiceSectionPager)
		server.PagerResponderInjectNextLinks(newListByInvoiceSectionPager, req, func(page *armbilling.ProductsClientListByInvoiceSectionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByInvoiceSectionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByInvoiceSectionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByInvoiceSectionPager) {
		p.newListByInvoiceSectionPager.remove(req)
	}
	return resp, nil
}

func (p *ProductsServerTransport) dispatchMove(req *http.Request) (*http.Response, error) {
	if p.srv.Move == nil {
		return nil, &nonRetriableError{errors.New("fake for method Move not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/products/(?P<productName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/move`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armbilling.TransferProductRequestProperties](req)
	if err != nil {
		return nil, err
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	productNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("productName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Move(req.Context(), billingAccountNameParam, productNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Product, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).Location; val != nil {
		resp.Header.Set("Location", *val)
	}
	if val := server.GetResponse(respr).RetryAfter; val != nil {
		resp.Header.Set("Retry-After", strconv.FormatInt(int64(*val), 10))
	}
	return resp, nil
}

func (p *ProductsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/products/(?P<productName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armbilling.Product](req)
	if err != nil {
		return nil, err
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	productNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("productName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Update(req.Context(), billingAccountNameParam, productNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Product, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *ProductsServerTransport) dispatchValidateMove(req *http.Request) (*http.Response, error) {
	if p.srv.ValidateMove == nil {
		return nil, &nonRetriableError{errors.New("fake for method ValidateMove not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/products/(?P<productName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validateMoveEligibility`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armbilling.TransferProductRequestProperties](req)
	if err != nil {
		return nil, err
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	productNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("productName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.ValidateMove(req.Context(), billingAccountNameParam, productNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ValidateProductTransferEligibilityResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
