//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/billing/armbilling"
	"net/http"
	"net/url"
	"regexp"
)

// EnrollmentAccountsServer is a fake server for instances of the armbilling.EnrollmentAccountsClient type.
type EnrollmentAccountsServer struct {
	// Get is the fake for method EnrollmentAccountsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, name string, options *armbilling.EnrollmentAccountsClientGetOptions) (resp azfake.Responder[armbilling.EnrollmentAccountsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method EnrollmentAccountsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armbilling.EnrollmentAccountsClientListOptions) (resp azfake.PagerResponder[armbilling.EnrollmentAccountsClientListResponse])
}

// NewEnrollmentAccountsServerTransport creates a new instance of EnrollmentAccountsServerTransport with the provided implementation.
// The returned EnrollmentAccountsServerTransport instance is connected to an instance of armbilling.EnrollmentAccountsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewEnrollmentAccountsServerTransport(srv *EnrollmentAccountsServer) *EnrollmentAccountsServerTransport {
	return &EnrollmentAccountsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armbilling.EnrollmentAccountsClientListResponse]](),
	}
}

// EnrollmentAccountsServerTransport connects instances of armbilling.EnrollmentAccountsClient to instances of EnrollmentAccountsServer.
// Don't use this type directly, use NewEnrollmentAccountsServerTransport instead.
type EnrollmentAccountsServerTransport struct {
	srv          *EnrollmentAccountsServer
	newListPager *tracker[azfake.PagerResponder[armbilling.EnrollmentAccountsClientListResponse]]
}

// Do implements the policy.Transporter interface for EnrollmentAccountsServerTransport.
func (e *EnrollmentAccountsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "EnrollmentAccountsClient.Get":
		resp, err = e.dispatchGet(req)
	case "EnrollmentAccountsClient.NewListPager":
		resp, err = e.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *EnrollmentAccountsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if e.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/enrollmentAccounts/(?P<name>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	nameParam, err := url.PathUnescape(matches[regex.SubexpIndex("name")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Get(req.Context(), nameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EnrollmentAccountSummary, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *EnrollmentAccountsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := e.newListPager.get(req)
	if newListPager == nil {
		resp := e.srv.NewListPager(nil)
		newListPager = &resp
		e.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armbilling.EnrollmentAccountsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		e.newListPager.remove(req)
	}
	return resp, nil
}
