//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armavs_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/avs/armavs"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/Addons_List.json
func ExampleAddonsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAddonsClient().NewListPager("group1", "cloud1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.AddonList = armavs.AddonList{
		// 	Value: []*armavs.Addon{
		// 		{
		// 			Name: to.Ptr("srm"),
		// 			Type: to.Ptr("Microsoft.AVS/privateClouds/addons"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/addons/srm"),
		// 			Properties: &armavs.AddonSrmProperties{
		// 				AddonType: to.Ptr(armavs.AddonTypeSRM),
		// 				ProvisioningState: to.Ptr(armavs.AddonProvisioningStateSucceeded),
		// 				LicenseKey: to.Ptr("41915178-A8FF-4A4D-B683-6D735AF5E3F5"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/Addons_Get_ArcReg.json
func ExampleAddonsClient_Get_addonsGetArcReg() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAddonsClient().Get(ctx, "group1", "cloud1", "arc", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Addon = armavs.Addon{
	// 	Name: to.Ptr("arc"),
	// 	Type: to.Ptr("Microsoft.AVS/privateClouds/addons"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/addons/arc"),
	// 	Properties: &armavs.AddonArcProperties{
	// 		AddonType: to.Ptr(armavs.AddonTypeArc),
	// 		ProvisioningState: to.Ptr(armavs.AddonProvisioningStateSucceeded),
	// 		VCenter: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg_test/providers/Microsoft.ConnectedVMwarevSphere/VCenters/test-vcenter"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/Addons_Get_HCX.json
func ExampleAddonsClient_Get_addonsGetHcx() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAddonsClient().Get(ctx, "group1", "cloud1", "hcx", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Addon = armavs.Addon{
	// 	Name: to.Ptr("hcx"),
	// 	Type: to.Ptr("Microsoft.AVS/privateClouds/addons"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/addons/hcx"),
	// 	Properties: &armavs.AddonHcxProperties{
	// 		AddonType: to.Ptr(armavs.AddonTypeHCX),
	// 		ProvisioningState: to.Ptr(armavs.AddonProvisioningStateSucceeded),
	// 		Offer: to.Ptr("VMware MaaS Cloud Provider (Enterprise)"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/Addons_Get_SRM.json
func ExampleAddonsClient_Get_addonsGetSrm() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAddonsClient().Get(ctx, "group1", "cloud1", "srm", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Addon = armavs.Addon{
	// 	Name: to.Ptr("srm"),
	// 	Type: to.Ptr("Microsoft.AVS/privateClouds/addons"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/addons/srm"),
	// 	Properties: &armavs.AddonSrmProperties{
	// 		AddonType: to.Ptr(armavs.AddonTypeSRM),
	// 		ProvisioningState: to.Ptr(armavs.AddonProvisioningStateSucceeded),
	// 		LicenseKey: to.Ptr("41915178-A8FF-4A4D-B683-6D735AF5E3F5"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/Addons_Get_VR.json
func ExampleAddonsClient_Get_addonsGetVr() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewAddonsClient().Get(ctx, "group1", "cloud1", "vr", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Addon = armavs.Addon{
	// 	Name: to.Ptr("vr"),
	// 	Type: to.Ptr("Microsoft.AVS/privateClouds/addons"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/addons/vr"),
	// 	Properties: &armavs.AddonVrProperties{
	// 		AddonType: to.Ptr(armavs.AddonTypeVR),
	// 		ProvisioningState: to.Ptr(armavs.AddonProvisioningStateSucceeded),
	// 		VrsCount: to.Ptr[int32](1),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/Addons_CreateOrUpdate_ArcReg.json
func ExampleAddonsClient_BeginCreateOrUpdate_addonsCreateOrUpdateArc() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAddonsClient().BeginCreateOrUpdate(ctx, "group1", "cloud1", "arc", armavs.Addon{
		Properties: &armavs.AddonArcProperties{
			AddonType: to.Ptr(armavs.AddonTypeArc),
			VCenter:   to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg_test/providers/Microsoft.ConnectedVMwarevSphere/VCenters/test-vcenter"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Addon = armavs.Addon{
	// 	Name: to.Ptr("arc"),
	// 	Type: to.Ptr("Microsoft.AVS/privateClouds/addons"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/addons/arc"),
	// 	Properties: &armavs.AddonArcProperties{
	// 		AddonType: to.Ptr(armavs.AddonTypeArc),
	// 		ProvisioningState: to.Ptr(armavs.AddonProvisioningStateSucceeded),
	// 		VCenter: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg_test/providers/Microsoft.ConnectedVMwarevSphere/VCenters/test-vcenter"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/Addons_CreateOrUpdate_HCX.json
func ExampleAddonsClient_BeginCreateOrUpdate_addonsCreateOrUpdateHcx() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAddonsClient().BeginCreateOrUpdate(ctx, "group1", "cloud1", "hcx", armavs.Addon{
		Properties: &armavs.AddonHcxProperties{
			AddonType: to.Ptr(armavs.AddonTypeHCX),
			Offer:     to.Ptr("VMware MaaS Cloud Provider (Enterprise)"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Addon = armavs.Addon{
	// 	Name: to.Ptr("hcx"),
	// 	Type: to.Ptr("Microsoft.AVS/privateClouds/addons"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/addons/hcx"),
	// 	Properties: &armavs.AddonHcxProperties{
	// 		AddonType: to.Ptr(armavs.AddonTypeHCX),
	// 		ProvisioningState: to.Ptr(armavs.AddonProvisioningStateSucceeded),
	// 		Offer: to.Ptr("VMware MaaS Cloud Provider (Enterprise)"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/Addons_CreateOrUpdate_SRM.json
func ExampleAddonsClient_BeginCreateOrUpdate_addonsCreateOrUpdateSrm() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAddonsClient().BeginCreateOrUpdate(ctx, "group1", "cloud1", "srm", armavs.Addon{
		Properties: &armavs.AddonSrmProperties{
			AddonType:  to.Ptr(armavs.AddonTypeSRM),
			LicenseKey: to.Ptr("41915178-A8FF-4A4D-B683-6D735AF5E3F5"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Addon = armavs.Addon{
	// 	Name: to.Ptr("srm"),
	// 	Type: to.Ptr("Microsoft.AVS/privateClouds/addons"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/addons/srm"),
	// 	Properties: &armavs.AddonSrmProperties{
	// 		AddonType: to.Ptr(armavs.AddonTypeSRM),
	// 		ProvisioningState: to.Ptr(armavs.AddonProvisioningStateSucceeded),
	// 		LicenseKey: to.Ptr("41915178-A8FF-4A4D-B683-6D735AF5E3F5"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/Addons_CreateOrUpdate_VR.json
func ExampleAddonsClient_BeginCreateOrUpdate_addonsCreateOrUpdateVr() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAddonsClient().BeginCreateOrUpdate(ctx, "group1", "cloud1", "vr", armavs.Addon{
		Properties: &armavs.AddonVrProperties{
			AddonType: to.Ptr(armavs.AddonTypeVR),
			VrsCount:  to.Ptr[int32](1),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Addon = armavs.Addon{
	// 	Name: to.Ptr("vr"),
	// 	Type: to.Ptr("Microsoft.AVS/privateClouds/addons"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.AVS/privateClouds/cloud1/addons/vr"),
	// 	Properties: &armavs.AddonVrProperties{
	// 		AddonType: to.Ptr(armavs.AddonTypeVR),
	// 		ProvisioningState: to.Ptr(armavs.AddonProvisioningStateSucceeded),
	// 		VrsCount: to.Ptr[int32](1),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a5e7ff51c8af3781e7f6dd3b82a3fc922e2f6f93/specification/vmware/resource-manager/Microsoft.AVS/stable/2023-03-01/examples/Addons_Delete.json
func ExampleAddonsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armavs.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewAddonsClient().BeginDelete(ctx, "group1", "cloud1", "srm", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
