"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.treeRow = void 0;
const tslib_1 = require("tslib");
const jsx_runtime_1 = require("react/jsx-runtime");
const react_styles_1 = require("@patternfly/react-styles");
const table_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Table/table"));
const table_tree_view_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Table/table-tree-view"));
const Button_1 = require('@patternfly/react-core/dist/js/components/Button');
const Checkbox_1 = require('@patternfly/react-core/dist/js/components/Checkbox');
const angle_down_icon_1 = tslib_1.__importDefault(require('@patternfly/react-icons/dist/js/icons/angle-down-icon'));
const ellipsis_h_icon_1 = tslib_1.__importDefault(require('@patternfly/react-icons/dist/js/icons/ellipsis-h-icon'));
const treeRow = (onCollapse, onCheckChange, onToggleRowDetails) => (value, { rowIndex, rowData }) => {
    const { isExpanded, isDetailsExpanded, 'aria-level': level, 'aria-setsize': setsize, toggleAriaLabel, checkAriaLabel, showDetailsAriaLabel, isChecked, checkboxId, icon } = rowData.props;
    const content = value.title || value;
    const text = ((0, jsx_runtime_1.jsxs)("div", { className: (0, react_styles_1.css)(table_tree_view_1.default.tableTreeViewText), children: [icon && ((0, jsx_runtime_1.jsx)("span", { className: (0, react_styles_1.css)(table_tree_view_1.default.tableTreeViewIcon), children: icon }, "tree-view-text-icon")), (0, jsx_runtime_1.jsx)("span", { className: table_1.default.tableText, children: content }, "table-text")] }, "tree-view-text"));
    const onChange = (isChecked, event) => {
        onCheckChange(event, isChecked, rowIndex, content, rowData);
    };
    return {
        component: 'th',
        className: table_tree_view_1.default.tableTreeViewTitleCell,
        children: level !== undefined ? ((0, jsx_runtime_1.jsxs)("div", { className: (0, react_styles_1.css)(table_tree_view_1.default.tableTreeViewMain), children: [setsize > 0 && ((0, jsx_runtime_1.jsx)("span", { className: (0, react_styles_1.css)(table_tree_view_1.default.tableToggle), children: (0, jsx_runtime_1.jsx)(Button_1.Button, { variant: "plain", onClick: (event) => onCollapse && onCollapse(event, rowIndex, content, rowData), className: (0, react_styles_1.css)(isExpanded && table_1.default.modifiers.expanded), "aria-expanded": isExpanded, "aria-label": toggleAriaLabel || `${isExpanded ? 'Collapse' : 'Expand'} row ${rowIndex}`, icon: (0, jsx_runtime_1.jsx)("div", { className: (0, react_styles_1.css)(table_tree_view_1.default.tableToggleIcon), children: (0, jsx_runtime_1.jsx)(angle_down_icon_1.default, {}) }) }) }, "table-toggle")), !!onCheckChange && ((0, jsx_runtime_1.jsx)("span", { className: (0, react_styles_1.css)(table_tree_view_1.default.tableCheck), children: (0, jsx_runtime_1.jsx)("label", { htmlFor: checkboxId || `checkbox_${rowIndex}`, children: (0, jsx_runtime_1.jsx)(Checkbox_1.Checkbox, { id: checkboxId || `checkbox_${rowIndex}`, "aria-label": checkAriaLabel || `Row ${rowIndex} checkbox`, isChecked: isChecked, onChange: (event, checked) => onChange(checked, event) }) }) }, "table-check")), text, !!onToggleRowDetails && ((0, jsx_runtime_1.jsx)("span", { className: (0, react_styles_1.css)(table_tree_view_1.default.tableTreeViewDetailsToggle), children: (0, jsx_runtime_1.jsx)(Button_1.Button, { variant: "plain", "aria-expanded": isDetailsExpanded, "aria-label": showDetailsAriaLabel || 'Show row details', onClick: (event) => onToggleRowDetails && onToggleRowDetails(event, rowIndex, content, rowData), icon: (0, jsx_runtime_1.jsx)("span", { className: `${table_1.default.table}__details-toggle-icon`, children: (0, jsx_runtime_1.jsx)(ellipsis_h_icon_1.default, {}) }) }) }, "view-details-toggle"))] })) : (text)
    };
};
exports.treeRow = treeRow;
//# sourceMappingURL=treeRow.js.map